/* File: /u1/oystr/HRPC/HRpcRTS/resolveB.c  Date:  8-Apr-1986  */

/*
 * $Header$
 * INTERFACE:	ResolveBinding( fBptr, fSpeak, fDescr,
 *				fIFDptr, fAnswer )
 *
 * FUNCTION:	Talks to the SUN 'portmap' binding agent
 *		to determine the port number for a running service.
 *
 * IMPORTS:	basicRpc.h, SpeakDefs.h
 *
 * EXPORTS:	ResolveBinding
 *
 * DESIGN:	Of course.
 *			>>>>> WARNING <<<<
 *		This routine talks to portmap using HRPC.  The
 *		static routine SunPMap_GetPort was derived from
 *		a stub generated routine.  We do go through some
 *		fancy stepping to get cobble up the generic initial binding
 *		to portmap.
 *
 * DEFECTS:	Multitudinous.
 * $Log$
 *  8-Apr-1986:	Initial implementation, Jan Sanislo
 */

#include <HRPC/basicRpc.h>
#include <netinet/in.h>
#include <HRPC/CIncludes/Binding_defs.h>
#include <HRPC/hrpcErrCodes.h>

/* Static IFD for *any* portmap server */
static InterfaceDescr pmapIfd = {
    100000, 2, (TBD) 0
};

/*
 * Static Binding template to *any* portmap server.
 */
static HRPCBinding templateBinding;
static HRPCBinding *templatebptr = &templateBinding;

/* Init flag */
static int initDone = 0;

/* from Binding/pmapIf.c */
extern HRPCErrRec *SunPMap_GetPort();

/*ARGSUSED*/
HRPCErrRec  *XXResolveBinding( fBptr, fSpeak, fDescr, fIFDptr, fAnswer )
    HRPCBinding        *fBptr;   /* dummy for now */
    int 		fSpeak;
    struct sockaddr_in *fDescr;  /* should be something defined by NS */
    InterfaceDescr     *fIFDptr; /* pointer to interface being located */
    struct sockaddr_in *fAnswer; /* pointer to returned addr. */
{
    struct sockaddr_in *ap;
    LongCardinal portNum;
    LongCardinal dummy;
    LongCardinal proto;
    SUN_XDR_UDP_BINDING_DESCR bdescr;
    HRPCBinding pmapBinding;
    HRPCBinding *pmbptr = &pmapBinding;
    HRPCErrRec *pmErr;

    /*
     * If first time through, set up everything once.
     * This relies on the fact that we are using UDP
     * to talk to the portmapper.
     */
    if ( !initDone ) {
	templatebptr->ifdPtr = &pmapIfd;
	/* Port number MUST be in network order */
	bdescr.portNum = (LongCardinal) htons( (u_short) 111);
	bdescr.progNum = 100000;
	FillSunRPC( templatebptr, &bdescr );
	FillSunOTW( templatebptr, &bdescr );
	FillSunUDP( templatebptr, &bdescr );
	templatebptr->bndProgNum = pmapIfd.progNum;
	*(int *) &templatebptr->speaking = 2;
	initDone = 1;
    }
	/* NOTE: FOLLOWING IS STRUCT ASSIGNMENT */
    *pmbptr = *templatebptr;

    /*
     * Plug in new IP address.
     */
    ap = (struct sockaddr_in *) &(pmbptr->transDescr.netAddr);
    ap->sin_addr.s_addr = fDescr->sin_addr.s_addr;

    if ( fSpeak == 1 ) proto = IPPROTO_TCP;
    else
    if ( fSpeak == 2 ) proto = IPPROTO_UDP;
    else {
/*
	fatalerr("ResolveBinding: can't handle speak type %d.\n",fSpeak);
 */
	return( NewHRPCErrRec( IMPORT_BADSPEAK, 0 ) );
    }

    /*
     * Call the thing.
     */
    pmErr = SunPMap_GetPort( pmbptr, fIFDptr->progNum, fIFDptr->versNum,
			     proto, dummy, &portNum );
    if ( pmErr ) {
	pmErr->errDetails = (char *) pmErr->hrpcErr;
	pmErr->hrpcErr = IMPORT_BAFAILED;
	return( pmErr );
    }

    if ( portNum == 0 ) {
#ifdef DEBUG
	errmsg("ResolveBinding: GetPort call returns 0 port.\n");
#endif
        pmErr = NewHRPCErrRec( IMPORT_NOTREGIS, 0 );
	goto tidy;
    }
    pmErr = (HRPCErrRec *) NULL;
    fAnswer->sin_family = AF_INET;
    fAnswer->sin_addr.s_addr = ap->sin_addr.s_addr;
    fAnswer->sin_port = htons( (u_short) portNum );

tidy:
    (*pmbptr->rpcDescr.CloseRpc)(pmbptr);
    (*pmbptr->otwDescr.CloseOtw)(pmbptr);
    (*pmbptr->transDescr.CloseLink)(pmbptr);
    return( pmErr );
}
