/* File: /u1/oystr/HRPC/HRpcRTS/import.c  Date: 25-Feb-1986  */

/*
 * $Header$
 * INTERFACE:	HRPC runtime binding interface.
 *
 * FUNCTION:	Implement communication with HCS nameserver
 *		and HCS binding agent necessary for the various
 *		stages of binding.
 *
 * IMPORTS:	Standard HRPC include files.
 *
 * EXPORTS:	InitHRPCBinding
 *
 * DESIGN:	Continuing.  Currently hardwired to use
 *		only SUN RPC portmap protocol.
 *
 * $Log$
 * 25-Feb-1986:	Initial implementation, Jan Sanislo
 *	Throw-away hack job for SUN RPC only.  This is
 *	pretty disgusting stuff but is a valuable learning
 *	experience.
 *
 * 28-Jul-1986:  oystr
 *	Still disgusting, but better than trying to have
 *	XNS include files all over the place.
 */

#include <HRPC/cCourierTypes.h>
#include <HRPC/basicRpc.h>
#include <netinet/in.h>
#include <netdb.h>
#include <HRPC/CIncludes/Binding_defs.h>
#include <HRPC/hrpcErrCodes.h>
extern HRPCErrRec *XXResolveBinding();
/****************************************************************
 * 			InitHRPCBinding				*
 ****************************************************************/

/*
 * INTERFACE:	XXInitHRPCBinding( fProg, fVers, fInstance
 *				 fSpare1, fSpare2, fSpare3,
 *				 fBinding )
 *
 * INPUT:	fProg, fVers: Program number & version number
 *		fInstance:    String name of instance (must be node
 *				name in current impl.
 *		fSpare*:      Spare params.
 *
 * OUTPUT:	fBinding:     Pointer to HRPCBinding structure
 *
 * EFFECT:	Contact "nameserver" and/or "binding agent"
 *		to get necessary information and fill in
 *		interface descriptor and preliminary binding info.
 *
 * DEFECTS:	Too numerous to mention.
 */

/*ARGSUSED*/
HRPCErrRec *XXInitHRPCBinding( fProg, fVers, fInstance,
		     fSpare1, fSpare2, fSpare3,
		     fBinding )
    LongCardinal fProg, fVers;
    String fInstance;
    LongUnspecified fSpare1, fSpare2, fSpare3;
    HRPCBinding **fBinding;
{
    InterfaceDescr *ifdptr;
    HRPCBinding    *lbptr;
    struct sockaddr_in server_in;
    struct hostent *hp;
    HRPCErrRec *pmstat;
    int useproto;
    SUN_XDR_UDP_BINDING_DESCR bdescr;
    
    ifdptr = (InterfaceDescr *) calloc(1, sizeof( InterfaceDescr ));
    ifdptr->progNum = fProg;
    ifdptr->versNum = fVers;

    lbptr = (HRPCBinding *) calloc( 1, sizeof( HRPCBinding ) );
    lbptr->ifdPtr = ifdptr;
    lbptr->bndProgNum = fProg;
    hp = gethostbyname( fInstance );
    if ( hp == (struct hostent *) 0 )
	fatalerr("InitHRPCBinding: can't get host '%s'.\n",fInstance);
    bcopy(hp->h_addr, &server_in.sin_addr, hp->h_length);
    server_in.sin_family = AF_INET;
    server_in.sin_port = 0;

    /* Call portmap on remote node, until we find one */
    pmstat = XXResolveBinding( lbptr, 2, &server_in, ifdptr, &server_in );
    if ( ! pmstat ) {
	useproto = IPPROTO_UDP;
	*(int *) &lbptr->speaking = 2;
    }
    else {
	pmstat = XXResolveBinding( lbptr, 1, &server_in, ifdptr, &server_in );
	if ( pmstat ) {
/*
	    fatalerr("XXInitHRPCBinding: XXResolveBinding fails.\n");
 */
	    return( pmstat );
	}
	*(int *) &lbptr->speaking = 1;
	useproto = IPPROTO_TCP;
    }

    /* Configure control blocks */
    bcopy(&server_in.sin_addr, &bdescr.ipAddr, sizeof(struct in_addr));
    bdescr.portNum = server_in.sin_port;
    bdescr.progNum = fProg;
    
    FillSunRPC( lbptr, &bdescr );
    FillSunOTW( lbptr, &bdescr );
    if ( useproto == IPPROTO_TCP ) {
	FillSunTCP( lbptr, &bdescr );
    }
    else {
	FillSunUDP( lbptr, &bdescr );
    }
    *fBinding = lbptr;
    return( NOHRPCERR );
}
