/* File: /u1/oystr/HRPC/HRpcRTS/configRpc.c  Date: 27-Feb-1986  */

/*
 * $Header$
 * INTERFACE:	ConfigRPC( fBptr, fType )
 *
 * FUNCTION:	Configure the RPC control block
 *
 * IMPORTS:	Standard stuff
 *
 * EXPORTS:	ConfigRPC
 *
 * DESIGN:	Of course.
 *
 * $Log$
 * 27-Feb-1986:	Initial implementation, Jan Sanislo
 */

#include <HRPC/basicRpc.h>

extern int SunInitOutgoing();
extern int SunPacketOutgoing();
extern int SunFinishOutgoing();
extern int SunInitAnswer();
extern int SunAnswerPacket();
extern int SunFinishAnswer();
extern int abort();
extern int SunCloseRpc();
extern int SunGetReplyId();

static RpcControl SunRpcControl = {
    SunInitOutgoing, SunPacketOutgoing, SunFinishOutgoing,
    abort, abort, abort,
    abort, abort, abort,
    SunInitAnswer, SunAnswerPacket, SunFinishAnswer,
    abort, abort,
    SunCloseRpc,
    SunGetReplyId,
    (memory) 0
};

ConfigRPC( fBptr, fType )
    HRPCBinding *fBptr;
    int		fType;
{
    if ( fType != SUNRPC )
	fatalerr("ConfigRPC: don't know RPC type %d.\n",fType);
    fBptr->rpcType  = fType;
    fBptr->rpcDescr = SunRpcControl;
}

extern int XdrCardinal();
extern int XdrLongCardinal();
extern int XdrInteger();
extern int XdrLongInteger();
extern int XdrBoolean();
extern int XdrUnspecified();
extern int XdrLongUnspecified();
extern int XdrString();
extern int XdrArray();
extern int XdrChoice();
extern int XdrEnumeration();
extern int XdrSequence();
extern int XdrRecord();
extern int XdrProcedure();
extern int XdrError();
extern int XdrDeallocate();
extern int XdrNilRecord();
extern int XdrCloseOtw();

static OtwControl XdrOtwControl = {
    XdrCardinal, XdrLongCardinal, XdrInteger,
    XdrLongInteger, XdrBoolean, XdrUnspecified,
    XdrLongUnspecified, XdrString, XdrArray,
    XdrChoice, XdrEnumeration, XdrSequence,
    XdrRecord, XdrProcedure, XdrError, XdrDeallocate,
    XdrNilRecord, XdrCloseOtw
};

ConfigOTW( fBptr, fType )
    HRPCBinding *fBptr;
    int		fType;
{
    if ( fType != SUNOTW )
	fatalerr("ConfigOTW: don't know OTW type %d.\n",fType);
    fBptr->otwType  = fType;
    fBptr->otwDescr = XdrOtwControl;
}

extern int TcpMaxBufferSize();
extern int TcpOpenLink();
extern int TcpCloseLink();
extern int TcpSendPacket();
extern int TcpRecvPacket();
extern int TcpInitSend();
extern int TcpFinishSend();
extern int TcpInitRecv();
extern int TcpFinishRecv();
extern memory TcpBufAlloc();
extern memory TcpBufDealloc();

static TransControl TcpTransControl = {
    TcpMaxBufferSize, TcpOpenLink,   TcpCloseLink,
    TcpSendPacket,    TcpRecvPacket, TcpInitSend,
    TcpFinishSend,    TcpInitRecv,   TcpFinishRecv,
    TcpBufAlloc,      TcpBufDealloc
};

extern int UdpMaxBufferSize();
extern int UdpOpenLink();
extern int UdpCloseLink();
extern int UdpSendPacket();
extern int UdpRecvPacket();
extern int UdpInitRecv();
extern int UdpFinishRecv();
extern int UdpInitSend();
extern int UdpFinishSend();
extern memory UdpBufAlloc();
extern memory UdpBufDealloc();

static TransControl UdpTransControl = {
    UdpMaxBufferSize, UdpOpenLink,   UdpCloseLink,
    UdpSendPacket,    UdpRecvPacket, UdpInitSend,
    UdpFinishSend,    UdpInitRecv,   UdpFinishRecv,
    UdpBufAlloc,      UdpBufDealloc
};

ConfigTRANSP( fBptr, fType, fNetAddr )
    HRPCBinding *fBptr;
    int		fType;
    struct sockaddr *fNetAddr;
{
    register TransControl *tcptr;

    if ( (fType != TCPTRANSP) && (fType != UDPTRANSP) )
	fatalerr("ConfigTRANSP: don't know transport type %d.\n",fType);
    fBptr->transType = fType;
    tcptr = &fBptr->transDescr;
    fBptr->transDescr = (fType == TCPTRANSP) ? TcpTransControl
					     : UdpTransControl;
    tcptr->netAddr = *fNetAddr; /* struct assignment */
    tcptr->sockfd = 0;
}
