/* File: /u2/dtc/HRPC/HRpcRTS/close.c  Date: 18-Mar-1986  */

/*
 * $Header: close.c,v 1.2 86/04/02 14:53:29 dtc Exp $
 * INTERFACE:	HRPC runtime binding interface.
 *
 * FUNCTION:	Implement communication with HCS nameserver
 *		and HCS binding agent necessary for the various
 *		stages of binding.
 *
 * IMPORTS:	Standard HRPC include files.
 *
 * EXPORTS:	InitHRPCBinding
 *
 * DESIGN:	Continuing.  Currently hardwired to use
 *		only Courier RPC protocol.
 *
 * $Log:	close.c,v $
 * Revision 1.3  86/06/16  11:18:25  oystr
 * Get rid of SPP specific close call - go through
 * transport specific close routine in Transport
 * descriptor.
 *
 * Revision 1.2  86/04/02  14:53:29  dtc
 * addition of sppclose() call.  Kinda important!
 * 
 * Revision 1.1  86/03/27  08:19:19  dtc
 * Initial revision
 * 
 * 24-Mar-1986:	Initial implementation, Dennis Ching.
 */

#include <HRPC/basicRpc.h>

/****************************************************************
 * 			CloseHRPCBinding			*
 ****************************************************************/

/*
 * INTERFACE:	CloseHRPCBinding( fBinding )
 *
 * INPUT:	fBinding:     Pointer to HRPCBinding structure
 *
 * EFFECT:	Tear down everything associated with a binding.
 *		Go through protocol specfic routines in the
 *		descriptor blocks.
 *
 * DEFECTS:	1) fBinding should be passed as var parameter
 *		   so we can set it to NULL.
 *		2) There is bound to be some set of protocols
 *		   where the order of the "close" calls given
 *		   here is wrong.  Currently we go top down
 *		   from RPC -> OTW -> Transport.
 */


void
CloseHRPCBinding( fBptr )
    register HRPCBinding *fBptr;
{
    /* Tidy up RPC protocol state */
    (*fBptr->rpcDescr.CloseRpc)( fBptr );

    /* Do the same for OTW - usually a noop */
    (*fBptr->otwDescr.CloseOtw)( fBptr );
    
    /* Shutdown socket(s), clobber transport buffer(s) */
    (*fBptr->transDescr.CloseLink)( fBptr );
    
    /* Get rid of interface descriptor -- FIXME: IFD's
       should be shared.  Not up for reference counts
       and IFD lists right now though.
     */
    free( fBptr->ifdPtr );

    /* Clobber binding itself */
    free ((memory) fBptr);
}
