/* File: /u1/oystr/HRPC/HRpcRTS/bufferOps.c  Date: 26-Mar-1986  */

/*
 * $Header$
 * INTERFACE:	Buffer positioning operations.
 *
 * FUNCTION:	It is sometimes necessary to rewrite
 *		information in the message buffers, so
 *		we need a way to get/set the buffer position.
 *
 * IMPORTS:	basicRpc.h, bufferOps.h
 *
 * EXPORTS:	GetBufPos, SetBufPos
 *
 * DESIGN:	Trivial
 *
 * DEFECTS:	These routines could (should) be macros.
 * $Log$
 * 26-Mar-1986:	Initial implementation, Jan Sanislo
 */

#include <HRPC/basicRpc.h>
#include <HRPC/bufferOps.h>

/*
 * Save the current buffer position in
 * the supplied BufPos.
 */

int GetBufPos( fBinding, fbp )
    register HRPCBinding *fBinding;
    register BufPos *fbp;
{
    fbp->bufMark = fBinding->curBufMark;
    fbp->bufSize = fBinding->curBufSize;
}

/*
 * Set binding buffer position to fNewPos.
 * If fOldPos is non-null, return a copy of
 * the current position.
 */

int SetBufPos( fBinding, fNewPos, fOldPos )
    register HRPCBinding *fBinding;
    register BufPos *fNewPos;
    register BufPos *fOldPos;
{
    if ( fOldPos != (BufPos *) NULL ) {
	fOldPos->bufMark = fBinding->curBufMark;
	fOldPos->bufSize = fBinding->curBufSize;
    }
    fBinding->curBufMark = fNewPos->bufMark;
    fBinding->curBufSize = fNewPos->bufSize;
}
