/* File: /u1/oystr/HRPC/HRpcRTS/resolveB.c  Date:  8-Apr-1986  */

/*
 * $Header$
 * INTERFACE:	ResolveBinding( fBptr, fDescr, fIFDptr, fAnswer )
 *
 * FUNCTION:	Talks to the SUN 'portmap' binding agent
 *		to determine the port number for a running service.
 *
 * IMPORTS:	basicRpc.h, SpeakDefs.h
 *
 * EXPORTS:	ResolveBinding
 *
 * DESIGN:	Of course.
 *			>>>>> WARNING <<<<
 *		This routine talks to portmap using HRPC.  The
 *		static routine SunPMap_GetPort was derived from
 *		a stub generated routine.  We do go through some
 *		fancy stepping to cobble up the generic initial binding
 *		to portmap.
 *
 * DEFECTS:	Multitudinous. Assume the only BA we have to deal with
 *		is SUN portmap.
 * $Log$
 *  8-Apr-1986:	Initial implementation, Jan Sanislo
 */

#include <HRPC/CIncludes/Binding_defs.h>

#ifndef basicRpc
#include <HRPC/basicRpc.h>
#endif

#include <HRPC/hrpcErrCodes.h>

#include <netinet/in.h>

/* Static IFD for *any* portmap server */
static InterfaceDescr pmapIfd = {
    100000, 2, (TBD) 0
};

/*
 * Static Binding template to *any* portmap server.
 */
static HRPCBinding templateBinding;
static HRPCBinding *templatebptr = &templateBinding;

/* Init flag */
static int initDone = 0;

/* from Binding/pmapIf.c */
extern HRPCErrRec *SunPMap_GetPort();

/*ARGSUSED*/
void ResolveBinding( fBptr, fDescr, fIFDptr, fAnswer, fResStat )
    HRPCBinding          *fBptr;   /* dummy for now */
    Binding_BINDING_DESCR *fDescr;  /* should be something defined by NS */
    InterfaceDescr       *fIFDptr; /* pointer to interface being located */
    Binding_BINDING_DESCR *fAnswer; /* pointer to returned addr. */
    Binding_STATUS_REC *fResStat;
{
    struct sockaddr_in *ap;
    LongCardinal portNum;
    LongCardinal dummy;
    LongCardinal proto;
    Binding_REAL_BINDING_DESCR *rbptr;
    Binding_SUN_XDR_UDP_BINDING_DESCR bdescr;
    HRPCBinding pmapBinding;
    HRPCBinding *pmbptr = &pmapBinding;
    SpeakDefs_Speak speak;
    HRPCErrRec *pmErr;

    /*
     * If first time through, set up everything once.
     * This relies on the fact that we are using UDP
     * to talk to the portmapper.
     */
    if ( !initDone ) {
	templatebptr->ifdPtr = &pmapIfd;
	templatebptr->bndProgNum = pmapIfd.progNum;
	templatebptr->speaking = SUN_XDR_UDP;
	bdescr.portNum = (LongCardinal) htons( (u_short) 111);
	bdescr.progNum = 100000;
	FillSunRPC( templatebptr, &bdescr );
	FillSunOTW( templatebptr, &bdescr );
	FillSunUDP( templatebptr, &bdescr );
	initDone = 1;
    }

	/* NOTE: FOLLOWING IS STRUCT ASSIGNMENT */
    *pmbptr = *templatebptr;
    fResStat->errCode = IMPORT_NORMAL;
    
    rbptr = &(fDescr->data);
    if ( rbptr->designator == SUN_XDR_UDP ) {
	proto = IPPROTO_UDP;
    }
    else
    if ( rbptr->designator == SUN_XDR_TCP ) {
	proto = IPPROTO_TCP;
    }
    else {
/*
	fatalerr("ResolveBinding: can't handle speak type %d.\n",
		 (int) rbptr->designator);
 */
	fResStat->errCode = IMPORT_BADSPEAK;
	return;
    }
#ifdef DEBUG
errmsg("ResolveBinding: protocol is %d.\n",proto);
#endif

    /*
     * Plug in new IP address.
     *		>>>>> WARNING <<<<<
     * Assumes TCP and UDP cases are equivalent (which they are).
     */
    ap = (struct sockaddr_in *) &(pmbptr->transDescr.netAddr);
    ap->sin_addr.s_addr = * (u_long *) rbptr->SUN_XDR_TCP_case.ipAddr;
#ifdef DEBUG
errmsg("   IP address is %08x.\n",ap->sin_addr.s_addr);
#endif

    /*
     * Call the thing.
     */
    pmErr = SunPMap_GetPort( pmbptr, rbptr->SUN_XDR_TCP_case.progNum,
		     fIFDptr->versNum, proto,
		     dummy, &portNum );
    if ( pmErr ) {
	fResStat->errCode = pmErr->hrpcErr;
	free( pmErr );
    }
    else
    if ( portNum == 0 ) {
#ifdef DEBUG
	errmsg("ResolveBinding: GetPort call returns 0 port.\n");
#endif
	fResStat->errCode = IMPORT_NOTREGIS;
    }
#ifdef DEBUG
errmsg("   Port number is: %d.\n",portNum);
#endif

tidy:
    (*pmbptr->rpcDescr.CloseRpc)(pmbptr);
    (*pmbptr->otwDescr.CloseOtw)(pmbptr);
    (*pmbptr->transDescr.CloseLink)(pmbptr);
    if ( fResStat->errCode != IMPORT_NORMAL ) return;

    *fAnswer = *fDescr; /* struct assignment */
    rbptr = &(fAnswer->data);
    portNum = htons((u_short)portNum);
    rbptr->SUN_XDR_TCP_case.portNum = (LongCardinal) portNum;
    return;
}

/*
 * Dummy routine for now.
 */

HRPCErrRec *LocateBA( fBptr )
    HRPCBinding *fBptr;
{
    /* do absolutely nothing for now */
    return( NOHRPCERR );
}
