.\" tbl | some-roff -ms
.nr LL 6.5i
.nr PO 1.0i
.nr PI 0.2i
.\" Two macros for code display --
.\" Use fixed width font so indents show up right,
.\" decrease point size and vertical spacing by two
.de LS
.DS B \\$1
.ft C
.ps -2
.vs -2
..
.de LE
.vs +2
.ps +2
.ft P
.DE
..
.\" Section headers with TOC generation
.\" Parameter 1 is the level, param 2 is the header string
.\" .XS and .XE are standard macros from "new" ms
.de hd
.NH \\$1
\\$2
.XS
\\*(SN \\$2
.XE
..
.ND " "
.RP
.TL
.ps +8
Heterogeneous Remote Procedure Call
.sp
Programmer's Guide
.sp 3
.ps -8
.AU
Version 1.2
20 March 1988
.AB
This document provides the information
necessary to construct applications using the \fIHeterogeneous
Remote Procedure Call\fP system (HRPC).  HRPC is capable
of emulating multiple RPC protocols.  The RPC protocol
used for a particular sequence of calls is chosen at run-time.
The fact that different RPC protocols are in use is, to a very
large extent, transparent to the user.
Because of this transparency, HRPC applications tend to
exhibit astonishing elegance, remarkable simplicity
and lasting utility.  On the rare occasions
when these characteristics are mutually exclusive, HRPC can
probably help you achieve at least one of them.
.sp 5
.ad r
\*QThere are lies, damned lies, and `some assembly required'.\*U
.sp
Unknown
.sp
.ad n
.AE
.hd 1 "Introduction: LPC, RPC and HRPC"
.PP
The purpose of this document is to provide a programmer's
introduction to the HRPC system.  That is, it tries to
provide details on how to \fIuse\fP HRPC rather than
dwelling on its internals.  Unfortunately, explaining
how to use the system requires a certain amount of terminology
that can only be motivated by outlining the differences
between local procedure call, remote procedure call, and
\fIheterogenous\fP remote procedure call.
.PP
In a local procedure call (LPC) the caller (\fIclient\fP) shares
the same address space as the callee (\fIserver\fP).
The parameters passed between client and server are placed on a stack
by a sequence of compiler generated instructions.  The size
and position of each parameter on the stack are governed by
the conventions of a particular programming language or machine
architecture.  The address of the server is determined by
a linker/loader system utility.  Transfer of control between
client and server is usually accomplished by single machine
instructions.
.PP
In remote procedure call (RPC) the client and server are
no longer assumed to share the same address space.  Indeed,
they are assumed to reside on different physical computers.
An RPC system works in approximately the following way:  The
client and server modules are programmed as if they were intended
to be linked together in the usual manner.  A description of
the interface implemented by the server, written in an \fIinterface
description language\fP (IDL), is processed, yielding two \fIstubs\fP,
one associated with the client and one associated with the server.
The client stub is linked with the client module.  To the client,
this stub looks like an LPC server.  Similarly,
the server stub is linked with the server module; to the server
this stub looks like a (local) client.  The stubs shield the
client and server from the details and complexities
caused by the fact that calls span address space/machine boundaries.
Taking care of \*Qremoteness\*U is the function of
an \fIRPC run-time system\fP. Client and server (and
stubs) are linked with the run-time system.  They will use the 
particular \*Qflavor\*U of RPC implemented by that run-time system
to communicate.
An RPC flavor (or \fIRPC protocol\fP) can be viewed as one particular
combination of three different functions:
.RS
.IP \-
A \fIcontrol\f component, that defines such things as
\*Qwhat is the format of a call message\*U, \*Qhow long
should I wait for a reply to come back\*U, and \*Qwhat sort
of errors do I know about\*U.
.IP \-
A \fIdata representation\fP or \fIOTW\fP (\*Qover-the-wire\*U)
format, defining how message data can be passed back and forth in
a machine independent manner.
.IP \-
A \fItransport\fP protocol, used to actually
send and receive messages over the network.
.RE
.LP
In most RPC systems these functions are constructed in such
a way that each depends upon or has knowledge about the
implementation of the others.  The rationale
for creating such a monolithic run-time system is performance.
If you assume that all the logically separate components
really implement a single function (\*Qour RPC\*U) then
the tighter you can make the components fit together and the faster
the system runs.  But the performance assumption requires
two more subtle assumptions: that
everything will use the same RPC protocol and that
all the basic components used in \*Qour RPC\*U, especially
network transport, will be easily available or easily implemented.
These latter assumptions have a profound effect on such practical
matters as the amount of effort required to integrate a new computer
system into the RPC community.
.PP
The \fIHeterogeneous\fP RPC system (HRPC) seeks to mitigate the effect
of the last two \*Qhappy family\*U assumptions.
HRPC does this by providing a run-time system
capable of \fIemulating\fP other RPC systems.  Just
as most RPC systems strive to make remoteness transparent,
HRPC tries to make it transparent that a single program is
using different underlying RPC protocols to communicate with
different services.
.PP
HRPC achieves this transparency by the use of \fIHRPCBindings\fP.
HRPCBindings are data structures that contain information
describing the components of the particular RPC protocol,
collectively termed a \fISpeakType\fP, used to
perform calls between client and server.  An HRPCBinding is
supplied by the application whenever it makes an RPC.
HRPCBindings are created in a protocol-independent manner,
allowing the application to use different underlying RPCs
in a consistent manner.  Indeed, simply by using different
HRPCBindings, functionally equivalent services on radically
different systems can be called.
.PP
An HRPCBinding
is created by a sequence of actions called \fIbinding\fP
that associates a client with a particular server.  The
server actively participates in the
binding process by \fIexporting\fP itself.  At export time,
the server provides such information as its name and what
RPC protocols it is capable of speaking.
The client application participates by \fIimporting\fP a server,
specifying by \fIname\fP which server is desired.
.PP
In the following sections we will cover each of the
major aspects of the HRPC system:
.RS
.IP \-
The interface description language.
.IP \-
The stub compiler.
.IP \-
The interface between client/server and stubs.
.IP \-
Naming and binding mechanisms used by HRPC.
.RE
.LP
As mentioned before, the emphasis is on providing enough
background information and instruction so that you can \fIuse\fP
HRPC.  There are many examples and these should be given more
than cursory attention.
A separate section, \fIExtra For Experts\fP, touches
on more esoteric things that can be accomplished
by direct use of HRPC run-time primitives.
.PP
As a final note, the current HRPC implementation emulates
two major RPC protocols:  the one developed by SUN Microsystems
and the Xerox Courier protocol.  These are often referred to as
\fBSUN\fP and \fBCOUR\fP, respectively.
.hd 1 "The Interface Description Language"
.PP
HRPC uses a version of the Courier Interface Description Language to define
the procedural interface between client and server in a machine-,
programming language- and SpeakType-independent manner.
A complete description of the Courier language is beyond the scope of this
document and you should at some point read the standard reference.\**
.FS
cf. Courier:  The Remote Procedure Call Protocol., Technical
Report XSIS 038112, Xerox Corporation, 1981. Be aware that
at this point our discussion is dealing with Courier as an IDL
rather than an RPC protocol.
.FE
If you are a quick study this section may postpone (but
certainly not eliminate) tracking down the full documentation.
However, the real purpose here is to acquaint you with
the concept of an interface description language as opposed
a programming language and to point out where the HRPC
version of the Courier language differs from
the Xerox standard version.  The relevance of these differences
may not make a whole lot of sense to you without the background
provided by the rest of this document and some experience
using HRPC.  Skim this section the
first time through and suppress your puzzlement.
.PP
Like Gaul, a Courier interface description is divided into three parts:
.RS
.IP \-
A \fIprogram header\fP declaration that contains a \fIprogram name\fP,
\fIprogram number(s)\fP, and \fIprogram version\fP.
.IP \-
A series of \fItype definitions\fP of any nonstandard types  used  by
the interface.
.IP \-
A series of \fIprocedure declarations\fP giving the \*Qnames\*U,
formal parameters and \fIprocedure number\fP of each remotely
callable procedure.
.RE
.hd 2 "Program Headers"
.LP
A program header has the following syntax:
.LS
<identifier> ':' PROGRAM <ProgramNumbers> VERSION <number> '='

<ProgramNumbers> ::= <number> | <ProtoDeclList>
<ProtoDeclList> ::= <ProtoDecl> | <ProtoDeclList> ',' <ProtoDecl>
<ProtoDecl> ::= <ProtoName> '=' <number>
<ProtoName> ::= SUN | COUR
.LE
.LP
This syntax is considerably different from the Xerox standard.
However, you will almost always be able to use just a <number>
(and thus conform to the standard)
rather than a <ProtoDeclList>.  This program number is used by parts of
the run-time system for \*Qaddressing\*U and error checking purposes.
Each program should have a unique number.
As of now HRPC provides no means of enforcing this uniqueness.
On the other hand, the program number space is very sparsely
populated.  Selecting a random number greater than 10000 is
almost guaranteed to work.
The only circumstances under which you are forced to use the
a <ProtoDeclList> is when the
program number spaces associated with different underlying RPC systems
are mutually exclusive. The current implementation
recognizes \fBSUN\fP and \fBCOUR\fP as protocol names.
Different program numbers can be associated with each of them.
The assumption here is that program numbers are meaningful only at
the RPC-protocol level and that there is no need to make distinctions
at \fIe.g.\fP, the network transport level.
.PP
You should start out using a version
number of 1 (one).  Change this number only if you modify the
interface by modifying types or procedures, altering the formal
parameter lists of existing procedures, etc.  In these cases, you
\fImust\fP change the version number.
.hd 2 "Type Declarations"
.PP
The HRPC Courier IDL provides a small number of predefined types (Table 1)
and the usual assortment of type constructors (Table 2).
.sp
.mk
.TS
tab (%) box;
c s
c s
c | c
l | l.
Table 1
Courier Base Types
=
Name%Description
_
CARDINAL%16-bit unsigned
LONG CARDINAL%32-bit unsigned
INTEGER%16-bit signed
LONG INTEGER%32-bit signed
BOOLEAN%8-bit (0/1)
UNSPECIFIED%16 bits
LONG UNSPECIFIED%32 bits
STRING%language dependent
.TE
.in +3i
.rt
.TS
tab (%) box;
c s
c s
c | c
l | l.
Table 2
Courier Type Constructors
=
Name%Description
_
ARRAY%T{
Homogenous components. Fixed length defined at documentation time
T}
SEQUENCE%T{
Homogeneous components. Maximum length defined at documentation time,
actual length defined at run-time.
T}
Enumeration%T{
16 bits \- \*Qsymbolic constant\*U.
T}
RECORD%T{
Heterogeneous components.
T}
CHOICE%T{
Data type chosen at run-time \- \*Qdiscriminated record\*U.
T}
.ig
ERROR%T{
16 bit discriminant of error return arguments, much
like CHOICE.
T}
..
.TE
.in -3i
.PP
In the HRPC version of the Courier language, the syntax for type
declarations has been altered slightly:
.LS
<Type> ::= <UserEscape> <TypeDecl>
<UserEscape> ::= empty | USERPROC <identifier>
<TypeDecl> ::= <PredefinedType> | <ConstructedType> | <ReferencedType>
.LE
.LP
The reason for the change is that
occasionally you will get into a situation
where the internal representation of a type
has no direct representation in the Courier language,
\fIe.g.\fP, trees or linked lists using pointers.
In such cases the automatic transformation of data (\fImarshalling\fP)
from internal form to the \*Qexternal\*U form
understood by a supported RPC system is beyond the capabilities of HRPC.
If you want to keep your special internal representation you must
provide your own marshalling routine by associating a \fBUSERPROC\fP
with a (dummy) Courier type.  The <identifier> following
the reserved word is the name of a local procedure, written by you, that
will be called by the HRPC run-time system whenever an item of
that type must be (de)marshalled.  An example of \fBUSERPROC\fP usage
is contained in Section 7.5.
.hd 2 "Procedure Declarations"
.PP
Procedure declarations define the formal parameter list of the
remotely callable operations provided by the interface.  The declaration
consists of a list of \fIinput parameters\fP and their types, a similar list
of \fIoutput parameters\fP preceded by the keyword \fBRETURNS\fP and the
\fIprocedure number\fP.  The procedure number is used internally
by HRPC.  Procedure numbers are assigned by the user
and should start at 1 (one).
If you change procedure numbers, you must
change the version number in the program declaration.
.PP
The following is a very important piece of information, so we will
put it in big bold letters:
.ce 10
\fB***** WARNING *****\fP
\fBDo not use the \*QREPORTS\*U construct in procedure declarations.
.ce 0
.LP
The ability to implement \fBREPORTS\fP (sometimes called \*Qalternate
return\*U)
depends on mechanisms that are part of each RPC system.
Not all RPC systems supported by HRPC (e.g., SUN RPC)
have such mechanisms.  Therefore,
you should never define an interface that requires them.  The function
provided by \fBREPORTS\fP can usually be accomplished in other ways, as
demonstrated in the the following example.
.hd 2 "An Example Interface"
.PP
To give a concrete idea of what the Courier IDL is like,
we present an example interface in Figure 1.
The interface is for a program that looks up information about
users on a Unix system.  Two different procedures are available.
One, \fILookupUid\fP, returns information based on a numeric
identifier.  The other, \fILookupUsers\fP, takes a number of
user names and returns a record describing each legitimate user.
For demonstration purposes
the example is a good deal more baroque than it really needs to be.
Be aware that the case of letters is significant.  Reserved words
(\fBBEGIN\fP, \fBEND\fP, \fBTYPE\fP, etc.)  must be all capitals.
Comment lines begin with \*Q--\*U and extend only to the end of the line.
We will be referring to this example in later sections in order to clarify 
certain points about usage.
.hd 1 "The Stub Compiler"
.PP
Once you have created an interface specification (the convention is to
use a file suffix of \fB.cr\fP), the only thing you can
do with it is to run it through the HRPC stub compiler.
The purpose of the stub compiler is to generate a set of routines
and data declarations in a \fIprogramming\fP language.  These
routines and declarations have two kinds of knowledge built into them:
Details regarding the interface (names of remotely
callable procedures, program numbers, parameter types, etc.) and
details about how to drive the HRPC run-time system in order to
perform a call.  Using stubs as drivers isolates
the user from tedious programming that is extraneous to his/her
main purpose \- building the application.
.PP
In order to use stub routines correctly, the user must
know the interface to each routine and any conventions regarding
how parameters are passed to the stub.
These conventions depend on the programming language in which
the stubs are generated.  The current HRPC stub
compiler generates stubs written in C.  As a result of this, the burden
for adhering to the conventions falls mainly on the user.
.PP
The stub compiler is invoked
by uttering the command \*Qhrpcstubs filename\*U,
where \fBfilename\fP is the name of the Courier file.   Barring
any  errors,  the stub generator produces five new files
in the current directory:
.DS
<ProgName>\fB.h\fP
<ProgName>\fB_defs.h\fP
<ProgName>\fB_client.c\fP
<ProgName>\fB_server.c\fP
<ProgName>\fB_otw.c\fP
.DE
where <ProgName> is the program name given in the Courier  file.
<ProgName>\fB.h\fP contains type and external declarations
for use with C programs and it \fImust\fP be included by all application  code
that uses the interface.  The \fB_otw.c\fP  file  contains
routines  for  marshalling and unmarshalling user-defined data
types.  The \fB_client.c\fP file contains stubs used by the client
program when making an RPC.
The \fB_server.c\fP file contains analogous stubs used by
the server to receive RPC requests.
If something is wrong with the interface description, the  stub  compiler
generates error messages of the cryptic \*Qsyntax error\*U variety.   It
does, however, give  you  line numbers to work with.
.KF
.LS
UnixFinger : PROGRAM 25791 VERSION 1 =
BEGIN
    -- This is a translation of the passwd structure in <pwd.h>
    Passwd : TYPE = RECORD [
	pw_name, pw_passwd, pw_dir, pw_shell : STRING,
	pw_uid, pw_gid : CARDINAL,
	pw_quota : LONG CARDINAL
    ];

    UserInfo : TYPE = RECORD [
	pwd 	: Passwd,
	forward : STRING
    ];

    -- OS level error code.
    SysStat : TYPE = LONG INTEGER;

    -- Interface level error code.
    LookUpStat : TYPE = { success(0), noSuchUser(1) };

    -- Returned for each user.
    PerUser : TYPE = CHOICE LookUpStat OF {
		success    => UserInfo,
		noSuchUser => RECORD[]     -- i.e. no data
    };

    -- Remote entry points.
    LookupUid   : PROCEDURE [ uid : CARDINAL ] 
		    RETURNS [ status : SysStat,  uinfo : PerUser ] = 1;

    -- Takes a list, returns a list
    UserNameList : TYPE = SEQUENCE OF STRING;
    ResultList   : TYPE = SEQUENCE OF PerUser;
    
    LookupUsers : PROCEDURE [ users : UserNameList ]
			RETURNS [ results : ResultList ]
		  = 1;
END.
.LE
.ce
Figure 1. Example Interface Description
.sp
.KE
.PP
The \fB.c\fP files must be compiled and the results linked in with the
application code.  Details about how to do this are contained in later
sections describing how to build client and server programs.  For now
we concentrate on stub properties that are independent of both
the application and the different processing requirements of client
and server.
.hd 2 "Syntax and Scope of Names"
.PP
Types and procedures declared by an interface are
accessible  by  prefixing \fB<ProgName>_\fP to the name given in
the interface.  Thus, referring to the example in Figure 1,
some typical type names used by the application would be
\fBUnixFinger_Passwd\fP and \fBUnixFinger_ResultList\fP.
Similarly, a client application would access the (stubs for)
remote procedures by the names \fBUnixFinger_LookupUid\fP and
\fBUnixFinger_LookupUsers\fP.  It is possible to refer to
interface-defined names without the \fB<ProgName>_\fP prefix
by including the \fB_defs.h\fP file rather than the \fB.h\fP file.
This usage is discouraged however.  Confusion will result
if you access two or more interfaces, each of
which defines a type or remote procedure of the same name.
.hd 2 "Mapping Courier Types To C Types"
.PP
Since the C language stubs are generated from Courier interface
descriptions, it is necessary to map Courier IDL types onto
types recognized by the C compiler.  This is relatively trivial
for predefined Courier types and only slightly more difficult
for constructed types.
.hd 3 "Predefined Types"
.PP
Predefined Courier types are mapped actual C types by a set of
\*Qtypedefs\*U, as shown in Table 3.
You should \fIalways\fP, \fIALWAYS\fP use
the C type name when declaring variables that will be parameters
to stub routines.
.TS
center tab (%) box;
c s s
c s s
c | c | c
l | l | l.
Table 3
Courier Base Types
=
Courier type%C typedef%Implemented as:
_
CARDINAL%Cardinal%unsigned short
LONG CARDINAL%LongCardinal%unsigned long
INTEGER%Integer%short
LONG INTEGER%LongInteger%long
BOOLEAN%Boolean%char
UNSPECIFIED%Unspecified%unsigned short
LONG UNSPECIFIED%LongUnspecified%unsigned long
STRING%String%char *
.TE
These typedefs are contained in a standard include file, <HRPC/cTypeDefs.h>,
that is automatically included when you explicitly include the
<ProgName>\fB.h\fP file.
.hd 3 "Constructed Types"
.PP
The Courier \fBENUMERATION\fP, 
\fBARRAY\fP, and (non-null) \fBRECORD\fP types  correspond
to C enums, arrays, and structures respectively.  The Courier null
record  corresponds to a LongInteger.
.PP
The Courier \fBSEQUENCE\fP and \fBCHOICE\fP types pose some problems when
they are
mapped into C.  This is because an object of these types must contain
run-time information (the length  of  the sequence or which choice is
present) that is implicit in Courier, but must be made explicit in C.
Furthermore,  the  C  programmer  must bear the responsibility of keeping
this information consistent.
.PP
A \fBSEQUENCE\fP is mapped into a C structure:
.LS
typedef struct {
	Cardinal length;
	<SequenceElementTypeName> *sequence;
} <SequenceTypeName>;
.LE
The \fBlength\fP contains the number of elements in the sequence.
The \fBsequence\fP field contains a pointer to a contiguous chunk of
memory containing the elements of the sequence.
The elements of the sequence  can be accessed  using either array notation
(\fBsequence[i]\fP) or pointer arithmetic.  The consistency requirement
is that \fBlength\fP contain the number of actual sequence elements.
.PP
A \fBCHOICE\fP type is mapped into a structure consisting  of an  enumeration
element called \fBdesignator\fP, and a union of all the possible choices.
The designator is of the enumeration type defined (implicitly or explicitly)
in the declaration of the choice type.  If this  enumeration has the symbolic
values \fBA\fP, \fBB\fP, and \fBC\fP, then the choices are accessible as
\fBA_case\fP, \fBB_case\fP,  and  \fBC_case\fP. For instance, the C type
generated for the \fBPerUser\fP type in the example program is:
.LS
typedef enum {
	success = 0,
	noSuchUser = 1
} UnixFinger_LookUpStat;

struct UnixFinger_PerUser {
	UnixFinger_LookUpStat designator;
	union {
		UnixFinger_UserInfo u_success;
#define success_case u.u_success
		NilRecord u_noSuchUser;
#define noSuchUser_case u.u_noSuchUser
	} u;
};
.LE
.LP
The consistency requirement
is  that \fBdesignator\fP  contain the enumeration value corresponding to
which choice currently  occupies  the union.
.hd 2 "Passing Parameters"
.PP
The C language has some quirky rules regarding how parameters
of different types are passed.  Routines generated by the stub
compiler expect (and abide by) a single overall parameter passing
convention \- that each parameter (input or output) takes the
same amount  of  space on the stack.  There are two different
circumstances: 1) you supply
parameters to the stub (client case) and 2) the stub supplies parameters
to you (server case).  Obviously,
given the rules for one case you can infer those for the other,
but for completeness we will spell it out.  First, the client case:
.RS
.IP \-
Never pass the address of an input parameter (\fIi.e\fP,
never use '&' in front of the name), unless the  parameter
is a \fBSEQUENCE\fP or \fBRECORD\fP type.  In the latter case always
pass the address.
.IP \-
Always pass the address of an output parameter,
unless the parameter is an
\fBARRAY\fP, in which case never prefix its name with an `&'.
.RE
.LP
In the server case the following rules apply to formal parameter
declarations in the application routine:
.RS
.IP \-
Input parameters are always passed by value except for \fBSEQUENCE\fP
and \fBRECORD\fP types. That is,
only \fBSEQUENCE\fPs and \fBRECORD\fPs have a '*' in front of their names
in the formal parameter declaration list.
.IP \-
Output parameters are always passed by reference except for
\fBARRAY\fPs.
.RE
.LP
The term \*Qtype\*U here applies to the outermost constructor.  For
instance, if a parameter is a \fBSEQUENCE OF ARRAY\fP it is always passed by
reference.  If the parameter is an \fBARRAY OF SEQUENCE\fP
it is always passed \*Qby value\*U.  These rules make a good
deal of sense if you  have
some experience  programming  in C.  If you don't have that experience, be
of good cheer.  You will get used to it.
.hd 2 "Storage Allocation And Deallocation"
.PP
The amount of memory occupied by\fBSTRING\fP and \fBSEQUENCE\fP
parameters is determined at run-time.\**
.FS
\fBCHOICE\fPs are defined in terms of a C \fIunion\fPs
and always occupy the
storage associated with the largest variant.
.FE
When a \fBSTRING\fP
or \fBSEQUENCE\fP appears as a server-side input parameter
or a client-side result parameter, the HRPC run-time system
automatically allocates the necessary storage.
In these cases, the receiver is responsible
for deallocating this storage by
means of the standard Unix routine \fIfree\fP(3), e.g.,
\fIfree(stringVar)\fP or \fIfree(sequenceVar.sequence)\fP.
.PP
In the case of client-side inputs and server-side outputs, the
burden for allocating space is placed on the application.  If necessary, this
allocation should be done using the Unix library routine \fImalloc\fP(3).
For client-side inputs, the client is responsible for any deallocation.
The situation is slightly more complicated for output parameters dynamically
allocated by the server.  Due to the way stubs work, it is difficult
(but still possible) for the server code to deallocate space since the
called procedure must \*Qreturn\*U in order for the reply to be
generated.  By default, \fIall\fP dynamic result parameters are
deallocated by server stub after the reply is generated.
Automatic 
deallocation can be turned off by using a stub generator \*Qpragma\*U.
A comment of the form \*Q\fC--$FreeRes-\fP\*U in the interface definition
with disable stub-level deallocation
for any procedures defined following the pragma.  Deallocation
can be turned on again by using \*Q\fC--$FreeRes+\fP\*U.
.PP
Note that as far as the stub generator is concerned,
whether or not a parameter is dynamically allocated
is determined sole by the parameter's type.  It is perfectly
permissible to return statically allocated \fBSTRING\fPs
and \fBSEQUENCE\fPs, but in these cases beware of the automatic
deallocation.  Also note that automatic deallocation applies to
\fIall\fP result parameters, not just some of them.
.PP
It may seem that a lot of excruciating detail has been presented in this
section.
However, it is important detail.  You will have nothing but grief if
you ignore the rules concerning manipulation of the programming language
structures created by the stub generator.
.hd 2 "Courier \*QInclude\*U Files"
.PP
The Courier IDL provides a means of \*Qincluding\*U interface definitions
by means of the \fBDEPENDS UPON\fP construct.  For instance, suppose
that your interface made use of a type declared in \fBfoo.cr\fP.
You would pick up those definitions by putting the line:
.LS
DEPENDS UPON foo (87654) VERSION 1;
.LE
.LP
in your IDL, where 87654 is foo's program number.  When the
stub compiler sees this construct it needs two things:
.RS
.IP \-
access to the actual \fB.cr\fP file
.IP \-
a pathname for the foo interface \fB.h\fP files that
must be included in the stubs
.RE
.LP
Note that the relevant \fB.h\fP files are not created as a result
of a \fBDEPENDS UPON\fP; they are assumed to already exist.
.PP
The HRPC stub generator uses the following rules to locate
the necessary files:
.RS
.IP \-
If the interface name is a simple identifier, then the \fB.cr\fP
file is assumed to be in the directory \fI<HRPC/Interfaces>\fP
and the \fB.h\fP file(s) are in \fI<HRPC/CIncludes>\fP.
.IP \-
If the interface names begins with a Unix pathname character ('~', '/',
or '.'), then the \fB.cr\fP and \fB.h\fP files are assumed to be
in the directory given by the pathname.
.RE
.hd 1 "Constructing the Client Program"
.PP
Once you have created an IDL description of your service and run it
through the stub generator, there is nothing left to do but actually
implement the service and the client program that uses it.  Creating
a client is simpler than creating a server, so we will describe client
construction first.  To call a remote procedure, your client
code must do three things:
.RS
.IP \-
Declare a variable of type \fIHRPCBinding *\fP for the
remote interface.
.IP \-
Initialize the binding by \fIimporting\fP the remote interface.
.IP \-
Call the remote procedure via a client-side stub, providing the
binding as an \*Qextra\*U parameter.
.RE
.PP
The name of the import routine depends on the name of the interface,
i.e., <ProgName>\fB_Import\fP.  However, the number and type of the
import parameters is always the same:
.LS
HRPCErrRec *<ProgName>_Import( fInterfaceName, fServBnd )
    char	*fInterfaceName;	/* \*QInterface\*U Name */
    HRPCBinding **fServBnd;		/* Address of an HRPCBinding pointer */
.LE
The \fIfInterfaceName\fP is theoretically the HCS name of service
to be called.  In the current implementation, this name should be
the host name of some machine on the network.
\fB_Import\fP returns a binding to the service running on
that host in the \fIServBnd\fP parameter. 
Figure 2 gives the relevant code for a \fIUnixFinger\fP client.
Here is a quick quiz:  Why is the address of \fIwho\fP passed
even though \fIwho\fP is an input parameter?
.KF
.LS
#include "UnixFinger.h"
main(argc, argv)
    int  argc;
    char *argv[];
{
    HRPCBinding *bptr;
    UnixFinger_ResultList results;
    UnixFinger_UserNameList who;
    UnixFinger_SysStat fingStat;
    HRPCErrRec *hrpcStat;

    /* Import the interface */
    hrpcStat = UnixFinger_Import( "larry", &bptr );
    if ( hprcStat ) {
	HRPCperror( hrpcStat );
	exit( 1 );
    }

    /* Initialize query list */
    who.length = 1;
    who.sequence[0] = "Roccoco Filigree";

    /* Actually call the remote procedure (via the stub) */
    hrpcStat = UnixFinger_LookupUsers( bptr, &who, &fingStat, &results );
    if ( hrpcStat ) {
	HRPCperror( hrpcStat );
	exit( 1 );
    }

    /* ... whatever ... */
    CloseHRPCBinding( bptr );
}
.LE
.ce
Figure 2. Example client program
.sp
.KE
.PP
Note the call to the routine \fBCloseHRPCBinding\fP.
There is a limit (imposed by Unix) on the number of \*Qopen\*U
bindings that can be in use at any one time.
When you are done making calls to a server, you should always
\*Qclose\*U the associated binding,   Failing to call \fBCloseHRPCBinding\fP
when you are done with a binding will ultimately result in running
out of operating system resources (file descriptors).  
At that point you will be unable to make calls or import new interfaces.
An almost certain sign that you have exhausted these resources is
a situation along the lines of \*QI can make 23 calls and then
everything stops functioning\*U.  The number 23 is magic as
far as open file descriptors go.
.PP
Remember that it is not necessary to import the server for every call;
the import should be done once before making the first call.
After the initial import, you can use the binding to make any number
of calls.\**
.FS
The usual semantics of RPC make bindings prime candidates for
\*Qgarbage collection\*U or re-use in a manner transparent
to the user.  Maybe in the next release.
.FE
.hd 2 "Error Reporting"
.PP
Note that \fB_Import\fP returns a
pointer to an \fIHRPCErrRec\fP.  \fIHRPCErrRec\fPs are the
way HRPC-level (\fInot\fP application-level) errors are reported.
All client-side stub routines also return such a pointer.
In the vast majority of cases, the pointer will
be NULL, meaning that the call succeeded.  If the
pointer is non-NULL, you can get an idea of what has gone
wrong by passing the error pointer to the routine \fBHRPCperror\fP.
An informative message will be printed on \fIstderr\fP.  More information
on errors is in Section 7.6.
.PP
In previous releases of HRPC, the general rule was to abort the
entire program if an error was encountered.  This is no longer
the case and you should make a habit of checking for errors.
Failure to do so will result in the program blowing up in
mysterious ways far from the point of the original fault.
.hd 2 "Using \fImake\fP(1)"
.PP
Figuring out how to use the \fImake\fP utility in the context of
HRPC takes some thinking.  To save you time
we present an example client (and server) \fImakefile\fP in Figure 3.
.KF
.LS
HRPCCLIENT = hrpcfinger.o UnixFinger_client.o UnixFinger_otw.o
$(HRPCCLIENT):  UnixFinger.h /usr/include/HRPC/basicRpc.h

HRPCSERVER = server.o UnixFinger_server.o UnixFinger_otw.o
$(HRPCSERVER):  UnixFinger.h /usr/include/HRPC/basicRpc.h

hrpcfinger:  $(HRPCCLIENT)
        cc -o hrpcfinger $(HRPCCLIENT) -lHRPC

hrpcserver: $(HRPCSERVER)
	cc -o server $(HRPCSERVER) -lHPRC

UnixFinger.h \e
UnixFinger_client.c \e
UnixFinger_server.c \e
UnixFinger_otw.c:     UnixFinger.cr
        hrpcstubs UnixFinger.cr
 
.c.o: ;cc -c -O $*.c
.LE
.sp
.ce
Figure 3. Example client makefile.
.sp
.KE
.PP
You have all used \fImake\fP(1) before and the intent here is
merely to show how to put in the dependencies for the files
created by the stub compiler.
.RS
.IP \-
\fIUnixFinger.cr\fP is the HRPC IDL specification of the remote
interface.  The four files which depend on a \fI.cr\fP file are
generated by the HRPC stub compiler.
.IP \-
The line beginning with \*Q\fIHRPCCLIENT\fP =\*U defines the object
files that the client depends on.
.IP \-
The line beginning with \*Q\fI$(HRPCCLIENT)\fP\*U declares the
include files that the object modules depend on.  Note that
we have listed a dependency on the major HRPC include file,
\fIbasicRpc.h\fP.  It is a wise idea to do this since HRPC
changes occasionally and this is a good way to keep up to date.
.IP \-
The line beginning with \*Q\fIhrpcfinger:\fP\*U declares that
\fIhrpcfinger\fP
depends on its object files.  The following line
simply performs the linking to create the executable.  Note the
conventional method of referring to the HRPC library with the
\fI-l\fP switch.
.RE
.hd 1 "Constructing The Server"
.PP
Creating a server is rather more complicated than creating a client.
This is because services interact to a much larger extent with
the HCS system as a whole, requiring the use of nameservers
and binding agents.  Basically a server consists of two parts:
.RS
.IP \-
A set of procedures implementing functions
defined by the interface specification.
.IP \-
A main program that performs certain HRPC initialization operations.
.RE
.LP
The HRPC run-time system assumes that the names of procedures follow
the naming rules given in Section 3.2
and that those routines obey exactly the parameter passing conventions
given in Section 3.4.  The run-time also assumes one other thing:
each procedure accepts as its first parameter a pointer to an
\fIHRPCBinding\fP structure.  In most cases the server routine doesn't
have to do anything more with this parameter than make sure it is
declared.
.PP
Going back to our example once again, the C routines to implement
the two Lookup functions would be defined in the following manner:
.LS
#define HRPC_SERVER
#include "UnixFinger.h"

void UnixFinger_LookupUid( binding, uid, status, uinfo )
    HRPCBinding *binding;
    Cardinal uid;
    UnixFinger_Systat *status;
    UnixFinger_PerUser *uinfo;
{
	/* whatever */
}

void UnixFinger_LookupUsers( binding, users, status, results )
    HRPCBinding *binding;
    UnixFinger_UserNameList *user;
    UnixFinger_Systat *status;
    UnixFinger_ResultList *results;
{
	/* whatever */
}
.LE
.LP
Notice that prior to including the file UnixFinger.h, the symbol
\*QHRPC_SERVER\*U is defined.  This is necessary because the
the return values of the routines with the same name change,
depending on whether they are called from within a server or
a client.  You should be sure to define \*QHRPC_SERVER\*U before
including the files associated with the interface(s) you are
implementing and undefining it before including interfaces of
which you are a client.
.PP
Notice also that the functions return a \fBvoid\fP result.
At present there is no communication between application
routine and sever stub.  As previously mentioned, any
application level errors must be returned as explicit
parameters in the remote call itself.
.hd 2 "Exporting The Server"
.PP
In order for clients to call a server, that server
must first advertise its presence.
The process by which this advertising takes place is called
\fIexporting the interface\fP.  The vast majority of the
work involved in exporting is done for you by the HRPC system.
All the user has to do is call the local procedure \*Q<ProgName>_Export\*U
created by the stub generator.  As implied by the name, some
actions performed by this routine are specific to a single server.
However, the actual interface to <ProgName>_Export is the exactly the same
for all servers:
.LS
HRPCErrRec * <ProgName>_Export( fName, fExpFlags, fSpkPrefs, fNumB, fBindings )
	String fName;
	int *fExpFlags;
	SpeakDefs_Speak fSpkPrefs[];
	int *fNumB;
	HRPCBinding *fBindings[];
.LE
.LP
The \fIfName\fP parameter is supposed to be the name of this particular
instance of the server.  The current HRPC implementation
ignores this parameter but you have to fill it in anyhow.  The safest
bet is to use the result of \fIgethostname\fP(2).  \fIFExpFlags\fP
is value/result parameter.  The input value is used to select various
options possible at export time.  The result value indicates the
\*Qtype\*U of export performed.
When you are in the development stage, use 0 (zero) as the value of
\fIfExpFlags\fP.\**
.FS
More about \fIfExpFlags\fP can be found in the section \*QExtra For
Experts\*U.
.FE
The array \fIfSpkPrefs\fP informs the run-time system which
RPC protocols the server wishes to use.  This is something you
should think about, since not all protocols provide equal functionality.
\fIFNumB\fP is a value-result parameter.  It initially contains
the number of elements in \fIfSpkPrefs\fP.  When the export completes,
\fIfNumB\fP contains the number of bindings actually created.  The
bindings themselves are in the \fIfBindings\fP array.
It is perfectly legitmate for the number of bindings returned to be
unequal to the number of \fIfSpkPrefs\fP initially supplied.
.ig
.PP
The export routine currently does not return any status values.
It either succeeds or it blows you completely out of the water
after printing an error message.  For the present, this is considered
reasonable behaviour by the implementors.
..
.PP
After successfully exporting itself, there is nothing 
for the server to do but sit around waiting for somebody to call
it.  Waiting for incoming calls and dispatching to the appropriate
application procedure
is the province of another routine created by the stub generator,
\fB<ProgName>_Server\fP.  Again, the interface to this routine is
the same for all servers:
.LS
<ProgName>_Server( fNumB, fBindings )
	int fNumB;
	HRPCBinding *fBindings[];
.LE
The inputs are the number of bindings and the array of bindings
itself.  In general, this routine never returns.  It is an
endless loop that waits for a call to come in, decides which
operation is requested, unmarshalls the input parameters,
calls the user-written routine, marshalls the result parameters,
sends a reply, and goes back to wait for the next call.
Note that this wait-call-reply loop is completely synchronous.
A server process handles one and only one call at a time.
Figure 4 contains an example of main program for the UnixFinger
service.
.KF
.LS
#include <HRPC/basicRpc.h>

#define HRPC_SERVER
#include "UnixFinger.h"

....

main( argc, argv )
...
{
    HRPCBinding **exports;
    int expFlags = 0;
    SpeakDefs_Speak spkPrefs[2];
    int numExp;
    char thisHost[80];

    /* Tell which RPC systems we want to emulate */
    spkPrefs[0] = COURIER_COURIER_SPP;
    spkPrefs[1] = SUN_XDR_TCP;
    numExp = 2;

    /* Export ourselves */
    gethostname( thisHost, sizeof(thisHost) );
    UnixFinger_Export( thisHost, &expFlags, spkPrefs, &numExp, &exports );

    /* Service requests */
    UnixFinger_Server( numExp, exports );
}
.LE
.sp
.ce
Figure 4.  Example server program
.sp
.KE
.PP
There is one exception to the endless loop behaviour
of the \fB_Server\fP routine.  If at some point it becomes impossible
for any more calls to be received, usually because all of the
bindings you are \*Qlistening\*U on have been closed, \fB_Server\fP
will return.  A normal return from the server loop can also be
provoked by using a small \*Qhook\*U in the HRPC run-time.
.LS
HRPCSetRequestTMO( fTmVal, fExitProc )
	struct timeval *fTmVal;
	int (*fExitProc)();
.LE
.LP
You call this routine to define how long you want to wait
for a call to arrive before the wait loop times out.
The semantics associated with \fIfTmVal\fP are exactly those
associated with the \fItimeout\fP parameter of the \fIselect\fP(2)
system call.  You can also
provide a user-written procedure, \fIfExitProc\fP,
to be called when a timeout occurs.  It is assumed that this routine
takes no parameters and that it returns either 0 or non-zero.
If \fIExitProc\fP returns non-zero, the run-time will resume
waiting for messages; if zero is returned, the \fB_Server\fP routine
will perform a normal return.  If a timeout value is set using
\fIHRPCSetRequestTMO\fP but \fIfExitProc\fP is specified as 0
(zero), the entire server process will terminate if a timeout
occurs.
.PP
Before you can run the your server program, there is one more
thing you must do.  You must provide some information describing
you interface to HNS, the HCS naming service.
You only have to provide this information once, when you first
create a service, not every time the service is run.
Providing naming information is  currently one of the thornier aspects
using of HRPC.
.hd 1 "\*QNames\*U, Binding Agents and Registration"
.LP
[The information in this section is subject to rapid and unexpected
change, possibly for the better.  What is described should be thought
of as a temporary situtation, useful only until [Schwartz 87/88]
comes on-line.]
.PP
One of the goals of HRPC is to provide services that are accessible
to \*Qnative\*U RPC systems that have no idea that HRPC exists \-
an HRPC service looks and acts just like a service developed under
the native system.
Thus, HRPC programs must live in several different worlds.  One world
consists of HCS itself.
The other worlds consist of the \*Qoperational contexts\*U
associated of each of the RPC systems emulated by HRPC.  Although HRPC
is largely successful a shielding the user from the details of actual
RPC mechanisms, it is \fIcurrently\fP somewhat less successful with
regard to these larger contexts, which encompass \fInaming\fP and
\fIbinding\fP.
.PP
Recall that binding is the process by which a client is
associated with a particular server at the time the client starts
execution.  As a general rule, a client initates the binding
process by specifying the \fIname\fP of a service.  Armed with
the service name, an RPC system communicates with a \fIbinding agent\fP to
obtain information regarding the service.  A binding agent operates
on behalf of all services that use a particular RPC system.  From
the standpoint of that RPC system, there is only one binding agent \-
the one that RPC system uses.\**
.FS
From the HCS/HRPC standpoint, the binding agents of individual
systems are considered \*Qnative\*U software that cannot be modified.
Under certain circumstances (cf. \fIExtra For Experts\fP) this
non-modifiability assumption is violated.
.FE
This means that HRPC services must provide binding information
to the binding agents of each native RPC system, including HCS
itself.
.PP
Although this may sound a little daunting at first, the nuts and
bolts of the implementation are simple if tedious.
.hd 2 "HRPC Names"
.PP
The naming/binding agent for HCS is known as the \fIHeterogenous
Name Server\fP (HNS).  Currently HNS uses the traditional Unix vehicle
of an ASCII file to implement a data base of available services.
This file currently lives in:
.LS
/usr/new/lib/HRPC/fakeNS
.LE
No amount of words can make this arrangement palatable, so we will
explain things as quickly as possible.
Each line (except comment lines,
beginning with a '#') describes a particular HRPC service configuration.
The format is:
.LS
<ProgramName> <HostName> <Speak> [<HostAddress>] <PortNum> <ProgramNumber> <UseBa>
.LE
<ProgramName> and <ProgramNumber> must be the same as those in the
program header of the server's interface description (\fB.cr\fP file).
Make sure that there are no other entries in the file using these
same numbers.  There will be one line for \fIeach SpeakType\fP
used by the server.  The remaining fields in each entry are totally
dependent on the <Speak> field and are defined in Table 4.
.KF
.TS
center tab(%) box;
c s s s s s
c s s s s s
c | c | c | c | c | c
c | l | l | l | l | l.
Table 4
Canonical fakeNS <Speak> entries
_
<Speak>%Symbolic Name%<PortNum>%<UseBA>%<HostName>%<HostAddress>
=
1%SUN_XDR_TCP%111%true%IP hostname%\-
2%SUN_XDR_UDP%111%true%IP hostname%\-
3%COURIER_COURIER_SPP%5%false%CH local name\u\s-21\s0\d%XNS address\u\s-22\s0\d
.TE
.ps -2
.vs -2
.in +10
.ti -5
1. Only the \*Qlocal name\*U part of the full domain name,
i.e., \*QMizar:CS:UWash\*U is entered as just \*QMizar\*U.
.ti -5
2. All components are expressed in hexadecimal notation.
.in -10
.vs +2
.ps +2
.KE
.ig
.\" Extra lines for table -- ignore for now
4%DEC_SRC_UDP%??%true%IP hostname%\-
5%RAW_TCP%per service\u\s-23\s0\d%false%IP hostname%\-
6%RAW_UDP%per service\u\s-23\s0\d%false%IP hostname%\-
..
.\" Extra lines for table notes, ditto
.ig
.ti -5
3. Do \fInot\fP assume that you can use any number.  Ask for one to
be assigned to you.
..
.PP
When you are developing an application, it can be something of a
hassle to run around changing all these files every 10 minutes.
The following trick can alleviate some of the problem:
Invoke the stub compiler with the command line switch \*Q-bhack\*U.
This will produce stubs that ignore the \fIfakeNS\fP file and
assume to all server names represent an IP hostname.  Note, however,
that this will only work if both the client and the server are using
a SUN RPC configuration.
.hd 2 "Courier-RPC Names"
.PP
If you wish to make your server accessible via the Xerox Courier
RPC (either the \*Qreal\*U Xerox implementation or the Cornell
implementation on the VAXen),
then you need to add a line to the file:
.LS
/usr/include/HRPC/Interfaces/interfaceList
.LE
on the server's host machine.  The format of this line is:
.LS
<ProgramName> <ProgramNumber> <ProgramVersion> <crFilePath> <exeFilePath>
.LE
The <ProgramName>, <ProgramNumber> and <ProgramVersion> are the same
as those in the server's \fB.cr\fP file.  Make sure
that the program number and version number are unique throughout the file.
If the description contains protocol-dependent program numbers, use
the one associated with the \fICOUR\fP definition.  <crFilePath> is
the Unix pathname of the server's \fB.cr\fP file.  This pathname is
used by the stub compiler in the (very unlikely) event that your
server interface appears in a \fIDEPENDS UPON\fP clause in another
interface description.  Similarly, <exeFilePath>
is the pathname of the server's executable image.  This is needed
since the default behaviour of the Courier-RPC binding agent is to
instantiate a separate server process for each in-bound \*Qconnection\*U.
.PP
You also need to be sure that the Courier-RPC binding agent is up
and running.  It is usually started when Unix is booted, but has
been known to become confused.  The simplest way to determine if
it is still there is say:
.LS
netstat -a -f ns
.LE
It you see a line of the form (the \*Q*.5H\*U is the important part):
.LS
spp	0	 0	*.5H	*.*	LISTEN
.LE
the all is well.  If you do not see this line
then you will have to find a privileged individual to start up
the binding agent.
.hd 2 "SUN-RPC Names"
.PP
The binding agent for SUN-RPC does not require you to update any files.
However, you must again be sure that the binding agent is running.
Issue the command:
.LS
netstat -a -f ip | grep sunrpc
.LE
You should see two lines (the \*Q*.sunrpc\*U is the important part):
.LS
tcp	0	0	*.sunrpc	*.*	LISTEN
udp	0	0	*.sunrpc	*.*
.LE
If these lines are absent, you will again have to locate a 
privileged individual to start the binding agent.
.PP
The final thing you have to do is make sure that your server
is running.  By default, the SUN family of RPC assumes that the
server process is started by external means and that there is only
one server per machine.  (Compare this with the Courier scheme
mentioned above.)  Just run your server in the background, i.e.
\*Qfooserver &\*U.  Of course, your server will not be a proper
daemon (which would be nice) but you can fix that later, right?
.hd 1 "Extra For Experts"
.PP
Previous sections have labored to keep you blissfully ignorant of
the details of the HRPC run-time system.  The discussion has been
mainly limited to explaining the use of routines created for you be the
stub generator.  However, for certain applications it may be
necessary to directly call the HRPC run-time system.
This section describes some of the primitives available and provides
examples of their use.
.hd 2 "Configuration Information"
.PP
One goal of HRPC is to free the user from worrying about the
exact details of which emulated RPC system is used during
an actual call.  It is in the nature of things, however,
that some people will \fIwant\fP to know this information.  Thus
there are several HRPC primitives for inquiring about
the configuration being used.  Each of these primitives
takes a single parameter \- a pointer to an \fBHRPCBinding\fP.
.RS
.IP "SpeakDefs_Speak HRPCGetSpeakType( fBptr )" 10
Return the \fISpeakType\fP being used by this binding: one of
\fBSUN_XDR_TCP\fP, \fBSUN_XDR_UDP\fP, \fBCOURIER_COURIER_SPP\fP.
.IP "int HRPCGetRpcType( fBptr )" 10
Return the RPC protocol being used by this binding: one of
\fBSUNRPC\fP, \fBCOURRPC\fP.
.IP "int HRPCGetOtwType( fBptr )" 10
Return the OTW protocol being used by this binding: one of
\fBSUNOTW\fP, \fBCOUROTW\fP.
.IP "int HRPCGetTranspType( fBptr )" 10
Return the network transport protocol being used by this binding:
one of \fBTCPTRANSP\fP, \fBUDPTRANSP\fP, \fBXNSTRANSP\fP.
.RE
.LP
The symbolic names of the return values are defined in
\fI<HRPC/basicRpc.h>\fP.  This file is automatically included
by any of the files produced by the stub generator.
.hd 2 "Writing Your Own Server Loop"
.PP
The HRPC system takes a very simple-minded view of how servers
operate:  the server process merely exports itself and then
goes into an infinite loop that waits for a request to arrive,
processes the request, sends an answer and goes back to wait
for the next request.  This model does indeed hold for the
majority of cases.  To assist users, the HRPC stub generator
produces a procedure, \fB<ProgName>_Server\fP,
that implements this loop as part of each server
stub.  However, it is occasionally useful to custom build
a server loop for applications requiring more control
over \fIinter-call\fP actions.
.PP
HRPC defines two primitives for \*Qdispatching\*U incoming
requests.
.LS
int HRPCDispatch( fNBindings, fBindings, fReady )
    int		fNBindings;
    HRPCBinding *fBindings[];
    HRPCBinding **fReady;
.LE
.LP
\fIHPRCDispatch\fP is used to wait for the next request to arrive.
It takes as parameters an array of bindings on which calls are
expected and the the number of bindings in the array.
If \fIHRPCDispatch\fP returns 0 then no requests have
been received within a specified amount of time.\**
.FS
See \fIHRPCSetRequestTMO\fP in Section 5.1.
.FE
A non-zero results means a request has been received;
\fIfReady\fP contains a pointer to the approriate binding.
Note that no I/O is actually performed by \fIHRPCDispatch\fP \-
it simply returns a binding on which nonblocking I/O \fIcan\fP be
performed.
.PP
After a request arrives, the next step is to discover which remote
procedure the request is invoking.  This information is obtain by
calling the \fIInitIncoming\fP procedure defined in the binding's
RPC control block.  Using our example above, the interface to this
procedure would be called as:
.LS
(*ready->rpcDescr.InitIncoming)
.LE
The interface to this routine is
.LS
InitIncoming( fReady, fPrognum, fVersnum, fProcnum, fStatus, fSpare )
    HRPCBinding *fReady;
    long	*fPrognum;
    long	*fVersum;
    long	*fProcnum;
    int		*fStatus;
    int		fSpare;
.LE
\fIfReady\fP is the binding pointer obtained from \fIHRPCDispatch\fP.
The \fIfStatus\fP parameter indicates whether or not the call is
valid from the viewpoint of the underlying RPC protocol.  A \fIfStatus\fP
value of 0 indicates that all is well.  A non-zero value indicates
that the call has been legitimately discarded by the run-time system;
in this case no further user action is necessary and \fIHRPCDispatch\fP
should be called to wait for the next request.
.PP
\fIfPrognum\fP, \fIfVersnum\fP are respectively
the program number and version number associated with the interface
to which the request is directed.\**
.FS
Thus a single server process can implement multiple interfaces.
There is currently no support for this option built into the
stub generator.
.FE
\fIfProcnum\fP is the number of the called procedure within the interface.
Given this information the user is expected to
perform any error checking that he/she deems necessary.
The stub routine (\fInot\fP the application routine) associated
with remote procedure should then be called.
This is most easily done
by using \fIfProcnum\fP as the discriminant of a \fIcase\fP or \fIswitch\fP
statement with calls to appropriate stub routines as the \*Qarms\*U.
Each procedure number is defined by a symbolic constant of the form
.LS
<ProgName>_<ProcedureName>
.LE
in all upper case, e.g. UNIXFINGER_LOOKUPUID.
Server stub routine names have the standard form
.LS
server_<ProgName>_<ProcedureName>
.LE
For an example of what a server loop looks like, run the example
interface description through the stub compiler and check out the
procedure \fBUnixFinger_Server\fP in \fIUnixFinger_server.c\fP.
.PP
As mentioned above, the main advantage provided by writing your own
server loop is that you can program essentially arbitrary \fIinter-call\fP
actions.  An area in which this kind of flexibility is desirable is
outlined in the next section.
.hd 2 "Bindings, Binding Descriptors and Callback"
.PP
There are applications in which it is advantageous to have
the client and the server switch roles after a session has
been established.  That is, the original server initiates RPCs
to the client.  There are several ways to achieve this effect;
HRPC chose to implement a relatively unsophisticated but general
method.  This method was chosen for two reasons:
.RS
.IP \-
HRPC callback is implemented entirely in terms of (H)RPC calls.
There is no special-purpose callback mechanism (such as requiring
that the client respond to messages received prior to receiving
an RPC \*Qreply\*U message).
.IP \-
Since no special-purpose mechanism is used, \fIany\fP underlying
RPC protocol is capable of supporting callback, rather than only
those where the concept of callback is defined as part of the protocol
itself.
.RE
.PP
The simplicity and breadth of this method exacts a certain price:
Applications (client/server teams) requiring callback must
behave in a stereotyped manner:  The client makes an initial
series of calls on the server.  The last of these calls informs
the server that the client is ready to assume its (new) role
as server, receiving calls rather than making them.  After
replying to this \*Qrole reversal\*U call, the server assumes the
role of client, making calls rather than receiving them.
Finally, the server makes a role reversal call on the original
client, terminating the callback interaction.  In effect, the
client and server abide by an \fIapplication level\fP protocol
that implements callback.
.PP
The trick to this method (from the HRPC standpoint),
is allowing the client to convey binding information
concerning itself to the server and allowing the server some way
to convert this information into an actual binding to the client.
Note that the binding information must be transferred from client
to server as \fIjust another parameter\fP in an (H)RPC call.
.PP
To satisfy these requirements, HRPC defines a \fIbinding
descriptor\fP data type.  These descriptors are passed from
client to server.
HRPC primitives are provided for converting bindings
into binding descriptors and vice versa.  
.LS
ConvBindingToBD( fBptr, fBDesc )
    HRPCBinding *fBptr;
    BIND_DESCR  *fBDesc;

ConvBDtoBinding( fBindDescr, fBptr )
    BIND_DESCR  *fBindDescr;
    HRPCBinding **fBptr;
.LE
.PP
To accomplish callback,
a client exports itself as an anonymous server.  Anonymity is
achieved by using \fBEXPF_CALLBACK\fP as the input value of \fIfExpFlags\fP
in the \fB_Export\fP call.\**
.FS
No attempt is made to register anonymous servers with underlying
naming services or binding agents.  This prevents any possible
confusion resulting from serveral independent clients exporting
themselves as the \fIsame\fP server.
.FE
The client then coverts the binding produced by the export into
a binding descriptor, passing the descriptor to
the server.  The server converts the descriptor into a binding
and uses this binding to talk to the client.
.PP
Although the binding/binding descriptor primitives form the
basis for doing callback,
you cannot just call them willy-nilly and expect everything to work.
Remember that there is a \*Qprotocol\*U that must be implemented
at the application level also.
To illustrate how to program callback at the application
level, consider the Courier IDL descriptions
of a client and server given in Figure 5.\**
.FS
It is, of course possible to use a single interface description
for both client and server.  However, separate IDs
are more in keeping with the spirit and intent of HRPC callback
and are usually more efficient in terms of code size.
.FE
.KF
.mk
.DS 0
.ft C
.ps -2
.vs -2
--
-- Client-side callback interface.
-- These procedures are called by the
-- server.
--

ClientIF : PROGRAM 50450 VERSION 1 =

BEGIN
    Done :
	PROCEDURE [ n1 : LONG INTEGER ]
	  RETURNS [ thanks : LONG INTEGER ]
	= 1;

    Ask  :
	PROCEDURE [ prompt : STRING ]
	  RETURNS [ n1 : LONG INTEGER ]
	= 2;
END.
.vs +2
.ps +2
.ft P
.DE
.in +3.0i
.rt
.DS 0
.ft C
.ps -2
.vs -2
--
-- Server-side interface.
-- These procedures are called by the client.
--

ServerIF : PROGRAM 50451 VERSION 1 =

BEGIN

-- "Include" binding descriptor definitions
DEPENDS UPON Binding(1234) VERSION 1;

    Connect :
	PROCEDURE [ me : Binding.BIND_DESCR ]
	  RETURNS [ handle : LONG INTEGER ]
	= 1;

    Reverse :
	PROCEDURE [ opcode : LONG INTEGER,
		    handle : LONG INTEGER ]
	  RETURNS [ ok : LONG INTEGER ]
	= 2;

    Disconnect :
	PROCEDURE [ handle : LONG INTEGER ]
	  RETURNS [ goodbye : LONG INTEGER ]
	= 3;

END.
.in -3.0i
.vs +2
.ps +2
.ft P
.sp
.ce
Figure 5. Example of Courier IDL for Callback Application
.sp
.DE
.KE
.LP
The server defines three procedures:
.IP \fIConnect\fP
Called by the client to supply its binding descriptor.
.IP \fIReverse\fP
The \*Qrole-reversal\*U procedure. After replying to
this call, the server will initiate calls and the client
will receive them.
.IP \fIDisconnect\fP
Called by the client to indicate that it is done using
the server.
.LP
The client defines two procedures callable by the server:
.IP \fIAsk\0\fP
Called by the server and presumed to supply as results
whatever it is that the server wants.
.IP \fIDone\fP
Another role-reversal procedure that returns the server's final
result and turns the client back into a client and the server
back into a server.
.LP
It should be emphasized once again that the semantics of the
role-reversal procedures are implemented at the \fIapplication\fP
level.  There is nothing magic about the names, number or
parameter types of the procedures in this example.  As far as
the HRPC run-time system is concerned, all procedure calls are
equal.
.PP
As mentioned previously, running the example IDs through the stub compiler
produces the include files \fIClientIF.h\fP and \fIServerIF.h\fP.  The
application code for client and server will use both of these files
but under slightly different circumstances.  Inside the client, the
include sequence looks like:
.LS
#include <HRPC/basicRpc.h>
#include <HRPC/CIncludes/Binding_defs.h>
#include "SrvIF.h"
#define HRPC_SERVER
#include "ClIF.h"
.LE
.LP
That is, the client includes itself in the server mode.  In the
server, the client is included in (what else) the client mode:
.LS
#include <HRPC/basicRpc.h>
#include <HRPC/CIncludes/Binding_defs.h>
#include "ClIF.h"
#define HRPC_SERVER
#include "SrvIF.h"
.LE
.PP
Having accomplished these preliminaries, the next step is to
actually write the client and server code.  For our example,
the client code would look something like that shown in Figure 6.
.de F6
.br
.bp
.so fig6.nr
.ch F6
.bp
..
.wh -1.5i F6
.PP
In the server, this code is essentially reversed.  The key point
being that the server will exit its \*Qserver loop\*U as the
result of handling a \fB_Reverse\fP call.
.hd 2 "Server Activation Options"
.PP
There are two ways that server instances are created
or \fIactivated\fP:
.RS
.IP \fIPre-Activation\fP.
For any particular host machine, there is
one and only one instance of a server running on that host.
The server has been activated by means completely separate from (H)RPC itself,
\fIi.e.\fP, somebody starts the server at host boot-time.
.IP \fIAuto-Activation\fP
Each client-server session (perhaps even each
separate RPC) forces the activation of a separate server instance.
.RE
.LP
Each of these activation models has advantages.  For instance, the
single-server model is useful in applications requiring retention of
state information between sessions (\fIe.g.\fP, caching).  Auto-activation
is useful when an application is used
infrequently or is \*Qdedicated\*U to a single client (\fIe.g.\fP,
an RPC-callable terminal emulator).
.PP
The HRPC run-time supports both activation models.  However,
each emulated RPC protocol assumes a particular activation
model.  \*QEnforcement\*U
of this model is generally a function of the binding agent for
that protocol.  Thus, if an application wishes to override
the default activation model for some RPC protocol, it
must make that desire known to the binding agent representing
that protocol.  In keeping with Unix tradition, such
information is contained in a well-known ASCII file:
.LS
/usr/new/lib/HRPC/actPrefs
.LE
Each line of the file describes the activation preferences of
an interface.  In defiance of Unix tradition, however, the
desription is keyword-oriented rather than positional.  Each
item on a line has the form:
.LS
<keyword>'='<value>
.LE
with no white-space allowed.  Keyword/value pairs are separated
by white-space.  New-lines can be escaped by using '\\' in the
usual manner.  Table 5 summarizes the current set of keywords,
the type of value associated with each and its meaning.
.ds UP \u\s-2
.ds DN \u\s0
.KS
.na
.TS
center tab(%) box;
c s s
c s s
c c c
lb l l .
Table 5
Server Activation Information
=
Keyword%Value%Meaning
_
progn%integer%Program Number
useprog%integer%T{
Use info for following program number\*(UP1\*(DN
T}
protos%T{
\fBsun_xdr_udp\fP, \fBsun_xdr_tcp\fP, \fBcour_cour_spp\fP
T}%T{
Underlying protocols to which info applies\*(UP2\*(DN
T}
act%T{
one of \fBpre\fP,
\fBauto\fP, \fBalwaysup\fP
T}%Activation preference\*(UP3\*(DN
args%quoted string%Argv values\*(UP4\*(DN
su%string%T{
Program is suid to username given by
string value\*(UP5\*(DN
T}
exe%string%Name of executable file\*(UP6\*(DN
logf%string%Name of stdout file\*(UP6,7\*(DN
errf%string%Name of stderr file\*(UP6,7\*(DN
dir%string%\*QRoot\*U directory\*(UP6,7\*(DN
.TE
.ad
.ps -2
.vs -2
.in +10
.ti -2
1. An entry of the form \*Q\fBprogn=\fPN \fBuseprog=\fPM\*U means
that the information for program number N is the same
as for program number M, except for the program number
itself.
.ti -2
2. Multiple protocol entries are separated by '/'.
.ti -2
3. Services specified as \fBalwaysup\fP are preactivated
and are started by the binding agent itself.
.ti -2
4. Multiple argument values should be quoted, \fIe.g.\fP,
\fBargs=\fP"a b c d".
.ti -2
5. File/directory access is interpreted relative to the given
username. The executable file itself must be suid to the given
username.
.ti -2
6. File names should begin with a '/' or '~'.  In the
latter case a valid username must follow.
.ti -2
7. Directories and/or files must have valid read/write/execute privileges.
If no entry is given or permissions are incorrect, the values default
to /usr/tmp or /dev/null, as appropriate.
.KE
.PP
The activation preference is RPC-protocol independent.  That is,
the program cannot be auto-activated for SUN protocols but pre-activated
for the COURIER protocol.  
.PP
No indication of whether the interface was \fBpre\fP or \fBauto\fP
activated is returned to the client program.  However, the activation
type is return to the server program via the \fIfExpFlags\fP parameter
to \fB_Export\fP.  After a successful export, \fIfExpFlags\fP
will contain either \fBEXPF_AUTOACT\fP or \fBEXPF_PREACT\fP.\**
.FS
To save you the trouble of looking, the return value of \fIfExpFlags\fP
will always be \fBEXPF_PREACT\fP for callback exports.
.FE
.PP
The \fBUnixFinger\fP program is a good example of a program that
can make use of activation preferences.  There is no good reason to
waste resources on a permanent UnixFinger server.  However, if
\fBUnixFinger\fP was to be SUN-RPC callable, a permanent
server would have to exist.  An appropriate line in the \fIactPrefs\fP file
will create new server whenever SUN-RPC call for the interface is
received:
.LS
progn=25791 act=auto protos=sun_xdr_tcp/sun_xdr_udp \e
	exe=~nobody/hrpcfinger
.LE
.PP
In a Unix environment, auto-activation of servers entails some
security risk.  This because, for a variety of reasons, binding
agents run with super-user privileges.  To discourage abuse
of this situation, servers created by binding agents \fIalways\fP
begin their existence with an effective uid of \fInobody\fP.
.PP
Auto-activation call also lead to the creation of \*Qorphan\*U
servers.  Since auto-activation creates a separate server for
each client, if the client disappears then the server will never
be re-used.  To guard against this annoying circumstance, auto-activated
servers (and their clients) should use explicit termination protocols
at the application level.  Additionally, servers should be sure to
set a time-out, using \fIHRPCSetRequestTMO\fP.
.hd 2 "Using \fBUSERPROC\fP"
.PP
The HRPC run-time system provides routines for marshalling a
limited number of primitive and constructed data types (see Tables
2 and 3). There may be occasions when
using a data type that is not supported by the stub generator (such
as a tree or a linked list) is absolutely fundamental to an
application.  In these cases, the stub generator provides an
escape mechanism, called a \fBUSERPROC\fP, that allows
the programmer to associate a customized
marshalling routine with a particular data type.
This routine is called at RPC-time whenever a parameter of that data type
is encountered.  The word \*Qcustomized\*U does \fInot\fP mean that
the user defines new primitive data types.  \*QCustomized\*U means
that, based on the available primitive data types, the user can
define application-specific ways of organizing and demarcating
transmitted data.
.PP
The actual implementation of a \fBUSERPROC\fP routine is completely
unknown to the HRPC run-time.  However, the run-time expects that the
\fBUSERPROC\fP obeys certain rules:
.RS
.IP \-
The interface to the routine must follow exactly
to the conventions used by automatically generated marshalling routines:
each routine takes two parameters, the first is a pointer to an
HRPC binding and the second is the \fIaddress\fP of the data to
be marshalled.
.IP \-
Only one routine is associated with a data type;
this single routine must be capable of both marshalling and de-marshalling
the data.
.RE
.PP
A \fBUSERPROC\fP is associated with a data type when the type is
declared in the \fB.cr\fP file.  E.g.,
.LS
Tree : TYPE = USERPROC OtwTree <TypeDeclaration>
.LE
means that the procedure \fIOtwTree\fP will be called to marshall
parameters of type \fITree\fP.  The <TypeDeclaration> is essentially
a dummy declaration \- it does not accurately describe the type
of data being transferred.  If you \fIcould\fP accurately describe
the type using Courier, there would be no need to use a \fBUSERPROC\fP
in the first place.
.PP
As an example, we will show how a tree structure could be passed
using a \fBUSERPROC\fP.\**
.FS
Remember, this is just an example illustrating how
certain facilities can be manipulated.  No one in their right mind
would actually pass a tree in this grossly inefficient way.
.FE
Assume that the application program uses
the following definition for each node of the tree:
.LS
struct TreeNode {
	Integer data;
	struct TreeNode *lson;
	struct TreeNode *rson;
};
.LE
.LP
The Courier IDL has no concept of pointer types or how to handle
them, so we define a \fBUSERPROC\fP that implements an application
specific OTW linearization of a tree.  The example uses an
in-order traversal.  The Courier definitions look like:
.LS
TreeRoot : TYPE USERPROC OtwTreeRoot LONG CARDINAL;
TreeNode : TYPE USERPROC OtwTreeNode
		RECORD [
		    data  : INTEGER,
		    left  : BOOLEAN,
		    right : BOOLEAN
		];

AcceptTree : PROCEDURE [ root : TreeRoot ]
		RETURNS [ status : INTEGER ] = 1;
.LE
.LP
The definition of \fITreeRoot\fP as a LONG CARDINAL is merely a
\*Qplace-holder\*U rather than the actual data type.  In the implementation
the root will actually be a pointer to a tree node and the \fIOtwTreeRoot\fP
merely performs some type conversions.
.PP
The \fIOtwTreeNode\fP marshaller does the real work
and is very straightforward.  Since we are
doing an in-order linearization, \fIOtwTreeNode\fP merely writes the data
describing a particular node, including whether or not there are sub-trees,
and then recursively calls itself for each non-empty subtree.
Example routines illustrating this strategy are given in Figure 7.
.de F7
.br
.bp
.so fig7.nr
.ch F7
.bp
..
.wh -1.8i F7
.PP
In the application, the call to the \fIstub routine\fP routine would
look something like:
.LS
TreeRoot *root;
    ...
    Trees_SendTree( fBptr, root, &status );
    ...
.LE
.hd 2 "More on Error Reporting"
.PP
The HRPC system reports errors by returning a non-null pointer to an
\fIHRPCErrRec\fP structure.  An \fIHRPCErrRec\fP contains a
numeric error code that uniquely identifies the error condition.
The structure also has a pointer to a piece of memory containing
more detailed, \*Qexplanatory\*U information concerning the error.
The exact content of this memory is (theoretically) error-dependent.
You can print (on \fIstderr\fP) a message associated with the
error code by calling the routine:
.LS
void HRPCperror( fErrRec )
    HRPCErrRec *fErrRec;
.LE
.LP
The HRPC error codes themselves have a structure.  Each error code
consists of a 32-bit integer.  The high-order 16 bits contains a
facility (e.g, HRPC run-time, binding agent, name server) number.
Unix system errors have a facility number of 0.
The low-order 16 bits contain an error number relative to the facility.
VMS \fIaficionados\fP will recognize this structure immediately \-
it simplifies the problem of generating new, unique error codes.
.PP
.PP
HRPC errors are returned from the \fB_Import\fP and \fB_Export\fP
routines and from each remote call.  The symbolic names of the
error codes and a short explanation of each are contained in Tables
6 and 7.
As mentioned in Section 4.1, you should make it a habit to check
if an error has occurred.  Remember that \fIHRPCErrRec\fP's are
dynamically allocated.  When you are done \*Qusing\*U the error
information, the space it occupies should be freed up by calling:
.LS
void HRPCFreeErr( fErrRec )
    HRPCErrRec *fErrRec;
.LE
.PP
The purpose of error returns is to allow the user
to make informed decisions about what to do next if something
goes wrong.  However, in an experimental system such as HRPC
a good deal of informative context can be lost as the error
migrates from where it was detected back to the user.  To avoid
this annoyance, 
it is possible to abort the program rather than report an error
by calling the routine:
.LS
int HRPCAbortOnErr( fDoIt )
    int fDoIt;
.LE
.LP
The program will be aborted if \fIfDoIt\fP is non-zero.  The
previous value of the abort flag is returned as a result of the
call.
.PP
One final note:  HRPC does not currently support the concept of
\*Qalternate returns\*U or \*Qexceptions\*U used by application
programs to report errors.
The reason for this is that not all RPC protocols emulated by
HRPC support such actions.  Programmers should
report application errors by means of explicit return parameters.
.sp 2
.TS
center tab(%) box;
c s
c s
c | c
l | l .
Table 6
Call Errors
=
Symbolic Name%Meaning
_
HRPC_NORMAL%T{
No error
T}
HRPC_REPLYTMO%T{
Call timed out waiting for a reply
T}
HRPC_PEERDIED%T{
"Remote" side of call died
T}
HRPC_BADPROGN%T{
Wrong program number used in call
T}
HRPC_BADPROCN%T{
Remote procedure does not exist
T}
HRPC_BADPARAM%T{
Parameter mismatch
T}
HRPC_BADVERSN%T{
Version number not support
T}
HRPC_BADAUTHN%T{
Invalid authentication information
T}
HRPC_WRNGSTUB%T{
HRPCBinding parameter passed to wrong stub routine
T}
HRPC_RPCVERSN%T{
Rpc protocol version mismatch
T}
HRPC_SYSERR%T{
Error encounter by underlying OS
T}
HRPC_UNKNERR%T{
Undifferentiated error
T}
HRPC_NOSERVER%T{
Server not running
T}
.TE
.sp 2
.TS
center tab(%) box;
c s
c s
c | c
l | l .
Table 7
Import/Export Errors
=
Symbolic Name%Meaning
_
IMPORT_NORMAL%T{
No error
T}
IMPORT_NSFAILED%T{
Can't contact nameserver
T}
IMPORT_BAFAILED%T{
Can't talk to to binding agent
T}
IMPORT_BADNAME%T{
Instance name not found
T}
IMPORT_BADSPEAK%T{
Invalid/unavailable protocol selection
T}
IMPORT_BADSYNTAX%T{
Invalid name syntax
T}
IMPORT_NOTREGIS%T{
Interface inactive/unavailable
T}
IMPORT_BADHOST%T{
No such host (deprecated)
T}
EXPORT_NORMAL%T{
No error
T}
EXPORT_NSFAILED%T{
Instance name cannot be registerd with name server
T}
EXPORT_BAFAILED%T{
Instance cannot be registered with binding agent
T}
EXPORT_INUSE%T{
An instance of the interface already exists
T}
EXPORT_BADSPEAK%T{
Invalid protocol preference
T}
EXPORT_BADSYNTAX%T{
Invalid interface name syntax
T}
.TE
.hd 2 "Lightweight Process Support"
.PP
HRPC supports the use of lightweight process (\*Qthread\*U)
packages.  Note that the phrase is \*Qsupports the use of\*U,
not \*Qprovides\*U or \*Qimplements\*U.  The basic idea is
that there are numerous thread packages available and that
HRPC should be capable of functioning with any of them.  Just
as the HRPC system is built around the idea that there is
an abstract model of how any RPC protocol works, LWP
support assumes that there are certain basic operations
implemented by all thread packages.  The user supplies HRPC with a
\*Qgeneric\*U interface to these operations.  HRPC then
uses this interface to manage threads in the context of making
heterogeneous remote procedure calls.
.PP
.PP
The \*Qgeneric\*U interface presented by the external LWP package
(which is assumed to be non-preemptive with priority-based scheduling)
to the HRPC thread subsystem consists of seven procedures.
.LS
int CreateThread( procedure, stacksize, priority, parameters, name, pid)
    int (*procedure)();
    int stacksize;
    int priority;
    char *parameters;
    char *name;
    int  *pid;

int DeleteThread( pid )
    int pid;
.LE
.PP
Threads are created and deleted within HRPC via the \fBCreateThread\fP
and \fBDeleteThread\fP routines.
The lightweight process created by \fBCreateThread\fP has the specified
priority, stack size and name (if these attributes are supported by the LWP
package being used), runs the specified procedure with the arguments
pointed to by \*Qparameters\*U, and is uniquely identified by the returned
pid.
The LWP subsystem makes no assumptions about which thread executes after
calling \fBCreateThread\fP.
.LS
int Wait(event);    int MWait(cnt, events);    int Signal(event);    void Scheduler();
  char *event;        int cnt;                   char *event;
                      char *events[];
.LE
.PP
\fBWait\fP is called within HRPC to block the running thread
until the specified event occurs. \fBMWait\fP is called to wait
for a total of \fBcnt\fP occurrences of any 
of the \fBevents\fP.  \fBEvents\fP is assumed to be an
array of events, the last of which
is 0.  \fBSignal\fP is called to awaken all threads waiting on the
specified event.
HRPC assumes that a thread does not relinquish the CPU by
calling \fBSignal\fP, but makes no assumption that signals are \*Qheld\*U.
An HRPC thread relinquishes the CPU by calling \fBScheduler\fP.
.\"
.\" No provision in current implementation for pre-emptive stuff.
.\" We leave these here as a reminder.
.ig
.PP
To accommodate preemptive packages requires the
two additional procedures:
.LS
BlockScheduler();	UnblockScheduler();
.LE
.PP
HRPC requires exclusive access to internal thread-related data structures
in order to prevent possible corruption.
Since a preemptive scheduler may be invoked asynchronously, routines
accessing these structures call
\fBBlockScheduler\fP to prevent context switches.
When exclusive access
is no longer needed \fBUnblockScheduler\fP is called.
The thread subsystem ensures that a thread does not relinquish the CPU between
calls to \fBBlockScheduler\fP and \fBUnblockScheduler\fP.
We assume that preemptive LWP packages either define such exclusive
access routines or
provide primitives that can be used to obtain the necessary functionality.
If a non-preemptive package is being used, the user would specify
\fBBlockScheduler\fP and \fBUnblockScheduler\fP routines as null
routines.
..
.PP
Remember, these routines define \fIan interface not an implementation\fP.
The assumption is that (with a little work) a \*Qthin veneer\*U can
be used to provide the required semantics using any reasonable threads
package.  Each routine (execept \fBScheduler\fP) returns an integer
error code that must be one of the values defined in
\fI<HRPC/LWP/LWPdefs.h>\fP.
.PP
HRPC thread support is initialized by the application programmer
by calling the routine:
.LS
SetupLwpSupport( Create, Destroy, Wait, MWait, Signal, Scheduler );
	int (*Create)(), (*Destroy)();
	int (*Wait)(), (*MWait)();
	int (*Signal)(), (*Scheduler)();
.LE
.LP
Where the parameters are the addresses of the actual routines
implementing the interface.  If the LWP package used requires
initialization, this initialization should be performed \fIbefore\fP
calling \fBSetupLwpSupport\fP.
If \fBSetupLwpSupport\fP is not called, HRPC operates in
\fIsingle-thread\fR mode.  Thread support within HRPC is terminated
by calling the routine \fBTerminateLwpSupport\fP.  Termination
has the side effect of closing all active HRPC bindings.  Naturally,
\fBTerminateLwpSupport\fP should be called \fIbefore\fP shutting
down the underlying thread package.
.ig
.hd 1 "Where It Is"
.PP
No matter where you go, there you are.
.hd 2 "Current HRPC Installations"
.PP
HRPC is not available to all who might enjoy abusing it.
The system is currently installed on all of the SUN workstations,
all of the non-Emerald uVAXen, and
all of the \*Qresearch\*U VAXen (i.e., Wally and Larry).
.hd 2 "Source Files"
.PP
Sometimes you just have to peek, even though you know you will be scared
spitless or see something \fIreally disgusting\fP.  The source files
for HRPC live on Larry, in /usr/src/local/HRPC.  This document itself
resides in ..../HRPC/Doc/readit&weep.nr.  Watch out for that '&'.
..
.\" clear center header
.ds CH
.bp
.PX
