/*
 * Definitions for HNS VERSION 1 NUMBER 2019.
 */
#ifndef __HNS
#define __HNS
#include <HRPC/cCourierTypes.h>
#include <HRPC/basicRpc.h>
#include <HRPC/hrpcErrCodes.h>


/*
 * Definitions from DEPENDS UPON Binding inclusion
 * (must be linked with Binding_otw.c also)
 */

#include <HRPC/CIncludes/Binding.h>
typedef LongInteger HNS_HNSStatus;
typedef String HNS_HierName;

typedef struct {
	String Context;
	String Name;
} HNS_HNSName;
extern int HNS_HNSNameOtw();

typedef struct {
	String NSMName;
	String NSvcName;
	String Operation;
	Binding_BINDING_DESCR_DESCR BindingDescr;
} HNS_NSMInfo;
extern int HNS_NSMInfoOtw();

typedef struct {
	String HNSCompName;
} HNS_HNSCompListElem;
extern int HNS_HNSCompListElemOtw();

typedef struct {
	String ContextName;
	String NSvcWhereStored;
	LongUnspecified OpsNeeded;
	LongCardinal ExpectedSize;
	LongCardinal ExpectedReadRate;
	LongCardinal ExpectedWriteRate;
} HNS_ContextInfo;
extern int HNS_ContextInfoOtw();

#ifndef HRPC_SERVER
extern HRPCErrRec * HNS_Ping();
#else
extern void HNS_Ping();
#endif
#define HNS_PING 1

typedef struct {
	Boolean Enable;
} HNS_EnabBINDCacheInputs;
extern int HNS_EnabBINDCacheInputsOtw();

#ifndef HRPC_SERVER
extern HRPCErrRec * HNS_EnabBINDCache();
#else
extern void HNS_EnabBINDCache();
#endif
#define HNS_ENABBINDCACHE 2

#ifndef HRPC_SERVER
extern HRPCErrRec * HNS_DumpHNSBINDCache();
#else
extern void HNS_DumpHNSBINDCache();
#endif
#define HNS_DUMPHNSBINDCACHE 3

typedef struct {
	String NSvcName;
	Binding_BINDING_DESCR BindingDescr;
} HNS_AddNSvcBDescrInputs;
extern int HNS_AddNSvcBDescrInputsOtw();

typedef struct {
	LongInteger Status;
} HNS_AddNSvcBDescrOutputs;
extern int HNS_AddNSvcBDescrOutputsOtw();

#ifndef HRPC_SERVER
extern HRPCErrRec * HNS_AddNSvcBDescr();
#else
extern void HNS_AddNSvcBDescr();
#endif
#define HNS_ADDNSVCBDESCR 4

typedef struct {
	String NSvcName;
	Binding_BINDING_DESCR BindingDescr;
} HNS_DelNSvcBDescrInputs;
extern int HNS_DelNSvcBDescrInputsOtw();

typedef struct {
	LongInteger Status;
} HNS_DelNSvcBDescrOutputs;
extern int HNS_DelNSvcBDescrOutputsOtw();

#ifndef HRPC_SERVER
extern HRPCErrRec * HNS_DelNSvcBDescr();
#else
extern void HNS_DelNSvcBDescr();
#endif
#define HNS_DELNSVCBDESCR 5

typedef struct {
	Cardinal length;
	HNS_HNSCompListElem *sequence;
} HNS_T_r2019_12;
extern int HNS_T_r2019_12Otw();

typedef struct {
	LongInteger Status;
	HNS_T_r2019_12 NSvcNameList;
} HNS_EnumNSvcsOutputs;
extern int HNS_EnumNSvcsOutputsOtw();

#ifndef HRPC_SERVER
extern HRPCErrRec * HNS_EnumNSvcs();
#else
extern void HNS_EnumNSvcs();
#endif
#define HNS_ENUMNSVCS 6

typedef struct {
	String NSvcName;
} HNS_FindNSvcInputs;
extern int HNS_FindNSvcInputsOtw();

typedef struct {
	LongInteger Status;
	Binding_BINDING_DESCR_LIST BDList;
} HNS_FindNSvcOutputs;
extern int HNS_FindNSvcOutputsOtw();

#ifndef HRPC_SERVER
extern HRPCErrRec * HNS_FindNSvc();
#else
extern void HNS_FindNSvc();
#endif
#define HNS_FINDNSVC 7

typedef struct {
	String OpName;
	String NSvcName;
	Binding_BINDING_DESCR_DESCR BindingDescrDescr;
} HNS_AddNSMBDDescrInputs;
extern int HNS_AddNSMBDDescrInputsOtw();

typedef struct {
	LongInteger Status;
} HNS_AddNSMBDDescrOutputs;
extern int HNS_AddNSMBDDescrOutputsOtw();

#ifndef HRPC_SERVER
extern HRPCErrRec * HNS_AddNSMBDDescr();
#else
extern void HNS_AddNSMBDDescr();
#endif
#define HNS_ADDNSMBDDESCR 8

typedef struct {
	String OpName;
	String NSvcName;
	Binding_BINDING_DESCR_DESCR BindingDescrDescr;
} HNS_DelNSMBDDescrInputs;
extern int HNS_DelNSMBDDescrInputsOtw();

typedef struct {
	LongInteger Status;
} HNS_DelNSMBDDescrOutputs;
extern int HNS_DelNSMBDDescrOutputsOtw();

#ifndef HRPC_SERVER
extern HRPCErrRec * HNS_DelNSMBDDescr();
#else
extern void HNS_DelNSMBDDescr();
#endif
#define HNS_DELNSMBDDESCR 9

typedef struct {
	Cardinal length;
	HNS_HNSCompListElem *sequence;
} HNS_T_r2019_17;
extern int HNS_T_r2019_17Otw();

typedef struct {
	LongInteger Status;
	HNS_T_r2019_17 NSMNameList;
} HNS_EnumNSMsOutputs;
extern int HNS_EnumNSMsOutputsOtw();

#ifndef HRPC_SERVER
extern HRPCErrRec * HNS_EnumNSMs();
#else
extern void HNS_EnumNSMs();
#endif
#define HNS_ENUMNSMS 10

typedef struct {
	String OpName;
	String NSvcName;
} HNS_GetNSMInfoInputs;
extern int HNS_GetNSMInfoInputsOtw();

typedef struct {
	LongInteger Status;
	Binding_BINDING_DESCR_DESCR_LIST NSMBDDList;
} HNS_GetNSMInfoOutputs;
extern int HNS_GetNSMInfoOutputsOtw();

#ifndef HRPC_SERVER
extern HRPCErrRec * HNS_GetNSMInfo();
#else
extern void HNS_GetNSMInfo();
#endif
#define HNS_GETNSMINFO 11

typedef struct {
	HNS_HNSName EntityName;
	String OpName;
	Boolean NeedNSMAddr;
} HNS_FindNSMInputs;
extern int HNS_FindNSMInputsOtw();

typedef struct {
	LongInteger Status;
	String NSMName;
	Binding_BINDING_DESCR_LIST NSMBDList;
	Binding_BINDING_DESCR_LIST NSvcBDList;
} HNS_FindNSMOutputs;
extern int HNS_FindNSMOutputsOtw();

#ifndef HRPC_SERVER
extern HRPCErrRec * HNS_FindNSM();
#else
extern void HNS_FindNSM();
#endif
#define HNS_FINDNSM 12
typedef HNS_ContextInfo HNS_CreateContextInputs;

typedef struct {
	LongInteger Status;
} HNS_CreateContextOutputs;
extern int HNS_CreateContextOutputsOtw();

#ifndef HRPC_SERVER
extern HRPCErrRec * HNS_CreateContext();
#else
extern void HNS_CreateContext();
#endif
#define HNS_CREATECONTEXT 13

typedef struct {
	String ContextName;
} HNS_DelContextInputs;
extern int HNS_DelContextInputsOtw();

typedef struct {
	LongInteger Status;
} HNS_DelContextOutputs;
extern int HNS_DelContextOutputsOtw();

#ifndef HRPC_SERVER
extern HRPCErrRec * HNS_DelContext();
#else
extern void HNS_DelContext();
#endif
#define HNS_DELCONTEXT 14

typedef struct {
	Cardinal length;
	HNS_HNSCompListElem *sequence;
} HNS_T_r2019_23;
extern int HNS_T_r2019_23Otw();

typedef struct {
	LongInteger Status;
	HNS_T_r2019_23 ContextNameList;
} HNS_EnumContextsOutputs;
extern int HNS_EnumContextsOutputsOtw();

#ifndef HRPC_SERVER
extern HRPCErrRec * HNS_EnumContexts();
#else
extern void HNS_EnumContexts();
#endif
#define HNS_ENUMCONTEXTS 15

typedef struct {
	String ContextName;
} HNS_GetContextInfoInputs;
extern int HNS_GetContextInfoInputsOtw();

typedef struct {
	LongInteger Status;
	HNS_ContextInfo Info;
} HNS_GetContextInfoOutputs;
extern int HNS_GetContextInfoOutputsOtw();

#ifndef HRPC_SERVER
extern HRPCErrRec * HNS_GetContextInfo();
#else
extern void HNS_GetContextInfo();
#endif
#define HNS_GETCONTEXTINFO 16

#endif __HNS


extern HRPCErrRec *HNS_Export();
extern HRPCErrRec *HNS_Import();
