/* File: /u2/dtc/HRPC/binding/import.c  Date:  7-Apr-1986  */

/*
 * $Header: import.c,v 1.3 86/04/10 10:53:34 dtc Exp $
 * INTERFACE:	
 *
 * FUNCTION:	
 *
 * IMPORTS:	
 *
 * EXPORTS:	
 *
 * DESIGN:	
 *
 * $Log:	import.c,v $
 * Revision 1.4  86/06/16  11:05:10  oystr
 * General clean up as part of merge
 *
 * Revision 1.3  86/04/10  10:53:34  dtc
 * error conditions RETURN'ed rather than REPORT'ed
 * 
 *  7-Apr-1986:	Initial implementation, Dennis Ching
 */
#include <HRPC/basicRpc.h>
#include <HRPC/CIncludes/Binding_defs.h>
#include <HRPC/hrpcErrCodes.h>

/****************************************************************
 * 			InitHRPCBinding				*
 ****************************************************************/

/*
 * INTERFACE:	InitHRPCBinding( fProg, fVers, fInstance,
 *				 fType, fSpare2, fSpare3,
 *				 fBinding )
 *
 * INPUT:	fProg, fVers: Program number & version number
 *		fInstance:    String name of instance (must be node
 *				name in current impl.
 *		fSpare*:      Spare params.
 *
 * OUTPUT:	fBinding:     Pointer to HRPCBinding structure
 *
 * EFFECT:	Contact "nameserver" and/or "binding agent"
 *		to get necessary information and fill in
 *		interface descriptor and preliminary binding info.
 *
 * DEFECTS:	Forerunner to HRPCImport().  Should receive an
 *		InterfaceDescr, and no program number.
 */

/*ARGSUSED*/

HRPCErrRec *InitHRPCBinding( fProg, fVers, fInstance,
		 fType, fSpare2, fSpare3,
		 fBinding )
    LongCardinal	fProg;
    Cardinal		fVers;
    String		fInstance;
    String		fType;
    LongUnspecified	fSpare2, fSpare3;
    HRPCBinding **	fBinding;
{
    InterfaceDescr	*ifdptr;
    HRPCBinding		*lbptr;
    BINDING_DESCR_LIST 	list;
    EvalQueryInputs	query;
    HRPCErrRec	 	*status;
    HRPCBinding 	*AllocBinding();
    HRPCErrRec		*ChooseServer();
    Binding_STATUS_REC	impStat;
    
    query.Type		= fType;
    query.Instance	= fInstance;

    lbptr = AllocBinding();
    
    ifdptr = (InterfaceDescr *) calloc(1, sizeof( InterfaceDescr ));
    ifdptr->versNum = fVers;
    lbptr->ifdPtr = ifdptr;

    EvalQuery(lbptr, &query, &list, &impStat);
    if ( impStat.errCode != IMPORT_NORMAL ) {
	status = NewHRPCErrRec(impStat.errCode, 0);
	DeAllocBinding(lbptr);
	return( status );
    }
    if ( status = ChooseServer(lbptr, &list) ) {
	DeAllocBinding(lbptr);
	return( status );
    }
    *fBinding = lbptr;
    free(list.sequence);
    return( NOHRPCERR );
}

HRPCBinding *
AllocBinding()
{
    HRPCBinding *binding;
    
    binding = (HRPCBinding *) calloc( 1, sizeof(HRPCBinding) );
    return binding;
}

DeAllocBinding(fBinding)
    HRPCBinding *fBinding;
{
    free ((memory) fBinding->rpcDescr.callState);
    free ((memory) fBinding->transDescr.transInfo);
    free ((memory) fBinding->ifdPtr);
    free ((memory) fBinding);
}
