/* File: /u2/oystr/HRPC/Binding/exportCour.c  Date:  4-Aug-1986  */

/*
 * $Header$
 * INTERFACE:	ExportCourierServ
 *
 * FUNCTION:	"Export" a Courier RPC server.
 *
 * IMPORTS:	basicRpc.h
 *
 * EXPORTS:	ExportCourierServ
 *
 * DESIGN:	Sure.
 *
 * DEFECTS:	Does not really "Export" anything for the moment.
 *		This is presumed to operate in a xnscourierd
 *		environment.  All we do is cobble together an
 *		HRPC binding that can be used by the upper levels.
 *		There are many nasty differences between the
 *		Courier & SUN RPC models of servers and clients.
 *		The grunge by which (some) of those differences
 *		are resolved appear in this file.
 *
 *		The standard xnscourierd -> service fork protocol
 *		passes the ASCII representation of data bytes that
 *		have been "over-read" when synching on version numbers.
 *		It would be damned hard to get at them here, since
 *		copies of argc & argv are no longer squirreled away
 *		by the C startup routines.  This is currently
 *		compensated for by some fancy footwork in Courier
 *		RPC protocol routines.
 *
 *			>>>>> WARNING <<<<< >>>>> WARNING <<<<<
 *		Parts of this file are conditionally compiled depending
 *		on SUN vs. 4.3 VAX, due to availability of XNS protocols.
 *		As far as the uVaxes go, this code will not compile
 *		on them and will blow sky high are runtime if you
 *		are silly enough to copy over the libraries.
 *
 * $Log$
 *  4-Aug-1986:	Initial implementation, Jan Sanislo
 *
 * 14-Nov-1986: Now do the hard part wrt pre-activation.
 *		Also, don't believe that the only times this
 *		file (or any other file) was changed are given
 *		by the $Log$ stuff.
 */

#ifndef basicRpc
#include <HRPC/basicRpc.h>
#endif
#include <HRPC/CIncludes/Binding.h>
#include <HRPC/hrpcErrCodes.h>

#include <sys/un.h>
#include <sys/uio.h>
#include "../Transports/connDefs.h"
#include "../RpcProtos/courDbg.h"
#include "../HRpcRTS/sysSpecific.h"

#ifndef HAS_XNS43
#undef NULL
#include <stdio.h>
HRPCErrRec *
ExportCourierServ()
{
    fprintf(stderr,"Sorry, Courier services not available %s.\n",
#ifdef sun
	"on SUNs"
#endif
#ifdef ultrix
	"under Ultrix"
#endif
	);
    abort();
}
#else
#include <netns/ns.h>

/*
 * A couple of defines to ease the typing.
 */
#define BDescr Binding_COURIER_COURIER_SPP_BINDING_DESCR

/* "forward" */
extern int FieldCourierConnection();
/*
 * This routine meets the generic export interface
 * specification.
 */
HRPCErrRec *
ExportCourierServ( fIfdPtr, fSpkType, fName, fExpFlags,
		   fNExp, fSpare2, fBptr )
    InterfaceDescr *fIfdPtr;
    SpeakDefs_Speak fSpkType;
    String 	    fName;
    int		    *fExpFlags; /* IN/OUT */
    int		    *fNExp;
    LongUnspecified fSpare2;
    HRPCBinding    **fBptr;
{
    char *ME = "ExportCourierServ:";
    BDescr bdesc;
    register int fd, i;
    struct sockaddr_ns nsAddr;
    struct sockaddr_un unixAddr;
    char unSockName[30];
    register ConnDescr *connptr;
    int addrSz;
    int numnew = 0;
    register HRPCBinding *newBptr = (HRPCBinding *) NULL;

#ifdef sun
fatalerr("Can't use Courier on a SUN, you ninny!\n");
#endif

    mCourDbgMsg((courLogF,"%s program# %d.\n",ME,fIfdPtr->progNum));
    bdesc.portNum = (LongCardinal) htons(5);
    bdesc.progNum = fIfdPtr->progNum;
    bzero((char *)bdesc.xnsAddr, 10);

    if ( (*fExpFlags & EXPF_AUTOACT) ) {
	/*
	 *			AUTO ACTIVATION
	 * Following is possibly the most outrageous programming
	 * hack in existence:  We have reason to believe that
	 * we are a child of the xnscourier daemon -- this process
	 * has accepted a connection for us and passed in on via
	 * some inherited file descriptor.  Usually, this is fd 4/5
	 * but we cannot be sure.  So poke around until we find one
	 * that looks right.
	 */
	fd = FindExportSocket( AF_NS, SOCK_SEQPACKET,
			       &nsAddr, sizeof(nsAddr));
	if ( fd >= 0 ) {
	    mCourDbgMsg((courLogF,"%s autoact fd is %d.\n",ME,fd));
	    *fExpFlags = EXPF_AUTOACT;
	    goto Fill_In;
	}
	*fExpFlags &= ~EXPF_AUTOACT;
	*fNExp = 0;
	mCourDbgMsg((courLogF,"%s can't find autoact fd.\n",ME));
	return( NOHRPCERR );
    }

    /*
     *		COURIER-COMPATIBLE PRE-ACTIVATION
     * Having this work depends heavily on the properties of
     * the Courier daemon running on this machine.  What follows
     * stretches to the limit some of those nice, round HRPC
     * ideas that we talked about in our college days.
     *
     * First, we assume that the local Courier daemon is smart
     * enough to route incoming requests for this interface to us
     * via an AF_UNIX socket, so create that socket.
     */
    *fExpFlags = EXPF_PREACT;
    fd = socket(AF_UNIX, SOCK_DGRAM, 0);
    if ( fd < 0 ) {
	fatalperr("%s preactivation can't create AF_UNIX socket.\n",ME);
	/*NOTREACHED*/
    }
    sprintf(unSockName,"/tmp/%d.%d",fIfdPtr->progNum,fIfdPtr->versNum);
    /*
     * Clobber previous resident, if any.  Note that if something
     * is already running this will isolate it, much like re-exporting
     * a preactivated SUN server isolates an existing one.  I guess
     * there is something to be said for consistency.
     */
    unlink(unSockName);
    unixAddr.sun_family = AF_UNIX;
    strcpy(unixAddr.sun_path,unSockName);
    /*
     * Set/Restore umask so that anybody can
     * send to the socket.
     */
    i = umask(0); /* MUCH faster than chmod */
    if ( bind(fd, &unixAddr, 2+strlen(unSockName)) < 0 ) {
	fatalperr("%s can't bind to %s.\n",ME,unSockName);
	/*NOTREACHED*/
    }
    umask(i);

    /*
     * Create pseudo-binding for AF_UNIX socket so we can
     * field incoming connections.
     */
    newBptr = (HRPCBinding *) calloc(1,sizeof(HRPCBinding));
    if ( newBptr == (HRPCBinding *) NULL ) {
	goto No_Memory;
    }
    newBptr->ifdPtr   = fIfdPtr;
    newBptr->speaking = (SpeakDefs_Speak) 0x756e6978 /* "unix" */;
    newBptr->rpcDescr.InitIncoming = FieldCourierConnection;
    newBptr->rpcDescr.callState =
	(memory) calloc(1,sizeof(HRPCBinding));
    if ( newBptr->rpcDescr.callState == (memory) NULL ) {
	goto No_Memory;
    }
    
    newBptr->transDescr.sockfd = fd;
    connptr = &connStates[fd];
    newBptr->connState = CONN_IDLE;
    connptr->masterfd = fd;
    connptr->selmask = (1 << fd);
    connptr->connbptr = newBptr;
    /*
     * Attach to binding list.
     */
    *fBptr++ = newBptr;
    numnew++;
    newBptr = (HRPCBinding *) newBptr->rpcDescr.callState;
    fd = 0 /* taking a significant chance with this */;
    
Fill_In:     
    /*
     * getsockname will return the port number, but NOT
     * the hostaddress.  Should not really matter, since
     * we are exporting from the local host and do not
     * NEED to know our address.  Note that callback (as we
     * have defined it) will fail in this case.  What we would
     * have to for callback is create our OWN port to listen
     * on and then pass that back as the binding descriptor.
     * Doing this successfully requires that a "regulation"
     * Courier implementation allow the specification of
     * a particular port in the "connect" request.  No reason
     * why it should not, but DOES it?
     *
     * Don't hassle this for now.
     */
    if ( newBptr == (HRPCBinding *) NULL ) {
	newBptr = (HRPCBinding *) calloc(1,sizeof(HRPCBinding));
	if ( newBptr == (HRPCBinding *) NULL ) {
	    goto No_Memory;
	}
    }
    
    newBptr->ifdPtr   = fIfdPtr;
    newBptr->speaking = fSpkType;
    newBptr->bndProgNum = fIfdPtr->progNum;

    FillCourRPC( newBptr, &bdesc );
    FillCourOTW( newBptr, &bdesc );
    FillSPP_XPT( newBptr, &bdesc );
    newBptr->transDescr.sockfd = fd;
    connptr = &connStates[fd];
    newBptr->connState = CONN_IDLE;
    connptr->masterfd = fd;
    connptr->selmask = (fd > 0) ? (1 << fd) : 0;
    connptr->connbptr = newBptr;
    /* That's all for now */
    mCourDbgMsg((courLogF,"Export complete.\n"));
    *fBptr = newBptr;
    *fNExp = ++numnew;
    return( NOHRPCERR );

No_Memory:
   fatalerr("%s can't allocate binding.\n",ME);
   /*NOTREACHED*/
}

/*
 * This is the routine that gets called when a message
 * arrives on our AF_UNIX socket.  It is plugged in to the
 * InitIncoming slot of the "binding" for this socket, which
 * explains the peculiar interface.  This routine *always*
 * returns a non-zero status, which informs the dispatcher
 * that this "call" should be ignored.
 *
 * The message received contains two parts:
 *   1) program number & version number, supposedly for this interface.
 *   2) a file descriptor for a new connection
 *	to a Courier-based client.  Note that you cannot do an
 *	accept(2) on this socket.
 */

#include "../RpcProtos/rpcCour.h"

int FieldCourierConnection( fBptr, fProgNum, fVersNum,
			    fProcNum, fStatus, fSpare2 )
    register HRPCBinding *fBptr;
    long *fProgNum;
    long *fVersNum;
    long *fProcNum;
    int  *fStatus;
    char *fSpare2;
{
    struct msghdr msg;
    struct iovec  iovector;
    int    junkbuf[25];
    int    newsockfd, unsockfd;
    char   *ME = "FieldCourierConnection:";
    extern int errno;
    register ConnDescr *connptr;
    HRPCBinding *realcb;
    CourCallInfo *cinfo;

    mCourDbgMsg((courLogF,"%s trying for new socket.\n",ME));
    *fStatus = 1; /* ALWAYS */

    /*
     * Set up message vector.
     */
    iovector.iov_base = (char *) junkbuf;
    iovector.iov_len  = sizeof(junkbuf);
    msg.msg_namelen   = 0;
    msg.msg_iovlen    = 1;
    msg.msg_iov	      = &iovector;
    msg.msg_accrights = (char *) &newsockfd;
    msg.msg_accrightslen = sizeof(newsockfd);

    unsockfd = fBptr->transDescr.sockfd;
    if ( recvmsg(unsockfd, (struct msghdr *)&msg, 0) < 0 ) {
	mCourDbgMsg((courLogF,"  Can't read from %d: %d.\n",unsockfd,errno));
	return;
    }

    if ( junkbuf[0] != fBptr->ifdPtr->progNum ) {
	fatalerr("%s program number mismatch, %d != %d.\n",
		 junkbuf[0],fBptr->ifdPtr->progNum);
	/*NOTREACHED*/
    }
    mCourDbgMsg((courLogF,"  New socket is %d.\n",newsockfd));

    /*
     * Major fancy footwork here.
     *
     * First retrieve the pointer to the "real" binding
     * that we have providentially squirreled away.
     */    
    realcb  = (HRPCBinding *) fBptr->rpcDescr.callState;
    /* Snarf connection block for new connection */
    connptr = &connStates[newsockfd];
    realcb->connState = CONN_IDLE;
    connptr->connfd = newsockfd;
    connptr->connbptr = realcb;
    if ( !realcb->transDescr.sockfd ) {
	realcb->transDescr.sockfd = newsockfd;
    }
    connptr->masterfd = realcb->transDescr.sockfd;
    connStates[connptr->masterfd].selmask |= (1 << newsockfd);
    /*
     * This is the very worst part....
     */
    if ( (cinfo = (CourCallInfo *) realcb->rpcDescr.callState) ) {
	cinfo->courState = COUR_WANTVERS;
    }
}
#endif ! (sun || ultrix)
