/* File: /u1/oystr/HRPC/Binding/export.c  Date: 25-Jun-1986  */

/*
 * $Header$
 * INTERFACE:	HRPCExport
 *
 * FUNCTION:	Front-end to protocol specific HRPC export routines.
 *
 * IMPORTS:	basicRpc.h
 *		CIncludes/Binding_defs.h
 *
 * EXPORTS:	HRPCExport, FindExportSocket
 *
 * DESIGN:	Very tentative.  Currently completely ignores
 *		talking to any kind of name server.
 *
 * DEFECTS:	The type of export desired (talk/don't talk to
 *		name server) is passed to the protocol specific
 *		export routine.  It is not at all clear that this
 *		is the right thing to do, since there is no reason
 *		why the SpeakType and the name server are related.
 *
 *		Too much pointer arithmetic.  I realize this is
 *		supposed to be stylish, but I don't have to like it.
 *
 *		The "unbind" parameter to the protocol-specific
 *		export routine is required since the SUN portmap
 *		process will not let you unbind on a protocol
 *		basis, but only on a program#/version# basis.
 *		Thus, multiple exports of the same routine using
 *		different protocols will clobber each other.  This
 *		is a terrible crock -- see futher comments in exportSun.c.
 *
 *		The battle between AUTO and PRE activation rages unabated
 *		in this code.  There is absolutely no chance that
 *		that the current implementation handles it correctly --
 *		"What is amazing is not that it does it well, but that
 *		it does it at all." Ben Johnson re: a dancing dog.
 *
 * $Log$
 * 25-Jun-1986:	Initial implementation, Jan Sanislo
 *
 * 12-Nov-1986: Dithering with auto/pre activation.  Added
 *		FindExportSocket.  See exportSun.c/exportCour.c
 *		for even further gory details.  Cleanup interface
 *		so that the binding array is created dynamically.
 *		had to do this because of Courier pre-activation
 *		support.
 *
 * 27-Feb-1987: Better support for error reporting.  Changed
 *		fExpFlags to value/result for better control
 *		of callback and pre/auto act.
 */

#include <HRPC/basicRpc.h>
#include <HRPC/hrpcErrCodes.h>
#include <HRPC/CIncludes/Binding_defs.h>
#include <netinet/in.h>
#include "../RpcProtos/courDbg.h"

#ifdef COURDBG
FILE *courLogF;
#endif

extern HRPCErrRec * (*ExportProcs[])();
static int checkSockets = 1;

/*
 * Maximum bindings created by a single
 * call to HRPCExport.
 */
#define MAXEXPBINDS 10

HRPCErrRec *
HRPCExport( fTypeName, fInstName, fProgNums, fVersNum, fExpFlags, fPrefs,
	    fBindings, fNPrefs, fSpare2, fSpare3 )
    String fTypeName;		/* Type (interface) name	*/
    String fInstName;		/* String name of interface	*/
    LongCardinal fProgNums[];	/* Program number(s)		*/
    LongCardinal fVersNum;	/* Version number		*/
    int	   *fExpFlags;		/* Normal/callback auto/pre	*/
    SpeakDefs_Speak fPrefs[];   /* What are we selling today?	*/
    HRPCBinding **fBindings[];    /* Returned bindings		*/
    int    *fNPrefs;		/* value == # prefs/result == # bindings */
    LongUnspecified fSpare2, fSpare3;
{
    InterfaceDescr *ifdptr;
    register SpeakDefs_Speak *spkptr;
    register HRPCBinding **retval;
    int lExpFlags, autoposs,unbind;
    HRPCBinding *newBindings[MAXEXPBINDS];
    int expres, totspks, totexp, spkindex;
    char *ME = "HRPCExport:";
    HRPCErrRec *errRec;

#ifdef COURDBG
if ( !courLogF ) {
    char fname[50];

    sprintf(fname,"/tmp/autosrv%d.%d",fProgNums[(int)fPrefs[0]],getpid());
    courLogF = fopen(fname,"w");
    if ( !courLogF ) {
	fatalerr("Can't open courier log '%s'\n",fname);
    }
    /* no buffering */
    setbuf(courLogF, NULL);
    /* no reason why this should NOT work - ha, ha! */
    bcopy(courLogF, stderr, sizeof( struct _iobuf ) );
}
#endif

    /* Allocate a (new) interface descriptor */
    ifdptr = (InterfaceDescr *) calloc(1, sizeof( InterfaceDescr ));
    if ( ifdptr == (InterfaceDescr *) NULL ) {
	fatalerr("%s can't alloc new interface.\n",ME);
	/*NOTREACHED*/
    }
    ifdptr->versNum = (Cardinal) fVersNum;
    ifdptr->configInfo = (TBD) NULL;

    /*
     * Probe around to see if we have any potential
     * inherited sockets.
     */
    autoposs = (*fExpFlags & EXPF_CALLBACK) ? 0 : EXPF_UNBIND;
    if ( checkSockets ) {
	if ( ! (*fExpFlags & EXPF_CALLBACK) && (CheckSockets() > 0) ) {
	    autoposs |= EXPF_AUTOACT;
	}
	checkSockets = 0;
    }
    mCourDbgMsg((courLogF,"autoposs is %d.\n",autoposs));

    /*
     * Minor sanity check, note that you can get back more
     * bindings than there are preferences.  Current max of
     * one extra.
     */
    totspks = *fNPrefs;
    if ( ! fNPrefs ||
	 ((totspks = *fNPrefs) <= 0) || (totspks >= MAXEXPBINDS) ) {
	fatalerr("%s bad prefs value = %d (linked with old stub??).\n",
		  ME,totspks);
	/*NOTREACHED*/
    }
    
    spkptr = fPrefs;
    retval = &newBindings[0];
    totexp = spkindex = 0;

    while ( spkindex < totspks ) {
	ifdptr->progNum = fProgNums[(int) *spkptr];
	/*
	 * return value is number of bindings created, >= 0.
	 */
	expres = 0;
	lExpFlags = *fExpFlags | autoposs;
	errRec =
	    (*ExportProcs[(int)*spkptr])(ifdptr, *spkptr, (String) 0,
				  &lExpFlags,  &expres, 0, retval);
	if ( errRec ) {
	    return( errRec );
	}
	
	totexp += expres;
	retval += expres;
	spkptr++;
	spkindex++;
	autoposs &= ~EXPF_UNBIND;
	if ( lExpFlags & EXPF_AUTOACT ) {
	    /* Auto-mode, first SP wins */
	    *fExpFlags = EXPF_AUTOACT;
	    break;
	}
    } /* while( spkindex < totspks ) */

    if ( ! (lExpFlags & EXPF_AUTOACT) ) {
	*fExpFlags = EXPF_PREACT;
    }
    mCourDbgMsg((courLogF,"final flags are: %d.\n",*fExpFlags));
    
    /*
     * If less exported than anticipated, complain bitterly.
     */
    if ( !totexp ) {
	fatalerr("%s nothing exported.\n",ME);
    }

    /*
     * Whack off enough space for returned bindings and
     * stuff results.
	*** alloc extra binding so that we can ***
	*** NULL terminate list for HRPC_Select ***
     */
    *fBindings = (HRPCBinding **) calloc(1,sizeof(HRPCBinding *) * (totexp+1));
    if ( *fBindings == (HRPCBinding **) NULL ) {
	fatalerr("%s can't alloc return binding space.\n",ME);
	/*NOTREACHED*/
    }
    *fNPrefs = totexp;
    bcopy( (char *) &newBindings[0], *fBindings,
		sizeof(HRPCBinding *) * totexp);
    (*fBindings)[totexp] = (HRPCBinding *) 0;
    return( NOHRPCERR );
}

/*
 * This procedure is here, not because it is called
 * directly but because it can be called from either
 * (or rather any) of the protocol specific export routines.
 * so it might as well be here.  Also, this routine potentially
 * has to know all sorts of details about the OS interface to
 * "sockets", so we might as well put it all in one place.
 *
 * Hey, kids!  Dig this!  Real pro-style stuff here. But this
 * is only the first part of the big joke.
 */

static struct sockaddr possibleSocket;
static int possibleFD;

int CheckSockets()
{
    int i, j;

    mCourDbgMsg((courLogF,"Scanning sockets...\n"));
    for ( i = 0; i < 8; i++ ) {
	j = sizeof( struct sockaddr );
	if ( ! getsockname( i, &possibleSocket, &j ) &&
	     (possibleSocket.sa_family > 0 /* i.e. not a pipe */ ) ) {
mCourDbgMsg((courLogF,"  Found fd %d, AF: %d.\n",i,possibleSocket.sa_family));
	    possibleFD = i;
	    return( i );
	}
    }
    possibleSocket.sa_family = 0;
    return( -1 );
}

int FindExportSocket( fAF, fProto, fAddr, fAddrSz )
    int fAF;
    int fProto;
    struct sockaddr *fAddr;
    int fAddrSz;
{
    int i,j;
    struct sockaddr bigsock;

    mCourDbgMsg((courLogF,"Looking for exported socket...\n"));
    if ( possibleSocket.sa_family == fAF ) {
	/*
	 * Biggest crock of shit in the world.
	 * If anybody finds a way of figuring out
	 * the protocol of a socket in any other way
	 * let me know.  This will undoubtedly cost us
	 * dearly later on.  N.B.: There is an explicit
	 * check for AF_NS since there appears to be a
	 * bug in the UNIX kernel (netns/spp_usrreq.c)
	 * that will allow a listen on an already connected
	 * port.  To the best of my knowledge this just
	 * ain't right.
	 */
mCourDbgMsg((courLogF,"fd %d, AF: %d, j: %d.\n",i,fAF,j));
	if ( fAF == AF_NS ) {
	    bcopy(&possibleSocket,fAddr,fAddrSz);
	    return( possibleFD );
	}

	j = listen(possibleFD,5);
	if ( ( (fProto == IPPROTO_TCP) && !j ) || 
	     ( (fProto == IPPROTO_UDP) &&  j ) ) {
	    bcopy(&possibleSocket,fAddr,fAddrSz);
	    return( possibleFD );
	}
    }
    return( -1 );
}
