/* File: /u2/dtc/HRPC/binding/configSUN.c  Date:  8-Apr-1986  */

/*
 * $Header: configSUN.c,v 1.1 86/04/09 13:06:08 dtc Exp $
 * INTERFACE:	
 *
 * FUNCTION:	
 *
 * IMPORTS:	
 *
 * EXPORTS:	
 *
 * DESIGN:	
 *
 * $Log:	configSUN.c,v $
 * Revision 1.1  86/04/09  13:06:08  dtc
 * Initial revision
 * 
 *  8-Apr-1986:	Initial implementation, Dennis Ching
 */

#include <sys/types.h>
#include <netinet/in.h>
#include <HRPC/basicRpc.h>
#include <HRPC/CIncludes/Binding_defs.h>

extern int SunInitOutgoing();
extern int SunPacketOutgoing();
extern int SunFinishOutgoing();
extern int SunInitAnswer();
extern int SunAnswerPacket();
extern int SunFinishAnswer();
extern int SunInitIncoming();
extern int SunPacketIncoming();
extern int SunFinishIncoming();
extern int SunInitReply();
extern int SunReplyPacket();
extern int SunFinishReply();
extern int abort();
extern int SunCloseRpc();
extern int SunGetReplyId();


static RpcControl SunRpcControl = {
    SunInitOutgoing, SunPacketOutgoing, SunFinishOutgoing,
    SunInitIncoming, SunPacketIncoming, SunFinishIncoming,
    SunInitReply,    SunReplyPacket,    SunFinishReply,
    SunInitAnswer, SunAnswerPacket, SunFinishAnswer,
    abort, abort,
    SunCloseRpc, abort,
    SunGetReplyId, 0,
    (memory) 0
};

FillSunRPC( fBptr, descr )
    register HRPCBinding *fBptr;
    SUN_XDR_UDP_BINDING_DESCR *descr;
{
    fBptr->rpcType  = SUNRPC;
    fBptr->rpcDescr = SunRpcControl;
    fBptr->ifdPtr->progNum = descr->progNum;
}

extern int XdrCardinal();
extern int XdrLongCardinal();
extern int XdrInteger();
extern int XdrLongInteger();
extern int XdrBoolean();
extern int XdrUnspecified();
extern int XdrLongUnspecified();
extern int XdrString();
extern int XdrArray();
extern int XdrChoice();
extern int XdrEnumeration();
extern int XdrSequence();
extern int XdrRecord();
extern int XdrProcedure();
extern int XdrError();
extern int XdrDeallocate();
extern int XdrNilRecord();
extern int XdrCloseOtw();

static OtwControl XdrOtwControl = {
    XdrCardinal, XdrLongCardinal, XdrInteger,
    XdrLongInteger, XdrBoolean, XdrUnspecified,
    XdrLongUnspecified, XdrString, XdrArray,
    XdrChoice, XdrEnumeration, XdrSequence,
    XdrRecord, XdrProcedure, XdrError, XdrDeallocate,
    XdrNilRecord, XdrCloseOtw
};

FillSunOTW( fBptr, descr )
    register HRPCBinding *fBptr;
    SUN_XDR_UDP_BINDING_DESCR *descr;
{
    fBptr->otwType  = SUNOTW;
    fBptr->otwDescr = XdrOtwControl;
}

extern int TcpMaxBufferSize();
extern int TcpOpenLink();
extern int TcpCloseLink();
extern int TcpSendPacket();
extern int TcpRecvPacket();
extern int TcpInitSend();
extern int TcpFinishSend();
extern int TcpInitRecv();
extern int TcpFinishRecv();
extern memory TcpBufAlloc();
extern memory TcpBufDealloc();

static TransControl TcpTransControl = {
    TcpMaxBufferSize, TcpOpenLink,   TcpCloseLink,
    TcpSendPacket,    TcpRecvPacket,
    TcpInitSend, TcpFinishSend, TcpInitRecv, TcpFinishRecv,
    TcpBufAlloc, TcpBufDealloc
};

extern int UdpMaxBufferSize();
extern int UdpOpenLink();
extern int UdpCloseLink();
extern int UdpSendPacket();
extern int UdpRecvPacket();
extern int UdpInitSend();
extern int UdpFinishSend();
extern int UdpInitRecv();
extern int UdpFinishRecv();
extern memory UdpBufAlloc();
extern memory UdpBufDealloc();

static TransControl UdpTransControl = {
    UdpMaxBufferSize, UdpOpenLink,   UdpCloseLink,
    UdpSendPacket,    UdpRecvPacket,
    UdpInitSend, UdpFinishSend, UdpInitRecv, UdpFinishRecv,
    UdpBufAlloc, UdpBufDealloc
};

FillSunTCP( fBptr, descr )
    HRPCBinding *fBptr;
    SUN_XDR_TCP_BINDING_DESCR *descr;
{
    TransControl *tcptr;
    register struct sockaddr_in *sockAddr;

    fBptr->transType = TCPTRANSP;
    fBptr->transDescr = TcpTransControl;
    tcptr = &fBptr->transDescr;
    sockAddr = (struct sockaddr_in *) &tcptr->netAddr;
    sockAddr->sin_family = AF_INET;
    sockAddr->sin_addr = *(struct in_addr *) descr->ipAddr;
    sockAddr->sin_port = descr->portNum;
    tcptr->transInfo = (memory) NULL;
    tcptr->sockfd = 0;
}

FillSunUDP( fBptr, descr )
    HRPCBinding *fBptr;
    SUN_XDR_UDP_BINDING_DESCR *descr;
{
    TransControl *tcptr;
    register struct sockaddr_in *sockAddr;
    
    fBptr->transType = UDPTRANSP;
    fBptr->transDescr = UdpTransControl;
    tcptr = &fBptr->transDescr;
    sockAddr = (struct sockaddr_in *) &tcptr->netAddr;
    sockAddr->sin_family = AF_INET;
    sockAddr->sin_addr = *(struct in_addr *) descr->ipAddr;
    sockAddr->sin_port = descr->portNum;
    tcptr->transInfo = (memory) NULL;
    tcptr->sockfd = 0;
}

