/* File: /u1/schwartz/HCS/Impl/HRPC/MyProtos/Binding/configRAW.c  Date:  27-Aug-1986  */

/*
 * $Header: configRAW.c,v 1.1 86/08/27 20:45:08 schwartz Exp $
 * INTERFACE:	
 *
 * FUNCTION:	Raw RPC configuration routines
 *
 * IMPORTS:	TCP and UDP transport routines; usual HRPC definitions
 *
 * EXPORTS:
 *
 * DESIGN:	A simple set of routines to allow an HRPC-flavor that just
 *		does the simplest possible TCP/UDP communication.  This is
 *		meant for accommodating ad hoc IPC-based communcation
 *		schemes, which are common in Unix 4.2+ software.  This code
 *		is mostly stolen from configSUN.c.
 *
 *
 * $Log:	configRAW.c,v $
 *
 * Revision 1.1  86/08/27 20:45:08 schwartz
 * Initial revision
 * 
 */

#include <sys/types.h>
#include <netinet/in.h>
#include <HRPC/basicRpc.h>
#include <HRPC/CIncludes/Binding_defs.h>

extern int RawInitOutgoing();
extern int RawPacketOutgoing();
extern int RawFinishOutgoing();
extern int RawInitAnswer();
extern int RawAnswerPacket();
extern int RawFinishAnswer();
extern int RawInitIncoming();
extern int RawPacketIncoming();
extern int RawFinishIncoming();
extern int RawInitReply();
extern int RawReplyPacket();
extern int RawFinishReply();
extern int abort();
extern int RawCloseRpc();


static RpcControl RawRpcControl = {
    RawInitOutgoing, RawPacketOutgoing, RawFinishOutgoing,
    RawInitIncoming, RawPacketIncoming, RawFinishIncoming,
    RawInitReply,    RawReplyPacket,    RawFinishReply,
    RawInitAnswer,   RawAnswerPacket,   RawFinishAnswer,
    abort, abort,
    RawCloseRpc, abort,
    abort/* until RawGetReplyId is written */, 0,
    (memory) 0
};

FillRawRPC( fBptr, descr )
    register HRPCBinding *fBptr;
    RAW_UDP_BINDING_DESCR *descr;
{
    fBptr->rpcType  = RAWRPC;
    fBptr->rpcDescr = RawRpcControl;
    fBptr->ifdPtr->progNum = descr->progNum;
}

extern int RawXdrCardinal();
extern int XdrLongCardinal();
extern int RawXdrInteger();
extern int XdrLongInteger();
extern int RawXdrBoolean();
extern int RawXdrUnspecified();
extern int XdrLongUnspecified();
extern int RawXdrString();
extern int RawXdrArray();
extern int XdrChoice();
extern int XdrEnumeration();
extern int XdrSequence();
extern int XdrRecord();
extern int XdrProcedure();
extern int XdrError();
extern int XdrDeallocate();
extern int XdrNilRecord();
extern int XdrCloseOtw();

/* Use the same OTW rep. as Sun XDR, except for the differences pointed out in
   the DESIGN comment at the top of otwRaw.c.  */
static OtwControl RawXdrOtwControl = {
    RawXdrCardinal, XdrLongCardinal, RawXdrInteger,
    XdrLongInteger, RawXdrBoolean, RawXdrUnspecified,
    XdrLongUnspecified, RawXdrString, RawXdrArray,
    XdrChoice, XdrEnumeration, XdrSequence,
    XdrRecord, XdrProcedure, XdrError, XdrDeallocate,
    XdrNilRecord, XdrCloseOtw
};

FillRawOTW( fBptr, descr )
    register HRPCBinding *fBptr;
    RAW_UDP_BINDING_DESCR *descr;
{
    fBptr->otwType  = RAWOTW;
    fBptr->otwDescr = RawXdrOtwControl;
}

extern int TcpMaxBufferSize();
extern int TcpOpenLink();
extern int TcpCloseLink();
extern int TcpSendPacket();
extern int TcpRecvPacket();
extern int TcpInitSend();
extern int TcpFinishSend();
extern int TcpInitRecv();
extern int TcpFinishRecv();
extern memory TcpBufAlloc();
extern memory TcpBufDealloc();

static TransControl TcpTransControl = {
    TcpMaxBufferSize, TcpOpenLink,   TcpCloseLink,
    TcpSendPacket,    TcpRecvPacket,
    TcpInitSend, TcpFinishSend, TcpInitRecv, TcpFinishRecv,
    TcpBufAlloc, TcpBufDealloc
};

extern int UdpMaxBufferSize();
extern int UdpOpenLink();
extern int UdpCloseLink();
extern int UdpSendPacket();
extern int UdpRecvPacket();
extern int UdpInitSend();
extern int UdpFinishSend();
extern int UdpInitRecv();
extern int UdpFinishRecv();
extern memory UdpBufAlloc();
extern memory UdpBufDealloc();

static TransControl UdpTransControl = {
    UdpMaxBufferSize, UdpOpenLink,   UdpCloseLink,
    UdpSendPacket,    UdpRecvPacket,
    UdpInitSend, UdpFinishSend, UdpInitRecv, UdpFinishRecv,
    UdpBufAlloc, UdpBufDealloc
};

FillRawTCP( fBptr, descr )
    HRPCBinding *fBptr;
    RAW_TCP_BINDING_DESCR *descr;
{
    TransControl *tcptr;
    register struct sockaddr_in *sockAddr;

    fBptr->transType = TCPTRANSP;
    fBptr->transDescr = TcpTransControl;
    tcptr = &fBptr->transDescr;
    sockAddr = (struct sockaddr_in *) &tcptr->netAddr;
    sockAddr->sin_family = AF_INET;
    sockAddr->sin_addr = *(struct in_addr *) descr->ipAddr;
    sockAddr->sin_port = htons(descr->portNum);
    tcptr->transInfo = (memory) NULL;
    tcptr->sockfd = 0;
}

FillRawUDP( fBptr, descr )
    HRPCBinding *fBptr;
    RAW_UDP_BINDING_DESCR *descr;
{
    TransControl *tcptr;
    register struct sockaddr_in *sockAddr;
    
    fBptr->transType = UDPTRANSP;
    fBptr->transDescr = UdpTransControl;
    tcptr = &fBptr->transDescr;
    sockAddr = (struct sockaddr_in *) &tcptr->netAddr;
    sockAddr->sin_family = AF_INET;
    sockAddr->sin_addr = *(struct in_addr *) descr->ipAddr;
    sockAddr->sin_port = htons(descr->portNum);
    tcptr->transInfo = (memory) NULL;
    tcptr->sockfd = 0;
}

