/* File: /u2/dtc/HRPC/binding/configCCS.c  Date:  7-Apr-1986  */

/*
 * $Header: configCCS.c,v 1.2 86/04/09 15:14:16 dtc Exp $
 * INTERFACE:	
 *
 * FUNCTION:	
 *
 * IMPORTS:	
 *
 * EXPORTS:	
 *
 * DESIGN:	
 *
 * $Log:	configCCS.c,v $
 * Revision 1.3  86/06/16  10:45:20  oystr
 * General clean up as part of merge.
 *
 * Revision 1.2  86/04/09  15:14:16  dtc
 * don't know what's different
 * 
 *  7-Apr-1986:	Initial implementation, Dennis Ching
 */
#include <sys/types.h>
#include <sys/socket.h>
#include <HRPC/basicRpc.h>
#include <HRPC/CIncludes/Binding_defs.h>
#include "../RpcProtos/rpcCour.h"
#include "../HRpcRTS/sysSpecific.h"

/*
 * the following should be in xn.h or spp.h
 */
#define IDPPORT_COURIER 5

extern int CourInitOutgoing();
extern int CourPacketOutgoing();
extern int CourFinishOutgoing();
extern int CourInitIncoming();
extern int CourPacketIncoming();
extern int CourFinishIncoming();
extern int CourInitReply();
extern int CourReplyPacket();
extern int CourFinishReply();
extern int CourInitAnswer();
extern int CourAnswerPacket();
extern int CourFinishAnswer();
extern int abort();
extern int CourCloseRpc();

static RpcControl CourRpcControl = {
    CourInitOutgoing, CourPacketOutgoing, CourFinishOutgoing,
    CourInitIncoming, CourPacketIncoming, CourFinishIncoming,
    CourInitReply,    CourReplyPacket,	  CourFinishReply,
    CourInitAnswer,   CourAnswerPacket,   CourFinishAnswer,
    abort, abort,
    CourCloseRpc, abort,
    abort/* until CourGetReplyId is written */, 0,
    (memory) 0
};

FillCourRPC( fBptr, descr )
    HRPCBinding *fBptr;
    COURIER_COURIER_SPP_BINDING_DESCR *	descr;
{
    fBptr->rpcType = COURRPC;
    fBptr->rpcDescr = CourRpcControl;
    fBptr->ifdPtr->progNum = descr->progNum;
}

extern int CourCardinal();
extern int CourLongCardinal();
extern int CourInteger();
extern int CourLongInteger();
extern int CourBoolean();
extern int CourUnspecified();
extern int CourLongUnspecified();
extern int CourString();
extern int CourArray();
extern int CourChoice();
extern int CourEnumeration();
extern int CourSequence();
extern int CourRecord();
extern int CourProcedure();
extern int CourError();
extern int CourDeallocate();
extern int CourNilRecord();
extern int CourCloseOtw();

static OtwControl CourOtwControl = {
    CourCardinal, CourLongCardinal, CourInteger,
    CourLongInteger, CourBoolean, CourUnspecified,
    CourLongUnspecified, CourString, CourArray,
    CourChoice, CourEnumeration, CourSequence,
    CourRecord, CourProcedure, CourError, CourDeallocate,
    CourNilRecord, CourCloseOtw
};

FillCourOTW( fBptr, descr )
    HRPCBinding *fBptr;
    COURIER_COURIER_SPP_BINDING_DESCR *	descr;
{
    fBptr->otwType  = COUROTW;
    fBptr->otwDescr = CourOtwControl;
}

/*
 * Only the transport is conditionally compiled, since
 * it is the only part that uses XNS per se.  Some
 * good may be server by leaving the other stuff in.
 */
#ifndef HAS_XNS43
FillSPP_XPT()
{
    fatalerr("XNS protocols not supported %s.\n",
#ifdef sun
	"on SUNs"
#else
#ifdef ultrix
	"under Ultrix"
#else
	"on this system"
#endif
#endif
	);
}

#else

#include <netns/ns.h>
#include <netns/sp.h>
#include "../Transports/sppTransp.h"

extern int SPPMaxBufferSize();
extern int SPPOpenLink();
extern int SPPCloseLink();
extern int SPPSendPacket();
extern int SPPRecvPacket();
extern int SPPInitSend();
extern int SPPFinishSend();
extern int SPPInitRecv();
extern int SPPFinishRecv();
extern memory SPPBufAlloc();
extern memory SPPBufDealloc();

static TransControl SPPTransControl = {
    SPPMaxBufferSize, SPPOpenLink,   SPPCloseLink,
    SPPSendPacket,    SPPRecvPacket,
    SPPInitSend, SPPFinishSend, SPPInitRecv, SPPFinishRecv,
    SPPBufAlloc, SPPBufDealloc
};

FillSPP_XPT( fBptr, descr )
    HRPCBinding *fBptr;
    COURIER_COURIER_SPP_BINDING_DESCR *	descr;
{
    register TransControl *	SPPtr;
    SppTransInfo *    		transInfo;
    struct sockaddr_ns *	sockAddr;

    fBptr->transType = XNSTRANSP;    
    fBptr->transDescr = SPPTransControl;
    SPPtr = &fBptr->transDescr;
    sockAddr = (struct sockaddr_ns *) &SPPtr->netAddr;
    sockAddr->sns_family = AF_NS;
    sockAddr->sns_addr = *(struct ns_addr *) descr->xnsAddr;
    sockAddr->sns_addr.x_port = htons(descr->portNum);
    SPPtr->sockfd = 0;
}
#endif
