
/*
 * Copyright (c) 1984 by Sun Microsystems, Inc.
 */

/*
 * portmap.c, Implements the program,version to port number mapping for
 * rpc.
 *
 * March, 1987.  oystr
 * 	Hacked considerably to support HRPC auto/pre/always activation.
 *	Note that alwaysups can't be true daemons if they expect
 *	to be restarted.  Somebody should do something about the
 *	sequential data structures.  Don't everybody volunteer at
 *	once.
 *
 *	This whole thing is a major-league security hole.  The
 *	bet is that we are all mature individuals.  I will lose
 *	this bet.
 *
 *	Log files are opened AFTER setreuid/gid is called.  If
 *	su is desired, the executable program must be owned by/suid to
 *	the user.  Which means that we have to stat the file every
 *	time before the exec.
 */

#include <rpc/rpc.h>
#include <rpc/pmap_prot.h>
#include <stdio.h>
#include <netdb.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <signal.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <errno.h>
extern int errno;

/* HRPC Activation info */
#include "actdb.h"
typedef struct {
    ActInfo *actent;
    struct Program *next;
    int notGarbage;
    /*
     * following fields used only "alwaysup" daemons
     */
    int bootTime;
    int numBoots;
    int daemonpid;
} Program;

char *prefsFile = (char *) 0;

Program actList;
Program daemonList;

/*
 * "Cloning".
 */
int imaClone = 0;

/*
 * Logging info.
 */
char *logfile = "/usr/tmp/portmap.log";
FILE *lf = NULL;
int dolog = 0;
#define LogMsg(x) if ( dolog ) fprintf x

char *malloc();
int reg_service();
static int debugging = 0;
extern int ChildHandler();
extern int ToggleLog();

PrintActEnt(actptr)
    ActInfo *actptr;
{
    LogMsg((lf,"pn: %d, proto: %x, pref: %d,\n  exe: %s\n",
	actptr->progNum,actptr->protos,actptr->actPref,
	actptr->exeFile));
}

PrintProgList( title, pptr )
    char *title;
    Program *pptr;
{
    LogMsg((lf,"Prog list: %s.\n",title));
    if ( !pptr ) {
	LogMsg((lf,"***NULL***\n"));
	return;
    }
    while ( pptr ) {
	LogMsg((lf,"NotG: %d, ",pptr->notGarbage));
	PrintActEnt( pptr->actent );
	pptr = (Program *) pptr->next;
    }
}

main(argc, argv)
    int  argc;
    char *argv[];
{
	SVCXPRT *xprt;
	int sock, pid, t;
	struct sockaddr_in addr;
	int len = sizeof(struct sockaddr_in);
	Program *prptr;
	ActInfo *actptr;
	int readfds;
	struct timeval daemonWait;
	Program *pptr;

#ifndef DEBUG
	pid = fork();
	if (pid < 0) {
		perror("portmap: fork");
		exit(1);
	}
	if (pid != 0)
		exit(0);
	for (t = 0; t < 20; t++) {
		close(t);
        }
 	open("/", 0);
 	dup2(0, 1);
 	dup2(0, 2);
 	t = open("/dev/tty", 2);
 	if (t >= 0) {
 		ioctl(t, TIOCNOTTY, (char *)0);
 		close(t);
 	}
#endif
/*
	ToggleLog();
 */
	LogMsg((lf,"Running... pid %d\n",getpid()));
	t = 1;
	while ( t < argc ) {
	    if ( !strcmp("-r",argv[t]) ) {
		imaClone = BeAClone(argv[++t]);
		LogMsg((lf,"I am %s a Clone.\n",imaClone ? "" : "not"));
	    }
	    else
	    if ( !strcmp("-f",argv[t]) ) {
		prefsFile = argv[++t];
		LogMsg((lf,"Prefs file is %s.\n",prefsFile));
	    }
	    t++;
	}

	/*
	 * Load up data base of activation preferences.
	 * If we're a clone, then existing always-ups will be
	 * greased right here.  Tough.
	 */
	if ( OpenActDB( prefsFile ) >= 0 ) {
	    while( actptr = GetActDBEnt() ) {
		if ( (actptr->protos & (SUNXDRTCP|SUNXDRUDP))
		     && (actptr->actPref != PRE_ACT) ) {
		    PrintActEnt( actptr );
		    prptr = (Program *) calloc(1,sizeof(Program));
		    prptr->actent = actptr;
		    if (actptr->actPref == AUTO_ACT ) {
			prptr->next = (struct Program *) actList.next;
			actList.next = (struct Program *) prptr;
		    }
		    else {
			prptr->next = (struct Program *) daemonList.next;
			daemonList.next = (struct Program *) prptr;
		    }
		}
		else {
		    FreeActDBEnt( actptr );
		}
	    }
	}
	PrintProgList("Act List",actList.next);
	PrintProgList("Daemon List",daemonList.next);
	signal(SIGCHLD,ChildHandler);
	signal(SIGHUP, ToggleLog);

	if ((sock = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP)) < 0) {
		perror("portmap cannot create socket");
		exit(1);
	}

	addr.sin_addr.s_addr = 0;
	addr.sin_family = AF_INET;
	addr.sin_port = htons( PMAPPORT );
	if (bind(sock, (struct sockaddr *)&addr, len) != 0) {
		perror("portmap cannot bind");
		exit(1);
	}

	if ((xprt = svcudp_create(sock)) == (SVCXPRT *)NULL) {
		fprintf(stderr, "couldn't do udp_create\n");
		exit(1);
	}

	if ((sock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0) {
		perror("portmap cannot create socket");
		exit(1);
	}
	if (bind(sock, (struct sockaddr *)&addr, len) != 0) {
		perror("portmap cannot bind");
		exit(1);
	}
	if ((xprt = svctcp_create(sock, 0, 0)) == (SVCXPRT *)NULL) {
		fprintf(stderr, "couldn't do tcp_create\n");
		exit(1);
	}

        (void)svc_register(xprt, PMAPPROG, PMAPVERS, reg_service, FALSE);

	/*
	 * There used to be a call to svc_run() here.  But now
	 * that we are babysitting HRPC daemons, we put the code
	 * in line so we can to the initial startup.  The thing
	 * to worry about is that the daemons will be trying to
	 * register themselves and if we fire them up all at once
	 * some of those messages will be lost due to buffer space
	 * limitations.  The retry strategy should take care of
	 * this, but why as for trouble.
	 */
	daemonWait.tv_sec = 15;
	daemonWait.tv_usec = 0;
	pptr = (Program *) daemonList.next;
	if ( pptr ) {
	    pptr->daemonpid = ForkServer(pptr->actent, -1);
	    pptr->bootTime = time(0);
	    pptr->numBoots++;
	    pptr = (Program *) pptr->next;
	}

	while ( 1 ) {
	    readfds = svc_fds;
	    switch ( select(32, &readfds, (int *) 0, (int *) 0,
		     (pptr) ? &daemonWait : (struct timeval *) 0) ) {
		case -1:
		    if ( errno == EINTR ) continue;
		    else {
			LogMsg((lf,"Main select err: %d.\n",errno));
			exit( 1 );
		    }

		case 0:
		    /* timed out, start next daemon, if any */
		    if ( pptr ) {
			pptr->daemonpid = ForkServer(pptr->actent, -1);
			pptr->bootTime = time(0);
			pptr->numBoots++;
			pptr = (Program *) pptr->next;
		    }
		    break;

		default:
		    svc_getreq(readfds);
	    }
	}
}

/*
 * Toggle logging on SIGHUP.
 */
int ToggleLog()
{
    int junk;
    
    junk = time(0);
    if ( dolog ) {
	if ( lf != NULL ) {
	    LogMsg((lf,">>Logging terminated by signal at %s",ctime(&junk)));
	    fclose(lf);
	    lf = NULL;
	}
	dolog = 0;
	return;
    }
    lf = fopen(logfile,"a");
    if ( lf == NULL ) return;
    setbuf(lf,NULL);
    fseek(lf,0L,2);
    dolog = 1;
    LogMsg((lf,">>Logging (re)started by signal at %s", ctime(&junk)));
}

/*
 * Act database has changed, so reload the information.
 */
int ReloadActDB()
{
    register ActInfo *actp1;
    register Program *pptr1, *trailer;
    Program *pptr2;

    LogMsg((lf,"Reloading...\n"));
    CloseActDB();
    if ( OpenActDB( prefsFile ) < 0 ) return;

    while ( actp1 = GetActDBEnt() ) {
	PrintActEnt( actp1 );
	
	if ( !(actp1->protos & (SUNXDRTCP|SUNXDRUDP))
	    || (actp1->actPref == PRE_ACT) ) continue;
	if ( actp1->actPref == AUTO_ACT ) {
	    pptr1 = (Program *) actList.next;
	    pptr2 = &actList;
	}
	else {
	    pptr1 = (Program *) daemonList.next;
	    pptr2 = &daemonList;
	}
	while ( pptr1 ) {
	    if ( pptr1->actent->progNum == actp1->progNum ) {
		FreeActDBEnt( pptr1->actent );
		pptr1->actent = actp1;
		pptr1->notGarbage = 1;
		break;
	    }
	    pptr1 = (Program *) pptr1->next;
	}
	if ( !pptr1 ) {
	    pptr1 = (Program *) calloc(1,sizeof(Program));
	    /*###
	     * if doing alwaysups, must fork process
	     *###
	     */
	    pptr1->actent = actp1;
	    pptr1->notGarbage = 1;
	    pptr1->next = (struct Program *) pptr2->next;
	    pptr2->next = (struct Program *) pptr1;
	}
    } /* while ( GetActDBEnt() ) */

    PrintProgList("BG Act List",actList.next);
    PrintProgList("BG Daemon List",daemonList.next);
    /*
     * Throw out the trash.
     */
    trailer = &actList;
    pptr1 = (Program *) actList.next;
    while ( pptr1 ) {
	if ( pptr1->notGarbage ) {
	    pptr1->notGarbage = 0;
	    trailer = pptr1;
	    pptr1 = (Program *) pptr1->next;
	    continue;
	}
	trailer->next = pptr1->next;
	FreeActDBEnt( pptr1->actent );
	free( pptr1 );
	pptr1 = (Program *) trailer->next;
    }
    PrintProgList("Act List",actList.next);
    PrintProgList("Daemon List",daemonList.next);

    /*
     * Now do daemons.  If a new one has arrived, fork it.
     * If it is now garbage, we do not kill it since this
     * would allow whoever edited the actPrefs file to kill
     * arbitrary daemons.  We do not keep track of whether
     * things "change" (except for presence or absence),
     * so to reboot a daemon you must edit the file and then
     * kill the daemon yourself.  ==> need a call to modified
     * in child handler.  Note that there is a race condition
     * in that the new daemon may will not have time to register
     * itself if the call that forced us to reload was an
     * inquiry for that daemon.
     */
    LogMsg((lf,"Starting daemons...\n"));
    trailer = &daemonList;
    pptr1 = (Program *) daemonList.next;
    while ( pptr1 ) {
	if ( pptr1->notGarbage ) {
	    pptr1->notGarbage = 0;
	    if ( pptr1->daemonpid == 0 ) {
		LogMsg((lf,"Daemon is...\n"));
		PrintActEnt(pptr1->actent);
		pptr1->daemonpid = ForkServer(pptr1->actent, -1);
		LogMsg((lf,"Pid is %d.\n",pptr1->daemonpid));
		pptr1->bootTime = time(0);
		pptr1->numBoots++;
	    }
	    trailer = pptr1;
	    pptr1 = (Program *) pptr1->next;
	    continue;
	}
	trailer->next = pptr1->next;
	FreeActDBEnt( pptr1->actent );
	free( pptr1 );
	pptr1 = (Program *) trailer->next;
    }
}

struct pmaplist *pmaplist;

struct pmaplist fakeEntry;
struct pmaplist *fakeptr;

/*
 * Read in a list (usually created by {/usr}/etc/rpcinfo) of what was
 * laying around before and stuff it in the (new) pmap list. Warning: returns 0
 * on failure, 1 on success.  If I had any real balls this would be
 * part of the pmap protocol.  Still be tough luck for the always-up
 * since the parent-child relationship would still be blown away.
 */

int BeAClone( fPrevContents )
    char *fPrevContents;
{
    FILE *fp;
    struct pmap *reg;
    struct pmaplist *pml;
    char linebuf[256];
    char *cp;
    char protoKind[50];
    int i;
    
    fp = fopen(fPrevContents,"r");
    if ( fp == NULL ) return(0);

    while ( fgets(linebuf,sizeof(linebuf),fp) != NULL ) {
	cp = linebuf;
	while ( (*cp > 0) && ! (*cp < '1') || (*cp > '9') ) cp++;
	if ( ! *cp ) continue;
	
	pml = (struct pmaplist *) malloc((u_int) sizeof(struct pmaplist));
	reg = &pml->pml_map;
	i = sscanf(cp,"%lu %lu %s %lu",&reg->pm_prog, &reg->pm_vers, protoKind,
		&reg->pm_port);
	if ( i !=  4 ) {
	    free(pml);
	    continue;
	}
	if ( !strcmp("udp",protoKind) ) {
	    reg->pm_prot = IPPROTO_UDP;
	}
	else
	if ( !strcmp("tcp",protoKind) ) {
	    reg->pm_prot = IPPROTO_TCP;
	}
	else {
	    free(pml);
	    continue;
	}

	pml->pml_next = pmaplist;
	pmaplist = pml;
    }
    fclose(fp);
    return(1);
}

static struct pmaplist *
find_service(prog, vers, prot)
    u_long prog;
    u_long vers;
{
    register struct pmaplist *hit = NULL;
    register struct pmaplist *pml;
    int child,i,sfd;
    struct sockaddr_in myAddr;
    Program *pptr;
    ActInfo *actptr;
    int wantSpeak;

    LogMsg((lf,"Request for %d/%d proto %d.\n",prog,vers,prot));
    if ( ActDBModified() ) {
	ReloadActDB();
    }
    wantSpeak = (prot == IPPROTO_TCP) ? SUNXDRTCP : SUNXDRUDP;
    pptr = (Program *) actList.next;
    while ( pptr != (Program *) NULL ) {
	actptr = pptr->actent;
	if ( actptr->progNum != prog ) {
	    pptr = (Program *) pptr->next;
	    continue;
	}
	if ( actptr->actPref != AUTO_ACT ) break;
	if ( ! (actptr->protos & wantSpeak) ) {
	    return( NULL );
	}
	
	fakeptr = &fakeEntry;
	fakeptr->pml_map.pm_prog = prog;
	fakeptr->pml_map.pm_vers = vers;
	fakeptr->pml_map.pm_prot = prot;
	sfd = socket(AF_INET,
		(prot == IPPROTO_TCP) ? SOCK_STREAM : SOCK_DGRAM, prot);
	if ( sfd < 0 ) return( NULL );
	myAddr.sin_addr.s_addr = 0;
	myAddr.sin_port = 0;
	if ( bind(sfd, &myAddr, sizeof(struct sockaddr_in)) < 0 ) {
	    close(sfd);
	    return(NULL);
	}
	child = sizeof(struct sockaddr_in);
	getsockname(sfd, &myAddr, &child);
	fakeptr->pml_map.pm_port = (long) ntohs(myAddr.sin_port);
	LogMsg((lf," port is: %d, fd is: %d.\n",fakeptr->pml_map.pm_port,sfd));
	if ( prot == IPPROTO_TCP ) {
	    listen(sfd,5);
	}

	PrintActEnt(actptr);
	child = ForkServer( actptr, sfd );
	close(sfd);
	if ( child < 0 ) {
	    return(NULL);
	}
	else {
	    return(fakeptr);
	}
    } /* while( pptr ) */
	
    for (pml = pmaplist; pml != NULL; pml = pml->pml_next) {
	if ((pml->pml_map.pm_prog != prog) ||
		(pml->pml_map.pm_prot != prot))
	    continue;
	    hit = pml;
	    if (pml->pml_map.pm_vers == vers)
		break;
    }
    return (hit);
}

int ForkServer( fActPtr, fSfd )
    ActInfo *fActPtr;
    int     fSfd;
{
    char *largv[MAXARGV+2];
    int su, sg, child;
    struct stat stbuf;

    /* Fork child process */
    sigblock(1<<SIGCHLD);
    if ( (child = vfork()) == 0 ) {
	/* 
	 * I'm a little hack job...
	 * close stdout, stderr and everything < sfd.
	 * Then open any logfiles.
	 */
	su = (fSfd > 0) ? fSfd : 8;
	for ( sg = 1; sg < su; sg++ ) {
	    close(sg);
	}
	su = 32767;
	sg = 9999;
	if ( (fActPtr->suid > 4)
	     && (stat(fActPtr->exeFile, &stbuf) >= 0) ) {
	    /*
	     * exe must be suid to owner. We check *every* time.
	     */
	    if ( (stbuf.st_uid == fActPtr->suid)
		  && (stbuf.st_mode & S_ISUID) ) {
		su = fActPtr->suid;
		sg = fActPtr->sgid;
	    }
	}

	setreuid(su,su);
	setregid(sg,sg);
	/*###
	 * Open log file -- count on setre[sg]uid
	 * to enforce access restrictions.
	 *###
	 */
	su = open( (fActPtr->logFile) ? fActPtr->logFile : "/dev/null",
		   O_WRONLY|O_CREAT|O_APPEND, 0664);
	if (su < 0) {
	    su = open("/dev/null",O_WRONLY|O_APPEND,0);
	}
	if ( su != 1 ) {
	    dup2(su,1);
	    close(su);
	}
        if ( fActPtr->errFile == NULL ) {
	    dup2(1,2);
	}
	else {
	    su = open( fActPtr->errFile, O_WRONLY|O_CREAT|O_APPEND, 0664 );
	    if ( su < 0 ) {
		su = open("/dev/null",O_WRONLY|O_APPEND,0);
	    }
	    if ( su != 2 ) {
		dup2(su,2);
		close(su);
	    }
	}

	if ( chdir( fActPtr->chdir ? fActPtr->chdir : "/tmp" ) < 0 ){
	    chdir("/tmp");
	}

	/*
	 * Dup new socket on fd 3.
	 */
	if ( fSfd > 0 ) {
	    dup2(fSfd,3);
	    close(fSfd);
	}
	largv[0] = fActPtr->exeFile;
	bcopy(fActPtr->exeArgs,&largv[1], sizeof(char *) * MAXARGV+1);
	execv(fActPtr->exeFile, largv);
	_exit(1);
    }
    sigsetmask(0);
LogMsg((lf,"Forked prog %d, pid: %d @ %d\n",fActPtr->progNum,child,time(0)));
    return( child );
}

#include <sys/wait.h>
#define W_STOPPED(w) WIFSTOPPED(w)
#define W_SIGNALED(w) WIFSIGNALLED(w)
#define W_TERMSIG(w) ((w).w_termsig)
#define W_CORE(w) ((w).w_coredump)
#define W_RETCODE(w) ((w).w_retcode)

ChildHandler()
{
    int pid;
    union wait status;
    register Program   *pptr;

    while( (pid = wait3(&status,WNOHANG,0)) > 0 ) {
	LogMsg((lf,"Reaped child %d.\n",pid));
	/*
	 * Look through pid list for pid match.
	 */
	pptr = (Program *) daemonList.next;
	while ( pptr ) {
	    if ( pptr->daemonpid == pid ) {
		break;
	    }
	    else pptr = (Program *) pptr->next;
	}
	if ( pptr == NULL ) {
	    LogMsg((lf,"...Not a daemon.\n"));
	    continue /* while ( wait() ) */;
	}

	if ( W_STOPPED(status) )
	    continue;
	if ( W_RETCODE(status) == 0 )
	    /* if they wanta quit, let'em */
	    continue;

	LogMsg((lf,"Program %d, termsig %d",pptr->actent->progNum,W_TERMSIG(status)));
	LogMsg((lf," core %d, retcode %d.\n",W_CORE(status),W_RETCODE(status)));

	/*
	 * Minimum 5 minute lifetime.
	 */
	if ( ( (time(0) - pptr->bootTime) / pptr->numBoots ) < 300 )
	    continue /* while ( wait() ) */;

	pptr->daemonpid = ForkServer( pptr->actent, -1 );
	pptr->numBoots++;
    }
}

/* 
 * 1 OK, 0 not
 */
reg_service(rqstp, xprt)
	struct svc_req *rqstp;
	SVCXPRT *xprt;
{
	struct pmap reg;
	struct pmaplist *pml, *prevpml, *fnd;
	int ans, port;
	caddr_t t;
	
#ifdef DEBUG
	LogMsg((lf, "server: about do a switch\n"));
#endif
	switch (rqstp->rq_proc) {

	case PMAPPROC_NULL:
		/*
		 * Null proc call
		 */
		if ((!svc_sendreply(xprt, xdr_void, NULL)) && debugging) {
			abort();
		}
		break;

	case PMAPPROC_SET:
		/*
		 * Set a program,version to port mapping
		 */
		if (!svc_getargs(xprt, xdr_pmap, &reg))
			svcerr_decode(xprt);
		else {
			/*
			 * check to see if already used
			 * find_service returns a hit even if
			 * the versions don't match, so check for it
			 */
			fnd = find_service(reg.pm_prog, reg.pm_vers, reg.pm_prot);
			if (fnd && fnd->pml_map.pm_vers == reg.pm_vers) {
				if (fnd->pml_map.pm_port == reg.pm_port) {
					ans = 1;
					goto done;
				}
				else {
					ans = 0;
					goto done;
				}
			} else {
				/* 
				 * add to list
				 */
				pml = (struct pmaplist *)
				    malloc((u_int)sizeof(struct pmaplist));
				pml->pml_map = reg;
				pml->pml_next = pmaplist;
				pmaplist = pml;
				ans = 1;
			}
		done:
			if ((!svc_sendreply(xprt, xdr_long, (caddr_t)&ans)) &&
			    debugging) {
				LogMsg((lf, "svc_sendreply\n"));
				abort();
			}
		}
		break;

	case PMAPPROC_UNSET:
		/*
		 * Remove a program,version to port mapping.
		 */
		if (!svc_getargs(xprt, xdr_pmap, &reg))
			svcerr_decode(xprt);
		else {
			ans = 0;
			for (prevpml = NULL, pml = pmaplist; pml != NULL; ) {
				if ((pml->pml_map.pm_prog != reg.pm_prog) ||
					(pml->pml_map.pm_vers != reg.pm_vers)) {
					/* both pml & prevpml move forwards */
					prevpml = pml;
					pml = pml->pml_next;
					continue;
				}
				/* found it; pml moves forward, prevpml stays */
				ans = 1;
				t = (caddr_t)pml;
				pml = pml->pml_next;
				if (prevpml == NULL)
					pmaplist = pml;
				else
					prevpml->pml_next = pml;
				free(t);
			}
			if ((!svc_sendreply(xprt, xdr_long, (caddr_t)&ans)) &&
			    debugging) {
				LogMsg((lf, "svc_sendreply\n"));
				abort();
			}
		}
		break;

	case PMAPPROC_GETPORT:
		/*
		 * Lookup the mapping for a program,version and return its port
		 */
		if (!svc_getargs(xprt, xdr_pmap, &reg))
			svcerr_decode(xprt);
		else {
			fnd = find_service(reg.pm_prog, reg.pm_vers, reg.pm_prot);
			if (fnd)
				port = fnd->pml_map.pm_port;
			else
				port = 0;
			if ((!svc_sendreply(xprt, xdr_long, (caddr_t)&port)) &&
			    debugging) {
				LogMsg((lf, "svc_sendreply\n"));
				abort();
			}
		}
		break;

	case PMAPPROC_DUMP:
		/*
		 * Return the current set of mapped program,version
		 */
		if (!svc_getargs(xprt, xdr_void, NULL))
			svcerr_decode(xprt);
		else {
			if ((!svc_sendreply(xprt, xdr_pmaplist,
			    (caddr_t)&pmaplist)) && debugging) {
				LogMsg((lf, "svc_sendreply\n"));
				abort();
			}
		}
		break;

	case PMAPPROC_CALLIT:
		/*
		 * Calls a procedure on the local machine.  If the requested
		 * procedure is not registered this procedure does not return
		 * error information!!
		 * This procedure is only supported on rpc/udp and calls via 
		 * rpc/udp.  It passes null authentication parameters.
		 */
		callit(rqstp, xprt);
		break;

	default:
		svcerr_noproc(xprt);
		break;
	}
}


/*
 * Stuff for the rmtcall service
 */
#define ARGSIZE 9000

typedef struct encap_parms {
	u_long arglen;
	char *args;
};

static bool_t
xdr_encap_parms(xdrs, epp)
	XDR *xdrs;
	struct encap_parms *epp;
{

	return (xdr_bytes(xdrs, &(epp->args), &(epp->arglen), ARGSIZE));
}

typedef struct rmtcallargs {
	u_long	rmt_prog;
	u_long	rmt_vers;
	u_long	rmt_port;
	u_long	rmt_proc;
	struct encap_parms rmt_args;
};

static bool_t
xdr_rmtcall_args(xdrs, cap)
	register XDR *xdrs;
	register struct rmtcallargs *cap;
{

	/* does not get a port number */
	if (xdr_u_long(xdrs, &(cap->rmt_prog)) &&
	    xdr_u_long(xdrs, &(cap->rmt_vers)) &&
	    xdr_u_long(xdrs, &(cap->rmt_proc))) {
		return (xdr_encap_parms(xdrs, &(cap->rmt_args)));
	}
	return (FALSE);
}

static bool_t
xdr_rmtcall_result(xdrs, cap)
	register XDR *xdrs;
	register struct rmtcallargs *cap;
{
	if (xdr_u_long(xdrs, &(cap->rmt_port)))
		return (xdr_encap_parms(xdrs, &(cap->rmt_args)));
	return (FALSE);
}

/*
 * only worries about the struct encap_parms part of struct rmtcallargs.
 * The arglen must already be set!!
 */
static bool_t
xdr_opaque_parms(xdrs, cap)
	XDR *xdrs;
	struct rmtcallargs *cap;
{

	return (xdr_opaque(xdrs, cap->rmt_args.args, cap->rmt_args.arglen));
}

/*
 * This routine finds and sets the length of incoming opaque paraters
 * and then calls xdr_opaque_parms.
 */
static bool_t
xdr_len_opaque_parms(xdrs, cap)
	register XDR *xdrs;
	struct rmtcallargs *cap;
{
	register u_int beginpos, lowpos, highpos, currpos, pos;

	beginpos = lowpos = pos = xdr_getpos(xdrs);
	highpos = lowpos + ARGSIZE;
	while ((int)(highpos - lowpos) >= 0) {
		currpos = (lowpos + highpos) / 2;
		if (xdr_setpos(xdrs, currpos)) {
			pos = currpos;
			lowpos = currpos + 1;
		} else {
			highpos = currpos - 1;
		}
	}
	xdr_setpos(xdrs, beginpos);
	cap->rmt_args.arglen = pos - beginpos;
	return (xdr_opaque_parms(xdrs, cap));
}

/*
 * Call a remote procedure service
 * This procedure is very quiet when things go wrong.
 * The proc is written to support broadcast rpc.  In the broadcast case,
 * a machine should shut-up instead of complain, less the requestor be
 * overrun with complaints at the expense of not hearing a valid reply ...
 */
static
callit(rqstp, xprt)
	struct svc_req *rqstp;
	SVCXPRT *xprt;
{
	char buf[2000];
	struct rmtcallargs a;
	struct pmaplist *pml;
	u_short port;
	struct sockaddr_in me;
	int socket = -1;
	CLIENT *client;
	struct authunix_parms *au = (struct authunix_parms *)rqstp->rq_clntcred;
	struct timeval timeout;

	timeout.tv_sec = 5;
	timeout.tv_usec = 0;
	a.rmt_args.args = buf;
	if (!svc_getargs(xprt, xdr_rmtcall_args, &a))
	    return;
	if ((pml = find_service(a.rmt_prog, a.rmt_vers, IPPROTO_UDP)) == NULL)
	    return;
	port = pml->pml_map.pm_port;
	get_myaddress(&me);
	me.sin_port = htons(port);
	client = clntudp_create(&me, a.rmt_prog, a.rmt_vers, timeout, &socket);
	if (client != (CLIENT *)NULL) {
		if (rqstp->rq_cred.oa_flavor == AUTH_UNIX) {
			client->cl_auth = authunix_create(au->aup_machname,
			   au->aup_uid, au->aup_gid, au->aup_len, au->aup_gids);
		}
		a.rmt_port = (u_long)port;
		if (clnt_call(client, a.rmt_proc, xdr_opaque_parms, &a,
		    xdr_len_opaque_parms, &a, timeout) == RPC_SUCCESS) {
			svc_sendreply(xprt, xdr_rmtcall_result, &a);
		}
		AUTH_DESTROY(client->cl_auth);
		clnt_destroy(client);
	}
	(void)close(socket);
}
