/*
 * Activation database definitions.  Each entry consists of
 * the following structure, indexed by program number.
 */

#ifndef actdb
#define actdb

#define NOPREF_ACT 0
#define AUTO_ACT   1
#define PRE_ACT    2
#define ALWAYS_ACT 3

/* Protos as bit masks */
#define SUNXDRTCP 1
#define SUNXDRUDP 2
#define COURCOURSPP 4
#define DECSRCUDP 8
#define RAWRAWTCP 16
#define RAWRAWUDP 32

typedef struct {
    long progNum;
    int  protos;   /* bit mask */
    int  actPref;  /* one of XX_ACT */
    char *exeFile; /* executable file name */
#define MAXARGV 5
    char *exeArgs[MAXARGV+1]; /* args for program */
    char *logFile; /* stdout */
    char *errFile; /* stderr */
    int  suid;
    int  sgid;
    char *chdir;
} ActInfo;

extern ActInfo *GetActDBEnt();
#endif
