#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <pwd.h>
#include "actdb.h"

static char *actdbDefault = "/usr/new/lib/HRPC/actPrefs";
static char actdbFile[100];

static FILE *actf = NULL;

/* "forward" */
extern char *TildeExpand();
extern char *ActStrDup();
extern char *ActItem();
extern char *ActNextLine();
extern char *ActSubStr();
extern char *ActNonBlank();

/*
 * Open the activation "database".  If no name
 * given, use default.
 */

static long lastctime = 0;

int OpenActDB( fName )
    char *fName;
{
    char *cp, *cp1;
    struct stat dbstat;
    
    if ( fName ) {
	cp = fName;
    }
    else
    if (actdbFile[0] == '\0') {
	cp = actdbDefault;
    }
    else {
	cp = actdbFile;
    }
    strcpy(actdbFile, (*cp == '~') ? TildeExpand(cp) : cp );

    if ( actf != NULL ) {
	fclose(actf);
    }
    actf = fopen(actdbFile,"r");
    if ( actf == NULL ) {
	return( -1 );
    }
    fstat(fileno(actf), &dbstat);
    lastctime = (long) dbstat.st_ctime;
    return( 0 );
}

int ActDBModified()
{
    struct stat dbstat;
    
    if ( actf != NULL ) {
#ifdef ultrix
	/* Bug in 2.0 Ultrix returns ESTALE on fstat */
	stat(actdbFile,&dbstat);
#else
	fstat(fileno(actf), &dbstat);
#endif
    }
    else {
	stat(actdbFile, &dbstat);
    }

    if ( dbstat.st_ctime > lastctime ) {
	lastctime = (long) dbstat.st_ctime;
	return( 1 );
    }
    else {
	return( 0 );
    }
}

int RewindActDB()
{
    if ( actf != NULL ) {
	return( fseek(actf, 0L, 0) );
    }
    else return( -1 );
}

int CloseActDB()
{
    int retval;
    
    if ( actf == NULL ) return( -1 );
    retval = fclose(actf);
    actf = NULL;
    return(retval);
}

/*
 * Get next entry in activation "database".  Return NULL on any error.
 * This is copied almost directly from the 4.3 inetd.
 */

ActInfo *GetActDBEnt()
{
	register ActInfo *actent;
	char *cp, *arg, *cp2;
	int argc;
	long pos = 0;
	int target;
	struct passwd *pwptr;
	struct stat statbuf;

	cp = ActNextLine(actf);
	if (cp == NULL)
		return ((ActInfo *)0);

	actent = (ActInfo *) calloc(1,sizeof(ActInfo));
	if ( actent == (ActInfo *) 0 ) return( (ActInfo *) 0 );

	arg = ActItem("progn=",cp);
	if ( !arg ) return( (ActInfo *) 0 );
	actent->progNum = atoi(arg);

	arg = ActItem("useprog=",cp);
	if ( arg ) {
	    pos = ftell(actf);
	    fseek(actf, 0L, 0);
	    target = atoi(arg);
more:
	    cp = ActNextLine(actf);
	    if ( cp == NULL ) {
		fseek(actf,pos,0);
		return( (ActInfo *) 0 );
	    }
	    arg = ActItem("progn=",cp);
	    if ( arg && ( atoi(arg) != target ) ) goto more;
	}

	arg = ActItem("protos=",cp);
	if ( ActSubStr("sun_xdr_udp", arg) )
	    actent->protos |= SUNXDRUDP;
	if ( ActSubStr("sun_xdr_tcp", arg) )
	    actent->protos |= SUNXDRTCP;
	if ( ActSubStr("cour_cour_spp", arg) )
	    actent->protos |= COURCOURSPP;
	if ( ActSubStr("dec_src_udp", arg) )
	    actent->protos |= DECSRCUDP;
	if ( ActSubStr("raw_raw_udp", arg) )
	    actent->protos |= RAWRAWUDP;
	if ( ActSubStr("raw_raw_tcp", arg) )
	    actent->protos |= RAWRAWTCP;

	actent->actPref = NOPREF_ACT;
	arg = ActItem("act=",cp);
	if ( !strcmp(arg,"pre") ) {
	    actent->actPref = PRE_ACT;
	}
	else
	if ( !strcmp(arg,"auto") ) {
	    actent->actPref = AUTO_ACT;
	}
	else
	if ( !strcmp(arg,"alwaysup") ) {
	    actent->actPref = ALWAYS_ACT;
	}
	
	arg = ActItem("exe=",cp);
	if ( arg ) {
	    if ( arg[0] == '~' ) {
	        actent->exeFile = ActStrDup( TildeExpand(arg) );
	    }
	    else {
	        actent->exeFile = ActStrDup( arg );
	    }
	}
	else actent->exeFile = ActStrDup( "/bin/date" );

	arg = ActItem("logf=",cp);
	if ( arg ) {
	    if ( arg[0] == '~' ) {
	        actent->logFile = ActStrDup( TildeExpand(arg) );
	    }
	    else {
	        actent->logFile = ActStrDup( arg );
	    }
	}
	arg = ActItem("errf=",cp);
	if ( arg ) {
	    if ( arg[0] == '~' ) {
		actent->errFile = ActStrDup( TildeExpand(arg) );
	    }
	    else {
		actent->errFile = ActStrDup( arg );
	    }
	}
	
	arg = ActItem("su=",cp);
	actent->suid = 32767;
	actent->sgid = 9999;
	if ( arg ) {
	    pwptr = getpwnam(arg);
	    if ( pwptr ) {
		actent->suid = pwptr->pw_uid;
		actent->sgid = pwptr->pw_gid;
	    }
	}

	arg = ActItem("dir=",cp);
	if ( arg ) {
	    if ( arg[0] == '~' ) {
		actent->chdir = ActStrDup( TildeExpand(arg) );
	    }
	    else {
		actent->chdir = ActStrDup(arg);
	    }
	    if ( stat(actent->chdir,&statbuf) ||
		 (statbuf.st_uid != actent->suid) ) {
		free(actent->chdir);
		actent->chdir = ActStrDup( "/tmp" );
	    }
	}
	
	arg = ActItem("args=",cp);
	argc = 0;
	if ( arg ) {
	    cp = arg;
#ifdef DEBUG
printf("args: %s.\n",cp);
#endif
	    for (arg = ActNonBlank(&cp); cp; arg = ActNonBlank(&cp)) {
#ifdef DEBUG
printf("arg %d: %s.\n",argc,arg);
#endif
		if (argc < MAXARGV)
			actent->exeArgs[argc++] = ActStrDup(arg);
	    }
	}	    
	while (argc <= MAXARGV)
		actent->exeArgs[argc++] = NULL;
	if ( pos ) fseek(actf,pos,0);
	return (actent);
}
    

FreeActDBEnt( fEnt )
	register ActInfo *fEnt;
{
	int i;

	if (fEnt->exeFile)
		free(fEnt->exeFile);
	if (fEnt->chdir)
		free(fEnt->chdir);
	for (i = 0; i < MAXARGV; i++)
		if (fEnt->exeArgs[i])
			free(fEnt->exeArgs[i]);
	free( fEnt );
}
