
/* turboutil.c */

#include"structs.h"
/* -------------------------------------------------------------- */

TURBO_ptr
turboutil_open( devtbl, num )
     VCONF_DEVTABLE *devtbl;
     int		num;
     /*  routine to open a turbo server, not a device */
{
  char *calloc();
  TURBO_ptr turbo;
  char devport[64];
  int res;

  if( !devtbl || num<0 || (num+1)>devtbl->ndevs ) {
    fprintf(stderr,"turboutil_open: given bad devtable or number\n");
    return NULL;
  }

  if( devtbl->dev[num].type != TURBO_DEV ) {
    fprintf(stderr,"rpdutil_open: device is not an RPD\n");
    return NULL;
  }
  
  turbo = (TURBO_ptr) calloc( 1, sizeof(TURBO) );
  if( turbo == NULL ) {
    fprintf(stderr,"turboutil_open: device is not an TURBO\n");
    return NULL;
  }

  strcpy(devport,"/dev/");
  strcat(devport,devtbl->dev[num].tty);
  
  strcpy(turbo->devname,devtbl->dev[num].name);
  strcpy(turbo->model,devtbl->dev[num].model);
  strcpy(turbo->volume,"TURBO GALATEA SERVER");

  res = vconf_find_model(turbo->model);
  switch(res) {
    case TURBO:
      strcpy(turbo->port, devport);
      turbo_setfuncs(turbo);
      if( (turbo->fd = 
	   ttyutil_open(
			devport,
			devtbl->dev[num].baud,
			devtbl->dev[num].parity) ) == -1 ) {
	fprintf(stderr,"turboutil_open: unable to open TURBO device\n");
	free( (char *) turbo );
	return NULL;
      }
      break;
    default:
      printf("turboutil_open: bad model <%s>\n",turbo->model);
      free( (char *) turbo);
      return NULL;
      break;
    }

  if (((*turbo->reset)(turbo)) == 0) {
    unlock_all();
    return turbo;
  }
  else {
    printf("turboutil_open: reset failed\n");
    turboutil_close(turbo);
    free((char *)turbo);
    unlock_all();
    return(NULL);
  }
}

/* -------------------------------------------------------------- */

TURBO_ptr
turboutil_close( turbo )

     TURBO_ptr turbo;
{
  ttyutil_close( turbo->fd );
  free( (char *) turbo );
  return NULL;
}
