
/* a4x1.c: a simple driver for the athena VCG 4x1 switcher,
	otherwise known as the "BOA Source Controller II" */


#include <stdio.h>
#include "switcher.h"

int	LeftSrc = 1;
int	RightSrc = 1;
int	VideoSrc = 1;

int
a4x1_open( devname, speed, parity )
	char *	devname;
	int	speed;
	int	parity;
{
int	ttyfd;

	if( (ttyfd = ttyutil_open( devname, speed, parity) ) == -1 )
	{
		fprintf(stderr,"a4x1_open: unable to open device %s\n",devname);
		return(-1);
	}
	a4x1_reset( ttyfd );
	return ttyfd;
}

int
a4x1_close( fd )

	int fd;
{
	if( fd < 0 )
		return -1;
	else 
		return close( fd );
}

static int
a4x1_set_state( v, a1, a2 )
	
	int	v,a1,a2;
{

	/* if a source is '0', leave it alone */

	if( v )
	{
		if( v < 1 )
			v = 1;
		else if( v > NUM_SOURCES )
			v = NUM_SOURCES;
		VideoSrc = v;
	}
	if( a1 )
	{
		if( a1 < 1 )
			a1 = 1;
		else if( a1 > NUM_SOURCES )
			a1 = NUM_SOURCES;
		LeftSrc = a1;
	}
	if( a2 )
	{
		if( a2 < 1 )
			a2 = 1;
		else if( a2 > NUM_SOURCES )
			a2 = NUM_SOURCES;
		RightSrc = a2;
	}
	return 0;
}

int
a4x1_reset( fd )

	int	fd;
{
char	cmd[10];

	if( fd<0 )
		return -1;

	sprintf(cmd, "@!1");
	ttyutil_write( fd, cmd, strlen(cmd), 10 );
	a4x1_set_state( 1, 1, 1 );
	return 0;
}

int
a4x1_set_video_src( fd, srcnum )

	int	fd;
	int 	srcnum;		/* from 1 to NUM_SOURCES */
{
char	cmd[10];

	if( fd<0 )
		return -1;

	if( srcnum < 1 )
		srcnum = 1;
	else if( srcnum > NUM_SOURCES )
		srcnum = NUM_SOURCES;

	sprintf(cmd, "@V%d", srcnum );
	ttyutil_write( fd, cmd, strlen(cmd), 10 );
	a4x1_set_state( srcnum, 0, 0 );
	return 0;
}

int
a4x1_set_left_src( fd, srcnum )

	int	fd;
	int 	srcnum;		/* from 1 to NUM_SOURCES */
{
char	cmd[10];

	if( fd<0 )
		return -1;

	if( srcnum < 1 )
		srcnum = 1;
	else if( srcnum > NUM_SOURCES )
		srcnum = NUM_SOURCES;

	sprintf(cmd, "@L%d", srcnum );
	ttyutil_write( fd, cmd, strlen(cmd), 10 );
	a4x1_set_state( 0, srcnum, 0 );
	return 0;
}


int
a4x1_set_right_src( fd, srcnum )

	int	fd;
	int 	srcnum;		/* from 1 to NUM_SOURCES */
{
char	cmd[10];

	if( fd<0 )
		return -1;

	if( srcnum < 1 )
		srcnum = 1;
	else if( srcnum > NUM_SOURCES )
		srcnum = NUM_SOURCES;

	sprintf(cmd, "@R%d", srcnum );
	ttyutil_write( fd, cmd, strlen(cmd), 10 );
	a4x1_set_state( 0, 0, srcnum );
	return 0;
}


int
a4x1_set_all_src( fd, srcnum )

	int	fd;
	int 	srcnum;		/* from 1 to NUM_SOURCES */
{
char	cmd[10];
int 	cc;

	if( fd<0 )
		return -1;

	if( srcnum < 1 )
		srcnum = 1;
	else if( srcnum > NUM_SOURCES )
		srcnum = NUM_SOURCES;

	sprintf(cmd, "@!%d", srcnum );
	cc = ttyutil_write( fd, cmd, strlen(cmd), 10 );
	a4x1_set_state( srcnum, srcnum, srcnum );
	return 0;
}

int
a4x1_set_chan_src( fd, chan, srcnum )

	int	chan;
	int	srcnum;
{
  int	ret = -1;

  if( fd < 0 )
    return -1;

/*  if( chan < VIDEO_CHAN )
    chan = VIDEO_CHAN;
  else if( chan > ALL_CHAN )
    chan = ALL_CHAN;*/
  
  if( srcnum < 1 )
    srcnum = 1;
  else if( srcnum > NUM_SOURCES )
    srcnum = NUM_SOURCES;
  
/*  switch( chan )
    {
    case VIDEO_CHAN:
    ret = a4x1_set_video_src( fd, srcnum );
    break;
    case LEFT_CHAN:
    ret = a4x1_set_left_src( fd, srcnum );
    break;
    case RIGHT_CHAN:
    ret = a4x1_set_right_src( fd, srcnum );
    break;
    case ALL_CHAN:
    ret = a4x1_set_all_src( fd, srcnum );
    break;
    default:
    break;
    }*/
  if ((chan & VIDEO_CHAN) && (chan & LEFT_CHAN) && (chan & RIGHT_CHAN)) {
    ret = a4x1_set_all_src( fd, srcnum);
    return ret;
  }
  if (chan & VIDEO_CHAN)
    ret = a4x1_set_video_src( fd, srcnum);
  if (chan & LEFT_CHAN)
    ret = a4x1_set_left_src( fd, srcnum);
  if (chan & RIGHT_CHAN)
    ret = a4x1_set_right_src( fd, srcnum);
 return ret;
}

int
a4x1_get_state( vsrc, lsrc, rsrc )

	int *	vsrc;
	int *	lsrc;
	int *	rsrc;
{
	*vsrc = VideoSrc;
	*lsrc = LeftSrc;
	*rsrc = RightSrc;
	return 0;
}


