#include"structs.h"

int parent_pid, starttiming(), endtiming();

sendback()
{
  signal(SIGALRM, sendback);
  
  signal(SIGUSR1, starttiming);
  signal(SIGUSR2, endtiming);

  kill(parent_pid, SIGUSR1);
  alarm(0);
}

starttiming()
{
  signal(SIGALRM, sendback);
  
  signal(SIGUSR1, starttiming);
  signal(SIGUSR2, endtiming);

  alarm(MAX_LOCK_TIME);
}

endtiming()
{
  signal(SIGALRM, sendback);
  
  signal(SIGUSR1, starttiming);
  signal(SIGUSR2, endtiming);

  alarm(0);
}

leave_supervisor()
{
  _exit(0);
}

supervisor()
{
  int cc, i;
  extern short DEBUG;
  struct timeval waitaround;
/* eliminate error messages */
  if (!DEBUG) {
    for (i = 0; i < 3; ++i)
      close(i);
    open("/",O_RDONLY);
    dup2(0,1);
    dup2(0,2);
    
    i = open("/dev/tty",O_RDWR);
    cc = 0;
    if (i >= 0) {
#ifndef SYSV
      ioctl(i,TIOCNOTTY,0);
#else
      /*ioctl(i, TIOCSPGRP, &cc);*/  /* Where is the definition???? */
#endif SYSV
      
      close(i);
    }
  }

  parent_pid = getppid();

  /*  leave cleanly, even under error conditions, because its probably
      the main galatead that got the error, and I want *that* core dump */
  signal(SIGTERM,leave_supervisor);
  signal(SIGINT,leave_supervisor);
  signal(SIGQUIT,leave_supervisor);
  signal(SIGILL,leave_supervisor);
  signal(SIGTRAP,leave_supervisor);
  signal(SIGIOT,leave_supervisor);
  signal(SIGEMT,leave_supervisor);
  signal(SIGFPE,leave_supervisor);
  signal(SIGBUS,leave_supervisor);
  signal(SIGSEGV,leave_supervisor);
  signal(SIGSYS,leave_supervisor);
  signal(SIGPIPE,leave_supervisor);
  signal(SIGXCPU,leave_supervisor);
  signal(SIGXFSZ,leave_supervisor);
  signal(SIGVTALRM,leave_supervisor);
  signal(SIGPROF,leave_supervisor);

  alarm(0);
  
  signal(SIGHUP,SIG_IGN);
  signal(SIGPIPE,SIG_IGN);

  signal(SIGALRM, sendback);
  
  signal(SIGUSR1, starttiming);
  signal(SIGUSR2, endtiming);

  while(1) {
    waitaround.tv_sec = 600;
    waitaround.tv_usec = 0;
    if (select(0,0,0,0,&waitaround) == 0)
      if (kill(parent_pid, 0) == -1) _exit(0);
  }
}
