#ifdef SIGGRAPH    /* entire file in this #ifdef */

#include"structs.h"

  static int start = 20;   /* seed for id's */

/* parm 1 is volume
   parm 2 is begin time
   parm 3 is end time
   parm 4 is the output of the client */
DoMakeReservation(msgsock, hostcommand, i)
     int msgsock, i;
     Galatea_packet *hostcommand;
{
  extern int max_reservations, num_reservations, client_output[],
  client_rev[], revision;
  extern Reservation *reservations;
  extern short DEBUG;

  struct timeval nowtime;
  int j, any_conflict = 0, new_output;
  char thisvolume[30];
  extern DeviceList *volumes;
  extern int num_volumes;

  gettimeofday(&nowtime, 0);
  
  if (client_rev[i] != revision) {
    sendint(msgsock,VOLUME_LIST_OLD);
    return(-2);
  }
  if (hostcommand->parm[1] >= num_volumes) {
    sendint(msgsock,BAD_VOLUME);
    return(-2);
  }
  if ((long)(hostcommand->parm[2]) < nowtime.tv_sec) {
    sendint(msgsock,BAD_ARGUMENT);
    return(-2);
  }
  if ((long)(hostcommand->parm[3]) < nowtime.tv_sec) {
    sendint(msgsock,BAD_ARGUMENT);
    return(-2);
  }
  if (hostcommand->parm[2] > hostcommand->parm[3]) {
    sendint(msgsock,BAD_ARGUMENT);
    return(-2);
  }

  if (hostcommand->parm[3] - hostcommand->parm[2] > MAXIMUM_RESERVATION) {
    sendint(msgsock, RESERVE_TOO_LONG);
    return(-2);
  }

  strcpy(thisvolume, volumes[hostcommand->parm[1]].volume);
  new_output = hostcommand->parm[4];

  for (j = 0; j < num_reservations; j++) {
    if (reservations[j].used == USED &&
	!(
	 ((long)(hostcommand->parm[2]) > reservations[j].end &&
	  (!strcmp(thisvolume,reservations[j].volume) ||
	   reservations[j].output == new_output)) ||
	 ((long)(hostcommand->parm[3]) < reservations[j].begin &&
	  (!strcmp(thisvolume,reservations[j].volume) ||
	   reservations[j].output == new_output))))
      any_conflict = 1;
  }

  if (any_conflict) {
    sendint(msgsock,TIME_OVERLAP);
    return(-2);
  }

  for (j=0;j<num_reservations&&reservations[j].used==USED;j++);

  if (j == max_reservations) {
    max_reservations *= 2;
    reservations = 
      (Reservation *)realloc(reservations, 
			     max_reservations * sizeof(Reservation));
  }
  reservations[j].begin = (long)hostcommand->parm[2];
  reservations[j].end = (long)hostcommand->parm[3];
  strcpy(reservations[j].volume, thisvolume);
  reservations[j].used = USED;
  reservations[j].id = unique_id();
  reservations[j].output = new_output;
  if (j == num_reservations) num_reservations++;
  if (DEBUG) {
    printf("New reservation[%d]: begin: %ld, end: %ld\n",j,
	   reservations[j].begin, reservations[j].end);
    printf("   volume: %s, id: %d, output: %d\n",reservations[j].volume,
	   reservations[j].id, reservations[j].output);
  }
  sendint(msgsock,reservations[j].id);
  write_new_reservation(j);
  return(-2);
}

unique_id()
{
  start++;
  if (start > VOLUME_LIST_OLD -5) start = 20; 
  return(start);
}

set_max_id(i)
     int i;
{
  if (i > start) {
    start = i;
    unique_id();
  }
}

write_new_reservation(j)
     int j;
{
  extern Reservation *reservations;
  extern int num_reservations;
  extern short DEBUG;
  int i, fd;

  fd = open(RESERVATION_FILE,O_WRONLY,0777);
  if (fd == -1) {
    if (DEBUG) printf("Unable to write %s\n",RESERVATION_FILE);
    return(0);
  }
  if (lseek(fd, (off_t)(j * sizeof(Reservation)), L_SET) == -1) {
    if (DEBUG) printf("lseek failed.\n");
    return(0);
  }
  write(fd, &(reservations[j]), sizeof(Reservation));
  chmod(fd,0777);
  fsync(fd);
  close(fd);
  return(0);
}

int read_reservations()
{
  extern Reservation *reservations;
  extern int num_reservations, max_reservations;
  extern short DEBUG;
  int i;
  FILE *fp, *fopen();
  struct stat buf;

  if (stat(RESERVATION_FILE, &buf) == -1) {
    if (DEBUG) printf("Unable to stat %s\n",RESERVATION_FILE);
    return(-1);
  }
  max_reservations = num_reservations = buf.st_size/sizeof(Reservation);
  fp = fopen(RESERVATION_FILE,"r");
  if (fp == NULL) {
    if (DEBUG) printf("Unable to open %s\n",RESERVATION_FILE);
    return(-1);
  }
  reservations = (Reservation *)malloc(num_reservations * sizeof(Reservation));
  i = fread(reservations, sizeof(Reservation), num_reservations, fp);
  if (i !=  num_reservations) {
    if (DEBUG) printf("Error reading %s, should read %d, actually read %d\n",
		      RESERVATION_FILE, num_reservations, i);
    fclose(fp);
    free(reservations);
    return(-1);
  }
  fclose(fp);
  for (i = 0; i < num_reservations; i++) {
    if (reservations[i].used == USED) {
      set_max_id(reservations[i].id);
      if (DEBUG) {
	printf("Saved reservation[%d]: begin: %ld, end: %ld\n",i,
	       reservations[i].begin, reservations[i].end);
	printf("   volume: %s, id: %d, output: %d\n",reservations[i].volume,
	       reservations[i].id, reservations[i].output);
      }
    }
  }
  return(num_reservations);
}

preen_reservations()
{
  int i;
  struct timeval nowtime;
  if (gettimeofday(&nowtime,0) == -1) return(0);

  for (i = 0; i < num_reservations; i++)
    if (reservations[i].end < nowtime.tv_sec)  {
      reservations[i].used = UNUSED;
      write_new_reservation(i);
    }
  return(0);
}

DoUseReservation(msgsock, hostcommand, i)
     int msgsock, i;
     Galatea_packet *hostcommand;
{
  sendint(msgsock, NO_ERROR);
  return(-2);
}

#endif SIGGRAPH
