
/* rpdutil.c */

#include"structs.h"
/* -------------------------------------------------------------- */

RPD_ptr
rpdutil_open( devtbl, num )

	VCONF_DEVTABLE *devtbl;
	int		num;
{
char *calloc();
RPD_ptr	rpd;
char devport[64];
int res;

	if( !devtbl || num<0 || (num+1)>devtbl->ndevs )
	{
		fprintf(stderr,"rpdutil_open: given bad devtable or number\n");
		return NULL;
	}
	if( devtbl->dev[num].type != RPD_DEV )
	{
		fprintf(stderr,"rpdutil_open: device is not an RPD\n");
		return NULL;
	}

	rpd = (RPD_ptr) calloc( 1, sizeof(RPD) );
	if( rpd == NULL ) {
  		fprintf(stderr,"rpdutil_open: device is not an RPD\n");
		return NULL;
	      }
	strcpy(devport,"/dev/");
	strcat(devport,devtbl->dev[num].tty);

	strcpy(rpd->devname,devtbl->dev[num].name);
	strcpy(rpd->model,devtbl->dev[num].model);
	strcpy(rpd->volume,"???");

	res = vconf_find_model( rpd->model );
	switch( res )
	{
	case SONY_LDP1000A:
	        strcpy(rpd->port, devport);
		sony_setfuncs( rpd );
		if( (rpd->fd = 
		     ttyutil_open(
				  devport,
				  devtbl->dev[num].baud,
				  devtbl->dev[num].parity) ) == -1 ) {
		  fprintf(stderr,"rpdutil_open: unable to open RPD device\n");
		  free( (char *) rpd );
		  return NULL;
		}
		break;
/* The next is for the hypothetical Georgia Tech driver */
/*	case SONY_LDP2000:
	        strcpy(rpd->port, devport);
		sony2000_setfuncs( rpd );
		if( (rpd->fd = 
		     ttyutil_open(
				  devport,
				  devtbl->dev[num].baud,
				  devtbl->dev[num].parity) ) == -1 ) {
		  fprintf(stderr,"rpdutil_open: unable to open RPD device\n");
		  free( (char *) rpd );
		  return NULL;
		}
		break;    */
	case DEC_VDP50:
	        strcpy(rpd->port, devport);
		vdp50_setfuncs( rpd );
		if( (rpd->fd = 
		     ttyutil_open(
				  devport,
				  devtbl->dev[num].baud,
				  devtbl->dev[num].parity) ) == -1 ) {
		  fprintf(stderr,"rpdutil_open: unable to open RPD device\n");
		  free( (char *) rpd );
		  return NULL;
		}
		break;
	case PANA_OMDR:
	        strcpy(rpd->port, devport);
		pana_setfuncs( rpd );
		if( (rpd->fd = 
		     ttyutil_open(
				  devport,
				  devtbl->dev[num].baud,
				  devtbl->dev[num].parity) ) == -1 ) {
		  fprintf(stderr,"rpdutil_open: unable to open RPD device\n");
		  free( (char *) rpd );
		  return NULL;
		}
		break;
        case NETRPD:
		strcpy(rpd->port, devtbl->dev[num].tty);
                netrpd_setfuncs( rpd );
		rpd->serv = devtbl->dev[num].server;
		rpd->fd = GConnection(rpd->serv);
		sscanf(devtbl->dev[num].channel,"%*d-%d",&rpd->volnum);
		break;
	default:
		printf("rpdutil_open: bad model <%s>\n",rpd->model);
		free( (char *) rpd );
		return NULL;
		break;
	}

	if (((*rpd->reset)(rpd)) == 0) {
	  unlock_all();
	  return rpd;
	}
        else {
	  printf("rpdutil_open: reset failed\n");
	  rpdutil_close(rpd);
	  free((char *)rpd);
	  unlock_all();
	  return(NULL);
	}
}

/* -------------------------------------------------------------- */

RPD_ptr
rpdutil_close( rpd )

	RPD_ptr rpd;
{
  int res;

  res = vconf_find_model( rpd->model );
  if (res == NETRPD) GCloseServer(rpd->serv);
  else ttyutil_close( rpd->fd );
  free( (char *) rpd );
  return NULL;
}
