
/* pana.h */

/* PANA_OMDR header file for videodisc driver */
/* 
	Russ Sasnett
	MIT Project Athena
	Visual Courseware Group
	russ@athena
*/

#ifndef PANA_H
#define PANA_H

/* 
	command transmission should have no CR/LF, 
	no ACK/NAK (because each command is in its own packet),
	and no error response (get it in packet form; tell
	from the completion response).

	therefore, only responses should be completion responses
	and data parms

	This communications mode is specified by ON-line mode #13
*/

typedef unsigned char	UBYTE;

static struct cmdtbl
{
	char *	cmd_name;
	char *	cmd_fmt;	/* output format (used for sprintf'ing) */
	char *	resp_fmt;	/* format of bytes received */
	UBYTE	nresp;		/* nchars in response (without STX + ETX)*/
} pana_table[] =

/*
	==========================================
	cmd_name, 	cmd_str, 	resp_bytes
	==========================================
*/
	{
	"Step-Fwd", 		"JF", 		"JF",	2,	/* actually uses the 'jump' cmd */
	"Step-Rev", 		"JR", 		"JR",	2,
	"Load", 		"LD", 		"LD",	2,
	"Eject",		"EJ", 		"EJ",	2,
	"Clear",		"AC",		"AC",	2,
	"Status",		"PS",		"Z%2s",	3,
	"On-Line-Mode",		"ON13:",	"ON",	2, /* hard-wired to be mode 13 */
	"Off-Line",		"OF",		"OF",	2,
	"GetFrame",		"NO",		"NO%05d", 7,	/* gets current address */
	"Record Stop",		"GR",		"GR",	2,
	"Record-Remain",	"RR",		"RR%05d", 7,	/* # frame can record */
	"Motor-Off",		"SP",		"SP",	2,
	"Fwd-Play",		"PF",		"PF",	2,
	"Rev-Play",		"PR",		"PR",	2,
	"Fwd-Play-To",		"PF%05d:",	"PF",	2,
	"Rev-Play-To",		"PR%05d:",	"PR",	2,
	"Fwd-Slow",		"LF%03d:",	"LF",	2, /* 1/X times normal */
	"Rev-Slow",		"LR%03d:",	"LR",	2, 
	"Fwd-Fast",		"FF%03d:",	"FF",	2, /* X times normal */
	"Rev-Fast",		"RF%03d:",	"RF",	2,
	"Search",		"SR%05d:",	"SR",	2,
	"A1-On",		"A134:",	"A1",	2,
	"A1-Off",		"A10:",		"A1",	2,
	"A2-On",		"A234:",	"A2",	2,
	"A2-Off",		"A20:",		"A2",	2,
	"Index-On",		"DS",		"DS",	2,
	"Index-Off",		"DR",		"DR",	2,
	"Video-On",		"VS",		"VS",	2,
	"Video-Off",		"VR",		"VR",	2,
	"Dub-Play",		"DP",		"DP",	2,
	"Manual-Record",	"RM%05d:",	"RM",	2, /* enter recording mode, with # frames */
	"Auto-Record",		"RA%05d:",	"RA",	2, /* enter recording mode, with # frames */
	"Record-Start",		"GS%05d:",	"GS",	2,
	"Record-Audio-On",	"AS",		"AS",	2,
	"Record-Audio-Off",	"AR",		"AR",	2,
	"Play-Audio-On",	"AS",		"AS",	2,
	"Play-Audio-Off",	"AR",		"AR",	2,
	"Find-Free-Video",	"RE",		"RE%05d", 7,	/* number of first free video */
	"Find-Free-Audio",	"AE",		"AE%05d", 7,	/* number of first free audio */
	"Record-Clear",		"RC",		"RC",	2,	/* gets out of recording mode */
	};

#define NUM_PANA_CMDS	( sizeof(pana_table) / sizeof(struct cmdtbl) )

/* error table */

struct _errtbl
{
	char *	resp;		/* actual returned bytes */
	char *	reason;		/* english explanation */
} Pana_Errors[] =

/*
	===========================
	response bytes,	explanation
	===========================
*/
	{
	"E01",		"bad instruction",
	"E02",		"bad disc format",
	"E03",		"no disc loaded",
	"E04",		"search timed out",
	"E06",		"bad focus",
	"E07",		"bad sync",
	"E08",		"head off of disc",
	"E09",		"track already recorded",
	"E10",		"sync problem in recording",
	"E11",		"bad load/eject",
	"E12",		"dew condensation",
	"E20",		"receive buffer overflow",
	"E21",		"communications error",
	"E22",		"unable to decode command",
	"E24",		"concentric disc can't record",
	"E30",		"battery problem",
	"E35",		"noise detected",
	};

#define PANA_BEGIN	0x02	/* begin a command packet */
#define PANA_END	0x03	/* end a command packet */

#endif PANA_H
