/* netswtr_driver.c: a simple driver for switcher forwarding */

#include <stdio.h>
#include "structs.h"
#include "netswtr.h"
#include "swtr_driver.h"

/* --------------------------------------------------------------- */

static int	/* private, internal utility routine */
netswtr_set_state( swtr, output, v, a1, a2 )
	
	SWTR_ptr swtr;
	int	output;		/* the number of the output */
	int	v,a1,a2;	/* the number of the input patched to that channel */
{
	if( !output || output < 1 || output > NUM_OUTPUTS || !swtr)
		return 0;
	output -= 1;	/* adjust for zero-base */

	/* if anything is 0, leave it alone */

	swtr->state[output].VideoSource = v;

	if( a1 )
	{
		if( a1 < 1 )
			a1 = 1;
		else if( a1 > NUM_INPUTS )
			a1 = NUM_INPUTS;
		swtr->state[output].LeftSource = a1;
	}
	if( a2 )
	{
		if( a2 < 1 )
			a2 = 1;
		else if( a2 > NUM_INPUTS )
			a2 = NUM_INPUTS;
		swtr->state[output].RightSource = a2;
	}
	return 0;
}

/* --------------------------------------------------------------- */

int
netswtr_reset( swtr )

	SWTR_ptr	swtr;
{
char	cmd[10];

	if( !swtr )
		return -1;

	if( swtr->fd<0 )
		return -1;

        return 0;   /* netswtr_reset is meaningless over the net */
}

/* --------------------------------------------------------------- */

int
netswtr_set_chan_src( swtr, chan, srcnum, output )

	SWTR_ptr swtr;
	int	output;	/* should always be 1, because only 1 output */
	int	chan;
	int	srcnum;
{
  int	ret = -1;
  char	cmd[10];
  extern int need_to_rebuild_list;

  if( !swtr )
    return -1;
  
  if( swtr->fd < 0 )
    return -1;
  if (add_lock(swtr->serv) == -1) return(-1);
  ret = GSwitch(swtr->serv,srcnum,chan);
  if (ret == GIO_ERROR) {
    need_to_rebuild_list = 1;
    bsdsyslog(LOG_NOTICE,
	   "netswtr_cmd: GIO_ERROR: %s",swtr->devname);
    return(-1);
  }

  ret = GRelease(swtr->serv);
  if (ret == GIO_ERROR) {
    need_to_rebuild_list = 1;
    bsdsyslog(LOG_NOTICE,
	   "netswtr_cmd: GIO_ERROR: %s",swtr->devname);
    return(-1);
  }
  return 0;
}

/* --------------------------------------------------------------- */

int
netswtr_inquire( swtr, output, vsrc, lsrc, rsrc )

	SWTR_ptr swtr;
	int	output;
	int *	vsrc;
	int *	lsrc;
	int *	rsrc;
{

	if( output < 1 || output > NUM_OUTPUTS || !swtr)
		return -1;	/* don't mess with the channel return values */
	output -= 1;		/* adjust for zero-base */

	*vsrc = swtr->state[output].VideoSource;
	*lsrc = swtr->state[output].LeftSource;
	*rsrc = swtr->state[output].RightSource;
	return 0;
}

/* --------------------------------------------------------------- */

int
netswtr_setfuncs( swtr )

	SWTR_ptr	swtr;
{
	swtr->reset = netswtr_reset;
	swtr->set_chan_src = netswtr_set_chan_src;
	swtr->inquire = netswtr_inquire;
	swtr->inputs = NUM_INPUTS;	/* from netswtr.h */
	swtr->outputs = NUM_OUTPUTS;	/* from netswtr.h */
	return 0;
}

