

/* netrpd.h */

/* 
	Russ Sasnett
	MIT Project Athena
	Visual Courseware Group
	russ@athena
*/

/* interface codes from the manual */

#ifndef NETRPD_H
#define NETRPD_H

/* the following are the possible player response codes */

#define SONY_COMPLETION		0x01	/* returned after search or repeat */
#define SONY_ERROR		0x02	/* command invalid or too large; use CL or CE */
#define SONY_PGMEND		0x04	/* completed internal program */
#define SONY_NOTTARGET		0x05	/* didn't complete search or repeat as desired */
#define SONY_ACK		0x0a	/* 1-byte command understood */
#define SONY_NAK		0x0b	/* 1-byte command not understood */

/* the rest are possible command bytes */

#define SONY_STOP		0x3f	/* stops disc and blanks video */

#define	SONY_RPLAY		0x4a
#define	SONY_RFAST		0x4b
#define	SONY_RSLOW		0x4c
#define	SONY_RSTEP		0x4d
#define	SONY_RSCAN		0x4e

#define	SONY_FPLAY		0x3a
#define	SONY_FFAST		0x3b
#define	SONY_FSLOW		0x3c
#define	SONY_FSTEP		0x3d
#define	SONY_FSCAN		0x3e

#define	SONY_SEARCH		0x43
#define	SONY_ENTER		0x40
#define SONY_STILL		0x4f	/* stops disc, displays current frame */
#define SONY_CL			0x56
#define SONY_CE			0x41
#define SONY_INDEXON		0x50
#define SONY_INDEXOFF		0x51
#define SONY_CH1ON		0x46	/* audio channel 1 on */
#define SONY_CH1OFF		0x47	/* ........ off */
#define SONY_CH2ON		0x48	/* audio channel 2 on */
#define SONY_CH2OFF		0x49	/* ........ off */
#define SONY_REPEAT		0x44
#define SONY_SEGMENT		0x45
#define SONY_SEGMODE		0x54	/* mode for search and repeat */
#define SONY_FRAMEMODE		0x55
#define SONY_PGM		0x57
#define SONY_RUN		0x58
#define SONY_END		0x59

#define SONY_ADDRINQ		0x60	/* frame # readback, gives 5 bytes */
#define SONY_CONTINUE		0x61	/* use after stop */

#define	SONY_MOTORON		0x62
#define	SONY_MOTOROFF		0x63

#define SONY_STATUSINQ		0x67
#define SONY_DISCIDINQ		0x68	/* only works on SONY discs */

#endif NETRPD_H
