
/* models.h */

#ifndef MODELS_H
#define MODELS_H

/* valid currently-supported device models */

static struct _mdlz		/* private to whoever includes it (video_conf.c) */
{
	char *the_name;
	char *gdb_mon;		/* name of GDB program to monitor the device */
} model_tbl[] =
	{
	"SONY_LDP1000A","rpd_pipe",
	"DEC_VDP50",	"rpd_pipe",
	"ATHENA_4x1",	"swtr_pipe",
	"PANA_OMDR",	"rpd_pipe",
	"NETRPD",	"rpd_mon",
	"NETSWTR",      "swtr_pipe",
	"PE_8x1vr",     "swtr_pipe",
/* This is for the hypothetical Georgia Tech driver */
/*	"SONY_LDP2000", "rpd_pipe",   */
	};

#define NUM_MODELS	(sizeof(model_tbl) / sizeof(struct _mdlz))

#define SONY_LDP1000A    0
#define DEC_VDP50        1
#define ATHENA_4x1       2
#define PANA_OMDR        3
#define NETRPD           4
#define NETSWTR          5
#define PE_8x1vr         6
/* This is for the hypothetical Georgia Tech driver */
/*#define SONY_LDP2000     7*/

#endif MODELS_H
