#include <stdio.h>
#include "structs.h"

static int num_locks = 0;
static Server *locks[100];

add_lock(fd)
     Server *fd;
{
  int i;
  extern int need_to_rebuild_list;
  for (i = 0; i < num_locks; i++)
    if (fd == locks[i]) return(0);
  locks[num_locks++] = fd;
  if (GLock(fd) == GIO_ERROR) {
    need_to_rebuild_list = 1;
    bsdsyslog(LOG_NOTICE,"remote server lock: GIO_ERROR");
    return(-1);
  }
  return(0);
}

unlock_all()
{
  int i;

  for (i = 0; i < num_locks; i++)
  if (GUnLock(locks[i]) == GIO_ERROR) {
    need_to_rebuild_list = 1;
    bsdsyslog(LOG_NOTICE,"remote server unlock: GIO_ERROR");
  }
  num_locks = 0;
}

clear_locks()
{
  num_locks = 0;
}
