#include"structs.h"

RPD_ptr players[30];
RPD_ptr rpd;
SWTR_ptr switchers[30];
Output rpd_out[30], input_out[30], switcher_out[30];
DeviceList *volumes;
int revision = 0;
int realswitcher[30];
int need_to_rebuild_list = 0;
char configfile[60];
Forward *remote_servers;
Server **servs;
#ifdef SIGGRAPH
Reservation *reservations;
int num_reservations = 0, max_reservations = 0;
#endif SIGGRAPH

fd_set allavail, lockavail;
int h_errno, sock, sockets[MAXSOCKETS], avail[MAXSOCKETS], 
  num_players = 0, num_switchers = 0, num_volumes = 0, num_inputs = 0,
  cur_volume_l = 0, cur_volume_r = 0, cur_volume_v = 0, whichlock, 
  notice_socket, client_rev[MAXSOCKETS], client_output[MAXSOCKETS], 
  num_notify = 0, num_forwards = 0, timer_pid;
#ifdef UNIXCONN
int unix_sock;
#endif UNIXCONN
char **addresses, **notify_list, localaddress[30];
struct hostent *lhp;
struct sockaddr_in notice;

short DEBUG = 0, RESTRICT = 0, ANSWER = 1, LOCKED = 0, SPINUP = 0;
VCONF_DEVTABLE vdt;
extern int dienow();

main(argc,argv)
     char **argv;
     int argc;
{
  fd_set ready, justcheck;
  int cc, tm, rpd_index, i, j, len, msgsock, intable, cur_volume, timeouts;
  
  struct timeval discsave;
  struct sockaddr_in server, client;
  struct in_addr inet_address;
#ifdef UNIXCONN
  struct sockaddr_un unix_server;
#endif UNIXCONN
  struct hostent *sourcehost;
  extern char *getenv();
  char localhost[60];
  struct passwd *userinfo;
  struct servent *service, *notice_service;
  struct timeval *to, timout;
  extern int sigrebuild();
  int dispatches = 0;
  extern int unlock_self();

  strcpy(configfile, CONFIGURATION_FILE);
/* command line parser */
  for (i = 1; i< argc ; i++) {
    if (strcmp(argv[i],"debug") == 0) DEBUG = 1;
    if (strcmp(argv[i],"restrict") == 0) RESTRICT = 1;
    if (strcmp(argv[i],"spinup") == 0) SPINUP = 1;
    if (argv[i][0] == '/') strcpy(configfile, argv[i]);
  }

  if (DEBUG) printf("Server revision: %.1f  Protocol Revision: %.1f\n",
		    (float)SERVER_REVISION / 10.0,
		    (float)PROTOCOL_REVISION / 10.0);
#ifndef SYSV
  if (DEBUG) printf("%d file descriptors\n", getdtablesize());
#endif SYSV

/* start a process to do our timing.  A rewrite of the device drivers
   and timers.c would allow me to use setitimer in this process to do
   this timer, but for now I'm just going to start another process
   and use signals USR1 and USR2 to coordinate timing activity */
  signal(SIGUSR1, unlock_self);
  timer_pid = fork();
  if (!timer_pid) supervisor();

/* setup timeouts */
  discsave.tv_sec = QUERYTIME;
  discsave.tv_usec = 0;

  signal(SIGPIPE, SIG_IGN);  /* take care of this nice and early */

/* open system logging facility */
  bsdopenlog("galatead", LOG_CONS | LOG_NOWAIT | LOG_PID, LOG_LOCAL2);
  userinfo = getpwuid(getuid());
  bsdsyslog(LOG_INFO,"Start by %s", userinfo->pw_name);
#ifdef SEAMLESS
  bsdsyslog(LOG_INFO,"Seamless editting enabled");
#endif SEAMLESS
#ifdef SIGGRAPH
  bsdsyslog(LOG_INFO,"SIGGRAPH authentication enabled");
  if (read_reservations() < 1) {
    reservations = (Reservation *)malloc(15 * sizeof(Reservation));
    max_reservations = 15;
    num_reservations = 0;
  }
#endif SIGGRAPH


/* setup video disk */
  build_volumes(0);
  need_to_rebuild_list = 0;

  FD_ZERO(&allavail);

/* establish local id */
  gethostname(localhost,32);
  lhp = gethostbyname(localhost);
  if (lhp) {
    bcopy(lhp->h_addr, &inet_address, lhp->h_length);
    strcpy(localaddress, inet_ntoa(inet_address));    
    if (DEBUG) printf("Local host is %s, address is %s\n",lhp->h_name,
		      localaddress);
  }
  if (!lhp && DEBUG) printf("Can't resolve local host.\n");
  

/* setup network connection */
  sock = socket(AF_INET,SOCK_STREAM,0);
  if (sock < 0) {
    printf("Error creating socket.\n");
    kill(timer_pid, SIGTERM);
    exit(NULL);
  }
  server.sin_family = AF_INET;
  server.sin_addr.s_addr = INADDR_ANY;
  
  service = getservbyname("galatea",NULL);

  if (service == 0) {
    server.sin_port = htons(4001);
  }
  else {
    server.sin_port = service->s_port;
  }
  if (DEBUG) printf("Port is %d.\n",ntohs(server.sin_port));

  if (bind(sock,&server,sizeof(server))) {
    printf("Error binding socket.  This could mean that %s\n",argv[0]);
    printf("is already running or that UNIX has not yet figured out\n");
    printf("that an old one has already died.  Server is not running.\n");
    kill(timer_pid, SIGTERM);
    exit(NULL);
  }

  bzero(avail,MAXSOCKETS*sizeof(int));

  FD_SET(sock,&allavail);

#ifdef UNIXCONN
/* setup unix listening socket */
  unix_sock = socket(AF_UNIX, SOCK_STREAM, 0);
  if (sock < 0) {
    printf("Error creating UNIX socket.  Server is running, anyway.\n");
  }
  mkdir(G_UNIX_DIR, 0777);
  chmod(G_UNIX_DIR, 0777);  /* prevent interference of umask */
  unix_server.sun_family = AF_UNIX;
  strcpy (unix_server.sun_path, G_UNIX_PATH);
  unlink(unix_server.sun_path);
  if (bind(unix_sock, (struct sockaddr *)&unix_server, 
	   strlen(unix_server.sun_path) + 2) < 0)
    printf("Error binding UNIX socket.  Server is running, anyway.\n");
  else {
    listen(unix_sock, 5);
    
    FD_SET(unix_sock,&allavail);
  }
#endif UNIXCONN

/* setup server recovery socket */
  if ((notice_socket = socket(AF_INET, SOCK_DGRAM, 0)) >= 0) {
    notice_service = getservbyname("galanotice","udp");
    if (notice_service == 0) {
      notice.sin_port = htons(4002);
    }
    else {
      notice.sin_port = notice_service->s_port;
    }

    notice.sin_addr.s_addr = INADDR_ANY;
    notice.sin_family = AF_INET;

    if (DEBUG) printf("Port is %d for notification.\n",ntohs(notice.sin_port));
    if (bind(notice_socket, &notice, sizeof(notice)) < 0) {
      if (DEBUG) printf("Bad bind for notification.\n");
      notice_socket = -1;
    }
  }
  if (notice_socket == -1 && DEBUG) 
    printf("No notification service.\n");
  if (notice_socket > -1 ) {
    FD_SET(notice_socket, &allavail);
    if (DEBUG) printf("Notification enabled.\n");
    notify_hosts();  /* notify previous connected hosts */
  }

/* misc bullshit */
  addresses = (char **)calloc(MAXSOCKETS, sizeof(char *));
  notify_list = (char **)calloc(MAXSOCKETS, sizeof(char *));

/* eliminate error messages */
  if (!DEBUG) {
    for (i = 0; i < 3; ++i)
      close(i);
    open("/",O_RDONLY);
    dup2(0,1);
    dup2(0,2);
    
    i = open("/dev/tty",O_RDWR);
    cc = 0;
    if (i >= 0) {
#ifndef SYSV
      ioctl(i,TIOCNOTTY,0);
#else
      /*ioctl(i, TIOCSPGRP, &cc);*/  /* Where is the definition???? */
#endif SYSV

      close(i);
    }
  }
  /* fork and start infinite loop */
  if (!DEBUG && fork()) exit(0);
  if (!DEBUG) bsdsyslog(LOG_INFO,"Forked");

/* write process ID */
  write_pid();

/* prepare to die */
  signal(SIGTERM,dienow);

/* handle requests to rebuild volume list */
  signal(SIGHUP, sigrebuild);

  listen(sock,5);

  justcheck = allavail;
  unlock_all();  /* just to make sure; its a cheap call */
  if (!SPINUP) saveplayers();
  if (SPINUP) spinupplayers();
  timeouts = 0;   /* we haven't had any timeouts yet */
  while(1) {
    /* check in case previous dealwithit inspired a rebuild */
    if (need_to_rebuild_list) rebuildvolumes();

    signal(SIGPIPE, sigrebuild);  /* handle rebuilds only when there is no
				     chance of getting the signal from a 
				     client connection */
    unlock_all();   /* just to make sure we have 
		       released all remote servers */
    do {
      /* figure out whether to use the all the file descripters, or just
	 the one for the locking client (if any) */
      if (LOCKED) justcheck = lockavail;
      else justcheck = allavail;
/*      if (DEBUG)
	to = NULL;
      else {*/
	timout = discsave;
	to = &timout;
/*      }*/
      cc = select(MAXSOCKETS,&justcheck,0,0,to);  /* anybody want anything? */
      if (need_to_rebuild_list) rebuildvolumes(); /* if there was a SIGHUP */
    } while (cc < 0);
    if (cc == 0) {
      if (timeouts < 3) {
	/* if we couldn't connect to a server before, see if we can now */
	check_remote_servers();
#ifdef SIGGRAPH
	preen_reservations();
#endif SIGGRAPH
	timeouts++;  /* we've had another timeout */
      }
      else {
	/* spin down players and wait for something to be requested */
	saveplayers(&justcheck);
	timeouts = 0;
      }
    }
    if (cc > 0) {
      /* make sure we can't get a SIGPIPE from clients */
      signal(SIGPIPE, SIG_IGN);
      
/* We have to rebuild volume tables */
      if (FD_ISSET(notice_socket, &justcheck) || need_to_rebuild_list)
	rebuildvolumes();

/* This is the main listening socket */
      if (FD_ISSET(sock,&justcheck)) acceptnew(sock);
#ifdef UNIXCONN
      if (FD_ISSET(unix_sock, &justcheck)) acceptnew(unix_sock);
#endif UNIXCONN

/* Check previously connected sockets */
      for (i = 0; i < MAXSOCKETS; i++) {
	if (FD_ISSET(sockets[i],&justcheck) && avail[i] == USED) {
	  dispatches++;
	  dealwithit(i);
       }
      }
    }
    if (dispatches > 300) {
#ifdef SIGGRAPH
      preen_reservations();
#endif SIGGRAPH
      dispatches = 0;
    }
  }
}


saveplayers()
{
  int i, cc;
  RPD_ptr rpd;
  fd_set justcheck;
  Output cur_output;
  struct timeval waitaround;

  if (DEBUG) printf("Spinning down RPD's.\n");
  if (num_volumes > 0) {  /* switch to the first volume in the table
			     so that we can have some kind of default
			     and Bob can watch TV */
    if (volumes[0].type == RPD_DEV) {
      cur_output = rpd_out[volumes[0].resource[volumes[0].cur_resource]];
    }
    if (volumes[0].type == INPUT_DEV) {
      cur_output = input_out[volumes[0].resource[volumes[0].cur_resource]];
    }
    doswitchtree(cur_output,ALL_CHAN);
  }
  spindownplayers();
  do {
    waitaround.tv_sec = QUERYTIME;
    waitaround.tv_usec = 0;
    if (LOCKED) justcheck = lockavail;
    else justcheck = allavail;
    cc = select(MAXSOCKETS,&justcheck,0,0,&waitaround);

    if (cc == 0) {
      check_remote_servers();
#ifdef SIGGRAPH
      preen_reservations();
#endif SIGGRAPH
    }
/* We have to rebuild volume tables */
    if (FD_ISSET(notice_socket, &justcheck) || need_to_rebuild_list) {
      rebuildvolumes();
      cc = 0;
    }
  } while( cc < 1);
  if (DEBUG) printf("Spinning up RPD's.\n");
  spinupplayers();
}

spinupplayers()
{
  int i, prev_fd = -1, num_forked = 0;
  RPD_ptr rpd;
  for (i = 0; i < num_players; i++) {
      rpd = players[i];
      if (prev_fd != rpd->fd) { /* with DUPed devices, don't want to try
				   LOADing it twice simultaneously! */
	if ((*rpd->cmd)(rpd,FORKLOAD) == 0) num_forked++;
	prev_fd = rpd->fd;
      }
  }
  while(num_forked-- > 0)
    wait(0);
  unlock_all();
}  

spindownplayers()
{
  int i, prev_fd = -1;
  RPD_ptr rpd;
  for (i = 0; i < num_players; i++) {
      rpd = players[i];
      if (prev_fd != rpd->fd) {
	(*rpd->cmd)(rpd,UNLOAD);
	prev_fd = rpd->fd;
      }
  }
  unlock_all();
}  

dienow()
{
  int i;
  RPD_ptr rpd;
  kill(timer_pid, SIGTERM);  /* eliminate supervisor */
  listen(sock,0);  /* don't allow new conenctions */
  notify_hosts();  /* tell the Requesting hosts to try to reconnect
		      The Requesting hosts's attempts will fail */
  sleep(3);
  bsdsyslog(LOG_NOTICE, "Spinning down disks on SIGTERM");
  spindownplayers();
  for (i = 0; i < MAXSOCKETS; i++) {
    if (avail[i] == USED) close(sockets[i]);
  }

  exit(0);
}
    
