#include"structs.h"

#ifdef SEAMLESS
static command *timing_list = NULL;
#endif SEAMLESS

/* parm 1 is output number */
DoOpenServer(msgsock,hostcommand, j)
     int msgsock, j;
     Galatea_packet *hostcommand;
{
  extern int num_volumes, revision, client_rev[], client_output[];
  extern DeviceList *volumes;
  int num_extensions = 0;
  int i, vols_for_client = 0, cur_type, cur_index;
  int netnum;
  extern short DEBUG;

  client_rev[j] = revision;
  client_output[j] = hostcommand->parm[1];
  for ( i = 0; i < num_volumes; i++)
    if (volumes[i].output == hostcommand->parm[1]) vols_for_client++;
  if (sendint(msgsock,vols_for_client) == -1) return(-1);

  for (i = 0 ; i< num_volumes; i++)
    if (volumes[i].output == hostcommand->parm[1]) {
      if (sendint(msgsock,i) == -1) return(-1);
      if (sendint(msgsock,volumes[i].type) == -1) return(-1);
      if (sendstring(msgsock,volumes[i].volume) == -1) return(-1);
      if (DEBUG) printf("Volume %d, %s\n",i, volumes[i].volume);
    }
  if (sendint(msgsock, VIDEO_CHAN | LEFT_CHAN | RIGHT_CHAN) == -1) return(-1);
#ifdef SIGGRAPH
  num_extensions++;
#endif SIGGRAPH
#ifdef SEAMLESS
  num_extensions++;
#endif SEAMLESS
  if (sendint(msgsock, num_extensions) == -1) return(-1);
#ifdef SIGGRAPH
  if (sendstring(msgsock,SIGGRAPH_NAME) == -1) return(-1);
#endif SIGGRAPH
#ifdef SEAMLESS
  if (sendstring(msgsock,SEAMLESS_NAME) == -1) return(-1);
#endif SEAMLESS
  if (sendint(msgsock, MAX_LOCK_TIME) == -1) return(-1);
  if (sendint(msgsock, 0) == -1) return(-1);  /* ex1 */
  if (sendint(msgsock, 0) == -1) return(-1);  /* ex2 */
  if (sendint(msgsock, 0) == -1) return(-1);  /* ex3 */
  if (sendint(msgsock, 0) == -1) return(-1);  /* ex4 */
  if (sendint(msgsock, 0) == -1) return(-1);  /* ex5 */
  if (sendint(msgsock, 0) == -1) return(-1);  /* ex6 */
  if (sendint(msgsock, 0) == -1) return(-1);  /* ex7 */
  if (sendint(msgsock, 0) == -1) return(-1);  /* ex8 */

  return(-2);
}

#ifdef SEAMLESS
DoPlayList(msgsock,hostcommand,i)
  int msgsock;
  Galatea_packet *hostcommand;
  int i;
{
  int rval;

  runlist(timing_list,msgsock);
  return(-2);
}
  
DoDownload(msgsock,hostcommand,i)
  int msgsock;
  Galatea_packet *hostcommand;
  int i;
{
  action *script;
  extern action *create_action_script();
  extern command *compile_script();
  extern short DEBUG;


  script = create_action_script(msgsock);
  if (DEBUG) {
	printf("DoDownload: printing action script . . .\n");
	print_script(script);
	}

  free_timing_list(timing_list);

  timing_list = compile_script(script); 
  if (DEBUG) {
	printf("DoDownload: printing timing list . . .\n");
        print_timing_list(timing_list);
	}
  if (DEBUG) printf("DoDownload: freeing action script . . .\n");
  free_script(script);
  if (timing_list != NULL) {
  	if (DEBUG) printf("DoDownload: returning NO_ERROR . . .\n");
  	return(sendint(msgsock,NO_ERROR));
  }
  else {
  	if (DEBUG) printf("DoDownload: returning COULDNT_DO_FUNC . . .\n");
	return(sendint(msgsock,COULDNT_DO_FUNC));
  }
}
#endif SEAMLESS

/* parm 1 is srcnum,
   parm 2 is channel
   parm 3 is sync */
/* returns BAD_VOLUME  */
DoSwitch(msgsock,hostcommand,i)
     int msgsock, i;
     Galatea_packet *hostcommand;
{
  extern int num_volumes;
  extern DeviceList *volumes;
  extern SWTR_ptr switchers[];
  extern int realswitcher[], cur_volume_l, cur_volume_r, cur_volume_v,
  client_rev[], revision;
  extern Output switcher_out[], rpd_out[], input_out[];

  Output cur_output;
  int whichdevice;
  whichdevice = hostcommand->parm[1];

  if (client_rev[i] != revision) {
    if (!hostcommand->parm[3]) return(sendint(msgsock,VOLUME_LIST_OLD));
    return(-2);
  }
  if (whichdevice >= num_volumes) {
    if (!hostcommand->parm[3]) return(sendint(msgsock,BAD_VOLUME));
    return(-2);
  }
  if (volumes[whichdevice].type == RPD_DEV) {
    cur_output = rpd_out[volumes[whichdevice].resource[volumes[whichdevice].cur_resource]];
  }
  if (volumes[whichdevice].type == INPUT_DEV) {
    cur_output = input_out[volumes[whichdevice].resource[volumes[whichdevice].cur_resource]];
  }
  doswitchtree(cur_output,hostcommand->parm[2]);
  if (hostcommand->parm[2] & LEFT_CHAN) cur_volume_l = hostcommand->parm[1];
  if (hostcommand->parm[2] & RIGHT_CHAN) cur_volume_r = hostcommand->parm[1];
  if (hostcommand->parm[2] & VIDEO_CHAN) cur_volume_v = hostcommand->parm[1];

  if (!hostcommand->parm[3]) return(sendint(msgsock,NO_ERROR));
  return(-2);
}

doswitchtree(oneoutput,mask)
     Output oneoutput;
     int mask;
{
  extern Output switcher_out[];
  extern int realswitcher[];
  extern SWTR_ptr switchers[];

  SWTR_ptr switcher;
  Output cur_output;

  cur_output = oneoutput;
  while (cur_output.switcher != 0) {
    switcher = switchers[realswitcher[cur_output.switcher]];
    (*switcher->set_chan_src)(switcher, mask, cur_output.channel, 1);
    cur_output = switcher_out[realswitcher[cur_output.switcher]];
  }
}

sendint(msgsock,msg)
     int msgsock, msg;
{
  int i;
  msg = htonl(msg);
  i = full_write(msgsock,&msg,sizeof(int));
  if ( i < sizeof(int)) i = -1;
  return(i);
}

sendstring(msgsock, mesg)
     int msgsock;
     char *mesg;
{
  int i;
  i = strlen(mesg) + 1;
  if (sendint(msgsock,i) == -1) return(-1);
  if (full_write(msgsock,mesg,i) != i) return(-1);
  return(0);
}

/* parm 1 is volume
   parm 2 is frame
   parm 3 is mask
   parm 4 is sync */
/* returns {actual current frame | BAD_VOLUME | FUNC_NOT_SUPPORTED | 
 COULDNT_SEARCH}*/
DoSearch(msgsock,hostcommand,i)
     int msgsock,i;
     Galatea_packet *hostcommand;
{
  extern RPD_ptr players[];
  extern DeviceList *volumes;
  extern Output rpd_out[];
  extern int cur_volume_l, cur_volume_r, cur_volume_v, num_volumes,
  client_rev[], revision;
  RPD_ptr rpd;
  int retframe, resource, mask;

  if (client_rev[i] != revision) {
    if (!hostcommand->parm[4]) return(sendint(msgsock,VOLUME_LIST_OLD));
    return(-2);
  }
  if (hostcommand->parm[1] >= num_volumes) {
    if (!hostcommand->parm[4]) return(sendint(msgsock,BAD_VOLUME));
    return(-2);
  }

  if (volumes[hostcommand->parm[1]].type != RPD_DEV) {
    if (!hostcommand->parm[4]) return(sendint(msgsock,FUNC_NOT_SUPPORTED));
    return(-2);
  }

  resource = findclosetresource(hostcommand->parm[1], 
				hostcommand->parm[2]);
  if (resource == -1) {
    if (!hostcommand->parm[4]) return(sendint(msgsock,FUNC_NOT_SUPPORTED));
    return(-2);
  }
  volumes[hostcommand->parm[1]].cur_resource = resource;
  rpd = players[volumes[hostcommand->parm[1]].resource[resource]];
  if (rpd == NULL) {
    if (!hostcommand->parm[4]) return(sendint(msgsock,FUNC_NOT_SUPPORTED));
    return(-2);
  }

  (*rpd->search)(rpd,hostcommand->parm[2],1);

  mask = hostcommand->parm[3];

  if (hostcommand->parm[1] == cur_volume_l) {
    mask |= LEFT_CHAN;
  }
  if (hostcommand->parm[1] == cur_volume_r) {
    mask |= RIGHT_CHAN;
  }
  if (hostcommand->parm[1] == cur_volume_v) {
    mask |=  VIDEO_CHAN;
  }

  if (mask)
    doswitchtree(rpd_out[volumes[hostcommand->parm[1]].resource[volumes[hostcommand->parm[1]].cur_resource]], mask);

  retframe = (*rpd->getframe)(rpd);

  if (!hostcommand->parm[4]) return(sendint(msgsock,retframe));
  return(-2);
}

findclosetresource(volume,goal)
     int volume, goal;
{
  extern DeviceList *volumes;
  int cur_close, cur_res, next_close, next_res, i;
  extern RPD_ptr players[];
  RPD_ptr rpd;

  if (volumes[volume].type != RPD_DEV) return(-1);
  
  rpd = players[volumes[volume].resource[0]];
  if (rpd == NULL) return(-1);

  cur_close = (*rpd->getframe)(rpd);
  
  cur_res = 0;

  for ( i = 1; i < volumes[volume].num_resources; i++) {
    rpd = players[volumes[volume].resource[i]];
    next_close = (*rpd->getframe)(rpd);
    if (abs(goal-next_close) < abs(goal-cur_close) && (
      next_close > 0 && next_close < VOLUME_LIST_OLD)) {
      cur_close = next_close;
      cur_res = i;
    }
  }
  return(cur_res);
}

/* parm 1 is volume,
   parm 2 is INDEX_ON or INDEX_OFF or INDEX_TOGGLE
   parm 3 is sync */
/* returns {NO_ERROR | BAD_VOLUME | BAD_ARGUMENT | FUNC_NOT_SUPPORTED} */
DoIndex(msgsock,hostcommand,j)
     int msgsock;
     Galatea_packet *hostcommand;
{
  extern DeviceList *volumes;
  extern RPD_ptr players[];
  extern int num_volumes, client_rev[], revision;
  int i;
  RPD_ptr rpd;

  if (client_rev[j] != revision) {
    if (!hostcommand->parm[3]) return(sendint(msgsock,VOLUME_LIST_OLD));
    return(-2);
  }
  if (hostcommand->parm[1] >= num_volumes) {
    if (!hostcommand->parm[3]) return(sendint(msgsock,BAD_VOLUME));
    return(-2);
  }

  if (volumes[hostcommand->parm[1]].type != RPD_DEV) {
    if (!hostcommand->parm[3]) return(sendint(msgsock,FUNC_NOT_SUPPORTED));
    return(-2);
  }

  if (hostcommand->parm[2] != INDEX_ON && 
      hostcommand->parm[2] != INDEX_OFF &&
      hostcommand->parm[2] != INDEX_TOGGLE) {
    if (!hostcommand->parm[3]) return(sendint(msgsock,BAD_ARGUMENT));
    return(-2);
  }

  if (hostcommand->parm[2] == INDEX_TOGGLE) {
    if (volumes[hostcommand->parm[1]].index_state == INDEX_ON)
      hostcommand->parm[2] = INDEX_OFF;
    else hostcommand->parm[2] = INDEX_ON;
  }
  volumes[hostcommand->parm[1]].index_state = hostcommand->parm[2];
  for ( i = 0 ; i < volumes[hostcommand->parm[1]].num_resources; i++) {
    rpd = players[volumes[hostcommand->parm[1]].resource[i]];
    if (rpd == NULL) continue;
    (*rpd->cmd)(rpd,hostcommand->parm[2]);
  }
  if (!hostcommand->parm[3]) return(sendint(msgsock,NO_ERROR));
  return(-2);
}

/* parm 1 is volume,
   parm 2 is a LEFT_CHAN | RIGHT_CHAN | VIDEO_CHAN | INDEX_CTRL
   parm 3 is TURN_ON or TURN_OFF
   parm 4 is sync */
/* returns {NO_ERROR | BAD_VOLUME | BAD_ARGUMENT | FUNC_NOT_SUPPORTED} */
DoConfigure(msgsock,hostcommand,j)
     int msgsock, j;
     Galatea_packet *hostcommand;
{
  extern DeviceList *volumes;
  extern RPD_ptr players[];
  extern int num_volumes, client_rev[], revision;
  int i, k;
  RPD_ptr rpd;

  if (client_rev[j] != revision) {
    if (!hostcommand->parm[4]) return(sendint(msgsock,VOLUME_LIST_OLD));
    return(-2);
  }
  if (hostcommand->parm[1] >= num_volumes) {
    if (!hostcommand->parm[4]) return(sendint(msgsock,BAD_VOLUME));
    return(-2);
  }

  if (volumes[hostcommand->parm[1]].type != RPD_DEV) {
    if (!hostcommand->parm[4]) return(sendint(msgsock,FUNC_NOT_SUPPORTED));
    return(-2);
  }

  if (hostcommand->parm[3] != TURN_ON && 
      hostcommand->parm[3] != TURN_OFF) {
    if (!hostcommand->parm[4]) return(sendint(msgsock,BAD_ARGUMENT));
    return(-2);
  }

  for ( i = 0 ; i < volumes[hostcommand->parm[1]].num_resources; i++) {
    rpd = players[volumes[hostcommand->parm[1]].resource[i]];
    if (rpd == NULL) continue;
    if (hostcommand->parm[3] == TURN_ON) {
      if (hostcommand->parm[2] & LEFT_CHAN) (*rpd->cmd)(rpd,A1_ON);
      if (hostcommand->parm[2] & RIGHT_CHAN) (*rpd->cmd)(rpd,A2_ON);
      if (hostcommand->parm[2] & INDEX_CTRL) (*rpd->cmd)(rpd,INDEX_ON);
    }
    if (hostcommand->parm[3] == TURN_OFF) {
      if (hostcommand->parm[2] & LEFT_CHAN) (*rpd->cmd)(rpd,A1_OFF);
      if (hostcommand->parm[2] & RIGHT_CHAN) (*rpd->cmd)(rpd,A2_OFF);
      if (hostcommand->parm[2] & INDEX_CTRL) (*rpd->cmd)(rpd,INDEX_OFF);
    }
  }
  if (!hostcommand->parm[4]) return(sendint(msgsock,NO_ERROR));
  return(-2);
}


/* parm 1 is volume,
   parm 2 is LOAD or UNLOAD 
   parm 3 is sync */
/* returns {NO_ERROR | BAD_VOLUME | BAD_ARGUMENT | FUNC_NOT_SUPPORTED} */
DoLoad(msgsock,hostcommand,j)
     int msgsock;
     Galatea_packet *hostcommand;
{
  extern DeviceList *volumes;
  extern RPD_ptr players[];
  extern int num_volumes;
  int i;
  RPD_ptr rpd;

  if (client_rev[j] != revision) {
    if (!hostcommand->parm[3]) return(sendint(msgsock,VOLUME_LIST_OLD));
    return(-2);
  }
  if (hostcommand->parm[1] >= num_volumes) {
    if (!hostcommand->parm[3]) return(sendint(msgsock,BAD_VOLUME));
    return(-2);
  }

  if (volumes[hostcommand->parm[1]].type != RPD_DEV) {
    if (!hostcommand->parm[3]) return(sendint(msgsock,FUNC_NOT_SUPPORTED));
    return(-2);
  }
  if (hostcommand->parm[2] != LOAD && 
      hostcommand->parm[2] != UNLOAD) {
    if (!hostcommand->parm[3]) return(sendint(msgsock,BAD_ARGUMENT));
    return(-2);
  }

  if (!islocal(j)) {
    if (!hostcommand->parm[3]) return(sendint(msgsock,PERMISSION_DENIED));
    return(-2);
  }

  for ( i = 0 ; i < volumes[hostcommand->parm[1]].num_resources; i++) {
    rpd = players[volumes[hostcommand->parm[1]].resource[i]];
    if (rpd == NULL) continue;
    (*rpd->cmd)(rpd,hostcommand->parm[2]);
  }
  if (!hostcommand->parm[3]) return(sendint(msgsock,NO_ERROR));
  return(-2);
}

int islocal(i)
     int i;
{
  extern char **addresses, localaddress[];
  
  if (!strcmp(addresses[i], UNIX_STRING) ||
      !strcmp(addresses[i], localaddress)) return(1);
  return(0);
}

/* parm 1 is volume
   parm 2 is speed
   parm 3 is mask
   parm 4 is sync */
/* returns {actual current speed | BAD_VOLUME | FUNC_NOT_SUPPORTED}*/
DoRun(msgsock,hostcommand,i)
     int msgsock,i;
     Galatea_packet *hostcommand;
{
  extern RPD_ptr players[];
  extern DeviceList *volumes;
  extern Output rpd_out[];
  extern int cur_volume_l, cur_volume_r, cur_volume_v, num_volumes,
  client_rev[], revision;
  RPD_ptr rpd;
  int retframe, resource, mask, retspeed;

  if (client_rev[i] != revision) {
    if (!hostcommand->parm[4]) return(sendint(msgsock,VOLUME_LIST_OLD));
    return(-2);
  }
  if (hostcommand->parm[1] >= num_volumes) {
    if (!hostcommand->parm[4]) return(sendint(msgsock,BAD_VOLUME));
    return(-2);
  }
  if (volumes[hostcommand->parm[1]].type != RPD_DEV) {
    if (!hostcommand->parm[4]) return(sendint(msgsock,FUNC_NOT_SUPPORTED));
    return(-2);
  }

  rpd = players[volumes[hostcommand->parm[1]].resource[volumes[hostcommand->parm[1]].cur_resource]];
  if (rpd == NULL) {
    if (!hostcommand->parm[4]) return(sendint(msgsock,FUNC_NOT_SUPPORTED));
    return(-2);
  }
  retspeed = (*rpd->varspeed)(rpd,hostcommand->parm[2]);

  retframe = (*rpd->getframe)(rpd);

  mask = hostcommand->parm[3];

  if (mask) 
    doswitchtree(rpd_out[volumes[hostcommand->parm[1]].resource[volumes[hostcommand->parm[1]].cur_resource]], mask);

  if (!hostcommand->parm[4]) return(sendint(msgsock,retspeed));
  return(-2);
}


/* parm 1 is volume
   parm 2 is direction
   parm 3 is mask 
   parm 4 is sync */
/* returns {actual current frame | BAD_VOLUME | FUNC_NOT_SUPPORTED} */
DoJog(msgsock,hostcommand,i)
     int msgsock, i;
     Galatea_packet *hostcommand;
{
  extern RPD_ptr players[];
  extern DeviceList *volumes;
  extern Output rpd_out[];
  extern int cur_volume_l, cur_volume_r, cur_volume_v, num_volumes,
  client_rev[], revision;
  RPD_ptr rpd;
  int retframe, resource, mask;

  if (client_rev[i] != revision) {
    if (!hostcommand->parm[4]) return(sendint(msgsock,VOLUME_LIST_OLD));
    return(-2);
  }
  if (hostcommand->parm[1] >= num_volumes) {
    if (!hostcommand->parm[4]) return(sendint(msgsock,BAD_VOLUME));
    return(-2);
  }
  if (volumes[hostcommand->parm[1]].type != RPD_DEV) {
    if (!hostcommand->parm[4]) return(sendint(msgsock,FUNC_NOT_SUPPORTED));
    return(-2);
  }

  rpd = players[volumes[hostcommand->parm[1]].resource[volumes[hostcommand->parm[1]].cur_resource]];
  if (rpd == NULL) {
    if (!hostcommand->parm[4]) return(sendint(msgsock,FUNC_NOT_SUPPORTED));
    return(-2);
  }
  (*rpd->jog)(rpd,hostcommand->parm[2]);

  retframe = (*rpd->getframe)(rpd);

  mask = hostcommand->parm[3];

  if (mask) doswitchtree(rpd_out[volumes[hostcommand->parm[1]].resource[volumes[hostcommand->parm[1]].cur_resource]], mask);

  if (!hostcommand->parm[4]) return(sendint(msgsock,retframe));
  return(-2);
}

/* parm 1 is volume
   parm 2 is mask
   parm 3 is sync */
/* returns {actual current frame | BAD_VOLUME | FUNC_NOT_SUPPORTED} */
DoStill(msgsock,hostcommand,i)
     int msgsock,i;
     Galatea_packet *hostcommand;
{
  extern RPD_ptr players[];
  extern DeviceList *volumes;
  extern Output rpd_out[];
  extern int cur_volume_l, cur_volume_r, cur_volume_v, num_volumes,
  client_rev[], revision;
  RPD_ptr rpd;
  int retframe, resource, mask;

  if (client_rev[i] != revision) {
    if (!hostcommand->parm[3]) return(sendint(msgsock,VOLUME_LIST_OLD));
    return(-2);
  }
  if (hostcommand->parm[1] >= num_volumes) {
    if (!hostcommand->parm[3]) return(sendint(msgsock,BAD_VOLUME));
    return(-2);
  }
  if (volumes[hostcommand->parm[1]].type != RPD_DEV) {
    if (!hostcommand->parm[3]) return(sendint(msgsock,FUNC_NOT_SUPPORTED));
    return(-2);
  }

  rpd = players[volumes[hostcommand->parm[1]].resource[volumes[hostcommand->parm[1]].cur_resource]];
  if (rpd == NULL) {
    if (!hostcommand->parm[3]) return(sendint(msgsock,FUNC_NOT_SUPPORTED));
    return(-2);
  }
  (*rpd->varspeed)(rpd,STOP);

  retframe = (*rpd->getframe)(rpd);

  mask = hostcommand->parm[2];

  if (mask) 
    doswitchtree(rpd_out[volumes[hostcommand->parm[1]].resource[volumes[hostcommand->parm[1]].cur_resource]], mask);

  if (!hostcommand->parm[3]) return(sendint(msgsock,retframe));
  return(-2);
}

/* parm 1 is volume
   parm 2 is sync */
/* returns {actual current frame | BAD_VOLUME | FUNC_NOT_SUPPORTED} */
DoGetFrame(msgsock,hostcommand,i)
     int msgsock,i;
     Galatea_packet *hostcommand;
{
  extern RPD_ptr players[];
  extern DeviceList *volumes;
  extern Output rpd_out[];
  extern int cur_volume_l, cur_volume_r, cur_volume_v, num_volumes,
  client_rev[], revision;
  RPD_ptr rpd;
  int retframe, resource, mask, cc;

  if (client_rev[i] != revision) {
    cc = sendint(msgsock,VOLUME_LIST_OLD);
    if (!hostcommand->parm[2]) return(cc);
    return(-2);
  }
  if (hostcommand->parm[1] >= num_volumes) {
    cc = sendint(msgsock,BAD_VOLUME);
    if (!hostcommand->parm[2]) return(cc);
    return(-2);
  }
  if (volumes[hostcommand->parm[1]].type != RPD_DEV) {
    cc = sendint(msgsock,FUNC_NOT_SUPPORTED);
    if (!hostcommand->parm[2]) return(cc);
    return(-2);
  }

  rpd = players[volumes[hostcommand->parm[1]].resource[volumes[hostcommand->parm[1]].cur_resource]];
  if (rpd == NULL) {
    cc = sendint(msgsock,FUNC_NOT_SUPPORTED);
    if (!hostcommand->parm[2]) return(cc);
    return(-2);
  }

  retframe = (*rpd->getframe)(rpd);
  if (retframe == -1) retframe = COULDNT_DO_FUNC;

  cc = sendint(msgsock,retframe);
  if (!hostcommand->parm[2]) return(cc);
  return(-2);
}

/* parm 1 is volume 
   parm 2 is sync */
/* returns {NO_ERROR | BAD_VOLUME | FUNC_NOT_SUPPORTED} */
DoReset(msgsock,hostcommand, j)
     int msgsock,j;
     Galatea_packet *hostcommand;
{
  extern RPD_ptr players[];
  extern DeviceList *volumes;
  extern Output rpd_out[];
  extern int cur_volume_l, cur_volume_r, cur_volume_v, num_volumes,
  client_rev[], revision;
  RPD_ptr rpd;
  int retframe, resource, mask, i;

  if (client_rev[j] != revision) {
    if (!hostcommand->parm[2]) return(sendint(msgsock,VOLUME_LIST_OLD));
    return(-2);
  }
  if (hostcommand->parm[1] >= num_volumes) {
    if (!hostcommand->parm[2]) return(sendint(msgsock,BAD_VOLUME));
    return(-2);
  }
  if (volumes[hostcommand->parm[1]].type != RPD_DEV) {
    if (!hostcommand->parm[2]) return(sendint(msgsock,FUNC_NOT_SUPPORTED));
    return(-2);
  }
  for ( i = 0 ; i < volumes[hostcommand->parm[1]].num_resources; i++) {
    rpd = players[volumes[hostcommand->parm[1]].resource[i]];
    if (rpd == NULL) continue;
    (*rpd->reset)(rpd);
  }

  if (!hostcommand->parm[2]) return(sendint(msgsock,NO_ERROR));
  return(-2);
}


/* parm 1 is volume
   parm 2 is start frame
   parm 3 is end frame
   parm 4 is speed
   parm 5 is mask
   parm 6 is return_flag
   parm 7 is sync*/
/* returns {actual current frame | BAD_VOLUME | FUNC_NOT_SUPPORTED} */
DoPlaySeg(msgsock,hostcommand, i)
     int msgsock, i;
     Galatea_packet *hostcommand;
{
  extern RPD_ptr players[];
  extern DeviceList *volumes;
  extern Output rpd_out[];
  extern int cur_volume_l, cur_volume_r, cur_volume_v, num_volumes,
  client_rev[], revision;
  RPD_ptr rpd;
  int retframe, resource, mask;

  if (client_rev[i] != revision) {
    if (!hostcommand->parm[7]) return(sendint(msgsock,VOLUME_LIST_OLD));
    return(-2);
  }
  if (hostcommand->parm[1] >= num_volumes) {
    if (!hostcommand->parm[7]) return(sendint(msgsock,BAD_VOLUME));
    return(-2);
  }
  if (volumes[hostcommand->parm[1]].type != RPD_DEV) {
    if (!hostcommand->parm[7]) return(sendint(msgsock,FUNC_NOT_SUPPORTED));
    return(-2);
  }

  resource = findclosetresource(hostcommand->parm[1],hostcommand->parm[2]);
  if (resource == -1) {
    if (!hostcommand->parm[7]) return(sendint(msgsock,FUNC_NOT_SUPPORTED));
    return(-2);
  }
  volumes[hostcommand->parm[1]].cur_resource = resource;
  rpd = players[volumes[hostcommand->parm[1]].resource[resource]];
  if (rpd == NULL) {
    if (!hostcommand->parm[7]) return(sendint(msgsock,FUNC_NOT_SUPPORTED));
    return(-2);
  }

  if (MAX_LOCK_TIME && 
      abs((hostcommand->parm[3] - hostcommand->parm[2]) / hostcommand->parm[4])
      > MAX_LOCK_TIME && hostcommand->parm[6] == RETURN_SYNC) {
    if (!hostcommand->parm[7]) return(sendint(msgsock,SEGMENT_TOO_LONG));
    return(-2);
  }

  mask = hostcommand->parm[5];

  if (hostcommand->parm[1] == cur_volume_l) {
    mask |= LEFT_CHAN;
  }
  if (hostcommand->parm[1] == cur_volume_r) {
    mask |= RIGHT_CHAN;
  }
  if (hostcommand->parm[1] == cur_volume_v) {
    mask |=  VIDEO_CHAN;
  }

  if (mask)
    doswitchtree(rpd_out[volumes[hostcommand->parm[1]].resource[volumes[hostcommand->parm[1]].cur_resource]], mask);

  (*rpd->segplay)(rpd,hostcommand->parm[2],hostcommand->parm[3],
		  hostcommand->parm[4], hostcommand->parm[6]);

  retframe = (*rpd->getframe)(rpd);

  if (!hostcommand->parm[7]) return(sendint(msgsock,retframe));
  return(-2);
}

/* no parms */
/* returns {NO_ERROR | VOLUME_LIST_OLD} */
DoCheckRevision(msgsock,hostcommand,i)
     int msgsock, i;
     Galatea_packet *hostcommand;
{
  extern int client_rev[], revision;
  if (client_rev[i] != revision)
    sendint(msgsock,VOLUME_LIST_OLD);
  else sendint(msgsock,NO_ERROR);
  return(-2);
}

/* no parms */
/* return current server time since midnight, January 1, 1970 */
DoGetServerTime(msgsock, hostcommand, i)
     int msgsock, i;
     Galatea_packet *hostcommand;
{
  struct timeval nowtime;
  int curtime;

  if (gettimeofday(&nowtime, 0) != 0) {
    if (DEBUG) printf("gettimeofday failed\n");
    bsdsyslog(LOG_INFO,"gettimeofday failed");
    curtime = -1;
    if (sendint(msgsock, curtime) == -1) return(-1);
    return(-2);
  }
  curtime = (int)(nowtime.tv_sec);
  if (sendint(msgsock,curtime) == -1) return(-1);
  return(-2);
}

/* no parms */
/* returns {NO_ERROR} */
DoLock(msgsock,hostcommand,i)
     int msgsock, i;
     Galatea_packet *hostcommand;
{
  extern short LOCKED;
  extern fd_set lockavail;
  extern int sock, whichlock, notice_socket;
  extern int timer_pid;

  FD_ZERO(&lockavail);
  FD_SET(msgsock,&lockavail);
/*  FD_SET(sock,&lockavail);*/
  if (notice_socket > -1)
    FD_SET(notice_socket,&lockavail);
  if (!LOCKED) {
    whichlock = i;
    if (MAX_LOCK_TIME) kill(timer_pid,SIGUSR1);
    LOCKED = 1;
  }
  sendint(msgsock,NO_ERROR);
  return(-2);
}

/* no parms */
/* returns {NO_ERROR} */
DoUnLock(msgsock,hostcommand, i)
     int msgsock;
     Galatea_packet *hostcommand;
{
  extern short LOCKED;
  
  LOCKED = 0;
  kill(timer_pid,SIGUSR2);
  sendint(msgsock,NO_ERROR);
  return(-2);
}

unlock_self()
{
  extern short LOCKED, DEBUG;
  extern int whichlock;
  bsdsyslog(LOG_NOTICE,"Timeout on client[%d] lock",whichlock);
  if (DEBUG) printf("Timeout on client[%d] lock\n",whichlock);
  LOCKED = 0;
}

clean_lock()
{
  extern short LOCKED;
  LOCKED = 0;
  kill(timer_pid,SIGUSR2);
}

/* parm 1 is SPINDOWN or NOSPINDOWN */
/* returns {NO_ERROR | BADARGUMENT} */
DoShutOff(msgsock,hostcommand,i)
     int msgsock, i;
     Galatea_packet *hostcommand;
{
  extern int sockets[], avail[], sock, timer_pid;
  extern char **addresses;
  extern short DEBUG;
  int j;

  if (hostcommand->parm[1] != SPINDOWN && hostcommand->parm[1] != NOSPINDOWN)
    return(sendint(msgsock,BAD_ARGUMENT));
    
  if (!islocal(i))
    return(sendint(msgsock,PERMISSION_DENIED));

  sendint(msgsock,NO_ERROR);

  bsdsyslog(LOG_NOTICE, "shutting down on %s",addresses[i]);
  kill(timer_pid, SIGTERM); /* get rid of supervisor */
  listen(sock,0);  /* don't allow new connections */
  notify_hosts();  /* tell the Requesting hosts to try to reconnect
                      The Requesting hosts attempt to connect will fail */
  sleep(3);  /* give the clients a bit to close the connection */
  for (j = 0; j < MAXSOCKETS; j++) {
    if (avail[j] == USED) close(sockets[j]);
  }
  if (hostcommand->parm[1] == SPINDOWN) spindownplayers();
  exit(0);
}
  
DoRequestNotification(msgsock, hostcommand, i)
     int msgsock, i;
     Galatea_packet *hostcommand;
{
  extern char **notify_list, **addresses, localaddress[];
  extern int num_notify;

  int j, len;
  struct sockaddr_in client;
  char *temp;

  len = sizeof(client);
  if (!getpeername(msgsock, &client, &len)) {
    if ( client.sin_family == AF_INET) {
      temp = addresses[i];
      if (DEBUG) printf("Requesting host is: %s on connection %d\n",
			temp,i);
      fflush (stdout);
      if (!strcmp(temp,localaddress)) return(-2);
      for ( j = 0; j < MAXSOCKETS; j++)
	if (!strcmp(temp,notify_list[j])) return(-2);
      notify_list[i] = (char *)malloc(strlen(temp)+1);
      strcpy(notify_list[i],temp);
      write_host_file();
      return(-2);
    }
    else if (DEBUG) printf("Client is not on AF_INET connection.\n");
  }
  else if (DEBUG) {
    printf("Hey, what?  getpeername failed!\n");
    perror("getpeername: ");
  }
  return(-2);
}

