#include"structs.h"

build_volumes(close_previous)
     int close_previous;
{
  extern VCONF_DEVTABLE vdt;
  extern short DEBUG;
  extern int num_players, num_switchers, num_volumes, num_inputs;
  extern RPD_ptr players[];
  extern SWTR_ptr switchers[];
  extern Output rpd_out[], input_out[30], switcher_out[];
  extern DeviceList *volumes;
  extern int realswitcher[];
  extern int revision, timer_pid;
  extern char configfile[60];
  int i, j, intable, cur_volume = 0, cur_tvolume = 0, num_tvolumes,
  previous_opened = 0;
  DeviceList *tvolumes;
  Output cur_output;

  clear_locks();
  if (close_previous) {
    for (i = 0; i < num_players; i++)
      rpdutil_close(players[i]);
    for (i = 0; i < num_switchers; i++)
      swtrutil_close(switchers[i]);
    sleep(1);   /* give UNIX a bit to catch up */
  }

  if( vconf_get_table(NULL, configfile, &vdt ) != VCONF_AOK )
    return(NULL);
  
/* build volume table */
  num_volumes = 0;
  for ( i = 0; i < vdt.ndevs; i++) {
    if (vdt.dev[i].type == RPD_DEV || vdt.dev[i].type == INPUT_DEV ||
	vdt.dev[i].type == DUP_DEV) {
      intable = 0;
      for ( j = 0; j < i; j++)
	if (!strcmp(vdt.dev[i].name,vdt.dev[j].name) &&
	    vdt.dev[i].output == vdt.dev[j].output) intable = 1;
      if (!intable) num_volumes++;
    }
  }
  
  if (DEBUG) printf("%d distinct volumes available.\n",num_volumes);
  volumes = (DeviceList *)malloc(sizeof(DeviceList)*num_volumes);
  if (volumes == NULL) {
    printf("Could not malloc volume table.\n");
    kill(timer_pid,SIGTERM);
    exit(1);
  }

  num_players = num_switchers = 0;
  for (i = 0; i < vdt.ndevs; i++) {
    if (vdt.dev[i].type == RPD_DEV) {
      if((players[num_players] = rpdutil_open(&vdt,i)) == NULL) {
	if (DEBUG) printf("unable to open rpd, index = %d\n",i);
      }
      if (players[num_players] != NULL) {
	bsdsyslog(LOG_INFO,"%s, %s, at %s",players[num_players]->model,
	       players[num_players]->devname, players[num_players]->port);
	if (DEBUG) printf("Opened: %s, %s as player %d, output %s, ",
			  players[num_players]->model,
			  players[num_players]->devname,num_players,
			  vdt.dev[i].channel);
	sscanf(vdt.dev[i].channel,"%d-%d",&rpd_out[num_players].switcher,
	       &rpd_out[num_players].channel);
	previous_opened = 1;
	if (DEBUG) printf("switch %d, channel %d\n",
			  rpd_out[num_players].switcher,
			  rpd_out[num_players].channel);
	intable = -1;
	for ( j = 0; j < cur_volume; j++) {
	  if (!strcmp(volumes[j].volume,vdt.dev[i].name) &&
	      volumes[j].output == vdt.dev[i].output) intable = j;
	}
	if (intable == -1) {
	  strcpy(volumes[cur_volume].volume,vdt.dev[i].name);
	  volumes[cur_volume].type = RPD_DEV;
	  volumes[cur_volume].num_resources = 1;
	  volumes[cur_volume].cur_resource = 0;
	  volumes[cur_volume].output = vdt.dev[i].output;
	  volumes[cur_volume].resource[0] = num_players;
	  cur_volume++;
	}
	else {/* what to do about duplicates */
	  volumes[intable].resource[volumes[intable].num_resources++] = num_players;
	}
	num_players++;
      }
      else previous_opened = 0;
    }

    if (vdt.dev[i].type == INPUT_DEV) {
      if (DEBUG) printf("Available: %s, output %s, ",vdt.dev[i].name,
			vdt.dev[i].channel);
      sscanf(vdt.dev[i].channel,"%d-%d",&input_out[num_inputs].switcher,
	     &input_out[num_inputs].channel);
      if (DEBUG) printf("switch %d, channel %d\n",
			input_out[num_inputs].switcher,
			input_out[num_inputs].channel);
      intable = -1;
      previous_opened = 1;
      for ( j = 0; j < cur_volume; j++){
	if (!strcmp(volumes[j].volume,vdt.dev[i].name) &&
	    volumes[j].output == vdt.dev[i].output) intable = j;
      }
      if (intable == -1) {
	strcpy(volumes[cur_volume].volume,vdt.dev[i].name);
	volumes[cur_volume].type = INPUT_DEV;
	volumes[cur_volume].num_resources = 1;
	volumes[cur_volume].cur_resource = 0;
	volumes[cur_volume].output = vdt.dev[i].output;
	volumes[cur_volume].resource[0] = num_inputs;
	cur_volume++;
      }
      else {/* what to do about duplicates */
	volumes[intable].resource[volumes[intable].num_resources++] = 
	  num_inputs;
      }
      num_inputs++;
    }

    else if (vdt.dev[i].type == SWTR_DEV) {
      if((switchers[num_switchers] = swtrutil_open(&vdt,i)) == NULL) {
	if (DEBUG) printf("unable to open switcher, index = %d\n",i);
      }
      if (switchers[num_switchers] != NULL) {
        bsdsyslog(LOG_INFO,"%s, %s, at %s",switchers[num_switchers]->model,
	       switchers[num_switchers]->devname, 
	       switchers[num_switchers]->port);
	if (DEBUG) printf("Opened: %s, %s as switcher %d, output %s, ",
			  switchers[num_switchers]->model,
			  switchers[num_switchers]->devname,
			  num_switchers,
			  vdt.dev[i].channel);
	sscanf(vdt.dev[i].channel,"%d-%d",
	       &switcher_out[num_switchers].switcher,
	       &switcher_out[num_switchers].channel);
	previous_opened = 1;
	if (DEBUG) printf("switch %d, channel %d\n",
			  switcher_out[num_switchers].switcher,
			  switcher_out[num_switchers].channel);
	sscanf(vdt.dev[i].name,"SWTR-%d",&j);
	realswitcher[j] = num_switchers;
	num_switchers++;
      }
      else previous_opened = 0;
    }
    else if (vdt.dev[i].type == DUP_DEV && previous_opened) {
      if (vdt.dev[i-1].type == RPD_DEV) {
	if (DEBUG) printf("DUPping previous RPD_DEV\n");
	players[num_players] = (RPD_ptr)calloc(1, sizeof(RPD));
	bcopy(players[num_players-1], players[num_players], sizeof(RPD));
	sscanf(vdt.dev[i].channel,"%d-%d",&rpd_out[num_players].switcher,
	       &rpd_out[num_players].channel);
	previous_opened = 1;
	if (DEBUG) printf("Opened: %s, %s as player %d, output %s, ",
			  players[num_players]->model,
			  players[num_players]->devname,num_players,
			  vdt.dev[i].channel);
	if (DEBUG) printf("switch %d, channel %d\n",
			  rpd_out[num_players].switcher,
			  rpd_out[num_players].channel);
	intable = -1;
	for ( j = 0; j < cur_volume; j++) {
	  if (!strcmp(volumes[j].volume,vdt.dev[i].name) &&
	      volumes[j].output == vdt.dev[i].output) intable = j;
	}
	if (intable == -1) {
	  strcpy(volumes[cur_volume].volume,vdt.dev[i].name);
	  volumes[cur_volume].type = RPD_DEV;
	  volumes[cur_volume].num_resources = 1;
	  volumes[cur_volume].cur_resource = 0;
	  volumes[cur_volume].output = vdt.dev[i].output;
	  volumes[cur_volume].resource[0] = num_players;
	  cur_volume++;
	}
	else {/* what to do about duplicates */
	  volumes[intable].resource[volumes[intable].num_resources++] = num_players;
	}
	num_players++;
      }
      else if (vdt.dev[i-1].type == INPUT_DEV) {
	if (DEBUG) printf("DUPping previous INPUT_DEV\n");
	      if (DEBUG) printf("Available: %s, output %s, ",vdt.dev[i-1].name,
			vdt.dev[i].channel);
  	sscanf(vdt.dev[i].channel,"%d-%d",&input_out[num_inputs].switcher,
	       &input_out[num_inputs].channel);
	if (DEBUG) printf("switch %d, channel %d\n",
			  input_out[num_inputs].switcher,
			  input_out[num_inputs].channel);
	intable = -1;
	previous_opened = 1;
	for ( j = 0; j < cur_volume; j++){
	  if (!strcmp(volumes[j].volume,vdt.dev[i-1].name) &&
	      volumes[j].output == vdt.dev[i].output) intable = j;
	}
	if (intable == -1) {
	  strcpy(volumes[cur_volume].volume,vdt.dev[i-1].name);
	  volumes[cur_volume].type = INPUT_DEV;
	  volumes[cur_volume].num_resources = 1;
	  volumes[cur_volume].cur_resource = 0;
	  volumes[cur_volume].output = vdt.dev[i].output;
	  volumes[cur_volume].resource[0] = num_inputs;
	cur_volume++;
	}
	else {/* what to do about duplicates */
	  volumes[intable].resource[volumes[intable].num_resources++] = 
	    num_inputs;
	}
	num_inputs++;
      }

    }
  }
  num_tvolumes = 0;
  for ( i = 0; i < num_volumes; i++) {
    if (volumes[i].num_resources != 0) num_tvolumes++;
  }
  tvolumes = (DeviceList *)malloc(sizeof(DeviceList)*num_tvolumes);

  for (i = 0; i < num_volumes; i++) {
    if (volumes[i].num_resources != 0) {
      if (DEBUG) printf("volume %d is %s, %d resources, output %d\n", 
			cur_tvolume, 
			volumes[i].volume,
			volumes[i].num_resources,
			volumes[i].output);
      tvolumes[cur_tvolume++] = volumes[i];
    }
  }
  free(volumes);
  volumes = tvolumes;
  num_volumes = num_tvolumes;
  revision++;

  if (num_volumes > 0) {  /* switch to the first volume in the table
			     so that we can have some kind of default
			     and Bob can watch TV */
    if (volumes[0].type == RPD_DEV) {
      cur_output = rpd_out[volumes[0].resource[volumes[0].cur_resource]];
    }
    if (volumes[0].type == INPUT_DEV) {
      cur_output = input_out[volumes[0].resource[volumes[0].cur_resource]];
    }
    doswitchtree(cur_output,ALL_CHAN);
    unlock_all();
  }
  
}
