#ifndef SYSINCLUDES
#define SYSINCLUDES

#include<stdio.h>
#include<sys/types.h>
#include<sys/socket.h>
#include<sys/time.h>
#include<sys/ioctl.h>
#include<sys/file.h>
#include<netinet/in.h>
#ifndef SYSV
#include<strings.h>
#include<netinet/tcp.h>
#include<sys/un.h>
#else
#include<string.h>
#endif

#include<netdb.h>
#include<ctype.h>

#endif

#ifndef GLIB
#define GLIB

#define G_UNIX_PATH "/tmp/.G-unix/G"
#define G_UNIX_DIR "/tmp/.G-unix"

#define MAX_FDS 32

/* standard defined speeds */

#define R_MAX		-300		/* maximum possible velocity */
#define R_VERY_FAST	-150		/* really moving along */
#define R_FAST		-90		/* 3-5 times normal; still visible */
#define R_PLAY		-30		/* reverse normal */
#define R_SLOW		-10		/* 1/2 to 1/5 normal */
#define R_VERY_SLOW	-3		/* just barely moving */
#define STOP		0		/* transport halted */
#define F_VERY_SLOW     3		/* just barely moving */
#define F_SLOW		10		/* 1/2 to 1/5 normal */
#define F_PLAY		30		/* forward normal */
#define F_FAST		90		/* 3-5 times normal; still visible */
#define F_VERY_FAST	150		/* really moving along */
#define F_MAX		300		/* maximum possible velocity */

/* for jogs */

#define FORWARD         1
#define REVERSE         -1

/* standard defined cmds */
#define INDEX_ON		0
#define INDEX_OFF		1
#define A1_ON			2
#define A1_OFF			3
#define A2_ON			4
#define A2_OFF			5
#define LOAD			6
#define UNLOAD			7
#define EJECT                   8
#define INDEX_TOGGLE            9
#define FORKLOAD                10

/* for immediate versus sync'd return for GPlaySeg*/
#define RETURN_NOW              0
#define RETURN_SYNC             1

/* selects library sync style */
#define ASYNC_MODE              1
#define SYNC_MODE               0

#define Notify                  1
#define NoNotify                0

#define TURN_ON                 1
#define TURN_OFF                0

#define SPINDOWN                1
#define NOSPINDOWN              0

typedef struct {
  int parm[10];
} Galatea_packet;

typedef struct {
  int index;
  int type;
  char *volume;
} VolumeList;

typedef struct _script_event {
  int target_frame;  /* frame (from 0 since start of list) */
  int action;    /* ROLL, SWITCH or RELEASE */
  int arg;    /* source frame or VIDEO_CHAN | RIGHT_CHAN | LEFT_CHAN */
  int arg2;   /* secondary argument... speed?*/
  struct _script_event *next;    /* next list item */
} script_event;

typedef struct _action {
  script_event *events;
  int source_vol;
  char *volume_name;
  struct _action *next;
} action;

/* Old Server type! */

/*typedef int Server;*/   

/*    New Server structure ! */
typedef struct _server {
  int fd;
  char *server;
  int output;
  int num_volumes;
  VolumeList *volumes;
  int switching_mask;
  int num_extensions;
  char **extensions;
  int max_lock_time;
  int ex1;
  int ex2;
  int ex3;
  int ex4;
  int ex5;
  int ex6;
  int ex7;
  int ex8;
  } Server;

#define OpenServer 1
#define Switch 2
#define Run 3
#define Jog 4
#define Still 5
#define Index 6
#define Search 7
#define GetFrame 8
#define PlaySeg 9
#define Reset 10
#define Release 11
#define Lock 12
#define UnLock 13
#define Download 14
#define PlayList 15
#define RequestNotification 16
#define ShutOff 17
#define Load 18
#define CheckRevision 19
#define Configure 20
#define GetServerTime 21
#define MakeReservation 22
#define UseReservation 23

#define ROLL    0
#define SEARCH  1
#define SWITCH  2
#define RELEASE 3
#define END_OF_TRANSMISSION   -1000000

#ifndef VIDEO_CHAN
#define VIDEO_CHAN      1
#define LEFT_CHAN       2
#define RIGHT_CHAN      4
#define ALL_CHAN        7
#define AUDIO_CHAN      LEFT_CHAN | RIGHT_CHAN
#endif

#define INDEX_CTRL      8

/* Standard defined errors */
#define NO_ERROR              999999
#define LOWEST_ERROR         1000000  /* use this for < LOWEST_ERROR */
#define VOLUME_LIST_OLD      1000000  /* something has changed */
#define BAD_VOLUME            1000001  /* not a real volume */
#define FUNC_NOT_SUPPORTED    1000002  /* volume doesn't support func */
#define BAD_COMMAND           1000003  /* unknown command */
#define COULDNT_SEARCH        1000004  /* fault in RPD search */
#define COULDNT_STOP          1000005  /* couldn't stop RPD */
#define COULDNT_CHANGE_SPEED  1000006  /* couldn't change RPD speed */
#define COULDNT_DO_FUNC       1000007  /* fault while trying func */
#define BAD_ARGUMENT          1000008  /* an argument was faulty */
#define GIO_ERROR             1000010  /* a write to a server failed */
#define TIME_OVERLAP          1000011  /* reserve time overlaps another */
#define VOLUME_RESERVED       1000012  /* volume is currently reserved */
#define RESERVE_TOO_LONG      1000013  /* reservation too long */
#define SEGMENT_TOO_LONG      1000014  /*PlaySeg request would block too long*/
#define PERMISSION_DENIED     1000015  /* unpermitted command */

/* procedure prototype definitions to keep C compilers happy...*/
Server *GOpenServer(), *GReopenServer();

char *GWhichVolumeName(), *GVolumeName();
long GGetServerTime();
char *acceptstring();

int _handleerror();

#endif

#ifndef FD_SET
#define NFDBITS    (sizeof(fd_set) * 8)
#define	FD_SET(n, p)	((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
#define	FD_CLR(n, p)	((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
#define	FD_ISSET(n, p)	((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
#define FD_ZERO(p)	bzero((char *)(p), sizeof(*(p)))
#endif FD_SET


