@chapter(Features and Use of Galatea)

Galatea provides access to video devices in a distributed network
environment.  The system is designed in a classic client/server network
model.  A Galatea client, designed for a custom application, connects to
a Galatea server on either the local or a remote machine.  Once this
connection is established, the client has access to all of the resources
on the server.  These can include video disk players, uncontrolled input
sources and video/audio switchers.  The video/audio switchers are not
referenced directly, but instead controlled by the server when the
client requests access to video disks or uncontrolled inputs.  A signal
routing table is maintained by the server which describes how the signal
sources are connected to the switches and how the switches are connected
together to form a switching tree.

A single Galatea server can provide reliable access to many clients.
The server dispatches on the incoming requests from clients, and
guarantees each client a small time segment during which it has
exclusive access.  One client is not allowed to dominate the server, so
that many clients and users can access a centralized bank of video
resources without excessive delays.

To provide additional flexibility, a Galatea server can connect to
another server and utilize the resources maintained there.  Once this
connection is established the resources on the secondary server are
considered equivalent to local resources.  This provides to a simple
client application the ability to access video resources on multiple
machines without having to connect to several servers.  The servers
maintain the forwarding capability and have automatic systems for
dealing with system crashes and network failures.  Typically, a Galatea
server runs on all machines on which you wish to run a Galatea client,
even if the machine has no local resources.  The local server has the
responsibility of maintaining connections with the other remote servers.
With this technique, a client program does not have to worry about a
connection terminating if a remote machine crashes.  The remote crash
will be detected by the local server, which can then take appropriate
action.

A volume table is a list of video sources, each identified by a unique
name.  A video source does not necessarily correspond to a single video
disk player or uncontrolled input channel.  Multiple video disk players
which contain the same disk are combined into a single volume for client
reference.  Using this system, a client need only specify the name of
the source that it wishes to access, and the server will deliver the video
from the source most readily available.  With this abstraction, there is
no distinction made between resources on a local server and resources
which are accessed through a chain of servers.

A Galatea server is capable of serving multiple outputs, be they several
channels on a cable television system or several displays on a single
workstation.  The identification of these outputs is site specific.  In
other words, the numbers used as identification for each output can be
arbitrary, in order to directly match cable channels or display numbers.
Each volume available on a server is tagged with a output number on
which it is viewable.  When a client connects to a server, it claims the
ability to view one particular output.  The client is then passed a list
of volumes which are available on that output.  A device which can be
viewed on multiple outputs can be identified as having that capability
in the configuration file.
