@section(Error messages)

Almost all Galatea library commands can cause an error to be generated
on the server, if there is a fault in the function call or a device
failure.  The values returned are integers (32 bits).  The return value
of NO_ERROR is used to indicate simple completion of request which does
not have an otherwise important return value.  All of the actual error
return values values have a value greater than or equal to LOWEST_ERROR.
The actually error return codes are as follows:

@begin(description)
@b[VOLUME_LIST_OLD]@\The volume list that the client is using is not up
to date with the current version on the server.  GReopenServer() should
be called to get a new volume list.

@b[BAD_VOLUME]@\The volume index number specified in the command is not
a valid volume in the server.

@b[FUNC_NOT_SUPPORTED]@\An attempt was made to execute a function on a
volume which cannot support the operation.  An example of this is trying
to do a frame search on an uncontrolled input device.

@b[BAD_COMMAND]@\The server was not able to interpret the request as a
reasonable command.  This is probably due to a mismatched library/server
combination.

@b[COULDNT_SEARCH]@\A device error was encountered while attempting to
search on a record/play device.  A retry may succeed.

@b[COULDNT_STOP]@\A device error was encountered while attempting to
stop a record/play device.  A retry may succeed.

@b[COULDNT_CHANGE_SPEED]@\A device error was encountered while
attempting to change the speed or direction of a record/play device.  A
retry may succeed.

@b[COULDNT_DO_FUNC]@\A device error or internal server error was
encountered while attemping an operation on any type of device.  A retry
may succeed.

@b[BAD_ARGUMENT]@\An argument to a command was not valid.

@b[GIO_ERROR]@\A server has been broken.  This is a rare error, as it
means the server to which to client is connected has broken connection.
Normally forwarding GIO_ERROR's are detected and translated into normal
device errors.  If a client receives this error, it should not attempt
to access the Galatea server again.

@b[TIME_OVERLAP]@\The requested reservation overlaps an already
requested reservation.  This error is part of the SIGGRAPH reservation system.

@b[VOLUME_RESERVED]@\The volume requested is currently being held by a
reservation and is therefore unusable.  This error is part of the
SIGGRAPH reservation system.

@b[RESERVE_TOO_LONG]@\The requested reservation exceeds the maximum
reservation time allowed by the server. This error is part of the
SIGGRAPH reservation system.

@b[SEGMENT_TOO_LONG]@\A segment requested in a GPlaySeg() exceeded the
maximum lock time on the server.  An attempt for the same segment in
RETUNR_NOW mode will probably succeed, but the segment may be interrupted.

@b[PERMISSION_DENIED]@\An attempt to access a device or operation for
which the user has insuffucient privleges was made.  This includes
attempting to load or unload volumes between separate hosts.
@end(description)
