@section(Various server functions)

There are several server requests which do not specify or access
particular resources on the server.  These are locking the server,
obtaining the current server time, and checking if the client's volume
list is up to date, and obtaining a new volume list.

@blankspace(2 lines)
@begin(example)
@flushleft[int GLock(@b[server])]
Server *server;
@end(example)
@begin(description)
@b(server)@\The server connection as returned by GOpenServer().
@end(description)

GLock() established a temporary lock on all the resources of the server.
This allows a client to be guaranteed of exclusive access to all
resources on the server without other client interfering.  These locks
are typically limited by servers so that other clients are not
permanently locked out of a server.  Any other client that attempts to
access the server during a locked period is simply blocked.  If the
locking client does not unlock the server before the time limit is
reached, the lock is silently broken by the server.  The maximum lock
time is available with the GMaxLockTIme() call.  Using locks is
encouraged for clients which need to ensure that a volume of interest is
completely set up for them for a short period of a time.  Say, to
GConfigure(), then GSearch(), then perform a still frame grab with an
external processor, then unlock.  GLock() is the only method to
guarantee that no other client will intrude between the GConfigure() and
the GSearch().  Also, if the frame grabbing board takes more time to
grab than the standard release time, this mechanism provides for a
slightly longer leeway after the GSearch().

(caution: locks that must be forwarded between servers may provide less
than the normal maximum lock time.)

@blankspace(2 lines)
@begin(example)
@flushleft[int GUnlock(@b[server])]
Server *server;
@end(example)
@begin(description)
@b(server)@\The server connection as returned by GOpenServer().
@end(description)

GUnlock() unlocks a server which has been locked by GLock().  Clients
are encouraged to unlock a server as soon as possible, in order to allow
other clients access to server resources.

@blankspace(2 lines)
@begin(example)
@flushleft[long GGetServerTime(@b[server])]
Server *server;
@end(example)
@begin(description)
@b(server)@\The server connection as returned by GOpenServer().
@end(description)

GGetServerTime() returns the current time on the server machine in
seconds since midnight, January 1, 1970.  This information is useful in
realizing scheduling systems such as the SIGGRAPH extension, designed to
reserve volumes on a server in advance.

@blankspace(2 lines)
@begin(example)
@flushleft[int GCheckRevision(@b[server])]
Server *server;
@end(example)
@begin(description)
@b(server)@\The server connection as returned by GOpenServer().
@end(description)

GCheckRevision() allows a client to manually check if its volume list
(contained in the server structure) is up to date.  Normally, an out of
date volume list is indicated by the error message, VOLUME_LIST_OLD,
returned by the server, on most other commands.  GCheckRevision() should
only return NO_ERROR, VOLUME_LIST_OLD, or GIO_ERROR. NO_ERROR means that
the client has an up to date volume list.  VOLUME_LIST_OLD means that
the client should get a new volume list with GReopenServer().  GIO_ERROR
is encountered when a connection to a server dies.  Unless a client is
handling SIGPIPE's however, the SIG_PIPE will probably arrive first, and
the client will exit.

@blankspace(2 lines)
@begin(example)
@flushleft[Server *GReopenServer(@b[server])]
Server *server;
@end(example)
@begin(description)
@b(server)@\The server connection as returned by GOpenServer().
@end(description)

GReopenServer() is used by a client to obtain a new volume list, if the
server indicates that the client has an out of date volume list.  This
situation can occur if a secondary server crashed, or comes on-line, and
the primary server rebuilds its internal volume tables to match the new
availibilty of resources.  A server can also be forced to rebuild its
volumes tables by sending it a SIGHUP.  GReopenServer returns a pointer
to a new server structure, or NULL, if there was some failure.

@section(Routines which change the action of the Galatea library)

The Galatea library (Glib) can be set to act in several different modes.
There are debug settings, timeouts, and asynchronous operation modes, as
well as an error handling system.

@blankspace(2 lines)
@begin(example)
@flushleft[int GSetState(@b[debug_mode], @b[set_time], @b[set_sync])]
int debug_mode;
struct timeval *settime;
int set_sync;
@end(example)
@begin(description)
@b(debug_mode)@\Specifies the new debug mode for library operation.

@b(set_time)@\Specifies the new time out length on reads from the server.

@b(set_sync)@\Specifies whether the library should act synchronously or
asynchronously.  
@end(description)

GSetState() sets several modes of library operation.  Debugging allows
the library to print out some information as routines are called.  This
is mainly used in debugging the library, so the information printed may
not be very consistent or useful.  A value of one enables debugging and
a value disables debugging.  

The maximum time that the library will wait for a reply from the server
can be set with the @b[set_time] argument.  If NULL, the time out is
infinite.  Infinite is the default library time out.  If @b[set_time] is
non-NULL, the time contained in the timeval structure is copied and used
for the new time out.

The library can also be set to use asynchonous or synchronous operation.
Normally, all commands send a request to the server and then wait for a
reply from the server indicating the request has been completed or that
an error occured.  This is called synchronous operation, since the
client is kept synchronized to the server by the wait.  For some
applications, say a video shuttle control, acknowledgment of successful
completetion is not necessary, since many commands are being sent, and
single failures are not a problem.  In the shuttle application, it is
also unnecessary to wait for synchronization, and that wait can cause
poor performance.  For such applications, setting the @b[set_sync]
argument to ASYNC_MODE will provide better performance.  In this mode,
many commands will report that no error occurred.  For some commands,
such as GReopenServer(), asynchronous mode is meaningless.  Some other
commands also act synchronously, even in ASYNC_MODE, such as GLock() and
GCheckRevision().  The other change in ASYNC_MODE is that the server
will not wait for a GRelease() from a client.  A @b[set_sync] of
SYNC_MODE returns the library to synchronized operation.

@blankspace(2 lines)
@begin(example)
@flushleft[int GSetErrorHandler(@b[handler])]
int (*handler)(Server *, int);
@end(example)
@begin(description)
@b(handler)@\A handler procedure to be called when errors are reported
by a server.
@end(description)

Many Galatea commands can be met with an error response from the server.
These errors are normally reported back to the client through the return
value for the command.  It is possible to intercept these error
messages, and cause the library to invoke a client specified error
handler.  A very useful error handler is one that can deal with a
VOLUME_LIST_OLD error, execute a GReopenServer() and then update client
structures or displays before returning.  Such a system reduces code
duplication.  The command that caused the server still returns the error
code, but the main sections of the client application need not handle
the error explicitly.  A NULL for the @b[handler] procedure, causes the
library to resume default action, which is to simply return the error
value to the calling client.

The arguments to the error handler are the server on which the error was
generated and the error code returned by the server.  The return value
from the handler is not used.
