@section(Controlling the switches)

Once a server is opened and the client has determined which volumes are
of interest, it is useful to set the server to display a particular
volume of interest.  The explicit switching command, GSwitch(), is used
for this function:
@blankspace(2 lines)
@begin(example)
@flushleft[int GSwitch(@b[server], @b[ind], @b[mask])]
Server *server;
int ind;
int mask;
@end(example)
@begin(description)
@b(server)@\The server connection as returned by GOpenServer().

@b(ind)@\The index number of the volume to which the switch should be made.

@b(mask)@\Bitwise or of one or more of LEFT_CHAN, RIGHT_CHAN,
and VIDEO_CHAN, indicating which channel should be switched.
@end(description)

GSwitch() commands the server to arrange for the volume indicated to
become the current source for one or more of the signal channels.
Servers can typically switch left audio, right audio, and video
independantly, although the independance of the two audio channels is
not guaranteed.  AUDIO_CHAN can be used to indicate the bitwise or of
LEFT_CHAN and RIGHT_CHAN, and ALL_CHAN can be used to indicate the
bitwise or of LEFT_CHAN, RIGHT_CHAN and VIDEO_CHAN.  Note that switching
does not explicitly determine a particular switcher to affect, as the
server may have to traverse a tree of switchers to accomplish the
desired result.  Only the desired volume is necessary.

Many other commands can perform an implied switch for better
performance.  A switching mask is one of the parameters for those
commands, for which a non-zero value indicates that switching should be
performed.  Using implied switching can increase speed of operation and
reliable delivery.  The only way to switch to an uncontrolled input
source is GSwitch(), as none of the commands which implement an implied
switch can operate on an uncontrolled input.

@section(Manipulating uncontrolled input sources)

As the name implies, there are no operations to be performed on an
uncontrolled input source.  The only command which can take the index
number of an uncontrolled input source is the GSwitch() command,
explained above.

@section(Manipulating record/play devices)

(Currently, there are no record capabilities in Galatea.)

There are several methods of controlling a record/play device, ranging
from variable speed play, to single frame search.  Several of these
commands have a switching mask as an argument.  When this mask is
non-zero, it indicates to the server that after the requested operation
is performed, a equivalent action to GSwitch() should be undertaken by
the server.  Therefore the end result of:
@begin(example)
@flushleft[GSearch(server, ind, 20000, ALL_CHAN)]
is the same as the result of:
@flushleft[GSearch(server, ind, 20000, 0)]
@flushleft[GSwitch(server, ind, ALL_CHAN)]
@end(example)

The former will typically be a smoother and faster operation.  Also,
there is no chance that another client can access the server and disturb
the arrangements in the first case, as can happen in the second.  Only
the results of a single command are guaranteed to be handled with
another client interfering.  The GRelease() command is used to indicate
to the server that client is finished with a particular request.  When a
request is made to a server, the server usually maintains the results of
that request until the client calls GRelease(), or the server times out
on the release.  The client can indicate (with GSetState()) that an
asynchronous mode should be used, in which the server does not maintain
results.  If the client issues another command, instead of a GRelease(),
that command is interpreted as a GRelease() and the server then handles
any incoming requests, not necessarily the command that acted as a
GRelease().  This algorithm ensures that a single client cannot dominate
a server by simply sending a stream of commands without GReleases().
Additionally, servers typically time out on releases in five seconds in
order to allow other requests to be processed.

@blankspace(2 lines)
@begin(example)
@flushleft[int GRelease(@b[server])]
Server *server;
@end(example)
@begin(description)
@b(server)@\The server connection as returned by GOpenServer().
@end(description)

GRelease() releases the server from maintaining the results of the
previous command.  If the server is not maintaining previous results,
this command does nothing.

@blankspace(2 lines)
@begin(example)
@flushleft[int GSearch(@b[server], @b[ind], @b[frame_num], @b[mask])]
Server *server;
int ind;
int frame_num;
int mask;
@end(example)
@begin(description)
@b(server)@\The server connection as returned by GOpenServer().

@b(ind)@\The index number of the volume on which you wish to search.

@b(frame_num)@\The absolute frame number to which the volume should be
searched.

@b(mask)@\A switching mask used for an implied switch.
@end(description)

GSearch() requests the server to search on the requested volume to the
specified frame number.  At the end of this operation, GSearch() returns
the frame number which the volume is currently displaying.  This command
may not simply cause a search on a single video disk player.  If
multiple copies of a volume are available, the server will use the copy
which will provide the fastest response time.  This action is invisible
to the client.  After the search is complete, a implied switch is
performed, if @b(mask) is non-zero.

@blankspace(2 lines)
@begin(example)
@flushleft[int GRun(@b[server], @b[ind], @b[speed], @b[mask])]
Server *server;
int ind;
int speed;
int mask;
@end(example)
@begin(description)
@b(server)@\The server connection as returned by GOpenServer().

@b(ind)@\The index number of the volume you wish to play.

@b(speed)@\The speed, in frames per second, at which the volume should
be played.

@b(mask)@\A switching mask used for an implied switch.
@end(description)

GRun() sets the requested volume in motion at the speed indicated.  The
speed is specified in frames per second, and the server will attempt as
well as possible to match the requested speed.   Not all players can
play at an arbitrary frame rate.  A closest match is attempted.  The
actual speed of playback is reported back to the client as the return
value.  The speed can be positive or negative.  The switching mask is
handled as for GSearch().  The play continues until one of the ends of
the disk is reached, or another motion command is executed.

@blankspace(2 lines)
@begin(example)
@flushleft[int GJog(@b[server], @b[ind], @b[direction], @b[mask])]
Server *server;
int ind;
int direction;
int mask;
@end(example)
@begin(description)
@b(server)@\The server connection as returned by GOpenServer().

@b(ind)@\The index number of the volume you wish to jog.

@b(direction)@\The direction in which the volume should be jogged.

@b(mask)@\A switching mask used for an implied switch.
@end(description)

A video jog is a single frame motion.  This provides an easy way to step
around a small portion of a video disk.  The directions possible are
FORWARD and REVERSE, only one of which may be specified.  The new
current position on the disk is returned.

@blankspace(2 lines)
@begin(example)
@flushleft[int GStill(@b[server], @b[ind], @b[mask])]
Server *server;
int ind;
int mask;
@end(example)
@begin(description)
@b(server)@\The server connection as returned by GOpenServer().

@b(ind)@\The index number of the volume you wish to stop.

@b(mask)@\A switching mask used for an implied switch.
@end(description)

To stop a running volume, use GStill().  The requested volume will be
stopped and the current frame number of the volume will be returned to
the client.

@blankspace(2 lines)
@begin(example)
@flushleft[int GPlaySeg(@b[server], @b[ind], @b[start], @b[end],
@b[speed], @b[mask], @b[return_flag])]
Server *server;
int ind;
int start;
int end;
int speed;
int mask;
int return_flag;
@end(example)
@begin(description)
@b(server)@\The server connection as returned by GOpenServer().

@b(ind)@\The index number of the volume you wish to play.

@b(start)@\The starting frame number from which the segment will be played.

@b(end)@\The ending frame number to which the segment will be played.

@b(speed)@\The speed at which the segment will be played.

@b(mask)@\A switching mask used for an implied switch.

@b(return_flag)@\Value indicating whether the server should block until
the end of the segment.
@end(description)

GPlaySeg() arranges to play a fully specified segment of video from a
volume.  The volume is first searched to the start frame, and playback
is then assumed at the specified speed.  Playback is stopped at the end
frame.  The implied switched in a GPlaySeg() is performed after the
initial search and before the playback begins.  Illegal combinations of
frame numbers and speeds have unpredictable results.  The
@b(return_flag) indicates to the server whether to block until the
segment is complete.  A client may wish to block until a segment is
complete, or it may wish to simply start the segment and let it
progress, while returning the client to a running state.  RETURN_NOW is
the flag for starting the segment and then immediately returning control
back to the client.  RETURN_SYNC indicates to the server that the server
should block until the segment is finished.  Some servers may place a
limit on the length of a segment requested with RETURN_SYNC, as such a
segment might interfere with the operation of other clients.  GPlaySeg()
returns the frame number at which the server returned control to the
client.  This may be early in the segment for a RETURN_NOW, and should
be the @b(end) frame for a RETURN_SYNC.

@blankspace(2 lines) Other operations possible on a record/play device
are changing the spinning, or load, state of the volume, changing the
visibility of player frame index numbers, and changing the audibility of
the two audio channels.

@blankspace(2 lines)
@begin(example)
@flushleft[int GLoad(@b[server], @b[ind], @b[on_off])]
Server *server;
int ind;
int on_off;
@end(example)
@begin(description)
@b(server)@\The server connection as returned by GOpenServer().

@b(ind)@\The index number of the volume you wish to load.

@b(on_off)@\The new load state requested.
@end(description)

GLoad() allows the client to manually load or unload disks during
runtime.  This allows the user the change disks dynamically for some
applications.  An @b[on_off] value of LOAD requests that the volume
should be spun up, or loaded.  A valed of UNLOAD requests that the
volume should be spun down, or unloaded.  Configuration with local
disk players that may require the user to change disks should spin down
the volume first, indicate that a disk should be changed, then spin up
the players.  When a Galatea server is properly configured, changing the
disks in a player where multiple copies of a disk exist may cause odd
results, as the server assumes that all of the players contain the named
disk.  There is currently no method to change the names of disks in
players from the client.

@blankspace(2 lines)
@begin(example)
@flushleft[int GConfigure(@b[server], @b[ind], @b[chan], @b[on_off])]
Server *server;
int ind;
int chan;
int on_off;
@end(example)
@begin(description)
@b(server)@\The server connection as returned by GOpenServer().

@b(ind)@\The index number of the volume whose configuration you wish to
change.

@b(chan)@\Specifies the channel or channels whose configuration should
be changed.

@b(on_off)@\The new configuration state requested.
@end(description)

When the client needs to change the audibility of the audio channels, or
change the state of the frame index numbers, a call to GConfigure()
should be made for a specific volume.  The @b[chan] parameter indicates
whether the left audio channel, the right audio channel, or the index
numbers should be changed by the bitwise of of LEFT_CHAN, RIGHT_CHAN and
INDEX_CTRL.  Any combination of these may be specified.  The @b[on_off]
parameter indicates the desired state of the specified channel.  Values
of TURN_ON and TURN_OFF can be specified.

@blankspace(2 lines)
@begin(example)
@flushleft[int GGetFrame(@b[server], @b[ind])]
Server *server;
int ind;
@end(example)
@begin(description)
@b(server)@\The server connection as returned by GOpenServer().

@b(ind)@\The index number of the volume whose current position you wish
to obtain.
@end(description)

GGetFrame() provides for the client to obtain the current position of a
volume.  If the user has searched maunally using GRun() commands for a
particular frame, and now wishes to record the frame number, GGetFrame()
can be used by the application to acquire that information.  The current
frame number is returned.
