@chapter(Glib - C Language Interface for Galatea)

@section(Opening a Galatea server)

The first operation a Galatea client needs to perform before making use
of video resources on a server is establishing a connection to the
server.  The action is accomplished with GOpenServer():

@begin(example)
@flushleft[Server *GOpenServer(@b[host], @b[outputnum])]
char *host;
int outputnum;
@end(example)
@begin(description)
@b(host)@\Specifies the name of the system which is running the Galatea
server to which you wish to connect.  If @b(host) is NULL or "unix"
Galatea will attempt to connect to a local server.

@b(outputnum)@\Specifies the number of the output of the server which you
wish to use.  A server which is used by several several workstations or
several displays on the same workstation may define independent outputs
for each unit.  It is the client's responsibility to claim connectivity
with a particular output, since no server-side tables are maintained
with such information.
@end(description)

If a connection to the server cannot be established, a NULL is returned.
Otherwise a legitimate connection has been established, and the returned
structure should be used in future Glib calls.

@section(Obtaining information about the server)

@blankspace(2 lines)
@begin(example)
@flushleft[int GNumberExtensions(@b[server])]
Server *server;
@end(example)
@begin(description)
@b(server)@\The server connection as returned by GOpenServer().
@end(description)

Returns the number of extensions that the server has available.  Once
this call is made, it is possible to interate down the list of extension
names with the following command.

@blankspace(2 lines)
@begin(example)
@flushleft[char *GExtensionName(@b[server], @b[which])]
Server *server;
int which;
@end(example)
@begin(description)
@b(server)@\The server connection as returned by GOpenServer().

@b(which)@\Specifies the position of an extension in the extension list.
@end(description)

Returns a pointer to a private area which contains the extension name of
the extension at position @b(which) in the extension list.

Several subroutines are provided for obtaining information about the
contents of the Server structure.  Clients applications should use these
routines for referencing the structure, and never attempt to modify it
or inspect it directly.

@blankspace(2 lines)
@begin(example)
@flushleft[int GNumberVolumes(@b[server])]
Server *server;
@end(example)
@begin(description)
@b(server)@\The server connection as returned by GOpenServer().
@end(description)

Returns the number of volumes available on the server.  The volume list
is comprised of entries numbered from zero to the number of volumes
minus one.  After inquiring into how many volumes a server has, it is
possible to interate down the volume list with the following three
functions.

@blankspace(2 lines)
@begin(example)
@flushleft[char *GVolumeName(@b[server], @b[which])]
Server *server;
int which;
@end(example)
@begin(description)
@b(server)@\The server conenction as returned by GOpenServer().

@b(which)@\Specifies the position of a volume in the volume list.
@end(description)

Returns a pointer to a private area which contains the volume name of
the volume at position @b(which) in the volume list.

@blankspace(2 lines)
@begin(example)
@flushleft[int GVolumeIndex(@b[server], @b[which])]
Server *server;
int which;
@end(example)
@begin(description)
@b(server)@\The server connection as returned by GOpenServer().

@b(which)@\Specifies the position of a volume in the volume list.
@end(description)

Returns the index number of the volume at position @b(which) in the
volume list.

@blankspace(2 lines)
@begin(example)
@flushleft[int GVolumeType(@b[server], @b[which])]
Server *server;
int which;
@end(example)
@begin(description)
@b(server)@\The server connection as returned by GOpenServer().

@b(which)@\Specifies the position of a volume in the volume list.
@end(description)

Returns the volume type of the volume at position @b(which) in the
volume list.  The volume type can be one of RPD_DEV or INPUT_DEV,
specifying a "Record/Play Device" or uncontrolled "Input Device,"
respectively.

@blankspace(2 lines)
@begin(example)
@flushleft[int GWhichVolumeIndex(@b[server], @b[volume_name])]
Server *server;
char *volume_name;
@end(example)
@begin(description)
@b(server)@\The server connection as returned by GOpenServer().

@b(volume_name)@\String containing the name of the volume whose index
number you wish to obtain.
@end(description)

Returns the index number of the specified volume on the given server.
This command allows a client which knows exactly which volume it needs
to find the volume index number easily.  The index number of a volume is
used in all server action requests.

@blankspace(2 lines)
@begin(example)
@flushleft[char *GWhichVolumeName(@b[server], @b[ind])]
Server *server;
int ind;
@end(example)
@begin(description)
@b(server)@\The server connection as returned by GOpenServer().

@b(ind)@\The index number of the volume whose name you wish to obtain.
@end(description)

Returns the name of the volume whose index is @b(ind).  This is the
reverse function of GWhichVolumeIndex().

@blankspace(2 lines)
@begin(example)
@flushleft[int GMaxLockTime(@b[server])]
Server *server;
@end(example)
@begin(description)
@b(server)@\The server connection as returned by GOpenServer().
@end(description)

Returns the maximum time, in seconds, for which a client can acquire
exclusive access to a server, either by a GLock() or by a GPlaySeg() in
RETURN_SYNC mode.  A lock which exceeds this time is silently broken by
the server and the server will refuse to play a segment by GPlaySeg()
which would exceed this time limit.  A time limit of zero means that
there is no limit on the length of a lock or segment.

@blankspace(2 lines)
@begin(example)
@flushleft[int GConnection(@b[server])]
Server *server;
@end(example)
@begin(description)
@b(server)@\The server connection as returned by GOpenServer().
@end(description)

Returns the connection number for the server.  In UNIX, this is the file
descriptor of the connection.

@section(Closing the server connection)

Once the client is finished accessing the resources of a server, it may
close the server connection with GCloseServer().

@blankspace(2 lines)
@begin(example)
@flushleft[GCloseServer(@b[server])]
Server *server;
@end(example)
@begin(description)
@b(server)@\The server connection as returned by GOpenServer().
@end(description)

GCloseServer() closes the connection to the server and frees all the
data in the server structure.  
