#include"xpointer.h"
#include<stdio.h>

setmap()
{
  extern Display *dpy;
  extern int screen;
  extern short DEBUG;
  extern Colormap cmap;
  extern Visual *visual;
  extern XColor background, foreground, nonhighlight, 
  highlight, mousecolor, border, green, red, orange, black;

  long pixels[256], planes;
  int status, nplanes;

  visual = DefaultVisual(dpy, screen);
  if (visual->class != PseudoColor && DEBUG) {
    printf("Screen doesn't have PseudoColor as default...continuing.\n");
    fflush(stdout);
    visual->class = PseudoColor;
  }

  cmap = DefaultColormap(dpy, screen);

  if (DEBUG) printf("Created colormap.\n");
  fflush(stdout);

  status = XAllocColorCells( dpy, cmap, &planes, &nplanes, 0, pixels, 10);

  background.pixel = pixels[0];
  background.red = background.blue = background.green = 30000;
  background.flags = DoRed | DoGreen | DoBlue;
  
  foreground.pixel = pixels[1];
  foreground.red = foreground.blue = foreground.green = 40000;
  foreground.flags = DoRed | DoGreen | DoBlue;

  nonhighlight.pixel = pixels[2];
  nonhighlight.red = nonhighlight.blue = nonhighlight.green = 20000;
  nonhighlight.flags = DoRed | DoGreen | DoBlue;

  mousecolor.pixel = pixels[3];
  mousecolor.red = mousecolor.blue = mousecolor.green = 55535;
  mousecolor.flags = DoRed | DoGreen | DoBlue;

  border.pixel = pixels[4];
  border.red = border.blue = border.green = 65535;
  border.flags = DoRed | DoGreen | DoBlue;

  highlight.pixel = pixels[5];
  highlight.red = highlight.blue = highlight.green = 65535;
  highlight.flags = DoRed | DoGreen | DoBlue;

  green.pixel = pixels[6];
  green.red = green.blue = 00000;
  green.green = 65535;
  green.flags = DoRed | DoGreen | DoBlue;

  red.pixel = pixels[7];
  red.red = 65535;
  red.blue = red.green = 0;
  red.flags = DoRed | DoGreen | DoBlue;

  orange.pixel = pixels[8];
  orange.red = 234*256;
  orange.blue = 80*256;
  orange.green = 207*256;
  orange.flags = DoRed | DoGreen | DoBlue;

  black.pixel = pixels[9];
  black.red = black.green = black.blue = 0;
  black.flags = DoRed | DoGreen | DoBlue;

  XStoreColor( dpy, cmap, &background);
  XStoreColor( dpy, cmap, &foreground);
  XStoreColor( dpy, cmap, &nonhighlight);
  XStoreColor( dpy, cmap, &mousecolor);
  XStoreColor( dpy, cmap, &border);
  XStoreColor( dpy, cmap, &highlight);
  XStoreColor( dpy, cmap, &red);
  XStoreColor( dpy, cmap, &green);
  XStoreColor( dpy, cmap, &orange);
  XStoreColor( dpy, cmap, &black);
}

