#include"xpointer.h"
#include<stdio.h>
#include"../../Glib/Glib.h"

Display *dpy;
Window root, *volume_windows, left_enable, right_enable, video_enable, toggle_video, icon, shuttlebar, rjog, stop, fjog, play, index_win, search, frame_win, exit_win, load_win, unload_win, audio_one, audio_two;
  
#ifdef PLX
Window livevideo;
int plx = 1;
#endif

Colormap cmap;
Cursor lightcursor;
GC gc, normtext, move_gc, brighttext, green_gc, red_gc, orange_gc, black_gc;
int screen, realheight, max_volumes = 0;
Visual *visual;
XColor background, foreground, nonhighlight, highlight, mousecolor, border,
  green, red, orange, black;
XContext button_context, expose_context, null_context, which_context, 
  enter_context, leave_context, string_context, key_context;
XFontStruct *normfont;

Server *serv;
int cur_volume = 0, l_cur_volume = 0, v_cur_volume = 0, r_cur_volume = 0;
int cur_mask = ALL_CHAN, cur_speed = 0, frame = 0;
char frameinput[1000];

short DEBUG = 0;
short ISVIDEO = 0;

int *the_which_tree;

main(argc, argv)
     int argc;
     char **argv;
{
  XEvent event;
  XContext context;
  int (*proc)(), i, outputnum, maj, fev, fer;
  char temp[70], *display_string, *getenv();
  long cur_time;
  extern int error_handler();
  display_string = getenv("DISPLAY");

  if (!display_string) {
    printf("Must set a DISPLAY variable.\n");
    exit(1);
  }

  for (i = 1 ; i < argc ; i++){
    if (strcmp(argv[i],"debug") == 0) DEBUG = 1;
    if (strcmp(argv[i],"-display") == 0) display_string = argv[++i];
#ifdef PLX
    if (strcmp(argv[i],"-noplx") == 0) plx = 0;
#endif PLX
  }

  if (!(dpy = XOpenDisplay(display_string))) {
    printf("Could not open X server on %s\n",display_string);
    exit(1);
  }
  screen = DefaultScreen(dpy);
#ifdef PLX
  if (!XQueryExtension( dpy, "ParallaxVideo", &maj, &fev, &fer)) plx = 0;
#endif PLX
  if (DEBUG) {
    printf("X Server is owned by %s and is revision %d.\n",
	   ServerVendor(dpy),VendorRelease(dpy));
    printf("X Server is version %d, protocol revision %d.\n",
	   ProtocolVersion(dpy),ProtocolRevision(dpy));
    printf("There are %d colormaps available.\n",
	   MaxCmapsOfScreen( &(dpy->screens[screen] )));
    fflush(stdout);
  }

  the_which_tree = (int *)malloc(256 * sizeof(int));
  for (i = 0; i < 256; i++)
    the_which_tree[i] = i;

  outputnum= atoi(index(DisplayString(dpy),':') + 1);
  if (DEBUG) printf("Output %d\n",outputnum);

  GSetState((int)DEBUG,NULL,SYNC_MODE);
  if (DEBUG) printf("sizeof(long) = %d\n", sizeof(long));
  serv = GOpenServer(getenv("SERVER"),outputnum);
  if (serv == NULL && getenv("SERVER")) {
    printf("Could not open Galatea server on %s\n",getenv("SERVER"));
    exit(2);
  }
  if (serv == NULL && !getenv("SERVER")) {
    gethostname(temp,64);   /* really should have a part of the server
			       structure have the failed hostname string */
    printf("Could not open Galatea server on %s\n", temp);
    exit(2);
  }
  if (DEBUG) {
    cur_time = GGetServerTime(serv);
    printf("Current Galatea server time is %s", ctime(&cur_time));
  }
  strcpy(frameinput,"1");
  GSetErrorHandler(error_handler);
  GSwitch(serv, GVolumeIndex(serv,0), ALL_CHAN);
  GRelease(serv);
  if (DEBUG) printf("Volumes available for video service:\n");
  for (i = 0; i < GNumberVolumes(serv); i++) {
    if (DEBUG) printf("%s\n",GVolumeName(serv,i));
  }

  setmap();
  create_cursor();
  setcontext();
  create_root();
  create_gcs();
  get_fonts();
  create_windows();

  while(1) {
    if (!XCheckMaskEvent( dpy, ButtonPressMask | KeyPressMask, &event))
      XMaskEvent( dpy, ButtonPressMask | ExposureMask | 
		 EnterWindowMask | LeaveWindowMask | KeyPressMask, 
		 &event);

    context = null_context;
    switch (event.type) {
    case ButtonPress:
      context = button_context;
      break;
    case EnterNotify:
      context = enter_context;
      break;
    case LeaveNotify:
      context = leave_context;
      break;
    case KeyPress:
      context = key_context;
      break;
    case Expose: /* let's just redraw once per blocks of exposures */
      if (!event.xexpose.count) context = expose_context; /* a la Hal */
      break;
    }
 
    if (context != null_context) 
      if (!XFindContext( dpy, event.xany.window, context, &proc)) 
	(*proc)(event);
    
  }
}



