#include"xpointer.h"
#include"../../Glib/Glib.h"

do_shuttle(event)
     XEvent event;
{
  extern int cur_volume, cur_speed;
  extern short DEBUG;
  extern Display *dpy;
  extern Server *serv;
  extern GC black_gc, normtext, brighttext;

  Window root_return, child_return, active_win;
  int root_x_return, root_y_return, win_x_return, win_y_return;
  unsigned int mask_return;

  active_win = event.xany.window;
  GSetState((int)DEBUG,0,ASYNC_MODE);
  while (event.type != ButtonRelease) {
    XQueryPointer( dpy, active_win, &root_return, &child_return,
		  &root_x_return, &root_y_return, &win_x_return, &win_y_return,
		  &mask_return);
    if (cur_speed != ((win_x_return+5)/10)*10-200) {
      XFillRectangle( dpy, active_win, black_gc,
		     cur_speed+200, 0, 5, 40);
      cur_speed = ((win_x_return+5)/10)*10-200;    
      GRun(serv, GVolumeIndex(serv,cur_volume), cur_speed, 0);
      if (DEBUG) printf("Speed is %d\n",cur_speed);
      XFillRectangle( dpy, active_win, brighttext,
		     cur_speed+200, 0, 5, 40);
    }
    XMaskEvent( dpy, ButtonReleaseMask | PointerMotionMask, &event);
  }
  XFillRectangle( dpy, active_win, black_gc,
		 cur_speed+200, 0, 5, 40);
  GRun(serv, GVolumeIndex(serv,cur_volume), 0, 0);
  cur_speed = 0;
  XFillRectangle( dpy, active_win, brighttext, 
		 cur_speed+200, 0, 5, 40);
  GSetState((int)DEBUG,0,SYNC_MODE);
}

do_control(event)
     XEvent event;
{
  extern int cur_volume, cur_mask;
  extern Server *serv;
  extern int frame;
  extern XContext which_context;
  extern char frameinput[];
  int *which;
  static index_state = TURN_OFF, audio_one_state = TURN_ON, 
  audio_two_state = TURN_ON;

  XFindContext( dpy, event.xany.window, which_context, &which);

  switch(*which) {
  case 0:
    GJog(serv, GVolumeIndex(serv,cur_volume), REVERSE, cur_mask);
    GRelease(serv);
    break;
  case 1:
    GRun(serv, GVolumeIndex(serv,cur_volume), 0, cur_mask);
    GRelease(serv);
    break;
  case 2:
    GJog(serv, GVolumeIndex(serv,cur_volume), FORWARD, cur_mask);
    GRelease(serv);
    break;
  case 3:
    GRun(serv, GVolumeIndex(serv,cur_volume), 30, cur_mask);
    GRelease(serv);
    break;
  case 4:
    if (index_state == TURN_ON) index_state = TURN_OFF;
    else index_state = TURN_ON;
    GConfigure(serv, GVolumeIndex(serv,cur_volume), INDEX_CTRL, index_state);
    GRelease(serv);
    break;
  case 5:
    frame = atoi(frameinput);
    GSearch(serv, GVolumeIndex(serv,cur_volume), frame, cur_mask);
    GRelease(serv);
    break;
  case 6:
    exit(0);
    break;
  case 7:
    GLoad(serv, GVolumeIndex(serv,cur_volume), LOAD);
    GRelease(serv);
    break;
  case 8:
    GLoad(serv, GVolumeIndex(serv,cur_volume), UNLOAD);
    GRelease(serv);
    break;
  case 9:
    if (audio_one_state == TURN_ON) audio_one_state = TURN_OFF;
    else audio_one_state = TURN_ON;
    GConfigure(serv, GVolumeIndex(serv,cur_volume),LEFT_CHAN, audio_one_state);
    GRelease(serv);
    break;
  case 10:
    if (audio_two_state == TURN_ON) audio_two_state = TURN_OFF;
    else audio_two_state = TURN_ON;
    GConfigure(serv, GVolumeIndex(serv,cur_volume),RIGHT_CHAN,audio_two_state);
    GRelease(serv);
    break;
  }
}
    







