/***************************************************************/
/*							       */
/*	       TANGO ANIMATION PACKAGE (window) 	       */
/*							       */
/***************************************************************/
/*    Copyright 1989 Brown University -- John T. Stasko        */

#include "tangolocal.h"
#include "tangowindow.h"

void	  topwindow_layout();
void	  leftwindow_layout();

int	  quit_fct();
int	  reset_fct();
int	  resize_fct();
int	  move_fct();
int	  pan_fct();
int	  zoom_fct();
void	  delayset();

void	  animate_begin();
void	  stabilize();


/***************************************************************/
/*							       */
/*  TANGO_layout_window - given a window to work with, create  */
/*	all the bells and whistles around it for scrolling,    */
/*	clearing, etc., then create an animation window in     */
/*	the middle.					       */
/*							       */
/***************************************************************/

void
TANGO_layout_window(window,Lx,By,Rx,Ty,mode,blting)
   ASH_WINDOW window;
   WIN_COORD Lx,By,Rx,Ty;
   int mode,blting;
{
   ASH_WINDOW	 easel,topwindow,leftwindow,rightwindow,quitwindow,resetwindow;
   int		 lx,by,rx,ty, height,width, leftx,rightx,topy,bottomy,
		 winx,winy, halfx, dummy;
   WIN_COORD	 xdiff,ydiff;

   ASHicon_define("left",16,16,leftbits);
   ASHicon_define("right",16,16,rightbits);
   ASHicon_define("up",16,16,upbits);
   ASHicon_define("down",16,16,downbits);
   ASHicon_define("in",16,16,inbits);
   ASHicon_define("out",16,16,outbits);

   xdiff = Rx-Lx;  /* user-specified real boundary coords */
   ydiff = By-Ty;

   ASHinq_size(window,ASH_SIZE_WINDOW,&lx,&by,&rx,&ty);

   STEMbtn_size(ASHloadfont("ASH_ICONS"),"down",&leftx,&dummy);
   rightx = 20;
   ASHinq_text_extent(ASHfont_id("helvetica",14,ASH_FONT_BOLD|ASH_FONT_ROMAN),"TANGO",&dummy,&topy);
   topy += 14;	/* padding */
   STEMbtn_size(ASHinq_font(window),"Reset",&dummy,&bottomy);

   leftx += 2;	/* seems to need more space */
   width = rx-lx-leftx-rightx;
   height = by-ty-topy-bottomy;

   if ( ((double)width/xdiff) >= ((double)height/ydiff) )
      { winy = height;
	winx = (int) ((double)height * xdiff / ydiff);
      }
   else
      { winx = width;
	winy = (int) ((double)width * ydiff / xdiff);
      }

   easel = ASHcreate(window,lx+leftx+1,ty+winy+topy+1,0,winy,winx,0,ASH_BORDER_THIN,ASH_WINDOW_NOCLEAR);

   topwindow = ASHcreate(window,0,ty+topy-1,0,topy-1,rx,0,ASH_BORDER_THIN,ASH_WINDOW_NOSAVE);
   topwindow_layout(topwindow,0,topy-1,rx,0);
   ASHset_refresh(topwindow,topwindow_layout);

   leftwindow = ASHcreate(window,lx,by-bottomy-1,0,by-ty-topy-bottomy-2,leftx-1,0,ASH_BORDER_THIN,ASH_WINDOW_NOSAVE);
   leftwindow_layout(leftwindow,0,by-ty-bottomy-topy-2,leftx-1,0);

   rightwindow = ASHcreate(window,rx-rightx+1,by-bottomy-1,0,by-ty-topy-bottomy-2,rightx-1,0,ASH_BORDER_THIN,ASH_WINDOW_NOSAVE);
   STEMscroll(rightwindow,delayset,0);
   STEMscroll_set(rightwindow,0,110,0,10);

   halfx = (rx-lx)/2;
   quitwindow = ASHcreate(window,0,by,0,bottomy-1,halfx-1,0,ASH_BORDER_THIN,ASH_WINDOW_NOSAVE);
   STEMmenu(quitwindow,quit_fct,0,RIP_BTN_ANY_UP,quit_btn);
   resetwindow = ASHcreate(window,halfx,by,0,bottomy-1,halfx-1,0,ASH_BORDER_THIN,ASH_WINDOW_NOSAVE);
   STEMmenu(resetwindow,reset_fct,0,RIP_BTN_ANY_UP,reset_btn);

   animate_begin(window,easel,rightwindow,Lx,By,Rx,Ty,mode,blting);
}




/***************************************************************/
/*							       */
/*  TANGO_layout_plainwindow - given a window to work with,    */
/*	create a plain animation window with no surrounding    */
/*	options.					       */
/*							       */
/***************************************************************/

void
TANGO_layout_plainwindow(window,Lx,By,Rx,Ty,mode,blting)
   ASH_WINDOW window;
   WIN_COORD Lx,By,Rx,Ty;
   int mode,blting;
{
   ASH_WINDOW	 easel,quitwindow,resetwindow;
   int		 lx,by,rx,ty, height,width, winx,winy, bottomy,dummy, halfx;
   WIN_COORD	 xdiff,ydiff;

   xdiff = Rx-Lx;  /* user-specified real boundary coords */
   ydiff = By-Ty;

   ASHinq_size(window,ASH_SIZE_WINDOW,&lx,&by,&rx,&ty);

   STEMbtn_size(ASHinq_font(window),"Reset",&dummy,&bottomy);
   width = rx-lx-2;
   height = by-ty-bottomy-2;

   if ( ((double)width/xdiff) >= ((double)height/ydiff) )
      { winy = height;
	winx = (int) ((double)height * xdiff / ydiff);
      }
   else
      { winx = width;
	winy = (int) ((double)width * ydiff / xdiff);
      }

   easel = ASHcreate(window,lx+1,ty+winy+1,0,winy,winx,0,ASH_BORDER_THIN,ASH_WINDOW_NOCLEAR);

   halfx = (rx-lx)/2;
   quitwindow = ASHcreate(window,0,by,0,bottomy-1,halfx-1,0,ASH_BORDER_THIN,ASH_WINDOW_NOSAVE);
   STEMmenu(quitwindow,quit_fct,0,RIP_BTN_ANY_UP,quit_btn);
   resetwindow = ASHcreate(window,halfx,by,0,bottomy-1,halfx-1,0,ASH_BORDER_THIN,ASH_WINDOW_NOSAVE);
   STEMmenu(resetwindow,reset_fct,0,RIP_BTN_ANY_UP,reset_btn);

   animate_begin(window,easel,NULL,Lx,By,Rx,Ty,mode,blting);
}




/***************************************************************/
/*							       */
/*  topwindow_layout - put the TANGO title along with the      */
/*	move and resize gadgets in the window above the        */
/*	animation window.				       */
/*							       */
/***************************************************************/

void
topwindow_layout(window,lx,by,rx,ty)
   ASH_WINDOW window;
   int lx,by,rx,ty;
{
   static int data[1];
   int size;
   ASH_WINDOW w1,w2;
   ASH_FONT old;
   ASH_COLOR old1,old2;

   ASHbackground_color(window,ASHlookup_color(window,"yellow"));
   ASHclear_box(window,lx,by,rx,ty);
   old = ASHfont(window,ASHfont_id("helvetica",14,ASH_FONT_BOLD|ASH_FONT_ROMAN));
   old1 = ASHtext_color(window,ASHlookup_color(window,"black"));
   old2 = ASHtext_background_color(window,ASHlookup_color(window,"yellow"));
   ASHcenter_text(window,"TANGO",lx,by,rx,ty);
   ASHfont(window,old);
   ASHtext_color(window,old1);
   ASHtext_background_color(window,old2);
}




/***************************************************************/
/*							       */
/*  leftwindow_layout - put the panning and zooming gadgets    */
/*	in the window to the left of the animation window.     */
/*							       */
/***************************************************************/

void
leftwindow_layout(window,lx,by,rx,ty)
   ASH_WINDOW window;
   int lx,by,rx,ty;
{
   static int data[1];
   int size,y;
   ASH_WINDOW w1,w2,w3,w4,w5,w6;

   size = rx-lx;

   y = (by-ty)/2 - 2*size - size/2;
   w1 = ASHcreate(window,lx,y,0,size,size,0,ASH_BORDER_THIN,ASH_WINDOW_NOSAVE);
   STEMstate(w1,left_menu,pan_fct,data,0);

   y += size+1;
   w2 = ASHcreate(window,lx,y,0,size,size,0,ASH_BORDER_THIN,ASH_WINDOW_NOSAVE);
   STEMstate(w2,right_menu,pan_fct,data,1);

   y += size+1;
   w3 = ASHcreate(window,lx,y,0,size,size,0,ASH_BORDER_THIN,ASH_WINDOW_NOSAVE);
   STEMstate(w3,up_menu,pan_fct,data,2);

   y += size+1;
   w4 = ASHcreate(window,lx,y,0,size,size,0,ASH_BORDER_THIN,ASH_WINDOW_NOSAVE);
   STEMstate(w4,down_menu,pan_fct,data,3);

   y += 2*size+1;
   w5 = ASHcreate(window,lx,y,0,size,size,0,ASH_BORDER_THIN,ASH_WINDOW_NOSAVE);
   STEMstate(w5,in_menu,zoom_fct,data,0);

   y += size+1;
   w6 = ASHcreate(window,lx,y,0,size,size,0,ASH_BORDER_THIN,ASH_WINDOW_NOSAVE);
   STEMstate(w6,out_menu,zoom_fct,data,1);
}






/***************************************************************/
/*							       */
/*  quit_fct - STEM calls this when the user wants to	       */
/*	leave TANGO.					       */
/*							       */
/***************************************************************/

int
quit_fct(data,index,event,window)
   int data;
   int index;
   int event;
   ASH_WINDOW window;
{
   exit(0);
}


/***************************************************************/
/*							       */
/*  reset_fct - STEM calls this when the user wants to	       */
/*	reset and start up a new animation.		       */
/*							       */
/***************************************************************/

int
reset_fct(data,index,event,window)
   int data;
   int index;
   int event;
   ASH_WINDOW window;
{
   IMAGE_PTR	im,old;
   TANGO_IMAGE	image;
   ERASER_PTR	e,f;

   ASHclear_box(TANGO__data->window,0,TANGO__data->height,TANGO__data->width,0);
   TANGO__data->window = ASHanim_next_frame(TANGO__data->window);
   if (!TANGO__data->blting)
      ASHset_color_table(TANGO__data->parentwindow, ASHinq_color_table(TANGO__data->window) );
   ASHclear_box(TANGO__data->window,0,TANGO__data->height,TANGO__data->width,0);
   TANGO__data->window = ASHanim_next_frame(TANGO__data->window);
   if (!TANGO__data->blting)
      ASHset_color_table(TANGO__data->parentwindow, ASHinq_color_table(TANGO__data->window) );

   im = TANGO__data->confighead;
   while (im)
   { image = im->image;
     if (image->type == TANGO_IMAGE_TYPE_COMPOSITE)
	{ ;
	}
     free(image);
     old = im;
     im = im->nexti;
     free(old);
   }
   /* get rid of paths, locs, and transitions */

   /* clean out eraser pointers */
   e = TANGO__data->erase[TANGO__data->framenum];
   while (e)
      { f = e;
	e = e->next;
	free(f);
      }
   TANGO__data->erase[TANGO__data->framenum] = NULL;
   if (!TANGO__data->blting)
      { TANGO__data->framenum = (TANGO__data->framenum + 1) % 2;
	e = TANGO__data->erase[TANGO__data->framenum];
	while (e)
	   { f = e;
	     e = e->next;
	     free(f);
	   }
	TANGO__data->erase[TANGO__data->framenum] = NULL;
      }

   TANGO__data->confighead = TANGO__data->configtail = NULL;
   TANGO__data->numimages = 0;
   TANGO__data->lx = TANGO__data->olx;
   TANGO__data->rx = TANGO__data->orx;
   TANGO__data->ty = TANGO__data->oty;
   TANGO__data->by = TANGO__data->oby;
   TANGO__data->scrollpct = 0;
   TANGO__data->motionblur = 0;
   if (TANGO__data->scrollwindow)
      STEMscroll_set(TANGO__data->scrollwindow,0,110,0,10);
   TANGO__data->delay = 0;

   ASSOC_clear();
}


/***************************************************************/
/*							       */
/*  resize_fct - STEM calls this when the user wants to        */
/*	resize the animation window.			       */
/*							       */
/***************************************************************/

int
resize_fct(data,state,value,event,window)
   int data;
   int state,value;
   int event;
   ASH_WINDOW window;
{
   printf("Calling resize fct\n");
}


/***************************************************************/
/*							       */
/*  move_fct - STEM calls this when the user wants to	       */
/*	move the animation window.			       */
/*							       */
/***************************************************************/

int
move_fct(data,state,value,event,window)
   int data;
   int state,value;
   int event;
   ASH_WINDOW window;
{
   printf("Calling move fct\n");
}


/***************************************************************/
/*							       */
/*  pan_fct - STEM calls this when the user wants to	       */
/*	pan around in the animation window.		       */
/*							       */
/***************************************************************/

int
pan_fct(data,state,value,event,window)
   int data;
   int state,value;
   int event;
   ASH_WINDOW window;
{
#define PANFACTOR  0.2

   switch (data)
   {
      case 0:
	 TANGO__data->lx -= PANFACTOR;
	 TANGO__data->rx -= PANFACTOR;
	 break;
      case 1:
	 TANGO__data->lx += PANFACTOR;
	 TANGO__data->rx += PANFACTOR;
	 break;
      case 2:
	 TANGO__data->ty -= PANFACTOR;
	 TANGO__data->by -= PANFACTOR;
	 break;
      case 3:
	 TANGO__data->by += PANFACTOR;
	 TANGO__data->ty += PANFACTOR;
	 break;
      default:
	 printf("???\n");
   }
   stabilize();
}


/***************************************************************/
/*							       */
/*  zoom_fct - STEM calls this when the user wants to	       */
/*	zoom in or out of the animation window. 	       */
/*							       */
/***************************************************************/

int
zoom_fct(data,state,value,event,window)
   int data;
   int state,value;
   int event;
   ASH_WINDOW window;
{
#define  ZOOMFACTOR  0.8
   WIN_COORD change;

   switch (data)
   {
      case 0:
	 change = (TANGO__data->rx - TANGO__data->lx) * (1.0-ZOOMFACTOR);
	 TANGO__data->rx -= change/2.0;
	 TANGO__data->lx += change/2.0;
	 change = (TANGO__data->by - TANGO__data->ty) * (1.0-ZOOMFACTOR);
	 TANGO__data->by -= change/2.0;
	 TANGO__data->ty += change/2.0;
	 break;
      case 1:
	 change = (TANGO__data->rx - TANGO__data->lx) * (1.0/ZOOMFACTOR - 1.0);
	 TANGO__data->rx += change/2.0;
	 TANGO__data->lx -= change/2.0;
	 change = (TANGO__data->by - TANGO__data->ty) * (1.0/ZOOMFACTOR - 1.0);
	 TANGO__data->by += change/2.0;
	 TANGO__data->ty -= change/2.0;
	 break;
      default:
	 printf("???\n");
   }
   stabilize();
}



/***************************************************************/
/*							       */
/*  TANGOclearset - specify a number of images, such that if   */
/*	if any animation grows to a larger number of images,   */
/*	then the clear_screen function will do an ASHclear()   */
/*	as opposed to drawing each image in white (bground     */
/*	color). 					       */
/*							       */
/***************************************************************/

void
TANGO_clearset(num)
   int num;
{
   TANGO__data->imageclear = num;
}



/***************************************************************/
/*							       */
/*  delayset - STEM calls this fct when the user has moved     */
/*	the scroll bar.  Adjust the delay setting appropriately*/
/*							       */
/***************************************************************/

void
delayset(data,dir,value)
   int data,dir,value;
{
#define TIMEINCR  1000
   if (dir == 0)
      { TANGO__data->delay = value * TIMEINCR;
	STEMscroll_set(TANGO__data->scrollwindow,0,110,value,value+10);
	TANGO__data->scrollpct = value;
      }
   else if (dir == -1)
      { TANGO__data->scrollpct--;
	TANGO__data->delay = TANGO__data->scrollpct * TIMEINCR;
	STEMscroll_set(TANGO__data->scrollwindow,0,110,TANGO__data->scrollpct,TANGO__data->scrollpct+10);
      }
   else if (dir == 1)
      { TANGO__data->scrollpct++;
	TANGO__data->delay = TANGO__data->scrollpct * TIMEINCR;
	STEMscroll_set(TANGO__data->scrollwindow,0,110,TANGO__data->scrollpct,TANGO__data->scrollpct+10);
      }
}



/***************************************************************/
/*							       */
/* animate_begin - this routine is used to set up the TANGO    */
/*	animation window and package.  The routine receives    */
/*	the animation window, its parent window, plus the      */
/*	user specified real-valued window boundary coords.     */
/*	The routine initializes all the fields of the main     */
/*	animation data structure, TANGO__data.		       */
/*							       */
/***************************************************************/

void
animate_begin(parwindow,pallette,scroll,Lx,By,Rx,Ty,mode,blting)
   ASH_WINDOW parwindow,pallette,scroll;
   WIN_COORD Lx,By,Rx,Ty;
   int mode,blting;
{
   int lx,by,rx,ty;

   BIOnew_input_window(parwindow);

   ASHinq_size(pallette,ASH_SIZE_WINDOW,&lx,&by,&rx,&ty);

   BIOnew_input_window(pallette);

   TANGO__data = (ANIMATION_PTR) malloc( sizeof( struct ANIMATION) );
   TANGO__data->rootwindow = ASHroot_X_window(parwindow);
   TANGO__data->parentwindow = parwindow;
   TANGO__data->origwindow = pallette;
   TANGO__data->scrollwindow = scroll;
   TANGO__data->mode = mode;
   TANGO__data->blting = blting;
   TANGO__data->width = rx-lx;
   TANGO__data->height = by-ty;
   TANGO__data->olx = TANGO__data->lx = Lx;
   TANGO__data->orx = TANGO__data->rx = Rx;
   TANGO__data->oty = TANGO__data->ty = Ty;
   TANGO__data->oby = TANGO__data->by = By;
   TANGO__data->scrollpct = 0;
   TANGO__data->delay = 0;
   TANGO__data->imageclear = 200;   /* default value */
   TANGO__data->numimages = 0;
   TANGO__data->motionblur = 0;
   TANGO__data->confighead = NULL;
   TANGO__data->configtail = NULL;
   TANGO__data->framenum = 0;
   TANGO__data->erase[0] = TANGO__data->erase[1] = NULL;

   if (blting)
      TANGO__data->window = ASHanim_setup(pallette,0,0,0);
   else
      TANGO__data->window = ASHanim_setup(pallette,8,2,0);

   ASHfill_table(TANGO_BASE_FILL,TANGO_NUM_FILL,TANGO__fill_table);
}




/***************************************************************/
/*							       */
/*  stabilize - this routine is called whenever the user has   */
/*	panned or zoomed the animation window.	It flips the   */
/*	plane once (those planes were already clear),	       */
/*	draws all the images (note the coords have	       */
/*	already been updated) into the next plane, and then    */
/*	flips the planes again. 			       */
/*							       */
/***************************************************************/

void
stabilize()
{
   IMAGE_PTR imlist;

   ASHclear_box(TANGO__data->window,0,TANGO__data->height,TANGO__data->width,0);
   TANGO__data->window	= ASHanim_next_frame(TANGO__data->window);
   if (!TANGO__data->blting)
      ASHset_color_table(TANGO__data->parentwindow, ASHinq_color_table(TANGO__data->window) );
   ASHclear_box(TANGO__data->window,0,TANGO__data->height,TANGO__data->width,0);
   for (imlist=TANGO__data->configtail; imlist; imlist=imlist->previ)
      WORMapply(TANGO__opid_draw,imlist->image->worm_obj,0.0,0.0);
   TANGO__data->window = ASHanim_next_frame(TANGO__data->window);
   if (!TANGO__data->blting)
      ASHset_color_table(TANGO__data->parentwindow, ASHinq_color_table(TANGO__data->window) );
}
