/***************************************************************/
/*							       */
/*			TANGOSCENELIB.C 		       */
/*							       */
/***************************************************************/
/*    Copyright 1989 Brown University -- John T. Stasko        */

#include <stdio.h>
#include <tango.h>



/* Make the image corresponding to the first two parameters move to the      */
/* window position identified by the following two parameters.		     */

void
TangoEvtMoveto(imid,imidx,locid,locidx)
   int imid,imidx;
   int locid,locidx;
{
   TANGO_IMAGE image;
   TANGO_LOC   at,to;
   TANGO_PATH  path;
   TANGO_TRANS move;

   image = (TANGO_IMAGE) ASSOCretrieve("ID",imid,imidx);

   at = TANGOimage_loc(image,TANGO_PART_TYPE_C);
   to = (TANGO_LOC) ASSOCretrieve("ID",locid,locidx);

   path = TANGOpath_distance(at,to,0.05);
   move = TANGOtrans_create(TANGO_TRANS_TYPE_MOVE,image,path);
   TANGOtrans_perform(move);

   TANGOpath_free(1,path);
   TANGOtrans_free(1,move);
}





/* Make the two images designated by the given parameters exchange positions */
/* on the screen in one simultaneous movement.	Reset associations to	     */
/* reflect this.							     */

void
TangoEvtExchange(id1,n1,id2,n2)
   int id1;
   int n1;
   int id2;
   int n2;
{
   TANGO_IMAGE image1,image2;
   TANGO_LOC   loc1,loc2;
   TANGO_PATH  path1,path2;
   TANGO_TRANS move[2],compose;

   image1 = (TANGO_IMAGE) ASSOCretrieve("ID",id1,n1);
   image2 = (TANGO_IMAGE) ASSOCretrieve("ID",id2,n2);

   loc1 = TANGOimage_loc(image1,TANGO_PART_TYPE_SW);
   loc2 = TANGOimage_loc(image2,TANGO_PART_TYPE_SW);
   path1 = TANGOpath_distance(loc1,loc2,0.05);
   path2 = TANGOpath_distance(loc2,loc1,0.05);
   move[0] = TANGOtrans_create(TANGO_TRANS_TYPE_MOVE,image1,path1);
   move[1] = TANGOtrans_create(TANGO_TRANS_TYPE_MOVE,image2,path2);
   compose = TANGOtrans_compose(2,move);
   TANGOtrans_perform(compose);

   ASSOCstore("ID",id1,n1,image2);  /* reset assocs due to exchange */
   ASSOCstore("ID",id2,n2,image1);

   TANGOpath_free(2,path1,path2);
   TANGOtrans_free(3,move[0],move[1],compose);
}




/* Make the two images designated by the given parameters exchange positions */
/* on the screen in one simultaneous movement.	Do not reset associations.   */

void
TangoEvtSwitch(id1,n1,id2,n2)
   int id1;
   int n1;
   int id2;
   int n2;
{
   TANGO_IMAGE image1,image2;
   TANGO_LOC   loc1,loc2;
   TANGO_PATH  path1,path2;
   TANGO_TRANS move[2],compose;

   image1 = (TANGO_IMAGE) ASSOCretrieve("ID",id1,n1);
   image2 = (TANGO_IMAGE) ASSOCretrieve("ID",id2,n2);

   loc1 = TANGOimage_loc(image1,TANGO_PART_TYPE_SW);
   loc2 = TANGOimage_loc(image2,TANGO_PART_TYPE_SW);
   path1 = TANGOpath_distance(loc1,loc2,0.05);
   path2 = TANGOpath_distance(loc2,loc1,0.05);
   move[0] = TANGOtrans_create(TANGO_TRANS_TYPE_MOVE,image1,path1);
   move[1] = TANGOtrans_create(TANGO_TRANS_TYPE_MOVE,image2,path2);
   compose = TANGOtrans_compose(2,move);
   TANGOtrans_perform(compose);

   TANGOpath_free(2,path1,path2);
   TANGOtrans_free(3,move[0],move[1],compose);
}




/*  Make the image designated by the parameters flash by toggling its	  */
/*  fill style.  The image is left in an unfilled state.		  */

void
TangoEvtFlash(id,index)
   int id,index;
{
   double val[2];
   TANGO_IMAGE image;
   TANGO_PATH  path,cat;
   TANGO_TRANS flash;

   val[0] = 1.0;
   val[1] = -1.0;

   image = (TANGO_IMAGE) ASSOCretrieve("ID",id,index);
   path = TANGOpath_create(2,val,val);
   cat = TANGOpath_iterate(path,5.0);
   flash = TANGOtrans_create(TANGO_TRANS_TYPE_FILL,image,cat);
   TANGOtrans_perform(flash);

   TANGOpath_free(2,path,cat);
   TANGOtrans_free(1,flash);
}





/*  Make the object corresponding to the given parameters become totally  */
/*  filled (in its current color).					  */

void
TangoEvtFill(id,index)
   int id;
   int index;
{
   TANGO_IMAGE image;
   TANGO_PATH  path;
   TANGO_TRANS fill;
   double f = 1.0;

   image = (TANGO_IMAGE) ASSOCretrieve("ID",id,index);
   path = TANGOpath_create(1,&f,&f);
   fill = TANGOtrans_create(TANGO_TRANS_TYPE_FILL,image,path);
   TANGOtrans_perform(fill);

   TANGOpath_free(1,path);
   TANGOtrans_free(1,fill);
}



/*  Make the object corresponding to the given parameters become totally  */
/*  unfilled (just an outline in its current color).			  */

void
TangoEvtUnfill(id,index)
   int id;
   int index;
{
   TANGO_IMAGE image;
   TANGO_PATH  path;
   TANGO_TRANS fill;
   double f = -1.0;

   image = (TANGO_IMAGE) ASSOCretrieve("ID",id,index);
   path = TANGOpath_create(1,&f,&f);
   fill = TANGOtrans_create(TANGO_TRANS_TYPE_FILL,image,path);
   TANGOtrans_perform(fill);

   TANGOpath_free(1,path);
   TANGOtrans_free(1,fill);
}




/*  Replace the image designated by the first parameters by the image  */
/*  designated in the second parameters.  (Move the second one there   */
/*  and change the visibility of the first.)			       */

void
TangoEvtReplace(id1,idx1,id2,idx2)
   int id1,idx1;
   int id2,idx2;
{
   TANGO_LOC   loc1,loc2;
   TANGO_IMAGE im1,im2;
   TANGO_PATH  one,path;
   TANGO_TRANS t[3];

   im1 = (TANGO_IMAGE) ASSOCretrieve("ID",id1,idx1);
   loc1 = TANGOimage_loc(im1,TANGO_PART_TYPE_C);
   im2 = (TANGO_IMAGE) ASSOCretrieve("ID",id2,idx2);
   loc2 = TANGOimage_loc(im2,TANGO_PART_TYPE_C);

   one = TANGOpath_null(1);
   path = TANGOpath_distance(loc1,loc2,10.0);  /* gets there in one shot */

   t[0] = TANGOtrans_create(TANGO_TRANS_TYPE_VISIBLE,im1,one);
   t[1] = TANGOtrans_create(TANGO_TRANS_TYPE_MOVE,im2,path);
   t[2] = TANGOtrans_compose(2,t);
   TANGOtrans_perform(t[2]);

   TANGOpath_free(2,one,path);
   TANGOtrans_free(3,t[0],t[1],t[2]);
}

