/*************************************************************/
/*							     */
/*							     */
/*			TANGOMSG.C			     */
/*							     */
/*							     */
/*************************************************************/
/*    Copyright 1989 Brown University -- John T. Stasko      */

#include  "tangolocal.h"
#include  "tangofsa.h"

/***************************************************************/
/*							       */
/*  fct_receive_event - this is the routine MSG in FIELD calls */
/*	with the events from the algorithm.  This routine      */
/*	must decide which animation scene functions to call    */
/*	based on the finite state info. 		       */
/*							       */
/***************************************************************/

int
fct_receive_event(str,evtnum,replyid)
   char *str;	  /* parameters coded into string format */
   int evtnum;	  /* algorithm event code number */
   int replyid;
{
   TRANSITION_PTR tr;
   PMAT_PAT	  pat;
   INTNODE_PTR	  ta,np;
   int		  args[20];
   int		  (*addr)();
   int		  ret;


   if (Tango_debug)
      printf("FIELD calls TANGO with ->%s<- %d %d\n",str,evtnum,replyid);

   tr = Trans_table[State][evtnum];
   if (tr == NULL)
      { fprintf(stderr,"tango:  error/bug unknown transition found in table\n");
	if (replyid >= 0) /* synchronous, so call back */
	   MSGreply(replyid,NULL);
	exit(-1);
      }

   if (tr->actions)
      { pat = PMATmake_pattern(Algoevts[evtnum].pat,Algoevts[evtnum].params,0);
	PMATmatch(str,pat,args);
	for (ta=tr->actions; ta; ta=ta->next)
	   for (np=NFAstate[ta->num].procs; np; np=np->next)
	      { addr = Animprocs[np->num].addr;
		ret = (*addr)(args[0],args[1],args[2],args[3],args[4],
			args[5],args[6],args[7],args[8],args[9],
			args[10],args[11],args[12],args[13],args[14],
			args[15],args[16],args[17],args[18],args[19]);
		if (TANGO__data->mode == 2)  /* safe-fast mode */
		   TANGO_refresh();   /* clean up the screen */
	      }
      }

   State = tr->to->num;

   if (Tango_debug)
      { printf("Receiving event # %d with msg ->%s<- \n",evtnum,str);
	printf("Changing from state %x %x to state %x %x\n\n",
		 tr->from->hi,tr->from->lo,tr->to->hi,tr->to->lo);
      }

   if (replyid >= 0) /* synchronous, so call back */
      { ASHsync(TANGO__data->rootwindow);
	if (Algoevts[evtnum].callback == 1)  /* expecting a return string */
	   MSGreply(replyid,ret);
	else  /* not expecting a return string, ret might be garbage, and passing
	      /* it to MSGreply could cause a crash */
	   MSGreply(replyid,NULL);
      }
   return(1);
}


