/***************************************************************/
/*							       */
/*	       TANGO ANIMATION PACKAGE (misc)		       */
/*							       */
/***************************************************************/
/*    Copyright 1989 Brown University -- John T. Stasko        */

#include "tangolocal.h"

/***************************************************************/
/**********	    local functions		      **********/
/***************************************************************/


/***************************************************************/
/*							       */
/*   TANGOinput_coord - allow the user to select an arbitrary  */
/*	window location.				       */
/*							       */
/***************************************************************/

int
TANGOinput_coord(x,y)
   WIN_COORD *x,*y;
{
   int xpt,ypt;

   if (!TANGO__init) TANGOinit();

/* printf("Click mouse down to select a point\n");
   ASHbell();	*/
   if (RIPinput_point(TANGO__data->origwindow,"",&xpt,&ypt))
      { *x = (double)xpt/(double)TANGO__data->width*(TANGO__data->rx-TANGO__data->lx)
		 + (double)TANGO__data->lx;
	*y = (double)ypt/(double)TANGO__data->height*(TANGO__data->by-TANGO__data->ty)
		 + (double)TANGO__data->ty;
	return(1);
      }
   else
      { *x = 0.0;
	*y = 0.0;
	return(0);
      }
}






/***************************************************************/
/*							       */
/*   TANGOinput_image - allow the user to select a position    */
/*	in the window, and return the uppermost image object   */
/*	whose bounding box contains that position.	       */
/*							       */
/***************************************************************/

int
TANGOinput_image(im)
   TANGO_IMAGE *im;
{
   int xpt,ypt;
   WIN_COORD x,y,lx,by,rx,ty;
   IMAGE_PTR i;
   TANGO_IMAGE image;
   TANGO_IMAGE_PTR imptr;

   if (!TANGO__init) TANGOinit();

/* printf("Click mouse down to select an image\n");
   ASHbell();	*/
   if (RIPinput_point(TANGO__data->origwindow,"",&xpt,&ypt))
      { x = (double)xpt/(double)TANGO__data->width*(TANGO__data->rx-TANGO__data->lx)
		 + (double)TANGO__data->lx;
	y = (double)ypt/(double)TANGO__data->height*(TANGO__data->by-TANGO__data->ty)
		 + (double)TANGO__data->ty;
	for (i=TANGO__data->confighead; i; i=i->nexti)
	   { image = i->image;
	     imptr = (TANGO_IMAGE_PTR) WORMaccess(TANGO__type_image,image->worm_obj);
	     if (imptr->visible)   /* only want to check visible images */
		{ TANGO_bounding_box(image,&lx,&by,&rx,&ty);
		  if ((lx <= x) && (x <= rx) && (ty <= y) && (y <= by))
		     break;
		}
	   }
	if (i)
	   { *im = i->image;
	     return(1);
	   }
      }
   *im = NULL;
   return(0);
}






