/***************************************************************/
/*							       */
/*			TANGOLOCAL.H			       */
/*							       */
/***************************************************************/
/*    Copyright 1989 Brown University -- John T. Stasko        */

/***************************************************************/
/**********	    include files		      **********/
/***************************************************************/

#define NO_THREADS

#include  <stdio.h>
#include  <strings.h>
#include  <math.h>

#include  <dl.h>

#include  <bio.h>
#include  <ash.h>
#include  <rip.h>
#include  <stem.h>
#include  <worm.h>
#include  <misc.h>

#include  <datatypes.h>
#include  <msg.h>
#include  <pmat.h>

#include  <tango.h>

/***************************************************************/
/**********	  constant definitions		      **********/
/***************************************************************/

#define   XOR	       10
#define   OFF	       0	/* used for fill styles */
#define   ON	       1

#define  TANGO_SCENE_LIB  "/tango/lib/tangoscenelib.o"

#define   TANGO_PATH_POINTS	20
#define   TANGO_PATH_NUMTYPES	 3

#define   TANGO_BASE_FILL	 33
#define   TANGO_NUM_FILL	  9
#define   TANGO_FILL_OUTLINE	 TANGO_BASE_FILL
#define   TANGO_FILL_FULL	 TANGO_BASE_FILL + TANGO_NUM_FILL - 1

#define   BIG_NUMBER	1000000
#define   STRINGLENGTH	256

#define  PICK_EPS	4
#define  CLOSE(A,B)	((A) <= (B) + PICK_EPS)
#define  SAME(A,B)	(CLOSE(A,B) && CLOSE(B,A))
#define  SAMEPT(P,Q)	(SAME(P[0],Q[0]) && SAME(P[1],Q[1]))

#define  EQUAL(A,B)    ( ((A) - 0.0001 < (B)) && ((B) < (A) + 0.0001) )


#ifndef ABS
#define  ABS(A)       ( (A) < 0.0 ? (-A) : (A) )
#endif

#ifndef MIN
#define  MIN(A,B)	( (A) < (B) ? (A) : (B) )
#endif

#define  ROUND(X)	( (X) > 0.0 ? ((X) + 0.5) : ((X) - 0.5) )

/* when window coords are decimals, this finds the corresponding pixel */
#define  XPIXEL(A,B)  ( (int) ROUND( ((B)-TANGO__data->lx) * (A) ) )
/* here, B is the real-valued position, and A is width/(rx-lx)	*/
#define  YPIXEL(A,B)  ( (int) ROUND( ((B)-TANGO__data->ty) * (A) ) )
/* here, B is the real-valued position, and A is height/(by-ty)  */


/***************************************************************/
/**********	      local data types		      **********/
/***************************************************************/

typedef  double      WIN_COORD;
#define  ZERO	     0.0


typedef struct _LOC
{
   WIN_COORD  x;
   WIN_COORD  y;
};


/* structures used by WORM */

typedef struct	_TANGO_IMAGE
{
   double loc[2];
   int	  visible;
} *TANGO_IMAGE_PTR;

typedef struct	_TANGO_LINE
{
   int	  color;
   double size[2];
   double width;
   double style;
   int	  arrow;   /* 0-none, 1-forward, 2-backward, 3-both */
   double arrowloc[4][2];
} *TANGO_LINE_PTR;

typedef struct	_TANGO_RECTANGLE
{
   int	  color;
   double size[2];
   double fill;
} *TANGO_RECTANGLE_PTR;

typedef struct	_TANGO_CIRCLE
{
   int	  color;
   double radius;
   double fill;
} *TANGO_CIRCLE_PTR;

typedef struct	_TANGO_ELLIPSE
{
   int	  color;
   double size[2];
   double fill;
} *TANGO_ELLIPSE_PTR;

typedef struct	_TANGO_POLYLINE   /* at most 8 vertices */
{
   int	  vertices;
   double vertex[7][2];
   int	  color;
   double width;
   double style;
   int	  arrow;   /* 0-none, 1-forward, 2-backward, 3-both */
   double arrowloc[4][2];
} *TANGO_POLYLINE_PTR;

typedef struct	_TANGO_POLYGON	 /* at most 8 vertices */
{
   int	  sides;
   double vertex[7][2];
   int	  color;
   double fill;
} *TANGO_POLYGON_PTR;

typedef struct	_TANGO_SPLINE	/* at most 8 vertices */
{
   int	  vertices;
   double vertex[7][2];
   int	  color;
   double width;
   double style;
} *TANGO_SPLINE_PTR;

typedef struct	_TANGO_TEXT
{
   int	   color;
   char    font_name[STRINGLENGTH];
   int	   fontid;
   char    text[STRINGLENGTH];
   int	   orient;
   int	   xext,xoff;
   int	   yext,yoff;
} *TANGO_TEXT_PTR;

typedef struct	_TANGO_COMPOSITE
{
   TANGO_IMAGE image_list;
} *TANGO_COMPOSITE_PTR;

/* end of structures used by WORM */





typedef struct IMAGE
{
   TANGO_IMAGE	 image;
   struct IMAGE *nexti;
   struct IMAGE *previ;
} *IMAGE_PTR;


typedef struct _IMAGE
{
   TANGO_IMAGE_TYPE type;
   WORM_OBJ	    worm_obj;
   int		    status;
   IMAGE_PTR	    inconfig;	/* used to mark place in configuration */
   struct _IMAGE   *nexti;
} ;



typedef struct OFFSET
{
   WIN_COORD	  dx;
   WIN_COORD	  dy;
   int		  absx;
   int		  absy;
   struct OFFSET *prevo;
   struct OFFSET *nexto;
} *OFFSET_PTR;


typedef struct _PATH
{
   OFFSET_PTR	head;
   OFFSET_PTR	tail;
   int		count;
   int		startx;   /* used for displaying a path */
   int		starty;
   struct _PATH *nextp;
   struct _PATH *prevp;
} ;



typedef struct FRAME
{
   TANGO_TRANS_TYPE  type;   /* maybe bag this, check if needed */
   int		     frame_num;
   WIN_COORD	     dx;
   WIN_COORD	     dy;
   struct FRAME      *prevf;
   struct FRAME      *nextf;
} *FRAME_PTR;


typedef struct ACTION
{
   TANGO_TRANS_TYPE   type;
   TANGO_IMAGE	      image;
   FRAME_PTR	      fhead;
   FRAME_PTR	      ftail;
   FRAME_PTR	      doing;
   struct ACTION     *nexta;
} *ACTION_PTR;


typedef struct _TRANS
{
   int		    num_frames;
   ACTION_PTR	    actions;
   struct _TRANS   *next;
} ;



#include <tangosup.h>

typedef struct ANIMATION
{
   ASH_WINDOW	rootwindow;	  /* X root window */
   ASH_WINDOW	parentwindow;	  /* animation window's outer parent */
   ASH_WINDOW	origwindow;	  /* window passed to ASHanim_setup */
   ASH_WINDOW	window; 	  /* current ASH window to be drawing into */
   ASH_WINDOW	scrollwindow;	  /* holds speed-control scrollbar */
   int		mode;		  /* 0-regular 1-fast */
   int		blting; 	  /* 1 if offscreen blts, 0 is color table flips */
   int		width;		  /* window's */
   int		height;
   WIN_COORD	olx,oby,orx,oty;  /* originals */
   WIN_COORD	lx,by,rx,ty;	  /* working vals */
   int		scrollpct;	  /* where speed control scroll bar is 0->100 */
   int		delay;		  /* how many usecs to sleep */
   int		imageclear;	  /* use clear_box when numimages is over this */
   int		numimages;	  /* # of basic TANGO images in window */
   int		motionblur;	  /* used for printing window dumps, disables clear */
   IMAGE_PTR	confighead;	  /* current configuration of TANGO images */
   IMAGE_PTR	configtail;
   int		framenum;	  /* either 0 or 1, used to tell which plane is active */
   ERASER_PTR	erase[2];	  /* used to hold images for clearing purposes */
} *ANIMATION_PTR;




/***************************************************************/
/**********	     global variables		      **********/
/***************************************************************/

extern	int			 TANGO__init;
extern	ANIMATION_PTR		 TANGO__data;

extern	TANGO_IMAGE_PTR 	 TANGO__image;
extern	TANGO_LINE_PTR		 TANGO__line;
extern	TANGO_RECTANGLE_PTR	 TANGO__rectangle;
extern	TANGO_CIRCLE_PTR	 TANGO__circle;
extern	TANGO_TEXT_PTR		 TANGO__text;
extern	TANGO_ELLIPSE_PTR	 TANGO__ellipse;
extern	TANGO_POLYLINE_PTR	 TANGO__polyline;
extern	TANGO_POLYGON_PTR	 TANGO__polygon;
extern	TANGO_COMPOSITE_PTR	 TANGO__composite;

extern	WORM_TYPE		TANGO__type_image;
extern	WORM_TYPE		TANGO__type_line;
extern	WORM_TYPE		TANGO__type_rectangle;
extern	WORM_TYPE		TANGO__type_circle;
extern	WORM_TYPE		TANGO__type_text;
extern	WORM_TYPE		TANGO__type_ellipse;
extern	WORM_TYPE		TANGO__type_polyline;
extern	WORM_TYPE		TANGO__type_polygon;
extern	WORM_TYPE		TANGO__type_composite;

extern	WORM_OPID		TANGO__opid_create;
extern	WORM_OPID		TANGO__opid_draw;
extern	WORM_OPID		TANGO__opid_trans;
extern	WORM_OPID		TANGO__opid_loc;

static double TANGO__path_type[TANGO_PATH_NUMTYPES][TANGO_PATH_POINTS][2] =
   { { {   0.01,0.0    },
       {   0.01,0.0    },
       {   0.01,0.0    },
       {   0.01,0.0    },
       {   0.01,0.0    },
       {   0.01,0.0    },
       {   0.01,0.0    },
       {   0.01,0.0    },
       {   0.01,0.0    },
       {   0.01,0.0    },
       {   0.01,0.0    },
       {   0.01,0.0    },
       {   0.01,0.0    },
       {   0.01,0.0    },
       {   0.01,0.0    },
       {   0.01,0.0    },
       {   0.01,0.0    },
       {   0.01,0.0    },
       {   0.01,0.0    },
       {   0.01,0.0    }
     },
     { {  0.002,-0.016 },
       {  0.002,-0.016 },
       {  0.006,-0.014 },
       {  0.010,-0.012 },
       {  0.010,-0.012 },
       {  0.012,-0.010 },
       {  0.012,-0.010 },
       {  0.014,-0.006 },
       {  0.016,-0.002 },
       {  0.016,-0.002 },
       {  0.016,0.002  },
       {  0.016,0.002  },
       {  0.014,0.006  },
       {  0.012,0.010  },
       {  0.012,0.010  },
       {  0.010,0.012  },
       {  0.010,0.012  },
       {  0.006,0.014  },
       {  0.002,0.016  },
       {  0.002,0.016  }
     },
     { { -0.002,-0.016 },
       { -0.002,-0.016 },
       { -0.006,-0.014 },
       { -0.010,-0.012 },
       { -0.010,-0.012 },
       { -0.012,-0.010 },
       { -0.012,-0.010 },
       { -0.014,-0.006 },
       { -0.016,-0.002 },
       { -0.016,-0.002 },
       { -0.016,0.002  },
       { -0.016,0.002  },
       { -0.014,0.006  },
       { -0.012,0.010  },
       { -0.012,0.010  },
       { -0.010,0.012  },
       { -0.010,0.012  },
       { -0.006,0.014  },
       { -0.002,0.016  },
       { -0.002,0.016  }
     } };

static short  TANGO__fill_table[TANGO_NUM_FILL][16] =
   { {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},

     {0x1111, 0x0000, 0x4444, 0x0000, 0x1111, 0x0000, 0x4444, 0x0000,
      0x1111, 0x0000, 0x4444, 0x0000, 0x1111, 0x0000, 0x4444, 0x0000},

     {0x1111, 0x4444, 0x1111, 0x4444, 0x1111, 0x4444, 0x1111, 0x4444,
      0x1111, 0x4444, 0x1111, 0x4444, 0x1111, 0x4444, 0x1111, 0x4444},

     {0x1111, 0xaaaa, 0x4444, 0xaaaa, 0x1111, 0xaaaa, 0x4444, 0xaaaa,
      0x1111, 0xaaaa, 0x4444, 0xaaaa, 0x1111, 0xaaaa, 0x4444, 0xaaaa},

     {0xaaaa, 0x5555, 0xaaaa, 0x5555, 0xaaaa, 0x5555, 0xaaaa, 0x5555,
      0xaaaa, 0x5555, 0xaaaa, 0x5555, 0xaaaa, 0x5555, 0xaaaa, 0x5555},

     {0x7777, 0xaaaa, 0xdddd, 0xaaaa, 0x7777, 0xaaaa, 0xdddd, 0xaaaa,
      0x7777, 0xaaaa, 0xdddd, 0xaaaa, 0x7777, 0xaaaa, 0xdddd, 0xaaaa},

     {0x7777, 0xdddd, 0x7777, 0xdddd, 0x7777, 0xdddd, 0x7777, 0xdddd,
      0x7777, 0xdddd, 0x7777, 0xdddd, 0x7777, 0xdddd, 0x7777, 0xdddd},

     {0x7777, 0xffff, 0xdddd, 0xffff, 0x7777, 0xffff, 0xdddd, 0xffff,
      0x7777, 0xffff, 0xdddd, 0xffff, 0x7777, 0xffff, 0xdddd, 0xffff},

     {0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
      0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff}
   };


/***************************************************************/
/**********	    local functions		      **********/
/***************************************************************/

void	  TANGO_layout_window();      /* in tangowindow.c */
void	  TANGO_layout_plainwindow();
void	  TANGO_clearset();

void	  TANGO_image_init();	      /* in tangoimage.c  */
void	  TANGO_bounding_box();
void	  TANGO_clear_screen();

void	  TANGO_refresh();	      /* in tangotrans.c  */

void	  ASSOC_clear();	      /* in tangoassoc.c  */


