/***************************************************************/
/*							       */
/*	       TANGO ANIMATION PACKAGE (loc)		       */
/*							       */
/***************************************************************/
/*    Copyright 1989 Brown University -- John T. Stasko        */

#include "tangolocal.h"

int		 TANGO__init = 0;
ANIMATION_PTR	 TANGO__data = NULL;

void
TANGOinit()
{
   if (TANGO__init) return;

   TANGO__init = 1;
   TANGO_image_init();
}


/***************************************************************/
/*							       */
/*   TANGOloc_create - create a loc object given its two       */
/*	coordinates.					       */
/*							       */
/***************************************************************/

TANGO_LOC
TANGOloc_create(x,y)
   WIN_COORD x,y;
{
   TANGO_LOC loc;

   if (!TANGO__init) TANGOinit();

   loc = (TANGO_LOC) malloc( sizeof( struct _LOC));
   loc->x = x;
   loc->y = y;
   return(loc);
}



/***************************************************************/
/*							       */
/*   TANGOloc_X - return the X component of the given LOC.     */
/*							       */
/***************************************************************/

WIN_COORD
TANGOloc_X(loc)
   TANGO_LOC loc;
{
   if (!TANGO__init) TANGOinit();

   return(loc->x);
}


/***************************************************************/
/*							       */
/*   TANGOloc_Y - return the Y component of the given LOC.     */
/*							       */
/***************************************************************/

WIN_COORD
TANGOloc_Y(loc)
   TANGO_LOC loc;
{
   if (!TANGO__init) TANGOinit();

   return(loc->y);
}


/***************************************************************/
/*							       */
/*   TANGOloc_inquire - return the x and y coordinates of	*/
/*	the given loc.					       */
/*							       */
/***************************************************************/

void
TANGOloc_inquire(loc,x,y)
   TANGO_LOC loc;
   WIN_COORD *x,*y;
{
   if (!TANGO__init) TANGOinit();

   *x = loc->x;
   *y = loc->y;
}


/***************************************************************/
/*							       */
/*   TANGOloc_modify - modify the given loc's coords by         */
/*	the given x and y values.			       */
/*							       */
/***************************************************************/

TANGO_LOC
TANGOloc_modify(loc,x,y)
   TANGO_LOC loc;
   WIN_COORD x,y;
{
   TANGO_LOC newloc;

   if (!TANGO__init) TANGOinit();

   newloc = (TANGO_LOC) malloc( sizeof( struct _LOC));
   newloc->x = x + loc->x;
   newloc->y = y + loc->y;
   return(newloc);
}



/***************************************************************/
/*							       */
/*   TANGOloc_equal - return 1 if the two locs have the 	*/
/*	same coordinates, 0 if not.			       */
/*							       */
/***************************************************************/

int
TANGOloc_equal(loc1,loc2)
   TANGO_LOC loc1,loc2;
{
   if (!TANGO__init) TANGOinit();

   return( EQUAL(loc1->x,loc2->x) && EQUAL(loc1->y,loc2->y) );
}



