/***************************************************************/
/*							       */
/*							       */
/*			  DANCE UTILITY 		       */
/*							       */
/*							       */
/***************************************************************/
/*    Copyright 1989 Brown University -- John T. Stasko        */

#include "dancelocal.h"

ASH_WINDOW    AnimWindow;
ASH_FONT      LabelFont;
ASH_CURSOR    DefCursor,LineCursor,RectCursor,CircleCursor,
		EllipseCursor,PolylineCursor,PolygonCursor,SplineCursor;
int	      Lx,By,Rx,Ty;
int	      Side;
ASH_COLOR     Color[8];

int	      DefiningScene = 0;
SCENE_PTR     SceneHead = NULL;
SCENE_PTR     SceneTail = NULL;
SCENE_PTR     SceneCurrent = NULL;


#include      "dancemenus.h"


/***************************************************************/
/**********		    Main Body		      **********/
/***************************************************************/

main (argc, argv)
   int argc;
   char *argv[];
{
   int		 dx,dy, topy,boty,dummy;
   int		 hit_type;
   ASH_WINDOW	 topWindow, menuWindow, promptWindow;
   ASH_FONT	 menuFont;
   ASH_COLOR	 black,white;

   argc = ASHset_application(argc,argv);
   ASHinit(ASH_MODE_INQUIRE,0);
   RIPinit();

   LabelFont = ASHfont_id("fixed",12,ASH_FONT_ROMAN);
   menuFont = ASHfont_id("helvetica",14,ASH_FONT_BOLD|ASH_FONT_ROMAN);

   topWindow = ASHinq_top();
   ASHinq_size(topWindow,ASH_SIZE_WINDOW,&Lx,&By,&Rx,&Ty);

   STEMbtn_size(menuFont,"Image",&dummy,&topy);
   ASHinq_text_next(menuFont,"Sample string",&dummy,&boty);

   dx = Rx - Lx;
   dy = By - Ty - topy - boty;
   Side = MIN(dx,dy);

   black = ASHinq_configuration_black(topWindow);
   white = ASHinq_configuration_white(topWindow);
   DefCursor = ASHcursor_define_pattern(defbits,defbits,16,16,7,9,black,white);
   LineCursor = ASHcursor_define_pattern(linebits,linebits,16,16,15,2,black,white);
   RectCursor = ASHcursor_define_pattern(rectbits,rectbits,16,16,7,9,black,white);
   CircleCursor = ASHcursor_define_pattern(circlebits,circlebits,16,16,7,9,black,white);
   EllipseCursor = ASHcursor_define_pattern(ellipsebits,ellipsebits,16,16,7,9,black,white);
   PolygonCursor = ASHcursor_define_pattern(polygonbits,polygonbits,16,16,7,9,black,white);
   PolylineCursor = ASHcursor_define_pattern(polylinebits,polylinebits,16,16,7,9,black,white);
   SplineCursor = ASHcursor_define_pattern(splinebits,splinebits,16,16,7,9,black,white);

   ASHfill_table(TANGO_BASE_FILL,TANGO_NUM_FILL,TANGO__fill_table);

   BIOnew_input_window(topWindow);
   BIOset_cursor_pattern(topWindow,DefCursor);

   menuWindow = ASHcreate(topWindow,0,topy,0,topy,Side,0,ASH_BORDER_THIN,ASH_WINDOW_NOSAVE);
   AnimWindow = ASHcreate(topWindow,0,topy+Side,0,Side,Side,0,ASH_BORDER_THIN,ASH_WINDOW_NOSAVE);
   promptWindow = ASHcreate(topWindow,0,Side+topy+boty+1,0,boty,Side,0,ASH_BORDER_THIN,ASH_WINDOW_NOSAVE);
   ASHset_refresh(AnimWindow,ash_refresh_fct);
   BIOnew_input_window(AnimWindow);
   ASHcolor(AnimWindow,ASHlookup_color(AnimWindow,"black"));
   RIParea(RIP_AREA_PROMPT,promptWindow);
   RIPset_tracking_cursor(DefCursor);

   ASHicon_define("compose",16,16,composebits);
   ASHicon_define("concatenate",16,16,concatenatebits);
   ASHicon_define("iterate",16,16,iteratebits);
   ASHicon_define("move",16,16,movebits);
   ASHicon_define("resize",16,16,resizebits);
   ASHicon_define("fill",16,16,fillbits);
   ASHicon_define("visible",16,16,visiblebits);
   ASHicon_define("color",16,16,colorbits);
   ASHicon_define("delay",16,16,delaybits);
   ASHicon_define("raise",16,16,raisebits);
   ASHicon_define("lower",16,16,lowerbits);

   ASHfont(promptWindow,menuFont);
   Color[DANCE_WHITE] = ASHlookup_color(AnimWindow,"white");
   Color[DANCE_BLACK] = ASHlookup_color(AnimWindow,"black");
   Color[DANCE_RED] = ASHlookup_color(AnimWindow,"red");
   Color[DANCE_ORANGE] = ASHlookup_color(AnimWindow,"orange");
   Color[DANCE_YELLOW] = ASHlookup_color(AnimWindow,"yellow");
   Color[DANCE_GREEN] = ASHlookup_color(AnimWindow,"green");
   Color[DANCE_BLUE] = ASHlookup_color(AnimWindow,"blue");
   Color[DANCE_MAROON] = ASHlookup_color(AnimWindow,"maroon");

   STEMpdm_define(menuWindow,0,menudata);
   STEMpdm_fonts(menuWindow,menuFont,menuFont);
   STEMdialog_mouse(1);
   do
     { hit_type = RIPuser_pick(NULL);
     }
   while (hit_type >= 0);
}


/***************************************************************/
/**********		 Call Functions 	      **********/
/***************************************************************/

/***************************************************************/
/*   ash_refresh_fct - this is the routine ASH calls when the  */
/*	display window needs to be refreshed.		       */
/***************************************************************/

void
ash_refresh_fct(window,lx,by,rx,ty)
   ASH_WINDOW window;
   int lx,by,rx,ty;
{
   ASHclear_box(window,lx,by,rx,ty);
   draw_all_images(1);
}



/***************************************************************/
/*   fctFileMake - get the file name and save all the current  */
/*	scenes in that file.				       */
/***************************************************************/

int
fctFileMake(data,menu,button,window)
   int data;
   char *menu;
   char *button;
   ASH_WINDOW window;
{
   char *format1 = "\nInclude current scene?\n%0.1o Yes     %0.0o No \n\n   %a";
   static char *format2[4] = {
      "\nWrite to file name?\n%0.32t\n",
      "\n%1.0o  append\n%1.1o  overwrite\n\n",
      "%a               %c",
      NULL };
   int	save;
   char file[32];
   int	over;
   SCENE_PTR fp,old;

   if (DefiningScene)
      { save = 1;
	STEMdialog1(AnimWindow,format1,&save);
	if (save)
	   fctSceneEnd(data,menu,button,window);
      }
   file[0] = '\0';
   over = 0;
   if (SceneHead)
      { if (STEMdialog(AnimWindow,format2,file,&over) && (file[0] != '\0'))
	   { write_file(file,over);
	     old = SceneHead;
	     do
		{ fp = old->next;
		  free_scene(old);
		  old = fp;
		}
	     while (fp);
	     SceneHead = SceneTail = NULL;
	   }
      }
   else
      RIPprompt("No scenes currently defined");
   return(1);
}


/***************************************************************/
/*   fctFileQuit - exit the demo program.  Check if anything   */
/*	is still active.				       */
/***************************************************************/

int
fctFileQuit(data,menu,button,window)
   int data;
   char *menu;
   char *button;
   ASH_WINDOW window;
{
   char *format1 = "\nSave defined scenes?\n%0.1o Yes     %0.0o No \n\n   %a";
   int save;

   save = 1;
   if (DefiningScene || SceneHead)
      { STEMdialog1(AnimWindow,format1,&save);
	if (save)
	   fctFileMake(data,menu,button,window);
      }
   return(-1);	/* will cause exit(0) */
}






/***************************************************************/
/*   write_file - print out all the current definitions to the */
/*	given file name.				       */
/***************************************************************/

void
write_file(name,overwrite)
   char *name;
   int overwrite;
{
   FILE *fp;
   char error[MAXSTRINGLENGTH];
   int i;
   SCENE_PTR scene;
   CALL_PTR cp;

   if (overwrite)
      { if ((fp = fopen(name,"w")) == NULL)
	  { sprintf(error,"Unable to open file %s for write",name);
	    RIPprompt(error);
	  }
	fprintf(fp,"#include <tango.h>\n\n\n");
      }
   else  /* append */
      { if ((fp = fopen(name,"a")) == NULL)
	  { sprintf(error,"Unable to open file %s for append write",name);
	    RIPprompt(error);
	  }
      }


   for (scene=SceneHead; scene; scene=scene->next)
      { fprintf(fp,"void\n%s(",scene->name);
	if (scene->num_params >= 1)
	   fprintf(fp,"p1");
	for (i=2; i<=scene->num_params; ++i)
	   fprintf(fp,",p%d",i);
	fprintf(fp,")\n");
	for (i=1; i<=scene->num_params; ++i)
	   if (scene->params[i-1])
	      fprintf(fp,"   double p%d;\n",i);
	   else
	      fprintf(fp,"   int  p%d;\n",i);
	fprintf(fp,"{\n");

	output_local_vars(fp,scene);

	for (cp=scene->calls; cp; cp=cp->next)
	   fprintf(fp,"   %s\n",cp->callstr);
	fprintf(fp,"}\n\n\n\n");
      }
   fclose(fp);
   fflush(fp);
}




/***************************************************************/
/*   output_local_vars - figure out the TANGO variables used   */
/*	by the scene, then write them neatly to the file.      */
/***************************************************************/

void
output_local_vars(fp,scene)
   FILE *fp;
   SCENE_PTR scene;
{
   char loc[200],image[200],path[200],trans[200],tail[200];
   CALL_PTR   call;
   DISPLAY_PTR disp;

   for (call=scene->calls; call; call=call->next)
      { if (call->special)
	  { if (call->special->type == DEMO_OBJ_IMAGE)
	       special_image(fp,call->special);
	    else if (call->special->type == DEMO_OBJ_PATH)
	       special_path(fp,call->special);
	  }
      }

   loc[0] = image[0] = path[0] = trans[0] = '\0';
   for (disp=scene->displays; disp; disp=disp->next)
      { if (disp->type == DEMO_OBJ_LOC)
	   { if (loc[0])
		sprintf(tail,", %s",disp->vname);
	     else
		sprintf(tail,"   TANGO_LOC %s",disp->vname);
	     strcat(loc,tail);
	   }
	if (disp->type == DEMO_OBJ_IMAGE)
	   { if (image[0])
		sprintf(tail,", %s",disp->vname);
	     else
		sprintf(tail,"   TANGO_IMAGE %s",disp->vname);
	     strcat(image,tail);
	   }
	if (disp->type == DEMO_OBJ_PATH)
	   { if (path[0])
		sprintf(tail,", %s",disp->vname);
	     else
		sprintf(tail,"   TANGO_PATH %s",disp->vname);
	     strcat(path,tail);
	   }
	if (disp->type == DEMO_OBJ_TRANS)
	   { if (trans[0])
		sprintf(tail,", %s",disp->vname);
	     else
		sprintf(tail,"   TANGO_TRANS %s",disp->vname);
	     strcat(trans,tail);
	   }
      }

   if (loc[0])
      { strcat(loc,";\n");
	fprintf(fp,"%s",loc);
      }
   if (image[0])
      { strcat(image,";\n");
	fprintf(fp,"%s",image);
      }
   if (path[0])
      { strcat(path,";\n");
	fprintf(fp,"%s",path);
      }
   if (trans[0])
      { strcat(trans,";\n");
	fprintf(fp,"%s",trans);
      }

   fprintf(fp,"\n");
}



/***************************************************************/
/*   special_image - dump out arrays of reals that are the     */
/*	vertices of a polygon image.			       */
/***************************************************************/

void
special_image(fp,sp)
   FILE *fp;
   DISPLAY_PTR sp;
{
   char var[1024],tail[200];
   int count;
   DEMO_IMAGE image;
   OFFSET_PTR off;

   image = (DEMO_IMAGE) sp->object;
   if (image->vertices == 1)
      return;
   sprintf(var,"   static double %s_x[%d] = {",sp->vname,
	      image->vertices-1);
   sprintf(tail," %lf",image->x[1]-image->x[0]);
   strcat(var,tail);
   for (count=2; count<image->vertices; ++count)
      { sprintf(tail," ,%lf",image->x[count]-image->x[0]);
	strcat(var,tail);   /* important, TANGO's are offsets, not absolutes */
      }
   strcat(var," };\n");
   fprintf(fp,"%s",var);

   sprintf(var,"   static double %s_y[%d] = {",sp->vname,
	      image->vertices-1);
   sprintf(tail," %lf",image->y[1]-image->y[0]);
   strcat(var,tail);
   for (count=2; count<image->vertices; ++count)
      { sprintf(tail," ,%lf",image->y[count]-image->y[0]);
	strcat(var,tail);
      }
   strcat(var," };\n");
   fprintf(fp,"%s",var);
}



/***************************************************************/
/*   special_path - dump out arrays of reals that are the      */
/*	individual x and y offsets of a path.		       */
/***************************************************************/

void
special_path(fp,sp)
   FILE *fp;
   DISPLAY_PTR sp;
{
   char var[5000],tail[200];
   int count;
   TANGO_PATH tpath;
   OFFSET_PTR off;

   tpath = (TANGO_PATH) sp->object;
   sprintf(var,"   static double %s_x[%d] = {",sp->vname,
	      tpath->count);
   sprintf(tail," %lf",tpath->head->dx);
   strcat(var,tail);
   count = 1;
   for (off=tpath->head->nexto; off; off=off->nexto)
      { if ((count % 25) == 0)
	   sprintf(tail,",%lf\n     ",off->dx);
	else
	   sprintf(tail,",%lf",off->dx);
	strcat(var,tail);
	count++;
      }
   strcat(var," };\n");
   fprintf(fp,"%s",var);

   sprintf(var,"   static double %s_y[%d] = {",sp->vname,
	      tpath->count);
   sprintf(tail," %lf",tpath->head->dy);
   strcat(var,tail);
   count = 1;
   for (off=tpath->head->nexto; off; off=off->nexto)
      { if ((count % 25) == 0)
	   sprintf(tail,",%lf\n     ",off->dy);
	else
	   sprintf(tail,",%lf",off->dy);
	strcat(var,tail);
	count++;
      }
   strcat(var," };\n");
   fprintf(fp,"%s",var);
}



