/***************************************************************/
/*							       */
/*			  DANCELOCAL.H			       */
/*							       */
/***************************************************************/
/*    Copyright 1989 Brown University -- John T. Stasko        */

/***************************************************************/
/**********	    include files		      **********/
/***************************************************************/

#include  <tangolocal.h>

/***************************************************************/
/**********	  constant definitions		      **********/
/***************************************************************/

#define   MAXSTRINGLENGTH   256

#define   COORD(X)   ( (double) (X) / (double) Side )
#define   ROUNDER(Y) ( (Y) > 0.0 ? ((Y) + 0.5) : ((Y) - 0.5) )
#define   ABSOL(Z)   ( (int) ROUNDER( Side * (Z) ) )

/***************************************************************/
/**********	      local data types		      **********/
/***************************************************************/

typedef int DEMO_OBJ_TYPE;

#define   DEMO_OBJ_PARAM      0
#define   DEMO_OBJ_ASSOC      1
#define   DEMO_OBJ_IMAGE      2
#define   DEMO_OBJ_LOC	      3
#define   DEMO_OBJ_PATH       4
#define   DEMO_OBJ_TRANS      5
#define   DEMO_OBJ_LINE       6
#define   DEMO_OBJ_RECT       7
#define   DEMO_OBJ_CIRCLE     8
#define   DEMO_OBJ_TEXT       9
#define   DEMO_OBJ_ELLIPSE   10
#define   DEMO_OBJ_POLYGON   11
#define   DEMO_OBJ_POLYLINE  12
#define   DEMO_OBJ_SPLINE    13


#define   DANCE_WHITE	      0
#define   DANCE_BLACK	      1
#define   DANCE_RED	      2
#define   DANCE_ORANGE	      3
#define   DANCE_YELLOW	      4
#define   DANCE_GREEN	      5
#define   DANCE_BLUE	      6
#define   DANCE_MAROON	      7


typedef struct _PT
{
   int x;
   int y;
} *PT_PTR;



typedef struct	_DISPLAY
{
   DEMO_OBJ_TYPE	type;
   int			vx,vy;
   char 		vname[MAXSTRINGLENGTH];
   int			lx,by,rx,ty;
   int			object;  /* universal pointer */
   int			marked;
   struct _DISPLAY     *prev;
   struct _DISPLAY     *next;
} *DISPLAY_PTR;



typedef struct	_DEMO_IMAGE
{
   DEMO_OBJ_TYPE    type;
   int		    visible;
   int		    vertices;
   int		    pixelx[9];
   int		    pixely[9];
   double	    x[9];
   double	    y[9];
   char 	    string[MAXSTRINGLENGTH];
   char 	    color[MAXSTRINGLENGTH];
   ASH_COLOR	    ashcolor;
   double	    fill;
   ASH_FILL_STYLE   ashfill;
   double	    width;
   double	    style;
   ASH_LINE_STYLE   linestyle;
   int		    arrow;
   double	    arrowloc[4][2];
   int		    pixelarrowloc[4][2];
} *DEMO_IMAGE;



typedef struct _DEMO_FRAME
{
   TANGO_TRANS_TYPE	type;
   int			frame_num;
   double		dx;
   double		dy;
   struct _DEMO_FRAME  *prevf;
   struct _DEMO_FRAME  *nextf;
} *DEMO_FRAME_PTR;


typedef struct _DEMO_ACTION
{
   TANGO_TRANS_TYPE	 type;
   DEMO_IMAGE		 image;
   DISPLAY_PTR		 display;
   DEMO_FRAME_PTR	 fhead;
   DEMO_FRAME_PTR	 ftail;
   DEMO_FRAME_PTR	 doing;
   struct _DEMO_ACTION	*nexta;
} *DEMO_ACTION_PTR;


typedef struct _DEMO_TRANS
{
   int		       x;
   int		       y;
   char 	       iconstr[25];
   int		       num_frames;
   DEMO_ACTION_PTR     actions;
   struct _DEMO_TRANS *next;
} *DEMO_TRANS;



typedef struct	_CALL
{
   DEMO_OBJ_TYPE  call_type;
   int		  num;
   char 	  callstr[256];
   DISPLAY_PTR	  special;     /* used to allocate local vars */
   struct _CALL   *next;
} *CALL_PTR;


typedef struct	_SCENE
{
   char 	  name[MAXSTRINGLENGTH];
   int		  num_params;
   int		  params[20];  /* 0->integer 1->double */
   int		  endx;
   int		  num_calls;
   CALL_PTR	  calls;
   CALL_PTR	  call_tail;
   DISPLAY_PTR	  displays;
   DISPLAY_PTR	  display_tail;
   struct _SCENE *next;
} *SCENE_PTR;




/***************************************************************/
/**********	     global variables		      **********/
/***************************************************************/

extern	ASH_WINDOW    AnimWindow;
extern	ASH_FONT      LabelFont;
extern	ASH_CURSOR    DefCursor,LineCursor,RectCursor,CircleCursor,
			EllipseCursor,PolylineCursor,PolygonCursor,SplineCursor;

extern	ASH_COLOR     Color[8];
extern	int	      Lx,By,Rx,Ty;
extern	int	      Side;

extern	int	      DefiningScene;
extern	SCENE_PTR     SceneHead;
extern	SCENE_PTR     SceneTail;
extern	SCENE_PTR     SceneCurrent;

extern	int	      TransSet;
extern	int	      TransX,TransY;

/***************************************************************/
/**********	   function declarations	      **********/
/***************************************************************/

void		 ash_refresh_fct();	 /* in dancemain.c    */
int		 fctFileMake();
int		 fctFileQuit();
void		 write_file();
void		 output_local_vars();
void		 special_image();
void		 special_path();

int		 fctSceneDefine();	   /* in dancefct.c	*/
int		 fctSceneEnd();
int		 check_scenebegin();
void		 free_scene();
CALL_PTR	 new_call();

DISPLAY_PTR	 new_display(); 	 /* in dancevis.c     */
void		 draw_all_images();
void		 clear_images();
void		 update_label_positions();
DISPLAY_PTR	 which_object();
PT_PTR		 get_point();
int		 loc_rtn();
PT_PTR		 query_point();
int		 track_rtn();
DISPLAY_PTR	 get_object();

int		 fctAssocMake();	 /* in danceassoc.c   */
int		 fctAssocStore();
int		 fctAssocRetrieve();
void		 get_params();

int		 fctLocCreate();	 /* in danceloc.c     */

int		 fctImageCreate();	 /* in danceimage.c   */
int		 fctImageLoc();
DEMO_IMAGE	 get_line();
DEMO_IMAGE	 get_rect();
DEMO_IMAGE	 get_ellipse();
DEMO_IMAGE	 get_polygon();
DEMO_IMAGE	 get_polyline();
DEMO_IMAGE	 get_spline();
DEMO_IMAGE	 get_circle();
DEMO_IMAGE	 get_text();
int		 demo_line_draw();
int		 demo_rect_draw();
int		 demo_circle_draw();
int		 demo_ellipse_draw();
int		 demo_polygon_draw();
int		 demo_polyline_draw();
int		 demo_spline_draw();
int		 demo_text_draw();
void		 place_name_at();
void		 image_loc();
void		 image_call();
void		 color_and_fill();
void		 width_and_style();
void		 get_an_arrow();
void		 make_arrow_integer();
void		 find_arrow_offsets();
void		 polyline_arrow_dir();
void		 addin_arrows();

int		 fctPathStore();	  /* in dancepath.c    */
int		 fctPathLoad();
int		 fctPathMake();
int		 fctPathType();
int		 fctPathCopy();
int		 fctPathNull();
int		 fctPathColor();
int		 fctPathRotate();
int		 fctPathInterpolate();
int		 fctPathScale();
int		 fctPathExtend();
int		 fctPathSmooth();
int		 fctPathIterate();
int		 fctPathConcat();
int		 fctPathCompose();
int		 fctPathExample();
int		 fctPathDistance();
int		 fctPathMotion();
int		 get_a_path();
int		 get_a_pick_path();
int		 edit_path();
void		 convert_path();
void		 erase_path();
void		 display_path();
void		 center_path();
void		 draw_path();
TANGO_PATH	 alloc_path();
void		 get_a_color();

int		 fctTransCreate();	    /* in dancetrans.c */
int		 fctTransIterate();
int		 fctTransCompose();
int		 fctTransConcat();
int		 fctTransPerform();
TANGO_TRANS_TYPE get_trans_type();
void		 show_transition();
DEMO_TRANS	 demo_trans_create();
DEMO_TRANS	 demo_trans_iterate();
DEMO_TRANS	 demo_trans_concatenate();
DEMO_TRANS	 demo_trans_compose();
void		 demo_trans_perform();
DEMO_TRANS	 demo_get_transition();
DEMO_ACTION_PTR  demo_get_action();
DEMO_FRAME_PTR	 demo_get_frame();
void		 demo_copy_frames_shift();
DEMO_ACTION_PTR  demo_copy_action_shift();
void		 demo_transition_free();
void		 move_image();
void		 resize_image();
void		 visible_image();
void		 fill_image();
void		 color_image();
void		 raise_image();
void		 lower_image();
