/***************************************************************/
/*							       */
/*		   DANCE PACKAGE (image)		       */
/*							       */
/***************************************************************/
/*    Copyright 1989 Brown University -- John T. Stasko        */

#include  <dancelocal.h>

int    X0,Y0,X1,Y1;	      /* used by XOR drawers to save values */


/***************************************************************/
/*   fctImageCreate - create a TANGO_IMAGE.  get all the       */
/*	params such as color and fill.	Allow the user to      */
/*	draw the object.				       */
/***************************************************************/

int
fctImageCreate(data,menu,button,window)
   int data;
   char *menu;
   char *button;
   ASH_WINDOW window;
{
   int choice;
   char var[32];
   static char *format1[6] =
      { "\nImage type\n%0.0o line\n%0.1o rectangle\n%0.2o circle",
	"%0.3o ellipse\n%0.4o polyline\n%0.5o polygon",
	"%0.6o spline\n%0.7o text\n",
	"Variable's name\n%1.32t\n",
	"\n%a          %c",
	NULL };
   double pt1[2],pt2[2];
   CALL_PTR call;
   DEMO_IMAGE image;
   DISPLAY_PTR disp;
   int x,y;

   if (!check_scenebegin(data,menu,button,window))
      return(1);
   choice = 0;
   var[0] = '\0';
   if (STEMdialog(AnimWindow,format1,&choice,var) && (var[0] != '\0'))
      { call = new_call(DEMO_OBJ_IMAGE);

	if (choice == 0)
	   image = get_line();
	else if (choice == 1)
	   image = get_rect();
	else if (choice == 2)
	   image = get_circle();
	else if (choice == 3)
	   image = get_ellipse();
	else if (choice == 4)
	   image = get_polyline();
	else if (choice == 5)
	   image = get_polygon();
	else if (choice == 6)
	   image = get_spline();
	else if (choice == 7)
	   image = get_text();

	image_call(call,image,var);  /* fills in the call->callstr field */

	disp = new_display(DEMO_OBJ_IMAGE,image,var,0,0);
	if ((choice == 4) || (choice == 5) || (choice == 6))
	   call->special = disp;  /* set aside vars to hold arrays of vertices */
      }
   return(1);
}





/***************************************************************/
/*   get_line - input a line by XORing the mouse cursor.       */
/***************************************************************/

DEMO_IMAGE
get_line()
{
   DEMO_IMAGE image;

   BIOset_cursor_pattern(AnimWindow,LineCursor);
   image = (DEMO_IMAGE) malloc( sizeof( struct _DEMO_IMAGE));
   ASHset_user_data(AnimWindow,image);
   RIPinput_track(AnimWindow,"Click and drag mouse to draw line",demo_line_draw,-1);
   BIOset_cursor_pattern(AnimWindow,DefCursor);
   return(image);
}



/***************************************************************/
/*   demo_line_draw - RIP calls this to make a line.	       */
/***************************************************************/

int
demo_line_draw(x,y,evt_num,trans,max,window)
  int x,y,evt_num;
  RIP_TRANS trans;
  int max;
  ASH_WINDOW window;
{
   static int drawing = 0;
   DEMO_IMAGE image;
   ASH_COLOR oldcolor;
   ASH_LINE_STYLE oldstyle;
   int tc;

   if (evt_num)
     { if ((trans == RIP_TRANS_DOWN) || (trans == RIP_TRANS_TAP))
	 { X0 = x;
	   Y0 = y;
	   ASHdraw_hilite(AnimWindow,1);
	   RIPprompt("Release button to complete line");
	 }
       else if ((trans == RIP_TRANS_MOVE) || (trans == RIP_TRANS_UP))
	 { if (drawing) /* unset in call routine */
	     ASHline(AnimWindow,X0,Y0,X1,Y1);	/* Erasure of old line */
	   X1 = x;
	   Y1 = y;
	   drawing = 1;
	   ASHline(AnimWindow,X0,Y0,X1,Y1);   /* Draw new line */
	 }
       if (trans == RIP_TRANS_UP)
	 { image = (DEMO_IMAGE) ASHinq_user_data(AnimWindow);
	   image->type = DEMO_OBJ_LINE;
	   image->visible = 1;
	   image->vertices = 2;
	   image->pixelx[0] = X0;
	   image->pixely[0] = Y0;
	   image->pixelx[1] = X1;
	   image->pixely[1] = Y1;
	   image->x[0] = COORD(X0);
	   image->y[0] = COORD(Y0);
	   image->x[1] = COORD(X1);
	   image->y[1] = COORD(Y1);

	   get_a_color(image->color, &tc, &(image->ashcolor));
	   width_and_style(&(image->width), &(image->style), &(image->linestyle));
	   get_an_arrow(&(image->arrow));
	   if ((image->arrow & 0x1) != 0)
	      { find_arrow_offsets(image->x[1]-image->x[0],image->y[1]-image->y[0],
				     &(image->arrowloc[0][0]),&(image->arrowloc[0][1]),
				     &(image->arrowloc[1][0]),&(image->arrowloc[1][1]));
		make_arrow_integer(image,0);
	      }
	   if ((image->arrow & 0x2) != 0)
	      { find_arrow_offsets(image->x[0]-image->x[1],image->y[0]-image->y[1],
				     &(image->arrowloc[2][0]),&(image->arrowloc[2][1]),
				     &(image->arrowloc[3][0]),&(image->arrowloc[3][1]));
		make_arrow_integer(image,2);
	      }

	   ASHline(AnimWindow,X0,Y0,X1,Y1);  /* erase old one */
	   ASHdraw_hilite(AnimWindow,0);    /* stop XORing */

	   oldcolor = ASHcolor(AnimWindow,image->ashcolor);
	   oldstyle = ASHline_style(AnimWindow,image->linestyle);
	   ASHline(AnimWindow,X0,Y0,X1,Y1);
	   addin_arrows(image);
	   ASHcolor(AnimWindow,oldcolor);
	   ASHline_style(AnimWindow,oldstyle);

	   drawing = 0;
	   return(0);
	 }
     }
   return(1);
}




/***************************************************************/
/*   get_rect - input a rectangle by XORing the mouse cursor.  */
/***************************************************************/

DEMO_IMAGE
get_rect()
{
   DEMO_IMAGE image;

   BIOset_cursor_pattern(AnimWindow,RectCursor);
   image = (DEMO_IMAGE) malloc( sizeof( struct _DEMO_IMAGE));
   ASHset_user_data(AnimWindow,image);
   RIPinput_track(AnimWindow,"Click and drag mouse to draw rectangle",demo_rect_draw,-1);
   BIOset_cursor_pattern(AnimWindow,DefCursor);
   return(image);
}



/***************************************************************/
/*   demo_rect_draw - RIP calls this to make a rectangle.      */
/***************************************************************/

int
demo_rect_draw(x,y,evt_num,trans,max,window)
  int x,y,evt_num;
  RIP_TRANS trans;
  int max;
  ASH_WINDOW window;
{
   static int drawing = 0;
   DEMO_IMAGE image;
   ASH_COLOR oldcolor;
   ASH_FILL_STYLE oldfill;

   if (evt_num)
     { if ((trans == RIP_TRANS_DOWN) || (trans == RIP_TRANS_TAP))
	 { X0 = x;
	   Y0 = y;
	   ASHdraw_hilite(AnimWindow,1);
	   RIPprompt("Release button to complete rectangle");
	 }
       else if ((trans == RIP_TRANS_MOVE) || (trans == RIP_TRANS_UP))
	 { if (drawing) /* unset in call routine */
	     ASHbox(AnimWindow,X0,Y0,X1,Y1);   /* Erasure of old rectangle */
	   X1 = x;
	   Y1 = y;
	   drawing = 1;
	   ASHbox(AnimWindow,X0,Y0,X1,Y1);   /* Draw new rectangle */
	 }
       if (trans == RIP_TRANS_UP)
	 { image = (DEMO_IMAGE) ASHinq_user_data(AnimWindow);
	   image->type = DEMO_OBJ_RECT;
	   image->visible = 1;
	   image->pixelx[0] = X0;
	   image->pixely[0] = Y0;
	   image->pixelx[1] = X1;
	   image->pixely[1] = Y1;
	   image->x[0] = COORD(X0);
	   image->y[0] = COORD(Y0);
	   image->x[1] = COORD(X1);
	   image->y[1] = COORD(Y1);

	   color_and_fill(image->color,&(image->ashcolor),
			     &(image->fill),&(image->ashfill) );

	   ASHbox(AnimWindow,X0,Y0,X1,Y1);  /* erase old one */
	   ASHdraw_hilite(AnimWindow,0);    /* stop XORing */

	   oldcolor = ASHcolor(AnimWindow,image->ashcolor);
	   if (image->ashfill == TANGO_FILL_OUTLINE)
	      ASHbox(AnimWindow,X0,Y0,X1,Y1);
	   else
	       { oldfill = ASHfill(AnimWindow,image->ashfill);
		 ASHrectangle(AnimWindow,X0,Y0,X1,Y1);
		 ASHfill(AnimWindow,oldfill);
	       }
	   ASHcolor(AnimWindow,oldcolor);

	   drawing = 0;
	   return(0);
	 }
     }
  return(1);
}




/***************************************************************/
/*   get_circle - input a circle by XORing the mouse cursor.   */
/***************************************************************/

DEMO_IMAGE
get_circle()
{
   DEMO_IMAGE image;

   BIOset_cursor_pattern(AnimWindow,CircleCursor);
   image = (DEMO_IMAGE) malloc( sizeof( struct _DEMO_IMAGE));
   ASHset_user_data(AnimWindow,image);
   RIPinput_track(AnimWindow,"Click and drag mouse to draw circle",demo_circle_draw,-1);
   BIOset_cursor_pattern(AnimWindow,DefCursor);
   return(image);
}



/***************************************************************/
/*   demo_circle_draw - RIP calls this to make a circle.       */
/***************************************************************/

int
demo_circle_draw(x,y,evt_num,trans,max,window)
  int x,y,evt_num;
  RIP_TRANS trans;
  int max;
  ASH_WINDOW window;
{
   static int drawing = 0;
   DEMO_IMAGE image;
   ASH_COLOR oldcolor;
   ASH_FILL_STYLE oldfill;
   int xdiff,ydiff;

   if (evt_num)
     { if ((trans == RIP_TRANS_DOWN) || (trans == RIP_TRANS_TAP))
	 { X0 = x;
	   Y0 = y;
	   ASHdraw_hilite(AnimWindow,1);
	   RIPprompt("Release button to complete circle");
	 }
       else if ((trans == RIP_TRANS_MOVE) || (trans == RIP_TRANS_UP))
	 { if (drawing) /* unset in call routine */
	      ASHcircle(AnimWindow,X0,Y0,X1);	/* Erasure of old circle */
	   xdiff = x - X0;
	   ydiff = y - Y0;
	   X1 = (int) sqrt( (double) ((xdiff*xdiff) + (ydiff*ydiff)) );
	   drawing = 1;
	   ASHcircle(AnimWindow,X0,Y0,X1);   /* Draw new circle */
	 }
       if (trans == RIP_TRANS_UP)
	 { image = (DEMO_IMAGE) ASHinq_user_data(AnimWindow);
	   image->type = DEMO_OBJ_CIRCLE;
	   image->visible = 1;
	   image->pixelx[0] = X0;
	   image->pixely[0] = Y0;
	   image->pixelx[1] = X1;
	   image->x[0] = COORD(X0);
	   image->y[0] = COORD(Y0);
	   image->x[1] = COORD(X1);

	   color_and_fill(image->color,&(image->ashcolor),
			     &(image->fill),&(image->ashfill) );

	   ASHcircle(AnimWindow,X0,Y0,X1);  /* erase old one */
	   ASHdraw_hilite(AnimWindow,0);    /* stop XORing */

	   oldcolor = ASHcolor(AnimWindow,image->ashcolor);
	   if (image->ashfill == TANGO_FILL_OUTLINE)
	      ASHcircle(AnimWindow,X0,Y0,X1);
	   else
	       { oldfill = ASHfill(AnimWindow,image->ashfill);
		 ASHfilled_circle(AnimWindow,X0,Y0,X1);
		 ASHfill(AnimWindow,oldfill);
	       }
	   ASHcolor(AnimWindow,oldcolor);

	   drawing = 0;
	   return(0);
	 }
     }
   return(1);
}





/***************************************************************/
/*   get_ellipse - input an ellipse by XORing the mouse cursor.*/
/***************************************************************/

DEMO_IMAGE
get_ellipse()
{
   DEMO_IMAGE image;

   BIOset_cursor_pattern(AnimWindow,EllipseCursor);
   image = (DEMO_IMAGE) malloc( sizeof( struct _DEMO_IMAGE));
   ASHset_user_data(AnimWindow,image);
   RIPinput_track(AnimWindow,"Click and drag mouse to draw ellipse",demo_ellipse_draw,-1);
   BIOset_cursor_pattern(AnimWindow,DefCursor);
   return(image);
}



/***************************************************************/
/*   demo_ellipse_draw - RIP calls this to make an ellipse.    */
/***************************************************************/

int
demo_ellipse_draw(x,y,evt_num,trans,max,window)
  int x,y,evt_num;
  RIP_TRANS trans;
  int max;
  ASH_WINDOW window;
{
   static int drawing = 0;
   DEMO_IMAGE image;
   ASH_COLOR oldcolor;
   ASH_FILL_STYLE oldfill;

   if (evt_num)
     { if ((trans == RIP_TRANS_DOWN) || (trans == RIP_TRANS_TAP))
	 { X0 = x;
	   Y0 = y;
	   ASHdraw_hilite(AnimWindow,1);
	   RIPprompt("Release button to complete ellipse");
	 }
       else if ((trans == RIP_TRANS_MOVE) || (trans == RIP_TRANS_UP))
	 { if (drawing) /* unset in call routine */
	     ASHellipse(AnimWindow,X0,Y0,X1,Y1);   /* Erasure of old rectangle */
	   X1 = ABS(x-X0);
	   Y1 = ABS(y-Y0);
	   drawing = 1;
	   ASHellipse(AnimWindow,X0,Y0,X1,Y1);	 /* Draw new rectangle */
	 }
       if (trans == RIP_TRANS_UP)
	 { image = (DEMO_IMAGE) ASHinq_user_data(AnimWindow);
	   image->type = DEMO_OBJ_ELLIPSE;
	   image->visible = 1;
	   image->pixelx[0] = X0;
	   image->pixely[0] = Y0;
	   image->pixelx[1] = X1;
	   image->pixely[1] = Y1;
	   image->x[0] = COORD(X0);
	   image->y[0] = COORD(Y0);
	   image->x[1] = COORD(X1);
	   image->y[1] = COORD(Y1);

	   color_and_fill(image->color,&(image->ashcolor),
			     &(image->fill),&(image->ashfill) );

	   ASHellipse(AnimWindow,X0,Y0,X1,Y1);	/* erase old one */
	   ASHdraw_hilite(AnimWindow,0);    /* stop XORing */

	   oldcolor = ASHcolor(AnimWindow,image->ashcolor);
	   if (image->ashfill == TANGO_FILL_OUTLINE)
	      ASHellipse(AnimWindow,X0,Y0,X1,Y1);
	   else
	       { oldfill = ASHfill(AnimWindow,image->ashfill);
		 ASHfilled_ellipse(AnimWindow,X0,Y0,X1,Y1);
		 ASHfill(AnimWindow,oldfill);
	       }
	   ASHcolor(AnimWindow,oldcolor);

	   drawing = 0;
	   return(0);
	 }
     }
  return(1);
}




/***************************************************************/
/*   get_polyline - input a polyline by XORing the mouse cursor. */
/***************************************************************/

DEMO_IMAGE
get_polyline()
{
   DEMO_IMAGE image;

   BIOset_cursor_pattern(AnimWindow,PolylineCursor);
   image = (DEMO_IMAGE) malloc( sizeof( struct _DEMO_IMAGE));
   ASHset_user_data(AnimWindow,image);
   RIPinput_track(AnimWindow,"Click down to designate polyline vertices",demo_polyline_draw,-1);
   BIOset_cursor_pattern(AnimWindow,DefCursor);
   return(image);
}



/***************************************************************/
/*   demo_polyline_draw - RIP calls this to make a polyline.   */
/***************************************************************/

int
demo_polyline_draw(x,y,evt_num,trans,max,window)
  int x,y,evt_num;
  RIP_TRANS trans;
  int max;
  ASH_WINDOW window;
{
   static int drawing = 0;
   static int pixX[9],pixY[9],vertex=0;
   DEMO_IMAGE image;
   ASH_COLOR oldcolor;
   ASH_LINE_STYLE oldstyle;
   int i,tc;
   double fx,fy,bx,by;

   if (evt_num)
     { if ((trans == RIP_TRANS_DOWN) || (trans == RIP_TRANS_TAP))
	 { if (drawing)
	      { ASHline(AnimWindow,X0,Y0,X1,Y1);  /* erase old one */
		X1 = x;
		Y1 = y;
		ASHline(AnimWindow,X0,Y0,X1,Y1);  /* draw new one */
	      }
	   else
	      { X1 = x;
		Y1 = y;
		if (vertex == 0)
		   ASHdraw_hilite(AnimWindow,1);
		RIPprompt("Mouse down for vertex, or press key to end polyline");
	      }
	   pixX[vertex] = X1;
	   pixY[vertex] = Y1;
	   vertex++;
	   X0 = X1;
	   Y0 = Y1;
	   drawing = 0;
	 }
       else if (trans == RIP_TRANS_MOVE)
	 { if (drawing)
	     ASHline(AnimWindow,X0,Y0,X1,Y1);	/* Erasure of old line */
	   X1 = x;
	   Y1 = y;
	   drawing = 1;
	   ASHline(AnimWindow,X0,Y0,X1,Y1);   /* Draw new line */
	 }
       if ((trans == RIP_TRANS_CHAR) || (vertex == 8))
	 { image = (DEMO_IMAGE) ASHinq_user_data(AnimWindow);
	   image->type = DEMO_OBJ_POLYLINE;
	   image->visible = 1;
	   image->vertices = vertex;
	   for (i=0; i<vertex; ++i)
	      { image->pixelx[i] = pixX[i];
		image->pixely[i] = pixY[i];
		image->x[i] = COORD(image->pixelx[i]);
		image->y[i] = COORD(image->pixely[i]);
	      }

	   if (trans == RIP_TRANS_CHAR)
	      ASHline(AnimWindow,X0,Y0,X1,Y1);	/* erase spurious line seg */

	   get_a_color(image->color, &tc, &(image->ashcolor));
	   width_and_style(&(image->width), &(image->style), &(image->linestyle));
	   get_an_arrow(&(image->arrow));
	   if (image->arrow != 0)
	      polyline_arrow_dir(image,&fx,&fy,&bx,&by);
	   if ((image->arrow & 0x1) != 0)
	      { find_arrow_offsets(fx,fy,&(image->arrowloc[0][0]),&(image->arrowloc[0][1]),
					  &(image->arrowloc[1][0]),&(image->arrowloc[1][1]));
		make_arrow_integer(image,0);
	      }
	   if ((image->arrow & 0x2) != 0)
	      { find_arrow_offsets(bx,by,&(image->arrowloc[2][0]),&(image->arrowloc[2][1]),
					  &(image->arrowloc[3][0]),&(image->arrowloc[3][1]));
		make_arrow_integer(image,2);
	      }

	   ASHpolyline(AnimWindow,vertex,pixX,pixY);  /* erase old one */
	   ASHdraw_hilite(AnimWindow,0);    /* stop XORing */

	   oldcolor = ASHcolor(AnimWindow,image->ashcolor);
	   oldstyle = ASHline_style(AnimWindow,image->linestyle);
	   ASHpolyline(AnimWindow,image->vertices,image->pixelx,image->pixely);
	   addin_arrows(image);
	   ASHcolor(AnimWindow,oldcolor);
	   ASHline_style(AnimWindow,oldstyle);

	   drawing = 0;
	   vertex = 0;
	   return(0);
	 }
     }
   return(1);
}




/***************************************************************/
/*   get_polygon - input a polygon by XORing the mouse cursor. */
/***************************************************************/

DEMO_IMAGE
get_polygon()
{
   DEMO_IMAGE image;

   BIOset_cursor_pattern(AnimWindow,PolygonCursor);
   image = (DEMO_IMAGE) malloc( sizeof( struct _DEMO_IMAGE));
   ASHset_user_data(AnimWindow,image);
   RIPinput_track(AnimWindow,"Click down to designate polygon vertices",demo_polygon_draw,-1);
   BIOset_cursor_pattern(AnimWindow,DefCursor);
   return(image);
}



/***************************************************************/
/*   demo_polygon_draw - RIP calls this to make a polygon      */
/***************************************************************/

int
demo_polygon_draw(x,y,evt_num,trans,max,window)
  int x,y,evt_num;
  RIP_TRANS trans;
  int max;
  ASH_WINDOW window;
{
   static int drawing = 0;
   static int pixX[9],pixY[9],vertex=0;
   DEMO_IMAGE image;
   ASH_COLOR oldcolor;
   ASH_FILL_STYLE oldfill;
   int i;

   if (evt_num)
     { if ((trans == RIP_TRANS_DOWN) || (trans == RIP_TRANS_TAP))
	 { if (drawing)
	      { ASHline(AnimWindow,X0,Y0,X1,Y1);  /* erase old one */
		X1 = x;
		Y1 = y;
		ASHline(AnimWindow,X0,Y0,X1,Y1);  /* draw new one */
	      }
	   else
	      { X1 = x;
		Y1 = y;
		if (vertex == 0)
		   ASHdraw_hilite(AnimWindow,1);
		RIPprompt("Mouse down for vertex, or press key to end polygon");
	      }
	   pixX[vertex] = X1;
	   pixY[vertex] = Y1;
	   vertex++;
	   X0 = X1;
	   Y0 = Y1;
	   drawing = 0;
	 }
       else if (trans == RIP_TRANS_MOVE)
	 { if (drawing)
	     ASHline(AnimWindow,X0,Y0,X1,Y1);	/* Erasure of old line */
	   X1 = x;
	   Y1 = y;
	   drawing = 1;
	   ASHline(AnimWindow,X0,Y0,X1,Y1);   /* Draw new line */
	 }
       if ((trans == RIP_TRANS_CHAR) || (vertex == 8))
	 { image = (DEMO_IMAGE) ASHinq_user_data(AnimWindow);
	   image->type = DEMO_OBJ_POLYGON;
	   image->visible = 1;
	   image->vertices = vertex;
	   for (i=0; i<vertex; ++i)
	      { image->pixelx[i] = pixX[i];
		image->pixely[i] = pixY[i];
		image->x[i] = COORD(image->pixelx[i]);
		image->y[i] = COORD(image->pixely[i]);
	      }

	   if (trans == RIP_TRANS_CHAR)
	      ASHline(AnimWindow,X0,Y0,X1,Y1);	/* erase spurious line seg */
	   ASHline(AnimWindow,X0,Y0,pixX[0],pixY[0]); /* complete polygon */

	   color_and_fill(image->color, &(image->ashcolor),
			     &(image->fill), &(image->ashfill) );

	   pixX[vertex] = pixX[0];
	   pixY[vertex] = pixY[0];
	   ASHpolyline(AnimWindow,vertex+1,pixX,pixY);	/* erase old one */
	   ASHdraw_hilite(AnimWindow,0);    /* stop XORing */

	   oldcolor = ASHcolor(AnimWindow,image->ashcolor);
	   if (image->ashfill == TANGO_FILL_OUTLINE)
	       { image->pixelx[vertex] = image->pixelx[0];
		 image->pixely[vertex] = image->pixely[0];
		 ASHpolyline(AnimWindow,image->vertices+1,image->pixelx,image->pixely);
	       }
	   else
	       { oldfill = ASHfill(AnimWindow,image->ashfill);
		 ASHpolygon(AnimWindow,image->vertices,image->pixelx,image->pixely);
		 ASHfill(AnimWindow,oldfill);
	       }
	   ASHcolor(AnimWindow,oldcolor);

	   drawing = 0;
	   vertex = 0;
	   return(0);
	 }
     }
   return(1);
}




/***************************************************************/
/*   get_spline - input a spline by XORing the mouse cursor.   */
/***************************************************************/

DEMO_IMAGE
get_spline()
{
   DEMO_IMAGE image;

   BIOset_cursor_pattern(AnimWindow,SplineCursor);
   image = (DEMO_IMAGE) malloc( sizeof( struct _DEMO_IMAGE));
   ASHset_user_data(AnimWindow,image);
   RIPinput_track(AnimWindow,"Click down to designate spline vertices",demo_spline_draw,-1);
   BIOset_cursor_pattern(AnimWindow,DefCursor);
   return(image);
}



/***************************************************************/
/*   demo_spline_draw - RIP calls this to make a spline.       */
/***************************************************************/

int
demo_spline_draw(x,y,evt_num,trans,max,window)
  int x,y,evt_num;
  RIP_TRANS trans;
  int max;
  ASH_WINDOW window;
{
   static int drawing = 0;
   static int pixX[9],pixY[9],vertex=0;
   DEMO_IMAGE image;
   ASH_COLOR oldcolor;
   ASH_LINE_STYLE oldstyle;
   int i,tc;

   if (evt_num)
     { if ((trans == RIP_TRANS_DOWN) || (trans == RIP_TRANS_TAP))
	 { if (drawing)
	      { ASHline(AnimWindow,X0,Y0,X1,Y1);  /* erase old one */
		X1 = x;
		Y1 = y;
		ASHline(AnimWindow,X0,Y0,X1,Y1);  /* draw new one */
	      }
	   else
	      { X1 = x;
		Y1 = y;
		if (vertex == 0)
		   ASHdraw_hilite(AnimWindow,1);
		RIPprompt("Mouse down for vertex, or press key to end spline");
	      }
	   pixX[vertex] = X1;
	   pixY[vertex] = Y1;
	   vertex++;
	   X0 = X1;
	   Y0 = Y1;
	   drawing = 0;
	 }
       else if (trans == RIP_TRANS_MOVE)
	 { if (drawing)
	     ASHline(AnimWindow,X0,Y0,X1,Y1);	/* Erasure of old line */
	   X1 = x;
	   Y1 = y;
	   drawing = 1;
	   ASHline(AnimWindow,X0,Y0,X1,Y1);   /* Draw new line */
	 }
       if ((trans == RIP_TRANS_CHAR) || (vertex == 8))
	 { image = (DEMO_IMAGE) ASHinq_user_data(AnimWindow);
	   image->type = DEMO_OBJ_SPLINE;
	   image->visible = 1;
	   image->vertices = vertex;
	   for (i=0; i<vertex; ++i)
	      { image->pixelx[i] = pixX[i];
		image->pixely[i] = pixY[i];
		image->x[i] = COORD(image->pixelx[i]);
		image->y[i] = COORD(image->pixely[i]);
	      }

	   if (trans == RIP_TRANS_CHAR)
	      ASHline(AnimWindow,X0,Y0,X1,Y1);	/* erase spurious line seg */

	   get_a_color(image->color, &tc, &(image->ashcolor));
	   width_and_style(&(image->width), &(image->style), &(image->linestyle) );

	   ASHpolyline(AnimWindow,vertex,pixX,pixY);  /* erase old one */
	   ASHdraw_hilite(AnimWindow,0);    /* stop XORing */

	   oldcolor = ASHcolor(AnimWindow,image->ashcolor);
	   oldstyle = ASHline_style(AnimWindow,image->linestyle);
	   ASHspline(AnimWindow,image->vertices,image->pixelx,image->pixely);
	   ASHcolor(AnimWindow,oldcolor);
	   ASHline_style(AnimWindow,oldstyle);

	   drawing = 0;
	   vertex = 0;
	   return(0);
	 }
     }
   return(1);
}




/***************************************************************/
/*   get_text - get a text TANGO_IMAGE. 		       */
/***************************************************************/

DEMO_IMAGE
get_text()
{
   DEMO_IMAGE image;
   PT_PTR pt;
   char str[32];
   char *format1 = "\nText string\n%0.32t\n\n  %a";
   ASH_COLOR col,bgdcol;
   int tcol;

   image = (DEMO_IMAGE) malloc( sizeof( struct _DEMO_IMAGE));
   str[0] = '\0';
   STEMdialog1(AnimWindow,format1,str);

   get_a_color(image->color, &tcol, &(image->ashcolor) );
   col = ASHtext_color(AnimWindow,image->ashcolor);
   bgdcol = ASHtext_background_color(AnimWindow,-1);
   RIPprompt("Click mouse down to select location of text");
   pt = get_point();
   RIPprompt(" ");
   ASHtext(AnimWindow,pt->x,pt->y,str);
   ASHtext_color(AnimWindow,col);
   ASHtext_background_color(AnimWindow,bgdcol);

   image->type = DEMO_OBJ_TEXT;
   image->visible = 1;
   image->pixelx[0] = pt->x;
   image->pixely[0] = pt->y;
   image->x[0] = COORD(pt->x);
   image->y[0] = COORD(pt->y);
   strcpy(image->string,str);
   return(image);
}



/***************************************************************/
/*   fctImageLoc - create a TANGO_LOC object that is	       */
/*	designated by a part of an image.  Let the user choose */
/*	the image to utilize, then qquery for the part.        */
/***************************************************************/

int
fctImageLoc(data,menu,button,window)
   int data;
   char *menu;
   char *button;
   ASH_WINDOW window;
{
   int choice;
   CALL_PTR call;
   DEMO_IMAGE image;
   DISPLAY_PTR disp;
   TANGO_PART_TYPE part;
   char *partstr;
   char vname[MAXSTRINGLENGTH];
   int x,y;
   TANGO_LOC loc;
   static char *format1[9] = {
      "\nLoc variable name\n %0.32t\n\n              Part\n",
      "       NW      N      NE",
      "       %1.0o     %1.1o     %1.2o\n",
      "       W       C      E",
      "       %1.3o     %1.4o     %1.5o\n",
      "       SW      S      SE",
      "       %1.6o     %1.7o     %1.8o\n\n",
      "%a                  %c",
      NULL };

   if (!check_scenebegin(data,menu,button,window))
      return(1);
   RIPprompt("Select image to query location.  (Press key to cancel)");
   do {
	disp = get_object();
	if (!disp) break;
	if (disp->type != DEMO_OBJ_IMAGE)
	   RIPprompt("Sorry that's not an image.  Try again. (key to cancel)");
	else
	   break;
      } while (1==1);
   RIPprompt(" ");
   if (!disp) return(1);

   vname[0] = '\0';
   choice = 1;
   if (STEMdialog(AnimWindow,format1,vname,&choice) && (vname[0] != '\0'))
      { call = new_call(DEMO_OBJ_IMAGE);

	switch(choice)
	{  case 0 :
	      partstr = "TANGO_PART_TYPE_NW";
	      part = TANGO_PART_TYPE_NW;
	      break;
	   case 1 :
	      partstr = "TANGO_PART_TYPE_N";
	      part = TANGO_PART_TYPE_N;
	      break;
	   case 2 :
	      partstr = "TANGO_PART_TYPE_NE";
	      part = TANGO_PART_TYPE_NE;
	      break;
	   case 3 :
	      partstr = "TANGO_PART_TYPE_W";
	      part = TANGO_PART_TYPE_W;
	      break;
	   case 4 :
	      partstr = "TANGO_PART_TYPE_C ";
	      part = TANGO_PART_TYPE_C ;
	      break;
	   case 5 :
	      partstr = "TANGO_PART_TYPE_E";
	      part = TANGO_PART_TYPE_E;
	      break;
	   case 6 :
	      partstr = "TANGO_PART_TYPE_SW";
	      part = TANGO_PART_TYPE_SW;
	      break;
	   case 7 :
	      partstr = "TANGO_PART_TYPE_S";
	      part = TANGO_PART_TYPE_S;
	      break;
	   case 8 :
	      partstr = "TANGO_PART_TYPE_SE";
	      part = TANGO_PART_TYPE_SE;
	      break;
	}

	image = (DEMO_IMAGE) disp->object;
	image_loc(image,part,&x,&y);
	loc = TANGOloc_create(COORD(x),COORD(y));
	ASHfilled_circle(AnimWindow,x,y,2);
	new_display(DEMO_OBJ_LOC,loc,vname,x,y);

       sprintf(call->callstr,"%s = TANGOimage_loc(%s, %s);",vname,disp->vname,partstr);
      }
   return(1);
}



/***************************************************************/
/*   place_name_at - given an image, determine the place to    */
/*	put its display object text banner (top left of a rect,*/
/*	above a circle, on the top of a line, at the top of an */
/*	ellipse, above a polygon, and at the lower left corner *
/*	of text.					       */
/***************************************************************/

void
place_name_at(image,x,y)
   DEMO_IMAGE image;
   int *x,*y;
{
   int x0,y0,x1,y1,min,i;

   x0 = image->pixelx[0];
   y0 = image->pixely[0];
   x1 = image->pixelx[1];
   y1 = image->pixely[1];

   switch (image->type)
   {
      case DEMO_OBJ_LINE:
	 *x = x0-10;
	 *y = y0-5;
	 break;
      case DEMO_OBJ_RECT:
	 if (y0 < y1)
	    { *x = x0-10;
	      *y = y0-5;
	    }
	 else
	    { *x = x1-10;
	      *y = y1-5;
	    }
	 break;
      case DEMO_OBJ_CIRCLE:
	 *x = x0-10;
	 *y = y0-x1-5;
	 break;
      case DEMO_OBJ_ELLIPSE:
	 *x = x0;
	 *y = y0-y1-5;
	 break;
      case DEMO_OBJ_POLYGON:
      case DEMO_OBJ_POLYLINE:
      case DEMO_OBJ_SPLINE:
/*	 min = 0;
	 for (i=1; i<image->sides; ++i)
	    if (image->pixely[i] < image->pixely[min])
	       min = i; 				      */
	 *x = image->pixelx[0] - 10;
	 *y = image->pixely[0] - 5;
	 break;
      case DEMO_OBJ_TEXT:
	 *x = x0-10;
	 *y = y0+10;
	 break;
      default:
	 *x = x0;
	 *y = y0;
   }
}



/***************************************************************/
/*   image_loc - return the (x,y) pixel coordinates	       */
/*	corresponding to the given part on the given image.    */
/***************************************************************/

void
image_loc(image,part,x,y)
   DEMO_IMAGE image;
   TANGO_PART_TYPE part;
   int *x,*y;
{
   int x0,y0,x1,y1;
   int xmin,xmax,ymin,ymax;
   int radius,corner,i;

   switch (image->type)
   {
     case DEMO_OBJ_LINE:
	if (image->pixelx[0] > image->pixelx[1])
	    { xmin = image->pixelx[1];
	      xmax = image->pixelx[0];
	    }
	else
	    { xmin = image->pixelx[0];
	      xmax = image->pixelx[1];
	    }
	if (image->pixely[0] > image->pixely[1])
	    { ymin = image->pixely[1];
	      ymax = image->pixely[0];
	    }
	else
	    { ymin = image->pixely[0];
	      ymax = image->pixely[1];
	    }
	switch (part)
	{
	   case TANGO_PART_TYPE_N :
	      *x = (xmin + xmax)/2;
	      *y = ymin;
	      break;
	   case TANGO_PART_TYPE_S :
	      *x = (xmin + xmax)/2;
	      *y = ymax;
	      break;
	   case TANGO_PART_TYPE_W :
	      *x = xmin;
	      *y = (ymin + ymax)/2;
	      break;
	   case TANGO_PART_TYPE_E :
	      *x = xmax;
	      *y = (ymin + ymax)/2;
	      break;
	   case TANGO_PART_TYPE_NW:
	      *x = xmin;
	      *y = ymin;
	      break;
	   case TANGO_PART_TYPE_NE:
	      *x = xmax;
	      *y = ymin;
	      break;
	   case TANGO_PART_TYPE_SE:
	      *x = xmax;
	      *y = ymax;
	      break;
	   case TANGO_PART_TYPE_SW:
	      *x = xmin;
	      *y = ymax;
	      break;
	   case TANGO_PART_TYPE_C :
	      *x = (xmin+xmax)/2;
	      *y = (ymin+ymax)/2;
	}
	break;
     case DEMO_OBJ_RECT:
	if (image->pixelx[0] < image->pixelx[1])
	   { x0 = image->pixelx[0];
	     x1 = image->pixelx[1];
	   }
	else
	   { x1 = image->pixelx[0];
	     x0 = image->pixelx[1];
	   }
	if (image->pixely[0] < image->pixely[1])
	   { y0 = image->pixely[0];
	     y1 = image->pixely[1];
	   }
	else
	   { y1 = image->pixely[0];
	     y0 = image->pixely[1];
	   }
	switch (part)
	{
	   case TANGO_PART_TYPE_C :
	      *x = (x0 + x1)/2;
	      *y = (y0 + y1)/2;
	      break;
	   case TANGO_PART_TYPE_NW :
	      *x = x0;
	      *y = y0;
	      break;
	   case TANGO_PART_TYPE_N :
	      *x = (x0+ x1)/2;
	      *y = y0;
	      break;
	   case TANGO_PART_TYPE_NE :
	      *x = x1;
	      *y = y0;
	      break;
	   case TANGO_PART_TYPE_E :
	      *x = x1;
	      *y = (y0 + y1)/2;
	      break;
	   case TANGO_PART_TYPE_SE :
	      *x = x1;
	      *y = y1;
	      break;
	   case TANGO_PART_TYPE_S :
	      *x = (x0 + x1)/2;
	      *y = y1;
	      break;
	   case TANGO_PART_TYPE_SW :
	      *x = x0;
	      *y = y1;
	      break;
	   case TANGO_PART_TYPE_W :
	      *x = x0;
	      *y = (y0 + y1)/2;
	      break;
	}
	break;
     case DEMO_OBJ_CIRCLE:
	x0 = image->pixelx[0];
	y0 = image->pixely[0];
	corner = (int) (sqrt( (double)(image->pixelx[1] * image->pixelx[1]) / 2.0 ));
	radius = image->pixelx[1];
	switch (part)
	{
	   case TANGO_PART_TYPE_C :
	      *x = x0;
	      *y = y0;
	      break;
	   case TANGO_PART_TYPE_NW :
	      *x = x0-corner;
	      *y = y0-corner;
	      break;
	   case TANGO_PART_TYPE_N :
	      *x = x0;
	      *y = y0-radius;
	      break;
	   case TANGO_PART_TYPE_NE :
	      *x = x0+corner;
	      *y = y0-corner;
	      break;
	   case TANGO_PART_TYPE_E :
	      *x = x0+radius;
	      *y = y0;
	      break;
	   case TANGO_PART_TYPE_SE :
	      *x = x0+corner;
	      *y = y0+corner;
	      break;
	   case TANGO_PART_TYPE_S :
	      *x = x0;
	      *y = y0+radius;
	      break;
	   case TANGO_PART_TYPE_SW :
	      *x = x0-corner;
	      *y = y0+corner;
	      break;
	   case TANGO_PART_TYPE_W :
	      *x = x0-radius;
	      *y = y0;
	      break;
	}
	break;
     case DEMO_OBJ_ELLIPSE:
	x0 = image->pixelx[0];
	y0 = image->pixely[0];
	x1 = image->pixelx[1];
	y1 = image->pixely[1];
	switch (part)
	{
	   case TANGO_PART_TYPE_C :
	      *x = x0;
	      *y = y0;
	      break;
	   case TANGO_PART_TYPE_NW :
	      *x = x0-x1;
	      *y = y0-y1;
	      break;
	   case TANGO_PART_TYPE_N :
	      *x = x0;
	      *y = y0-y1;
	      break;
	   case TANGO_PART_TYPE_NE :
	      *x = x0+x1;
	      *y = y0-y1;
	      break;
	   case TANGO_PART_TYPE_E :
	      *x = x0+x1;
	      *y = y0;
	      break;
	   case TANGO_PART_TYPE_SE :
	      *x = x0+x1;
	      *y = y0+y1;
	      break;
	   case TANGO_PART_TYPE_S :
	      *x = x0;
	      *y = y0+y1;
	      break;
	   case TANGO_PART_TYPE_SW :
	      *x = x0-x1;
	      *y = y0+y1;
	      break;
	   case TANGO_PART_TYPE_W :
	      *x = x0-x1;
	      *y = y0;
	      break;
	}
	break;
     case DEMO_OBJ_POLYLINE:
     case DEMO_OBJ_POLYGON:
     case DEMO_OBJ_SPLINE:
	xmin = xmax = ymin = ymax = 0;
	for (i=1; i<image->vertices; ++i)
	   { if (image->pixelx[i] < image->pixelx[xmin])
		xmin = i;
	     if (image->pixelx[i] > image->pixelx[xmax])
		xmax = i;
	     if (image->pixely[i] < image->pixely[ymin])
		ymin = i;
	     if (image->pixely[i] > image->pixely[ymax])
		ymax = i;
	   }
	xmin = image->pixelx[xmin];
	xmax = image->pixelx[xmax];
	ymin = image->pixely[ymin];
	ymax = image->pixely[ymax];
	switch (part)
	{
	   case TANGO_PART_TYPE_N :
	      *x = (xmin + xmax)/2;
	      *y = ymin;
	      break;
	   case TANGO_PART_TYPE_S :
	      *x = (xmin + xmax)/2;
	      *y = ymax;
	      break;
	   case TANGO_PART_TYPE_W :
	      *x = xmin;
	      *y = (ymin + ymax)/2;
	      break;
	   case TANGO_PART_TYPE_E :
	      *x = xmax;
	      *y = (ymin + ymax)/2;
	      break;
	   case TANGO_PART_TYPE_NW:
	      *x = xmin;
	      *y = ymin;
	      break;
	   case TANGO_PART_TYPE_NE:
	      *x = xmax;
	      *y = ymin;
	      break;
	   case TANGO_PART_TYPE_SE:
	      *x = xmax;
	      *y = ymax;
	      break;
	   case TANGO_PART_TYPE_SW:
	      *x = xmin;
	      *y = ymax;
	      break;
	   case TANGO_PART_TYPE_C :
	      *x = (xmin+xmax)/2;
	      *y = (ymin+ymax)/2;
	}
	break;

     case DEMO_OBJ_TEXT:
	x0 = image->pixelx[0];	 /* lower left */
	y0 = image->pixely[0];
	ASHinq_text_extent(ASHinq_font(AnimWindow),image->string,&x1,&y1);
	x1 = x0 + x1;		 /* upper right */
	y1 = y0 - y1;
	switch (part)
	{
	   case TANGO_PART_TYPE_C :
	      *x = (x0+x1)/2;
	      *y = (y0+y1)/2;
	      break;
	   case TANGO_PART_TYPE_NW :
	      *x = x0;
	      *y = y1;
	      break;
	   case TANGO_PART_TYPE_N :
	      *x = (x0+x1)/2;
	      *y = y1;
	      break;
	   case TANGO_PART_TYPE_NE :
	      *x = x1;
	      *y = y1;
	      break;
	   case TANGO_PART_TYPE_E :
	      *x = x1;
	      *y = (y0+y1)/2;
	      break;
	   case TANGO_PART_TYPE_SE :
	      *x = x1;
	      *y = y0;
	      break;
	   case TANGO_PART_TYPE_S :
	      *x = (x0+x1)/2;
	      *y = y0;
	      break;
	   case TANGO_PART_TYPE_SW :
	      *x = x0;
	      *y = y0;
	      break;
	   case TANGO_PART_TYPE_W :
	      *x = x0;
	      *y = (y0+y1)/2;
	      break;
	}
	break;
   }
}





/***************************************************************/
/*   image_call - given an image, fill in the appropriate      */
/*	TANGOimage_create command in the given call's callstr  */
/*	field.	var designates the TANGO_IMAGE variable used.  */
/***************************************************************/

void
image_call(call,image,var)
   CALL_PTR call;
   DEMO_IMAGE image;
   char *var;
{
   char args[MAXSTRINGLENGTH];

   sprintf(call->callstr,"%s = TANGOimage_create(",var);
   switch (image->type)
   {
      case DEMO_OBJ_LINE:
	 sprintf(args,"TANGO_IMAGE_TYPE_LINE, %lf, %lf, 1, %s, %lf, %lf, %lf, %lf, %d);",
		    image->x[0],image->y[0],image->color,
		    image->x[1]-image->x[0],image->y[1]-image->y[0],
		    image->width,image->style,image->arrow);
	 break;
      case DEMO_OBJ_RECT:
	 sprintf(args,"TANGO_IMAGE_TYPE_RECTANGLE, %lf, %lf, 1, %s, %lf, %lf, %lf);",
		    image->x[0],image->y[0],image->color,
		    image->x[1]-image->x[0],image->y[1]-image->y[0],image->fill);
	 break;
      case DEMO_OBJ_CIRCLE:
	 sprintf(args,"TANGO_IMAGE_TYPE_CIRCLE, %lf, %lf, 1, %s, %lf, %lf);",
		    image->x[0],image->y[0],image->color,image->x[1],image->fill);
	 break;
      case DEMO_OBJ_ELLIPSE:
	 sprintf(args,"TANGO_IMAGE_TYPE_ELLIPSE, %lf, %lf, 1, %s, %lf, %lf, %lf);",
		    image->x[0],image->y[0],image->color,
		    image->x[1],image->y[1],image->fill);
	 break;
      case DEMO_OBJ_POLYLINE:
	 sprintf(args,"TANGO_IMAGE_TYPE_POLYLINE, %lf, %lf, 1, %s, %d, %s_x, %s_y, %lf, %lf, %d);",
		    image->x[0],image->y[0],image->color,image->vertices,
		    var,var,image->width,image->style,image->arrow);
	 break;
      case DEMO_OBJ_POLYGON:
	 sprintf(args,"TANGO_IMAGE_TYPE_POLYGON, %lf, %lf, 1, %s, %d, %s_x, %s_y, %lf);",
		    image->x[0],image->y[0],image->color,image->vertices,
		    var,var,image->fill);
	 break;
      case DEMO_OBJ_SPLINE:
	 sprintf(args,"TANGO_IMAGE_TYPE_SPLINE, %lf, %lf, 1, %s, %d, %s_x, %s_y, %lf, %lf);",
		    image->x[0],image->y[0],image->color,image->vertices,
		    var,var,image->width,image->style);
	 break;
      case DEMO_OBJ_TEXT:
	 sprintf(args,"TANGO_IMAGE_TYPE_TEXT, %lf, %lf, 1, %s, NULL, \"%s\", 0);",
		    image->x[0],image->y[0],image->color,image->string);
	 break;
   }
   strcat(call->callstr,args);
}



/***************************************************************/
/*   color_and_fill - query the user to choose a color and a   */
/*	fill style to use in drawing an image.		       */
/***************************************************************/

void
color_and_fill(imcolor,ashcolor,imfill,ashfill)
   char *imcolor;
   ASH_COLOR *ashcolor;
   double *imfill;
   ASH_FILL_STYLE *ashfill;
{
   int color,fill;
   char arr[6][MAXSTRINGLENGTH];
   char *format[12];

   format[0] = "\nColor%M Fill";
   format[1] = "  %0.0.1.41o%M   %1.0.1.33o";
   sprintf(arr[0],"  %%0.1.%d.41o%%M   %%1.1.1.34o",Color[DANCE_RED]);
   format[2] = arr[0];
   sprintf(arr[1],"  %%0.2.%d.41o%%M   %%1.2.1.35o",Color[DANCE_ORANGE]);
   format[3] = arr[1];
   sprintf(arr[2],"  %%0.3.%d.41o%%M   %%1.3.1.36o",Color[DANCE_YELLOW]);
   format[4] = arr[2];
   sprintf(arr[3],"  %%0.4.%d.41o%%M   %%1.4.1.37o",Color[DANCE_GREEN]);
   format[5] = arr[3];
   sprintf(arr[4],"  %%0.5.%d.41o%%M   %%1.5.1.38o",Color[DANCE_BLUE]);
   format[6] = arr[4];
   sprintf(arr[5],"  %%0.6.%d.41o%%M   %%1.6.1.39o",Color[DANCE_MAROON]);
   format[7] = arr[5];
   format[8] = "%M   %1.7.1.40o",
   format[9] = "%M   %1.8.1.41o\n",
   format[10] = "%C%a",
   format[11] = NULL;

   color = 0;
   fill = 0;
   STEMdialog(AnimWindow,format,&color,&fill);

   switch (color)
   {
      case 0:
	 sprintf(imcolor,"TANGO_COLOR_BLACK");
	 *ashcolor = Color[DANCE_BLACK];
	 break;
      case 1:
	 sprintf(imcolor,"TANGO_COLOR_RED");
	 *ashcolor = Color[DANCE_RED];
	 break;
      case 2:
	 sprintf(imcolor,"TANGO_COLOR_ORANGE");
	 *ashcolor = Color[DANCE_ORANGE];
	 break;
      case 3:
	 sprintf(imcolor,"TANGO_COLOR_YELLOW");
	 *ashcolor = Color[DANCE_YELLOW];
	 break;
      case 4:
	 sprintf(imcolor,"TANGO_COLOR_GREEN");
	 *ashcolor = Color[DANCE_GREEN];
	 break;
      case 5:
	 sprintf(imcolor,"TANGO_COLOR_BLUE");
	 *ashcolor = Color[DANCE_BLUE];
	 break;
      case 6:
	 sprintf(imcolor,"TANGO_COLOR_MAROON");
	 *ashcolor = Color[DANCE_MAROON];
	 break;
   }
   switch (fill)
   {
      case 0:
	 *imfill = 0.0;
	 *ashfill = 33;
	 break;
      case 1:
	 *imfill = 0.1666;
	 *ashfill = 34;
	 break;
      case 2:
	 *imfill = 0.2777;
	 *ashfill = 35;
	 break;
      case 3:
	 *imfill = 0.3888;
	 *ashfill = 36;
	 break;
      case 4:
	 *imfill = 0.5;
	 *ashfill = 37;
	 break;
      case 5:
	 *imfill = 0.6111;
	 *ashfill = 38;
	 break;
      case 6:
	 *imfill = 0.7222;
	 *ashfill = 39;
	 break;
      case 7:
	 *imfill = 0.8333;
	 *ashfill = 40;
	 break;
      case 8:
	 *imfill = 1.0;
	 *ashfill = 41;
	 break;
   }
}



/***************************************************************/
/*   width_and_style - query the user to choose a	       */
/*	width and style to use in drawing a line, polyline or  */
/*	spline image.					       */
/***************************************************************/

void
width_and_style(width,style,linestyle)
   double *width;
   double *style;
   ASH_LINE_STYLE *linestyle;
{
   int w,s;
   char *format[6];

   format[0] = "\nWidth%M Style";
   format[1] = "%0.0o normal%M %1.0o solid";
   format[2] = "%0.1o thick%M %1.1o dashed";
   format[3] = "%0.2o thicker%M %1.2o dotted";
   format[4] = "%C%a",
   format[5] = NULL;

   w = 0;
   s = 0;
   STEMdialog(AnimWindow,format,&w,&s);

   switch (w)
   {
      case 0:
	 *width = 0.0;
	 if (s == 0)
	    { *style = 1.0;
	      *linestyle = ASH_STYLE_SOLID;
	    }
	 else if (s == 1)
	    { *style = 0.5;
	      *linestyle = ASH_STYLE_DASHED;
	    }
	 else
	    { *style = 0.0;
	      *linestyle = ASH_STYLE_DOTTED;
	    }
	 break;
      case 1:
	 *width = 0.5;
	 if (s == 0)
	    { *style = 1.0;
	      *linestyle = ASH_STYLE_THICK;
	    }
	 else if (s == 1)
	    { *style = 0.5;
	      *linestyle = ASH_STYLE_THICK_DASHED;
	    }
	 else
	    { *style = 0.0;
	      *linestyle = ASH_STYLE_THICK_DOTTED;
	    }
	 break;
      case 2:
	 *width = 1.0;
	 if (s == 0)
	    { *style = 1.0;
	      *linestyle = ASH_STYLE_THICKER;
	    }
	 else if (s == 1)
	    { *style = 0.5;
	      *linestyle = ASH_STYLE_THICKER_DASHED;
	    }
	 else
	    { *style = 0.0;
	      *linestyle = ASH_STYLE_THICKER_DOTTED;
	    }
	 break;
   }
}




/***************************************************************/
/*   get_an_arrow - query the user to select an arrow type     */
/*	for lines or polylines. 			       */
/***************************************************************/

void
get_an_arrow(arrow)
   int *arrow;
{
   char *format[7];

   format[0] = "\nArrow";
   format[1] = "%0.0o none";
   format[2] = "%0.1o forward";
   format[3] = "%0.2o backward";
   format[4] = "%0.3o both";
   format[5] = "%C%a",
   format[6] = NULL;

   *arrow = 0;
   STEMdialog(AnimWindow,format,arrow);
}



/***************************************************************/
/*   make_arrow_integer - convert double arrow coords to       */
/*	integer pixels. 				       */
/***************************************************************/

void
make_arrow_integer(image,i)
   DEMO_IMAGE image;
   int i;
{
   image->pixelarrowloc[i][0] = ABSOL(image->arrowloc[i][0]);
   image->pixelarrowloc[i][1] = ABSOL(image->arrowloc[i][1]);
   image->pixelarrowloc[i+1][0] = ABSOL(image->arrowloc[i+1][0]);
   image->pixelarrowloc[i+1][1] = ABSOL(image->arrowloc[i+1][1]);
}



/***************************************************************/
/*   polyline_arrow_dir - determine what directions the arrows */
/*	at the ends of a polyline should be pointing.	       */
/***************************************************************/

void
polyline_arrow_dir(im,fx,fy,bx,by)
   DEMO_IMAGE im;
   double *fx,*fy,*bx,*by;
{
   int i;

   for (i=im->vertices-1; i>=1; --i)
      { *fx = im->x[i] - im->x[i-1];
	*fy = im->y[i] - im->y[i-1];
	if ((*fx != 0.0) || (*fy != 0.0))
	   break;
      }
   for (i=1; i<=im->vertices-1; --i)
      { *bx = im->x[i-1] - im->x[i];
	*by = im->y[i-1] - im->y[i];
	if ((*bx != 0.0) || (*by != 0.0))
	   break;
      }
}




/***************************************************************/
/*   find_arrow_offsets - figure out what the offsets should   */
/*	be for the points of an arrow.			       */
/*	I haven't got a clue how this works, but it just does. */
/*	Many thanks to Eric Golin for code.		       */
/***************************************************************/

#define   PIE  ((double)3.14159)
#define   ARROW_HEAD_LENGTH   ((double)0.025)
#define   ARROW_HEAD_ANGLE    PIE/2.5

void
find_arrow_offsets(dx,dy,adx1,ady1,adx2,ady2)
   double dx,dy;
   double *adx1,*ady1,*adx2,*ady2;
{
   double arclen,len,theta,alpha,beta;

   if ((dx == 0.0) && (dy == 0.0))
      { *adx1 = *adx2 = *ady1 = *ady2 = 0.0;
	return;
      }

   arclen = ARROW_HEAD_LENGTH;
   len = sqrt((dx*dx) + (dy*dy));
   if (len < arclen)
      arclen = len;

   theta = atan2(dx,dy);
   alpha = -(theta + ARROW_HEAD_ANGLE);
   beta = PIE - (theta - ARROW_HEAD_ANGLE);
   *adx1 = arclen * cos(alpha);
   *ady1 = arclen * sin(alpha);
   *adx2 = arclen * cos(beta);
   *ady2 = arclen * sin(beta);
}




/***************************************************************/
/*   addin_arrows - draw the arrows specified by the given     */
/*	image.						       */
/***************************************************************/

void
addin_arrows(image)
   DEMO_IMAGE image;
{
   int v,x,y;

   v = image->vertices;
   if ((image->arrow & 0x1) != 0)
      { ASHline(AnimWindow,x=image->pixelx[v-1],y=image->pixely[v-1],
		   x+image->pixelarrowloc[0][0],y+image->pixelarrowloc[0][1]);
	ASHline(AnimWindow,x,y,x+image->pixelarrowloc[1][0],y+image->pixelarrowloc[1][1]);
      }
   if ((image->arrow & 0x2) != 0)
      { ASHline(AnimWindow,x=image->pixelx[0],y=image->pixely[0],
		   x+image->pixelarrowloc[2][0],y+image->pixelarrowloc[2][1]);
	ASHline(AnimWindow,x,y,x+image->pixelarrowloc[3][0],y+image->pixelarrowloc[3][1]);
      }
}
