/************************************************************************/
/*									*/
/*		xrsc_expr.c						*/
/*									*/
/*	Expression processing module for xref scanning			*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#include "xrsc_local.h"





/************************************************************************/
/*									*/
/*	Local types							*/
/*									*/
/************************************************************************/



typedef struct _EXPR_DATA *	EXPR_DATA;


typedef struct _EXPR_DATA {
   EXPR_DATA previous;
   Character name[256];
   Character file[256];
   Integer line;
   Boolean valid;
} EXPR_DATA_INFO;





/************************************************************************/
/*									*/
/*	Local Storage							*/
/*									*/
/************************************************************************/


static	EXPR_DATA	cur_data;




/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/





/************************************************************************/
/*									*/
/*	XRSC_expr_init -- module initialization 			*/
/*									*/
/************************************************************************/


void
XRSC_expr_init()
{
   cur_data = PALLOC(EXPR_DATA_INFO);
   cur_data->valid = FALSE;
};




/************************************************************************/
/*									*/
/*	XRSC_expr_id -- scan id during expression			*/
/*	XRSC_expr_op -- scan operator during expression 		*/
/*	XRSC_expr_push -- push current expression			*/
/*	XRSC_expr_pop -- pop current expression 			*/
/*									*/
/************************************************************************/


void
XRSC_expr_id(file,line,name)
   String name;
{
   strcpy(cur_data->name,name);
   strcpy(cur_data->file,file);
   cur_data->line = line;
   cur_data->valid = TRUE;
};




void
XRSC_expr_op()
{
   cur_data->valid = FALSE;
};





void
XRSC_expr_push()
{
   EXPR_DATA ed;

   ed = PALLOC(EXPR_DATA_INFO);
   ed->previous = cur_data;
   ed->name[0] = 0;
   ed->valid = FALSE;
   cur_data = ed;
};




void
XRSC_expr_pop()
{
   EXPR_DATA ed;

   ed = cur_data->previous;

   if (ed == NULL) {
      cur_data->valid = FALSE;
    }
   else {
      free(cur_data);
      cur_data = ed;
    };
};





/************************************************************************/
/*									*/
/*	XRSC_expr_assignop -- handle assignment operator		*/
/*									*/
/************************************************************************/


void
XRSC_expr_assignop()
{
   if (cur_data->valid) {
      XRSC_out_assign(cur_data->file,cur_data->line,cur_data->name);
    };

   cur_data->valid = FALSE;
};





/************************************************************************/
/*									*/
/*	XRSC_expr_call -- handle call operator				*/
/*									*/
/************************************************************************/


void
XRSC_expr_call(from)
   String from;
{
   if (cur_data->valid && from != NULL) {
      XRSC_out_call(cur_data->file,cur_data->line,cur_data->name,from);
    };

   cur_data->valid = FALSE;
};




/* end of xrscexpr.c */
