/************************************************************************/
/*									*/
/*		xrefmsg.c						*/
/*									*/
/*	MSG interface for xref facility 				*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#include "xref_local.h"





/************************************************************************/
/*									*/
/*	Local storage							*/
/*									*/
/************************************************************************/


typedef struct _REPLY {
   Integer rid;
   FILE * otf;
   Character fname[64];
} REPLY;





/************************************************************************/
/*									*/
/*	Forward definitions						*/
/*									*/
/************************************************************************/


static	void		handle_query();
static	void		handle_reload();
static	void		handle_output();
static	void		handle_rebuilt();




/************************************************************************/
/*									*/
/*	XREF_msg_init -- module initialization				*/
/*									*/
/************************************************************************/


void
XREF_msg_init()
{
   MSGregister("XREF QUERY %1s %2s %3r",handle_query,3,NULL);
   MSGregister("XREF RELOAD %1s",handle_reload,1,NULL);
   MSGregister("BUILD FINISH %2d %s %1s",handle_rebuilt,2,NULL);
};





/************************************************************************/
/*									*/
/*	handle_query -- handle a xref query				*/
/*									*/
/************************************************************************/


static void
handle_query(sys,ret,q,rid)
   String sys;
   String ret;
   String q;
   Integer rid;
{
   REPLY * r;
   XREF_WIN xwi;
   Character fnm[32];

   xwi = PALLOC(XREF_WIN_INFO);

   xwi->window = NULL;
   xwi->menu_win = NULL;
   xwi->disp_win = NULL;
   xwi->edit_info = NULL;
   xwi->clear_fg = FALSE;
   xwi->skip_fg = TRUE;
   xwi->data = XREF_set_system(sys,TRUE);
   xwi->outline[0] = 0;

   strcpy(fnm,"/tmp/XREFqueryXXXXXX");
   mktemp(fnm);

   r = PALLOC(REPLY);
   r->rid = rid;
   if (rid  > 0) r->otf = fopen(fnm,"w");
   strcpy(r->fname,fnm);

   MSGsync_allow();

   XREF_run_query(xwi,ret,q,handle_output,r);
};





/************************************************************************/
/*									*/
/*	handle_reload -- handle request to reload database		*/
/*									*/
/************************************************************************/


static void
handle_reload(sys,rid)
   String sys;
   Integer rid;
{
   XREF_DATA xd;

   xd = XREF_set_system(sys,FALSE);
   if (xd == NULL) return;

   XREF_load_system(xd);

   if (rid >= 0) MSGreply(rid,NULL);
};




/************************************************************************/
/*									*/
/*	handle_output -- handle output line for query			*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static void
handle_output(xw,line,r)
   XREF_WIN xw;
   String line;
   REPLY * r;
{
   if (line == NULL) {
      if (r->rid >= 0) {
	 fclose(r->otf);
	 MSGreply(r->rid,r->fname);
       };
      free(r);
    }
   else if (r->rid >= 0) {
/*    printf("%s\n",line);              */
      fprintf(r->otf,"%s\n",line);
    };
};





/************************************************************************/
/*									*/
/*	handle_rebuilt -- handle system rebuilt message from BUILD	*/
/*									*/
/************************************************************************/


static void
handle_rebuilt(sys,sts,rid)
   String sys;
   Integer sts;
   Integer rid;
{
   XREF_DATA xd;
   String s;

   if (rid >= 0) MSGreply(rid,NULL);

   if (sts > 0) return;

   s = rindex(sys,'.');
   if (s != NULL) {
      if (STREQL(s,".o") || STREQL(s,".c") || STREQL(s,".dep")) return;
    };

   xd = XREF_set_system(sys,FALSE);
   if (xd == NULL) return;

   XREF_load_system(xd);
};





/* end of xrefmsg.c */
